/*
===========================================================================
File        :   main.c
Author(s)   :   The Dude From X
Company     :   WaffleGadgets
Website     :   www.wafflegadgets.com
Project     :   Survey - example using Radio Checkboxes, Buttons 
Date	    :   July 18 2000
Revision    :   1.0.01
Note        :   Portions of this source were adapted from VT-OS SDK
===========================================================================
*/     

#include <system.h>
#include "res\resource.h"
#include "emudbg.h"

#define NUMQUESTIONS 6

static char *data[NUMQUESTIONS*6] = {
   "I prefer to drive",
   "- a big big truck",
   "- a minivan",
   "- a beetle bug",
   "- a corvette",
   "- other",
   "I'm like to eat",
   "- Hamburgers",
   "- Pizza",
   "- Subs",
   "- Tacos",
   "- other",
   "I like to watch",
   "- Xfiles",
   "- Simpsons",
   "- MTV",
   "- 3rd Rock",
   "- other",
   "I like to listen to",
   "- Techno/Electronica",
   "- Hip Hop/Rap",
   "- Rock & Roll",
   "- Latin",
   "- other",
   "If I had the $$$ I would buy",
   "- The company I work for",
   "- Lots of cars",
   "- A Big big house",
   "- A small island",
   "- other",
   "I usually wake up at",
   "- 6:30 am",
   "- 8:00 am",
   "- 10:00 am",
   "- noon",
   "- other"
};

BOOLEAN (*FormDispatchEvent)(EvtType *Event);

//-------------------------------------------------------------------------------
void DrawQuestion(int i, int a) {
   // Please note that this writes directly to the LCD 
   // a more compatible way is to use string UI objects

   static char msg[] = "ya answa is:";
   char *ans;
   ObjectBounds bnds;
   int c;
   
   bnds.xcoord = 20; bnds.ycoord = 36;
   bnds.width = 130; bnds.height = 14;
   LcdDrawBox(&bnds, COLOR_WHITE, COLOR_WHITE, 0);
   LcdDrawFixedString(&bnds, data[i*6], COLOR_BLACK, COLOR_WHITE, MEDIUM_FONT, FALSE, 0);
   bnds.width = 120; bnds.height = 12;
   bnds.xcoord = 36;
   for (c = 1; c < 6; c++) {
      bnds.ycoord = 38+c*12;
      LcdDrawBox(&bnds, COLOR_WHITE, COLOR_WHITE, 0);
      LcdDrawFixedString(&bnds, data[i*6+c], COLOR_BLACK, COLOR_WHITE, SMALL_FONT, FALSE, 0);
   }
   bnds.xcoord = 20; bnds.ycoord = 110;
   bnds.width = 130; bnds.height = 14;
   LcdDrawBox(&bnds, COLOR_WHITE, COLOR_WHITE, 0);
   LcdDrawFixedString(&bnds, msg, COLOR_BLACK, COLOR_WHITE, MEDIUM_FONT, FALSE, 0);
   bnds.ycoord = 122;
   LcdDrawBox(&bnds, COLOR_WHITE, COLOR_WHITE, 0);
   if (a < 0) return;
   ans = data[i*6+a]+2;
   c = StrGetWidth(ans, MEDIUM_FONT);
   bnds.xcoord = 80 - c/2;
   bnds.width = c;
   LcdDrawFixedString(&bnds, ans,  COLOR_BLACK, COLOR_WHITE, MEDIUM_FONT, FALSE, 0);
}
//-------------------------------------------------------------------------------
void ResetRadioBox(ObjectID itemID) {
   Control *itemPTR;
   Err      found;
   BYTE     objectType;

   found = UISearchForAddress(itemID, &objectType, (void *) &itemPTR);
   if (found) {
      ((ControlTemplateCheckBox*) (itemPTR->control_template))->control_value = FALSE;
      ControlDrawControl(itemID);
   }
}
//-------------------------------------------------------------------------------
static BOOLEAN EH_MainHandler(EvtType *event) {
static int q = 0;
static int a = -1;

   switch (event->eventType) {
      case EVT_FORM_OPEN:
         FormDrawForm(MAIN_FORM);
         DrawQuestion(q, a = -1);
         return TRUE;
      case EVT_CONTROL_SELECT:
         switch (event->eventID) {
            case PREV_BTN:
               ResetRadioBox(a+A_CHECKBOX-1);
               a = -1;
               q = (q > 0) ? --q: NUMQUESTIONS-1;
               break;
            case NEXT_BTN:
               ResetRadioBox(a+A_CHECKBOX-1);
               a = -1;
               q = (++q % NUMQUESTIONS);
               break;
         }
         if ((event->eventID >= A_CHECKBOX) && (event->eventID <= E_CHECKBOX))
            a = event->eventID - A_CHECKBOX + 1;
         DrawQuestion(q, a);
         return TRUE;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------
static BOOLEAN AppHandleEvent(EvtType *event) {
   ObjectID formID;
   Err      found;
   void    *formPTR;
   BYTE     objectType;

   if (event->eventType == EVT_FORM_LOAD) {
      formID = event->eventID;
      found = UISearchForAddress(formID, &objectType, &formPTR);
      if (event->para1 == 1 || found != TRUE) {
         FormInitForm(formID);
         found = UISearchForAddress(formID, &objectType, &formPTR);
         if (!found) return FALSE;
      }
      switch (formID) {
         case MAIN_FORM:
            FormSetEventHandler(MAIN_FORM, (void **) &FormDispatchEvent, EH_MainHandler);
            break;
      }
      FormSetActiveForm(formID);
      return TRUE;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------
void EventLoop(void) {
   EvtType event;

   do {
      EvtGetEvent(&event);
      if (!SystemHandleEvent(&event)) {
         if (!MenuHandleEvent(&event)) {
            if (!AppHandleEvent(&event)) {
               FormDispatchEvent(&event);
            }
         }
      }
   } while(event.eventType != EVT_APP_STOP);
}
//-------------------------------------------------------------------------------
void ProgramInit(void) {
   FormPopupForm(MAIN_FORM);
}
//-------------------------------------------------------------------------------
void ProgramExit(void) {
}
//-------------------------------------------------------------------------------
__main(WORD cmd, void *cmd_ptr) {
   switch (cmd) {
      case LAUNCH_CMD_NORMAL_LAUNCH:
         UIApplicationInit();
         ProgramInit();
         EventLoop();
         ProgramExit();
         UIDeleteAllAppObjects();
         return TRUE;
      case LAUNCH_CMD_FIND:
         pfree(cmd_ptr);
         return TRUE;
      case LAUNCH_CMD_GOTO_REC:
         if (((GotoRec*)cmd_ptr)->find_string != NULL)
            pfree(((GotoRec*)cmd_ptr)->find_string);
         pfree(cmd_ptr);
         return TRUE;
      case LAUNCH_CMD_ALARM_HIT:
         pfree(cmd_ptr);
         return TRUE;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------

/*
===========================================================================
History

June 13 2000 - Original creation
July 18 2000 - Minor stuff so that it can be posted on the web
===========================================================================
*/     
