/*
===========================================================================
File        :   main.c
Author(s)   :   The Dude From X
Company     :   WaffleGadgets
Website     :   www.wafflegadgets.com
Project     :   Typing - example on using fields & pushbuttons
Date	    :   July 18 2000
Revision    :   1.0.01
Note        :   Portions of this source were adapted from VT-OS SDK
===========================================================================
*/     

#include <system.h>
#include "res\resource.h"
#include "emudbg.h"

BOOLEAN (*FormDispatchEvent)(EvtType *Event);

//-------------------------------------------------------------------------------
static BOOLEAN EH_MainHandler(EvtType *event) {
   WORD Ip;

   switch (event->eventType) {
      case EVT_FORM_OPEN:
         FormDrawForm(MAIN_FORM);
         FormObjectSetFocus(TYPING_FIELD);
         EvtAppendEvt(EVT_INLAY_SELECT, 0, INLAY_KEYBOARD, 0, NULL);
         return TRUE;
      case EVT_CONTROL_SELECT:
         switch (event->eventID) {
            case SMALL_FNT_BTN:
               FieldSetFont(TYPING_FIELD, SMALL_FONT);
               break;
            case MEDIUM_FNT_BTN:
               FieldSetFont(TYPING_FIELD, MEDIUM_FONT);
               break;
         }
         FieldGetInsertPointPosition(TYPING_FIELD, &Ip);
         FieldSetInsertPointPositionByCharPos(TYPING_FIELD, Ip);
         FieldDrawField(TYPING_FIELD);
         FormObjectSetFocus(TYPING_FIELD);
         return TRUE;
      case EVT_KEY:
         if (event->para1 != 0) {
            FieldAddKeyInChar(TYPING_FIELD, event->para1);
         }
         break;
      case EVT_FIELD_MODIFIED:
         FieldDrawField(TYPING_FIELD);
         break;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------
static BOOLEAN AppHandleEvent(EvtType *event) {
   ObjectID formID;
   Err      found;
   void    *formPTR;
   BYTE     objectType;

   if (event->eventType == EVT_FORM_LOAD) {
      formID = event->eventID;
      found = UISearchForAddress(formID, &objectType, &formPTR);
      if (event->para1 == 1 || found != TRUE) {
         FormInitForm(formID);
         found = UISearchForAddress(formID, &objectType, &formPTR);
         if (!found) return FALSE;
      }
      switch (formID) {
         case MAIN_FORM:
            FormSetEventHandler(MAIN_FORM, (void **) &FormDispatchEvent, EH_MainHandler);
            break;
      }
      FormSetActiveForm(formID);
      return TRUE;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------
void EventLoop(void) {
   EvtType event;

   do {
      EvtGetEvent(&event);
      if (!SystemHandleEvent(&event)) {
         if (!MenuHandleEvent(&event)) {
            if (!AppHandleEvent(&event)) {
               FormDispatchEvent(&event);
            }
         }
      }
   } while(event.eventType != EVT_APP_STOP);
}
//-------------------------------------------------------------------------------
void ProgramInit(void) {
   FormPopupForm(MAIN_FORM);
}
//-------------------------------------------------------------------------------
void ProgramExit(void) {
}
//-------------------------------------------------------------------------------
__main(WORD cmd, void *cmd_ptr) {
   switch (cmd) {
      case LAUNCH_CMD_NORMAL_LAUNCH:
         UIApplicationInit();
         ProgramInit();
         EventLoop();
         ProgramExit();
         UIDeleteAllAppObjects();
         return TRUE;
      case LAUNCH_CMD_FIND:
         pfree(cmd_ptr);
         return TRUE;
      case LAUNCH_CMD_GOTO_REC:
         if (((GotoRec*)cmd_ptr)->find_string != NULL)
            pfree(((GotoRec*)cmd_ptr)->find_string);
         pfree(cmd_ptr);
         return TRUE;
      case LAUNCH_CMD_ALARM_HIT:
         pfree(cmd_ptr);
         return TRUE;
   }
   return FALSE;
}
//-------------------------------------------------------------------------------

/*
===========================================================================
History

June 14 2000 - Original creation
July 18 2000 - Minor stuff so that it can be posted on the web
===========================================================================
*/     
