/*
 * @(#)helio.h
 *
 * Copyright 1999-2001, Aaron Ardiri (mailto:aaron@ardiri.com)
 * All rights reserved.
 *
 * The  source code outlines a number of basic Helio Computing Programming
 * principles and you  should be able to take the core structure and write 
 * a large complex program. It is distributed WITHOUT ANY WARRANTY; use it
 * "AS IS" and at your own risk.
 *
 * The code presented is Copyright by Aaron Ardiri. It should be used  for 
 * educational purposes only.  You shall not modify the Cube3D source code 
 * in  any way and  re-distribute it as your own,  however you are free to
 * use the code as a guide for developing programs on the Helio  Computing 
 * Platform.
 */

#ifndef _HELIO_H
#define _HELIO_H

// system includes
#include <system.h>
#include "resource/gfx.h"

// application constants
#define CUBE_FPS 16                  // this is "adequate" for animations :)

// local includes
#include "device.h"
#include "help.h"
#include "cube3D.h"
#include "resource.h"
#include "fixed.h"

// functions
extern void    InitApplication(void);
extern BOOLEAN ApplicationHandleEvent(EvtType *);
extern void    ApplicationDisplayDialog(ObjectID);
extern void    EventLoop(void);
extern void    EndApplication(void);
extern BOOLEAN HelioMain(WORD, void *);

#endif 
