/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "system.h"
#include "sysetup.h"
#include "voxmemo.h"
#include "voxmdef.h"


//#define DEBUG

/* ==================================================================== */
/* ========================= Function Prototypes ====================== */
/* ==================================================================== */
extern DatabaseID	VoxMemo_dbid;
AppID app_id;
void EventLoop();
void MMUInit();
void KernelInit();
void ResInit();
static BOOLEAN ApplicationHandleEvent(EvtType *Event);

BOOLEAN (*FormDispatchEvent)(EvtType *Event);

extern UWORD *sys_page, *app_page;
extern REGISTRY app_reg[];

#ifdef PC_SIM
extern BOOL m_bIsExit;
#endif



/* ==================================================================== */
/* ========================= Global Variables ========================= */
/* ==================================================================== */
DatabaseID maths_dbid;
extern UBYTE res_data[];
UBYTE sysres_data[1];

/********************************************************
* Function:	ApplicationHandleEvent
* Purpose: 	This function is used to load the specific data of
form and set event handler of the form
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
static BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
	Form *form_ptr;
	ObjectID form_id;
	BYTE object_type;
	Err Error;
	
	if (Event->eventType == EVT_FORM_LOAD)
	{
		form_id = (ObjectID)Event->eventID;
		Error = UISearchForAddress(form_id,&object_type,(void**)&form_ptr);
		if (Event->para1 == 1 || Error != TRUE)
		{
			FormInitForm(form_id);
		}
		if (!UISearchForAddress(form_id,&object_type,(void**)&form_ptr)) return FALSE;
		switch (form_id)
		{
		case FORM_VOXMEMO_LIST:
			FormSetEventHandler(FORM_VOXMEMO_LIST, (void**)&FormDispatchEvent, VoxMemoList);
			break;
		case FORM_VOXMEMO_REC:
			FormSetEventHandler(FORM_VOXMEMO_REC, (void**)&FormDispatchEvent, VoxMemoRec);
			break;
		case FORM_VOXMEMO_INFO:
			FormSetEventHandler(FORM_VOXMEMO_INFO, (void**)&FormDispatchEvent, VoxMemoInfo);
			break;
		case FORM_VOXMEMO_PLAY:
			FormSetEventHandler(FORM_VOXMEMO_PLAY, (void**)&FormDispatchEvent, VoxMemoPlay);
			break;
		case FORM_VOXMEMO_DIALOG_ERASE:
			FormSetEventHandler(FORM_VOXMEMO_DIALOG_ERASE, (void**)&FormDispatchEvent, VoxMemoDialogErase);
			break;
		case FORM_VOXMEMO_DIALOG_LOWMEM:
			FormSetEventHandler(FORM_VOXMEMO_DIALOG_LOWMEM, (void**)&FormDispatchEvent, VoxMemoDialogLowMem);
			break;
		case FORM_VOXMEMO_DIALOG_SAVE:
			FormSetEventHandler(FORM_VOXMEMO_DIALOG_SAVE, (void**)&FormDispatchEvent, VoxMemoDialogSave);
			break;
		case FORM_VOXMEMO_DIALOG_RECABORT:
			FormSetEventHandler(FORM_VOXMEMO_DIALOG_RECABORT, (void**)&FormDispatchEvent, VoxMemoDialogRecAbort);
			break;
		case FORM_VOXMEMO_DIALOG_EDTITLE:
			FormSetEventHandler(FORM_VOXMEMO_DIALOG_EDTITLE, (void**)&FormDispatchEvent, VoxMemoDialogEditTitle);
			break;
		case FORM_VOXMEMO_DIALOG_LOW_BATTERY:
			FormSetEventHandler(FORM_VOXMEMO_DIALOG_LOW_BATTERY, (void**)&FormDispatchEvent, VoxMemoDialogLowBattery);
			break;
		default:
			break;
		}
		FormSetActiveForm(form_id);
		return TRUE;
	}
	//----------------------------------------------------------------------------------------------
	//------- For Hardware Keyboard's key ----------------------------------------------------------
#ifdef DEBUG
	printf("\n--->> AHE: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)	
	{
		if (Event->para2 & 0x00000200)
		{
			FormGetActiveFormID(&form_id);
			switch (form_id)
			{
			case FORM_VOXMEMO_LIST:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_VOXMEMO_LIST: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_NEW || Event->para1 == SLETTER_NEW)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_VOXMEMO_NEW_RECORD;
					Event->evtPBP		= NULL;
				}
				else if (Event->para1 == LLETTER_PLAY || Event->para1 == SLETTER_PLAY)
				{
					Event->eventType	= EVT_IO_KEY_CTRL;
					Event->eventID		= EVT_IO_KEY_PRESS;
					Event->para2		= IO_SOUND_PLAY;
					Event->evtPBP		= NULL;
				}
				break;
			case FORM_VOXMEMO_REC:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_VOXMEMO_REC: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_REC || Event->para1 == SLETTER_REC)
				{
					Event->eventType	= EVT_IO_KEY_CTRL;
					Event->eventID		= EVT_IO_KEY_PRESS;
					Event->para2		= IO_SOUND_RECORD;
					Event->evtPBP		= NULL;
				}
				else if (Event->para1 == LLETTER_STOP || Event->para1 == SLETTER_STOP)
				{
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_VOXMEMO_REC_STOP;
					Event->evtPBP		= NULL;
				}
				break;
			case FORM_VOXMEMO_INFO:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_VOXMEMO_INFO: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				break;
			case FORM_VOXMEMO_PLAY:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_VOXMEMO_PLAY: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_PLAY || Event->para1 == SLETTER_PLAY)
				{
					Event->eventType	= EVT_IO_KEY_CTRL;
					Event->eventID		= EVT_IO_KEY_PRESS;
					Event->para2		= IO_SOUND_PLAY;
					Event->evtPBP		= NULL;
				}
				else if (Event->para1 == LLETTER_STOP || Event->para1 == SLETTER_STOP)
				{
					Event->eventType	= EVT_IO_KEY_CTRL;
					Event->eventID		= EVT_IO_KEY_PRESS;
					Event->para2		= IO_SOUND_STOP;
					Event->evtPBP		= NULL;
				}
				else if (Event->para1 == LLETTER_ERASE || Event->para1 == SLETTER_ERASE)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_VOXMEMO_ERASE_RECORD;
					Event->evtPBP		= NULL;
				}
				else if (Event->para1 == LLETTER_RENAME || Event->para1 == SLETTER_RENAME)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_VOXMEMO_RENAME_RECORD;
					Event->evtPBP		= NULL;
				}
				else if ((Event->para2 & 0x000000ff) == KEY_UP)
					//else if (Event->para2 == 0x215)
				{
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_VOXMEMO_PLAY_FBWDN;
					Event->evtPBP		= NULL;
					/*
					Event->eventType	= EVT_IO_KEY_CTRL;
					Event->eventID		= EVT_IO_KEY_PRESS;
					Event->para2		= IO_UP_ARROW;
					Event->evtPBP		= NULL;
					Event->eventType	= EVT_IO_KEY_CTRL;
					Event->eventID		= EVT_IO_KEY_PRESS;
					Event->para2		= IO_SOUND_PLAY;
					Event->evtPBP		= NULL;
					*/
				}
				else if ((Event->para2 & 0x000000ff) == KEY_DOWN)
				{
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_VOXMEMO_PLAY_FFWDN;
					Event->evtPBP		= NULL;
					/*
					Event->eventType	= EVT_IO_KEY_CTRL;
					Event->eventID		= EVT_IO_KEY_PRESS;
					Event->para2		= IO_DOWN_ARROW;
					Event->evtPBP		= NULL;
					*/
				}
				break;
			case FORM_VOXMEMO_DIALOG_ERASE:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_VOXMEMO_DIALOG_ERASE: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_VOXMEMO_DIALOG_ERASE_YES;
					Event->evtPBP		= NULL;
				}
				else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_VOXMEMO_DIALOG_ERASE_NO;
					Event->evtPBP		= NULL;
				}
				break;
			case FORM_VOXMEMO_DIALOG_LOWMEM:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_VOXMEMO_DIALOG_LOWMEM: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				break;
			case FORM_VOXMEMO_DIALOG_SAVE:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_VOXMEMO_DIALOG_SAVE: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_VOXMEMO_DIALOG_SAVE_YES;
					Event->evtPBP		= NULL;
				}
				else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
				{
					Event->eventType	= EVT_CONTROL_SELECT;
					Event->eventID		= BUTTON_VOXMEMO_DIALOG_SAVE_NO;
					Event->evtPBP		= NULL;
				}
				else if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
				{
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_VOXMEMO_DIALOG_SAVE_X;
					Event->evtPBP		= NULL;
				}
				break;
			case FORM_VOXMEMO_DIALOG_RECABORT:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_VOXMEMO_DIALOG_RECABORT: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
				{
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_VOXMEMO_DIALOG_RECABORT_X;
					Event->evtPBP		= NULL;
				}
				break;
			case FORM_VOXMEMO_DIALOG_EDTITLE:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_VOXMEMO_DIALOG_EDTITLE: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
				{
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_VOXMEMO_DIALOG_EDTITLE_X;
					Event->evtPBP		= NULL;
				}
				break;
			case FORM_VOXMEMO_DIALOG_LOW_BATTERY:
#ifdef DEBUG
				printf("\n--->> AHE2 FORM_VOXMEMO_DIALOG_LOW_BATTERY: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
				{
					Event->eventType	= EVT_BITMAP_SELECT;
					Event->eventID		= BITMAP_VOXMEMO_DIALOG_LOW_BATTERY_X;
					Event->evtPBP		= NULL;
				}
				break;
			default:
#ifdef DEBUG
				printf("\n--->> AHE2 default: type=%ld, id=%ld, para1=%ld, para2=%ld", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				break;
			}
		}
		/*
		else if (form_id == FORM_VOXMEMO_PLAY && (Event->para2 == KEY_PAGE_DOWN || Event->para2 == KEY_PAGE_UP))
		{
		if (Event->para2 == KEY_PAGE_DOWN)
		Event->eventID		= BITMAP_VOXMEMO_PLAY_FBWDN;
		else
		Event->eventID		= BITMAP_VOXMEMO_PLAY_FFWDN;
		
		  Event->eventType	= EVT_BITMAP_SELECT;
		  Event->evtPBP		= NULL;		
		  }
		  */
	}
	
	return FALSE;
}

/********************************************************
* Function:	EventLoop
* Purpose: 	This function is a loop to get events from event
manager and then passes the event to different
event handler
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EventLoop(void)
{
	EvtType event;
	do
	{
		EvtGetEvent (&event);
		if (!SystemHandleEvent(&event))
		{
			if (!MenuHandleEvent(&event))
			{
				if (!ApplicationHandleEvent(&event))
				{
					FormDispatchEvent(&event);
				}
			}
		}
	}
#ifdef PC_SIM
	while (event.eventType != EVT_APP_STOP && m_bIsExit == FALSE);
#else
	while (event.eventType != EVT_APP_STOP);
#endif
}
/********************************************************
* Function:	main
* Purpose: 	main procedure of the application
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
__main(WORD cmd, void *cmd_ptr)
{
    VoxMemoAppLaunch(cmd, (void*)cmd_ptr);
}

