/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

  Software distributed under the License is distributed on an "AS IS" basis, 
  WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
  for the specific language governing rights and limitations under the License.
  
	The Original Code is VT-OS Ver. 1.1 Operating System, released 
	on October 1st, 1999
	
	  The Initial Developer of the Original Code is VTech Informations Ltd.  All 
	  codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
	  ===========================================================================
*/

/*
===========================================================================
File        :   aappinit.c
Author(s)   :   Kenng Ng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   alarm manager source
Revision    :   1.1
Note        :   None
===========================================================================
*/              



/* AlarmMgrApp           */

/*  link list structure

  show_list
  ++++++++++
  app
  type			AppHitList
  desc[]			++++++++++
  *evt_link ------------- *event  <----point to an entry in alarmgr_hitlist->event  | in same
  *next			*status <----point to an entry in alarmgr_hitlist->status | node
  *next
  
	
*/
#include "stdafx.h"
#include "platform.h"
#include "datatype.h"
#include "alarmgr.h"
#include "str.h"
#include "virtable.h"
#include "alaunch.h"
#include "sysetup.h"

#define DEBUG

AlarmEventLink *alarm_list;
AlarmQueryLink *alarm_querylist;
AlarmHitLink *alarm_hitlist;
UBYTE alarm_en;
UBYTE total_hit;
AppID sch_appid;
AppID todo_appid;
AppID ani_appid;
BYTE first_line;

BYTE date_setting;
BYTE time_setting;
extern BYTE     alarmgr_font;

#define MAX_ALARM_ENTRY	100
#define SEPERATOR	(BYTE*) "---------------------------------"

struct _hit_link
{
	AlarmEvent *event;    /* point to a valid entry in alarmmgr_hitlist */
	UBYTE *status;        /* point to a valid entry in alarmmgr_hitlist */
	struct _hit_link *next;
};
typedef struct _hit_link AlarmAppHitLink;

typedef struct _alarm_show_list
{
	AppID app;
	UBYTE type;
	BYTE app_desc[20];
	AlarmAppHitLink *evt_link;
	struct _alarm_show_list *next;
} AlarmShowLink;

AlarmShowLink *show_list;
AlarmAppHitLink *alarm_disp_index[MAX_ALARM_ENTRY];

extern VirtualTable vir_tbl;
void AlarmAppListAppend(USHORT index, BYTE* desc)
{
	first_line = 0;
	index--;
	VTInsertRow(&vir_tbl, 9999, desc, desc);
}

#define SCH_MISS	0xFFFE
#define TODO_MISS	0xFFFD
#define ANI_MISS	0xFFFC

/*Get alarmgr internal varibles */
void AlarmAppInit()
{
	CountrySettings country_setting;
	show_list = NULL;
	total_hit = 0;
	AlarmGetVariable(&alarm_list, &alarm_hitlist, &alarm_querylist, &alarm_en);
	
	/* arrange alarm hit to UI disp */
	if(SysGetAppID(SCHEDULER, &sch_appid) != TRUE) /* get scheduler's app id */
	{  /* Scheduler not found */
		sch_appid = SCH_MISS;  /* mark scheduler not found */
#ifdef DEBUG
		printf("\nAlarmMgr: Cannot found Scheduler in registry! ");
#endif
	}
	
	date_setting = SYSETUP_MDY;
	time_setting = SYSETUP_12HR_DISPLAY;

	if( SySetupGetCountrySettings(&country_setting) == TRUE)
	{
		date_setting = country_setting.date_fmt;
		time_setting = country_setting.time_fmt;
	}
	
	if(SysGetAppID(TODO, &todo_appid) != TRUE) /* get scheduler's app id */
	{  
		todo_appid = TODO_MISS;  /* mark not found */
#ifdef DEBUG
		printf("\nAlarmMgr: Cannot found To Do in registry! ");
#endif
	}
	
	if(SysGetAppID(ANN, &ani_appid) != TRUE) /* get scheduler's app id */
	{  
		ani_appid = ANI_MISS;  /* mark  not found */
#ifdef DEBUG
		printf("\nAlarmMgr: Cannot found Anniversaries in registry! ");
#endif
	}
}

/* Classify the new alarm */
void AlarmAppClassifyHit()
{
	AlarmShowLink *show_ptr = show_list, *prev_show_ptr = show_list;
	AlarmAppHitLink *evt_ptr, *prev_evt_ptr, *tmp_evt_ptr;
	UBYTE found;
	
#ifdef DEBUG
	/*
	printf("\nClassfy hit");
	printf("\n alarm_hitlist = %ld", alarm_hitlist);
	printf("\n alarm_hitlist app_id = %ld", alarm_hitlist->event->app);
	printf("\n alarm_hitlist dbid = %ld", alarm_hitlist->event->dbid);
	printf("\n alarm_hitlist rec_id = %ld", alarm_hitlist->event->rec_id);
	printf("\n alarm_hitlist voice dbid = %ld", alarm_hitlist->event->extra_info->dbid);
	printf("\n alarm_hitlist voice rec_id = %ld", alarm_hitlist->event->extra_info->rec_id);
	*/
#endif
	
	while(alarm_hitlist) {
#ifdef DEBUG
		printf("\n-------------------NewAlarmDetected");
#endif
		prev_show_ptr = show_ptr = show_list;
		found = 0;
		while(show_ptr)  /* insert the event to show list, group by appid and type */
		{
		/*			
		printf("\n ABC");
		printf("\n show_ptr->app = %ld", show_ptr->app);
		printf("\n alarm_hitlist->event->app = %ld", alarm_hitlist->event->app);
			*/
			if( (show_ptr->app == alarm_hitlist->event->app))// &&
				//(AlarmGetEventType(show_ptr) == AlarmGetEventType(alarm_hitlist->event) ))
			{  /* same app and type found */
				prev_evt_ptr = evt_ptr = show_ptr->evt_link;
				while(evt_ptr)
				{
					if (RtcCompareTime(&(alarm_hitlist->event->hit_time), &(evt_ptr->event->hit_time)))
					{ /*  this event time, should insert here > this node's time */
						tmp_evt_ptr = (AlarmAppHitLink*) qmalloc(sizeof(AlarmAppHitLink));
						tmp_evt_ptr->next = evt_ptr;
						if(evt_ptr != show_ptr->evt_link)
							prev_evt_ptr->next = tmp_evt_ptr;
						else
							show_ptr->evt_link = tmp_evt_ptr;
						tmp_evt_ptr->event = alarm_hitlist->event;
						
						tmp_evt_ptr->status = &(alarm_hitlist->status);
						found = 1;
						total_hit++;
						break;
					}
					prev_evt_ptr = evt_ptr;
					evt_ptr = evt_ptr->next;
				} /* while evt_ptr*/
				if(!found)   /* should append a new node */
				{
					if(!prev_evt_ptr)
					{  /* the first node */
						show_ptr->evt_link = (AlarmAppHitLink*) qmalloc(sizeof(AlarmAppHitLink));
						prev_evt_ptr = show_list->evt_link;
						prev_evt_ptr->next = NULL;
					}
					else
					{
						tmp_evt_ptr = (AlarmAppHitLink*) qmalloc(sizeof(AlarmAppHitLink));
						tmp_evt_ptr->next = prev_evt_ptr->next;
						prev_evt_ptr->next = tmp_evt_ptr;
						prev_evt_ptr = tmp_evt_ptr;
					}
					prev_evt_ptr->event = alarm_hitlist->event;
					prev_evt_ptr->status = &(alarm_hitlist->status);
					found = 1;
					total_hit++;
					break;
				}
			}
			if(!found)
			{
				prev_show_ptr = show_ptr;
				show_ptr = show_ptr->next;
			}
			else
				break;
		} /* while */
		
		if (!found)
		{  /* same app and type not found, append a new node at end */
			if(!prev_show_ptr)  /* == NULL */
				/* show list is empty */
			{
				show_list = (AlarmShowLink*) qmalloc(sizeof(AlarmShowLink));
				prev_show_ptr = show_list;
			}
			else
			{
				prev_show_ptr->next = (AlarmShowLink*) qmalloc(sizeof(AlarmShowLink));
				prev_show_ptr = prev_show_ptr->next;
			}
			prev_show_ptr->next = NULL;
			prev_show_ptr->app = alarm_hitlist->event->app;
			prev_show_ptr->type = AlarmGetEventType(alarm_hitlist->event);
			prev_show_ptr->evt_link = (AlarmAppHitLink*) qmalloc(sizeof(AlarmAppHitLink));
			prev_show_ptr->evt_link->event = alarm_hitlist->event;
			/*
			printf("\n alarm_hitlist = %ld", alarm_hitlist);
			printf("\n alarm_hitlist app_id = %ld", alarm_hitlist->event->app);
			printf("\n alarm_hitlist dbid = %ld", alarm_hitlist->event->dbid);
			printf("\n alarm_hitlist rec_id = %ld", alarm_hitlist->event->rec_id);
			printf("\n alarm_hitlist voice dbid = %ld", alarm_hitlist->event->extra_info->dbid);
			printf("\n alarm_hitlist voice rec_id = %ld", alarm_hitlist->event->extra_info->rec_id);
			
			  printf("\n prev_show_ptr = %ld", alarm_hitlist);
			  printf("\n prev_show_ptr app_id = %ld", alarm_hitlist->event->app);
			  printf("\n prev_show_ptr dbid = %ld", alarm_hitlist->event->dbid);
			  printf("\n prev_show_ptr rec_id = %ld", alarm_hitlist->event->rec_id);
			  printf("\n prev_show_ptr voice dbid = %ld", alarm_hitlist->event->extra_info->dbid);
			  printf("\n prev_show_ptr voice rec_id = %ld", alarm_hitlist->event->extra_info->rec_id);
			*/
			prev_show_ptr->evt_link->status = &(alarm_hitlist->status);
			prev_show_ptr->evt_link->next = NULL;
			prev_show_ptr->app_desc[0] = 0x00;
			SysGetAppName(alarm_hitlist->event->app, prev_show_ptr->app_desc);
			total_hit++;
		}
		alarm_hitlist = alarm_hitlist->next;
	}
	/*
	printf("\n Point B");   
	printf("\n Classify Hit DBID = %ld", ((show_list->evt_link)->event)->dbid);
	printf("\n Classify Hit RECID = %ld", ((show_list->evt_link)->event)->rec_id);
	printf("\n Classify Hit VOICE_DBID = %ld", (((show_list->evt_link)->event)->extra_info)->dbid);
	printf("\n Classify Hit VOICE_RECID = %ld", (((show_list->evt_link)->event)->extra_info)->rec_id);
	*/
}

/* Get an the event that is offset 'index' from root */
BOOLEAN AlarmAppGetEventFromIndex(UBYTE index, AlarmAppHitLink **hit_list)
{
	AlarmShowLink *show_ptr;
	AlarmAppHitLink *evt_ptr;
	
	show_ptr = show_list;
	while((show_ptr) && (index))
	{
		evt_ptr = show_ptr->evt_link;
		while(evt_ptr)
		{
			if(--index != 0 )
				evt_ptr = evt_ptr->next;
			else
			{
				*hit_list = evt_ptr;
				break;
			}
		}
		show_ptr = show_ptr->next;
	}
	
	if(index)	/* should be 0 */
		return FALSE;
	else
		return TRUE;
}



/* format a message to disp
input : date and message to disp.
output: formatted string
*/
void AlarmAppFormatMsg(RTM *disp_date, AlarmEvent *event, BYTE *msg, BYTE *disp_buf)
{
	BYTE tmp_buf[30];
	BYTE pos = 0;
	
	switch(AlarmGetEventClass(event))
	{
	case ALARM_ONDAY:
#ifdef DEBUG
		printf("\n ALARM_ONDAY");
#endif
		if(date_setting == SYSETUP_DMY)
			strcpy(tmp_buf, DDMM);
		else
			strcpy(tmp_buf, MMDD);
		disp_buf += RtcFormatDate(disp_date, tmp_buf, disp_buf);
		break;
	case ALARM_ONTIME:
#ifdef DEBUG
		printf("\n ALARM_ONTIME");
#endif
	default:
		if(time_setting == SYSETUP_12HR_DISPLAY)
			strcpy(tmp_buf, ALMSTR1);
		else
			strcpy(tmp_buf, ALMSTR2);
		
		pos = strlen(tmp_buf);
		if(date_setting == SYSETUP_DMY)
			strcpy(tmp_buf + pos, DDMM);
		else
			strcpy(tmp_buf + pos, MMDD);
		
		disp_buf += RtcFormatDate(disp_date, tmp_buf, disp_buf);
		break;
	}
	*disp_buf++ = '\r';
	strcpy(disp_buf, msg);
}

void AlarmAppShowList()
{
/* display sequence

  Scheduler, ToDoList, Aniversaries, Thrid Party
  each sub-type is ordered by time in decending order
	*/
	
	UBYTE index = 0;
	BYTE *disp_buf;
	AppID prev_appid;
	UBYTE count = 0;
	
	AlarmShowLink *show_ptr;
	AlarmAppHitLink *evt_ptr;
	first_line = 1;
	
	disp_buf = (BYTE*) qmalloc(230);  /* 230 byte buffer for a single message */
	
	
#ifdef DEBUG
    printf("\nShow List");
#endif
	/* go through the list to search for scheduler, events in the link already in decending order */
	show_ptr = show_list;
	while(show_ptr){
		if((show_ptr->app == sch_appid)){
			if(!first_line)	{
				AlarmAppListAppend(index, SEPERATOR);
				alarm_disp_index[index++] = NULL;	/* non-clickable */
			}
			
			alarm_disp_index[index++] = NULL;	/* non-clickable */
			AlarmAppListAppend(index, ALMSTR3);
			evt_ptr = show_ptr->evt_link;
			while(evt_ptr){
				/* put the msg to the table */
				alarm_disp_index[index++] = evt_ptr;
				AlarmAppFormatMsg(&(evt_ptr->event->hit_time), evt_ptr->event , evt_ptr->event->alert_msg, disp_buf);
				AlarmAppListAppend(index, disp_buf);
				if(evt_ptr->event->extra_info)  /* voice alarm */
					VTSetRowAlarm(&vir_tbl, index - 1, VOICE_ALARM, 0);
				else
					VTSetRowAlarm(&vir_tbl, index - 1, TONE_ALARM, 0);
				evt_ptr = evt_ptr->next;
			}
			break;
		}
		
		show_ptr = show_ptr->next;
	}
	
	/*todo: if show_ptr == NULL  =>  no event for scheduler */
	
	/* search for ToDoList */
	show_ptr = show_list;
	while(show_ptr)
	{
		if( (show_ptr->app == todo_appid))
		{
			if(!first_line)
			{
				AlarmAppListAppend(index, SEPERATOR);
				alarm_disp_index[index++] = NULL;	/* non-clickable */
			}
			alarm_disp_index[index++] = NULL;	/* non-clickable */
			AlarmAppListAppend(index, ALMSTR4);
			evt_ptr = show_ptr->evt_link;
			while(evt_ptr)
			{
				/* put the msg to the table */
				alarm_disp_index[index++] = evt_ptr;
				AlarmAppFormatMsg(&(evt_ptr->event->hit_time), evt_ptr->event , evt_ptr->event->alert_msg, disp_buf);
				AlarmAppListAppend(index, disp_buf);
				VTSetRowAlarm(&vir_tbl, index - 1, TONE_ALARM, 0);
				if(evt_ptr->event->extra_info)  /* voice alarm */
					if(evt_ptr->event->extra_info->type == TYPE_VOICE)  /* voice alarm */
						VTSetRowAlarm(&vir_tbl, index - 1, VOICE_ALARM, 0);
					evt_ptr = evt_ptr->next;
			}
			break;
		}
		show_ptr = show_ptr->next;
	}
	/*
	printf("\n show list contents");
	for (count = 0; count <= index; count++)
	{
	printf("\n count = %ld", count);
	if (alarm_disp_index[count] != NULL)
	{
	printf("\n alarm_disp_index[%ld]->event->extra_info->type = %ld", count, alarm_disp_index[count]->event->extra_info->type);
	printf("\n alarm_disp_index[%ld]->event->extra_info->dbid = %ld", count, alarm_disp_index[count]->event->extra_info->dbid);
	printf("\n alarm_disp_index[%ld]->event->extra_info->rec_id = %ld", count, alarm_disp_index[count]->event->extra_info->rec_id);
	}
	else
	printf("\n alarm_disp_index[%ld] = NULL", count);
}*/
	/*todo: if show_ptr == NULL  =>  no event for ToDo */
	
	/* search for Aniversaries */
	show_ptr = show_list;
	while(show_ptr)
	{
		if((show_ptr->app == ani_appid))
		{
			if(!first_line)
			{
				AlarmAppListAppend(index, SEPERATOR);
				alarm_disp_index[index++] = NULL;	/* non-clickable */
			}
			alarm_disp_index[index++] = NULL;	/* non-clickable */
			AlarmAppListAppend(index, ALMSTR5);
			evt_ptr = show_ptr->evt_link;
			while(evt_ptr)
			{
				/* put the msg to the table */
				alarm_disp_index[index++] = evt_ptr;
				AlarmAppFormatMsg(&(evt_ptr->event->hit_time), evt_ptr->event , evt_ptr->event->alert_msg, disp_buf);
				AlarmAppListAppend(index, disp_buf);
				if(evt_ptr->event->extra_info)  /* voice alarm */
					VTSetRowAlarm(&vir_tbl, index - 1, VOICE_ALARM, 0);
				else
					VTSetRowAlarm(&vir_tbl, index - 1, TONE_ALARM, 0);
				evt_ptr = evt_ptr->next;
			}
			break;
		}
		
		show_ptr = show_ptr->next;
	}
	
	/*todo: if show_ptr == NULL  =>  no event for Aniversaries */
	
	/* search for third party program */
	show_ptr = show_list;
	prev_appid = 0xFFFF;
	while(show_ptr)
	{
		if( (show_ptr->app != sch_appid) &&
			(show_ptr->app != todo_appid) &&
			(show_ptr->app != ani_appid) )
		{
			if((!first_line) && (show_ptr->app != prev_appid))
			{
				alarm_disp_index[index++] = NULL;	/* non-clickable */
				AlarmAppListAppend(index, SEPERATOR);
			}
			if(show_ptr->app != prev_appid)
			{
				alarm_disp_index[index++] = NULL;	/* non-clickable */
				AlarmAppListAppend(index, show_ptr->app_desc);
			}
			prev_appid = show_ptr->app;
			evt_ptr = show_ptr->evt_link;
			while(evt_ptr)
			{
				/* put the msg to the table */
				alarm_disp_index[index++] = evt_ptr;
				AlarmAppFormatMsg(&(evt_ptr->event->hit_time), evt_ptr->event , evt_ptr->event->alert_msg, disp_buf);
				AlarmAppListAppend(index, disp_buf);
				if(evt_ptr->event->extra_info)  /* voice alarm */
					VTSetRowAlarm(&vir_tbl, index - 1, VOICE_ALARM, 0);
				else
					VTSetRowAlarm(&vir_tbl, index - 1, TONE_ALARM, 0);
				evt_ptr = evt_ptr->next;
			}
		}
		show_ptr = show_ptr->next;
	}
	
#ifdef DEBUG
	printf("\n index = %ld", index);
#endif
	
    VTSetTableFontSize(&vir_tbl, alarmgr_font);
    if (alarmgr_font == SMALL_FONT)
    {
        MenuDeleteItem(MENU_POPUP, 0);
        MenuInsertItem(MENU_POPUP, 0, ALMLFONT);
    }
    else
    {
        MenuDeleteItem(MENU_POPUP, 0);
        MenuInsertItem(MENU_POPUP, 0, ALMSFONT);
    }
	VTSetVirtualTableLayout(&vir_tbl);
	VTVirtualTableSetScrollbar(&vir_tbl);
	VTTransferAllToRT(&vir_tbl, TABLE_MAIN_FRM);
	TableDrawTable(TABLE_MAIN_FRM);
	qfree(disp_buf);
}

void AlarmAppListClick(USHORT click_index)
{
#ifdef xxxxxxxxx
	AlarmEventHit *hit_event_data;
	
	if(alarm_disp_index[click_index] == NULL)	/* non-clickable */
		return;
	
	hit_event_data = (AlarmEventHit*) pmalloc(sizeof(AlarmEventHit));
	
	hit_event_data->type = alarm_disp_index[click_index]->event->type;
	hit_event_data->rec_id = alarm_disp_index[click_index]->event->rec_id;
	
	if(alarm_disp_index[click_index]->event->extra_info)
		hit_event_data->app_data = alarm_disp_index[click_index]->event->extra_info->app_data;
	else
		hit_event_data->app_data = 0xff;
	
	
	AlarmDelHit(*(alarm_disp_index[click_index]->event));
#ifdef DEBUG
	printf("\nEvent Click detected");
#endif
#endif
}

/* clear all alarm event */
void AlarmAppListClearAll()
{
	AlarmShowLink *show_ptr;
	AlarmAppHitLink *evt_ptr;
	
	show_ptr = show_list;
	while(show_ptr)
	{
		evt_ptr = show_ptr->evt_link;
		while(evt_ptr)
		{
			AlarmDelHit(*(evt_ptr->event));
			evt_ptr = evt_ptr->next;
		}
		show_ptr = show_ptr->next;
	}
	
	/*todo: clear the list */
	
	//	EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
}

extern VirtualTable vir_tbl;
void AlarmCreateVirTable()
{
	Table *tbl_ptr;
	Field *field_ptr;
	BYTE object_type;
	
	FormGetObjectPointer((ObjectID)(TABLE_MAIN_FRM), &object_type, (void**)&tbl_ptr);
	FormGetObjectPointer((ObjectID)(FIELD_ALARMPP_0), &object_type, (void**)&field_ptr);
	VTInit(&vir_tbl, tbl_ptr->bounds, 0, tbl_ptr->table_num_column,
		tbl_ptr->table_top_row_num, tbl_ptr->table_row_height, tbl_ptr->table_column_width,
		1, SCROLLBAR_MAIN_FRM);
}

void VTTableClick(USHORT clicked_row)
{
	Table *tbl_ptr;
	SHORT click_row = 0;
	UWORD acc_height = vir_tbl.vt_bounds.ycoord;
	BYTE object_type;
	USHORT acc;
	USHORT j;
	GotoRec *cmd_ptr;
	
#if 0
	/* check x bound */
	if(ptx <  vir_tbl.vt_bounds.xcoord)
		return;
	
	
	if(ptx > (vir_tbl.vt_bounds.xcoord + vir_tbl.vt_bounds.width))
		return;
	
	
	/* check y bound */
	if(pty < vir_tbl.vt_bounds.ycoord)
		return;
	
	
	if(pty > vir_tbl.vt_bounds.ycoord + vir_tbl.vt_bounds.height)
		return;
	
	
	FormGetObjectPointer((ObjectID)(TABLE_MAIN_FRM), &object_type, (void**)&tbl_ptr);
	
	
	//	if ((click_row = (pty - vir_tbl.vt_bounds.ycoord) / 9) >= vir_tbl.vt_num_rows)
	//		return;
	
	click_row = (pty - vir_tbl.vt_bounds.ycoord) / 9;
	
	
	acc = 0;
	j = vir_tbl.vt_top_row_num;
	
#ifdef DEBUG
	printf("\n virtual table top row num = %ld", vir_tbl.vt_top_row_num);
#endif
	
	while(click_row>=0)
	{
		if ( j >= vir_tbl.vt_num_rows)
			return;
		click_row -= (SHORT) vir_tbl.vt_items[j++]->ptr->field_total_num_lines;
	}
	
	j--;
#ifdef DEBUG
	printf("\nRow %d ", j);
#endif
	
	if(alarm_disp_index[j] == NULL)
	{
#ifdef DEBUG
		printf("\nNon-Clickable");
#endif
		return;
	}
	else
	{
#ifdef DEBUG
		printf("\n%s ", alarm_disp_index[j]->event->alert_msg);
#endif
	}
	
	if(ptx < tbl_ptr->bounds.xcoord + tbl_ptr->table_column_width[0])
	{
		/* click on col. 0 */
		
	}
	else
	{
#endif 
		
	j = clicked_row;
	// ===================================================
	// modified at 29062000
	if (vir_tbl.vt_top_row_num == 0)
		j += vir_tbl.vt_top_row_num ;
	// ===================================================
		
	/* click on message */
	cmd_ptr = (GotoRec*) pmalloc(sizeof(GotoRec));
	cmd_ptr->app_id = alarm_disp_index[j]->event->app;
	cmd_ptr->dbid = alarm_disp_index[j]->event->dbid;
	cmd_ptr->rec_id = alarm_disp_index[j]->event->rec_id;
	cmd_ptr->field_num = 0;
	cmd_ptr->find_string = NULL;
	AlarmSetCallApp();
	//18-Aug-2000
	printf("\n Start Call AlarmSaveAlarmHitCount()");        
	printf("\n Stop Call AlarmSaveAlarmHitCount()");
	printf("\n VTTableClick EVT_APP_STOP");
	EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
	EvtAppendEvt(EVT_APP_LAUNCH, alarm_disp_index[j]->event->app, LAUNCH_CMD_GOTO_REC, 0, cmd_ptr);
	AlarmDelHit(*(alarm_disp_index[j]->event));
	AlarmSaveAlarmHitCount();
}
	
