/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

  Software distributed under the License is distributed on an "AS IS" basis, 
  WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
  for the specific language governing rights and limitations under the License.
  
	The Original Code is VT-OS Ver. 1.1 Operating System, released 
	on October 1st, 1999
	
	  The Initial Developer of the Original Code is VTech Informations Ltd.  All 
	  codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
	  ===========================================================================
*/

/*
===========================================================================
File        :   aplaunch.c
Author(s)   :   Henry Fok, Kenny Ng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application launch sequences
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"
#include "alarmgr.h"
#include "alaunch.h"
#include "sysetup.h"

DatabaseID    sysetup_dbid;
BYTE           alarmgr_font;

#define DEBUG

/********************************************************
* Function:	StartApplication
* Purpose: 	it is the start up procedure for an application.
This function is used to load the data of form 1
from storage to RAM
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
static void StartApplication(void)
{       
    BYTE    *buffer;
    UWORD   byte_read;
	
    FormInitAllFormObjects(FORM_ALARMAPP);
	
    if (!DataFindDB(SYSETUPDB, &sysetup_dbid))
        SySetupDatabaseInit();        
    if (DataOpenDB(sysetup_dbid, 0, OPEN_RW) != TRUE)
        DataOpenDB(sysetup_dbid, 0, OPEN_RW);
	
    DataGetField(sysetup_dbid, ALARMGR_FONT, 0, &buffer, &byte_read);
    alarmgr_font = *buffer;
    qfree(buffer);
	
	ScrollbarSetScrollbarDrawPagesize(30, 10);
	AlarmCreateVirTable();
	AlarmAppInit();
	AlarmAppClassifyHit();
    AlarmAppShowList();
	
    DataCloseDB(sysetup_dbid);
	FormPopupForm(FORM_ALARMAPP);
}


BOOLEAN AlarmAppLaunch(WORD cmd, void *cmd_ptr)
{
	switch(cmd)
	{
	case LAUNCH_CMD_NORMAL_LAUNCH:
#ifdef DEBUG
		printf("\n Alarm Query");
#endif
		AlarmQueryApp();
		UIApplicationInit();
		StartApplication();
		EventLoop();
		UIDeleteAllAppObjects();
		
		//=============== Font saving =============================
		
		if (!DataFindDB(SYSETUPDB, &sysetup_dbid))
			SySetupDatabaseInit();        
		if (DataOpenDB(sysetup_dbid, F_App, OPEN_RW) != TRUE)
			DataOpenDB(sysetup_dbid, F_App, OPEN_RW);
		
		DataWriteField(sysetup_dbid, ALARMGR_FONT, 0, 1, &alarmgr_font);
		DataCloseDB(sysetup_dbid);
		SndStop();
		
		//=========================================================
		
		return TRUE;
	case LAUNCH_CMD_FIND:
		pfree(cmd_ptr);
		return TRUE;
	case LAUNCH_CMD_GOTO_REC:
		if (((GotoRec*)cmd_ptr)->find_string)
			pfree(((GotoRec*)cmd_ptr)->find_string);
		pfree(cmd_ptr);
		return TRUE;
	case LAUNCH_CMD_ALARM_HIT:
		pfree(cmd_ptr);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}
