/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   app.c
Author(s)   :   Henry Fok, Kenng Ng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application form flow
Revision    :   1.1
Note        :   None
===========================================================================
*/              

#include "stdafx.h"
#include "App.h"
#include "virtable.h"
#include "alarmgr.h"
#include "system.h"
#include "sndmgr.h"
#include "sndmevt.h"
#include "sysetup.h"
#include "dev_pwr.h"

//#define DEBUG
extern BYTE     alarmgr_font;

void AlarmAppTest();
void AlarmAppListClick(USHORT click_index);
void AlarmAppShowList();

void AlarmAppInit();
void AlarmAppClassifyHit();
BOOLEAN AlarmgrLowBattery(EvtType* Event);

UBYTE alm_type;

#define		EVT_ALARM_FIELD_SELECT			8000
#define		EVT_ALARM_FIELD_ENTER			8001
#define		EVT_ALARM_FIELD_EXIT			8002
#define     WITHSOUND

struct _hit_link
{
	AlarmEvent *event;    /* point to a valid entry in alarmmgr_hitlist */
	UBYTE *status;        /* point to a valid entry in alarmmgr_hitlist */
	struct _hit_link *next;
};
typedef struct _hit_link AlarmAppHitLink;

void SchedulerReplayScrollbarSetVolume(EvtType *Event);

VirtualTable    vir_tbl;
EvtType         alarm_old_event;
extern AlarmAppHitLink *alarm_disp_index[];
BOOLEAN play_stop = TRUE;
UWORD   play_pause_frame = 0;
DatabaseID voice_playing_dbid;
RecordID voice_playing_recid;
USHORT voice_playing_field;

/********************************************************
* Function:    AlarmAppMain
* Purpose: 	This function is the event handler for the FORM_PC_SYNC
screen of the PC SYNC application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void AlarmAppTest();
void VTTableClick(USHORT clicked_row);
BOOLEAN AlarmStringHandleEvent(EvtType *Event);

BOOLEAN AlarmAppMain(EvtType *Event)
{
    USHORT row_to_be_drawn;
    AppID appid;
    USHORT j;
    WORD    count;
    static UBYTE load_count = 0;

	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if ((Event->para2 & 0x00000200))
		{
			if (Event->para2 == 0x215 || Event->para2 == 0x21c)
			{
				ScrollbarHardButtonSetScrollbar(vir_tbl.vt_scrollbar_id, SCROLLBAR_UP_ARROW);            
				return TRUE;
			}
			else if (Event->para2 == 0x216 || Event->para2 == 0x21d)
			{
				ScrollbarHardButtonSetScrollbar(vir_tbl.vt_scrollbar_id, SCROLLBAR_DOWN_ARROW);
				return TRUE;
			}
			else if (Event->para1 == LLETTER_CANCEL || Event->para1 == SLETTER_CANCEL)
			{
				Event->eventType    =   EVT_CONTROL_SELECT;
				Event->eventID      =   BUTTON_CLEAR_ALL;
			}
		}
	}

	switch(Event->eventType)
	{
	case EVT_BITMAP_SELECT:
		j = vir_tbl.vt_top_row_num + Event->eventID - BITMAP_ALARMPP_0;
		voice_playing_dbid =  alarm_disp_index[j]->event->extra_info->dbid;
		voice_playing_recid = alarm_disp_index[j]->event->extra_info->rec_id;
		FormInitAllFormObjects(FORM_PLAY_VOICE);
		FormPopupForm(FORM_PLAY_VOICE);
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_ALARMAPP);
		if((CheckBatteryLow() == 0) && (AlarmGetAlertType(&alm_type, &voice_playing_dbid, &voice_playing_recid, &voice_playing_field) == TYPE_VOICE))
		{
			AlarmSetAlertType(TYPE_TONE);
			FormInitAllFormObjects(FORM_PLAY_VOICE);
			FormPopupForm(FORM_PLAY_VOICE);
			EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_PLAY_PLAY, 0, 0 , NULL);
		}
		InlaySetEnableStatus(FALSE);
		AlarmRestoreSoundSettings();
		return TRUE;
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(vir_tbl.vt_scrollbar_id, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(vir_tbl.vt_scrollbar_id, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
	case EVT_SCROLLBAR_SELECT:
	case EVT_SCROLLBAR_REPEAT:
		if (Event->eventID != vir_tbl.vt_scrollbar_id)
			return FALSE;
		//---------------------------------------------------------------------------
		//Michelle modified at 15-Aug-2000
		VTScrollbarSetVirtualTable(&vir_tbl, Event, &row_to_be_drawn);
		VTTransferAllToRT(&vir_tbl, TABLE_MAIN_FRM);
		TableDrawTable(TABLE_MAIN_FRM);
		return TRUE;
		//---------------------------------------------------------------------------
	case EVT_MENU_SELECT_ITEM:
		if (vir_tbl.vt_font_size == SMALL_FONT)
		{
			alarmgr_font = MEDIUM_FONT;
			VTSetTableFontSize(&vir_tbl, MEDIUM_FONT);
			MenuDeleteItem(MENU_POPUP, 0);
			MenuInsertItem(MENU_POPUP, 0, ALMSFONT);
		}
		else
		{
			alarmgr_font = SMALL_FONT;
			VTSetTableFontSize(&vir_tbl, SMALL_FONT);
			MenuDeleteItem(MENU_POPUP, 0);
			MenuInsertItem(MENU_POPUP, 0, ALMLFONT);
		}
		for (count = 0; count < vir_tbl.vt_num_rows; count++)
		{
			vir_tbl.vt_items[count]->ptr->bounds.height = 9;
			vir_tbl.vt_items[count]->ptr->screen_bounds.height = 9;
			vir_tbl.vt_row_height[count] = 9; 
		}
		VTSetVirtualTableLayout(&vir_tbl);
		VTVirtualTableSetScrollbar(&vir_tbl);
		VTTransferAllToRT(&vir_tbl, TABLE_MAIN_FRM);
		TableDrawTable(TABLE_MAIN_FRM);
		ScrollbarDrawScrollbar(vir_tbl.vt_scrollbar_id);
		return TRUE;
	case PEN_EVENT:
	case EVT_ALARM_FIELD_ENTER:
	case EVT_ALARM_FIELD_EXIT:
		AlarmStringHandleEvent(Event);
		return TRUE;
	case EVT_ALARM_FIELD_SELECT:
		VTTableClick(Event->para1);
		return TRUE;
	case EVT_CONTROL_SELECT:
		switch(Event->eventID)
		{
			AppID app_id;
		case BUTTON_CLEAR_ALL:
			AlarmDelAllHit();
			EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
			if(SysGetActiveAppID() == SysGetPrevAppID())
			{
				SysGetAppID(MAINMENU, &app_id);
				EvtAppendEvt(EVT_APP_LAUNCH, app_id, 0, 0, NULL);
			}
			else
				EvtAppendEvt(EVT_APP_LAUNCH, SysGetPrevAppID(), 0, 0, NULL);
			return TRUE;
		default: return FALSE;
		}
		return FALSE;
        default:  return FALSE;
	} //switch(Event->eventType)
}

/*****************************************************************
* Function:    AlarmStringStringHandleEvent
* Purpose:     Thsi function is called to handle the click down on string object
* Scope:		application/internal
* Input:		app_id			application id
dbid			the database id
rec_id			record id
string			the display_string
* Output:		None
* Return:		None
* Comment: 	if app_id == 0xFF, then it is noted as a separator
******************************************************************/
BOOLEAN AlarmStringHandleEvent(EvtType *Event)
{
	Field *field_ptr;
	BYTE object_type;
	ObjectID count_id;
	USHORT count = 0;
	
	if (alarm_old_event.eventType != NULL_EVENT)
		FormGetObjectPointer((ObjectID)(alarm_old_event.eventID), &object_type, (void**)&field_ptr);
	
	switch (Event->eventType)
	{
	case PEN_EVENT:
		switch (Event->eventID)
		{
		case PEN_UP:
			switch (alarm_old_event.eventType)
			{
			case EVT_ALARM_FIELD_ENTER:
				EvtAppendEvt(EVT_ALARM_FIELD_SELECT, alarm_old_event.eventID,
					alarm_old_event.para1, 0, alarm_old_event.evtPBP);
				break;
			case EVT_ALARM_FIELD_EXIT:
				break;
			default: return FALSE;
			}
			field_ptr->field_highlight_start_char = 0;
			field_ptr->field_highlight_end_char = 0;
			field_ptr->field_highlight_length = 0;
			field_ptr->field_attr.field_highlight = FALSE;
			FieldDrawField(field_ptr->identification.ui_object_id);
			alarm_old_event.eventType = NULL_EVENT;
			return TRUE;
			case PEN_DOWN:
				for (count_id = FIELD_ALARMPP_0; count_id < FIELD_ALARMPP_13; count_id++)
				{
					FormGetObjectPointer(count_id, &object_type, (void**)&field_ptr);
					if (Event->para1 >= field_ptr->screen_bounds.xcoord &&
						Event->para1 < (field_ptr->screen_bounds.xcoord + field_ptr->screen_bounds.width) &&
						Event->para2 >= field_ptr->screen_bounds.ycoord &&
						Event->para2 < (field_ptr->screen_bounds.ycoord + field_ptr->screen_bounds.height) &&
						((count_id - FIELD_ALARMPP_0 + vir_tbl.vt_top_row_num) < vir_tbl.vt_num_rows))
					{
						if (alarm_disp_index[(count_id - FIELD_ALARMPP_0 + vir_tbl.vt_top_row_num)])
						{
							EvtAppendEvt(EVT_ALARM_FIELD_ENTER, count_id, (vir_tbl.vt_top_row_num + (count_id - FIELD_ALARMPP_0)), 0, (void*)field_ptr);
							return TRUE;
						}
						else break;
					}
				}
				alarm_old_event.eventType = NULL_EVENT;
				return FALSE;
			case PEN_MOVE:
				switch (alarm_old_event.eventType)
				{
				case EVT_ALARM_FIELD_ENTER:
					FormGetObjectPointer((ObjectID)(alarm_old_event.eventID), &object_type, (void**)&field_ptr);
					if (Event->para1 < field_ptr->screen_bounds.xcoord ||
						Event->para1 >= (field_ptr->screen_bounds.xcoord + field_ptr->screen_bounds.width) ||
						Event->para2 < field_ptr->screen_bounds.ycoord ||
						Event->para2 >= (field_ptr->screen_bounds.ycoord + field_ptr->screen_bounds.height))
						EvtAppendEvt(EVT_ALARM_FIELD_EXIT, (ObjectID)(alarm_old_event.eventID),
						(vir_tbl.vt_top_row_num + (alarm_old_event.eventID - FIELD_ALARMPP_0)), 0, (void*)field_ptr);
					return TRUE;
				case EVT_ALARM_FIELD_EXIT:
					FormGetObjectPointer((ObjectID)(alarm_old_event.eventID), &object_type, (void**)&field_ptr);
					if (Event->para1 >= field_ptr->screen_bounds.xcoord &&
						Event->para1 < (field_ptr->screen_bounds.xcoord + field_ptr->screen_bounds.width) &&
						Event->para2 >= field_ptr->screen_bounds.ycoord &&
						Event->para2 < (field_ptr->screen_bounds.ycoord + field_ptr->screen_bounds.height))
						EvtAppendEvt(EVT_ALARM_FIELD_ENTER, (ObjectID)(alarm_old_event.eventID), 
						(vir_tbl.vt_top_row_num + (alarm_old_event.eventID - FIELD_ALARMPP_0)), 0, (void*)field_ptr);
					return TRUE;
				default: return FALSE;
				}
				default: return FALSE;
		}
		case EVT_ALARM_FIELD_ENTER:
			alarm_old_event = *Event;
			FormGetObjectPointer((ObjectID)(alarm_old_event.eventID), &object_type, (void**)&field_ptr);
			if (strlen(field_ptr->field_string))
			{
				field_ptr->field_highlight_start_char = 0;
				field_ptr->field_highlight_end_char = strlen(field_ptr->field_string) - 1;
				field_ptr->field_highlight_length = strlen(field_ptr->field_string);
				field_ptr->field_attr.field_highlight = TRUE;
				FieldDrawField(field_ptr->identification.ui_object_id);
			}
			return TRUE;
		case EVT_ALARM_FIELD_EXIT:
			alarm_old_event = *Event;
			FormGetObjectPointer((ObjectID)(alarm_old_event.eventID), &object_type, (void**)&field_ptr);
			field_ptr->field_highlight_start_char = 0;
			field_ptr->field_highlight_end_char = 0;
			field_ptr->field_highlight_length = 0;
			field_ptr->field_attr.field_highlight = FALSE;
			FieldDrawField(field_ptr->identification.ui_object_id);
			return TRUE;
		default: return FALSE;
	}
}

/********************************************************
* Function:    AlarmPlayVoice
* Purpose:     This function is the event handler for the FORM_PLAY_VOICE
screen of the Alarm application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN AlarmPlayVoice(EvtType *Event)
{
	BYTE            object_type;
	Bitmap          *bitmap_ptr;
    SoundSettings   sound;
	Scrollbar       *scroll_ptr;
    UWORD           rec_num;
    RecordID        rec_id;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
            if (Event->para1 == LLETTER_PLAY || Event->para1 == SLETTER_PLAY)
            {
                if (FormGetObjectPointer(BITMAP_PLAY_PAUSE, &object_type, (void**)&bitmap_ptr) == TRUE)
                {
                    if (bitmap_ptr->bitmap_attr.bitmap_visible)
                    {
						Event->eventType    = EVT_BITMAP_SELECT;
                        Event->eventID      = BITMAP_PLAY_PAUSE;
                        Event->evtPBP       = NULL;
                    }
                }                                       
                if (FormGetObjectPointer(BITMAP_PLAY_PLAY, &object_type, (void**)&bitmap_ptr) == TRUE)
                {
                    if (bitmap_ptr->bitmap_attr.bitmap_visible)
                    {
						Event->eventType    = EVT_BITMAP_SELECT;
                        Event->eventID      = BITMAP_PLAY_PLAY;
                        Event->evtPBP       = NULL;
                    }           
                }
            }                            
            else if (Event->para1 == LLETTER_STOP || Event->para1 == SLETTER_STOP)
            {
                if (FormGetObjectPointer(BITMAP_PLAY_STOP, &object_type, (void**)&bitmap_ptr) == TRUE)
                {
                    if (bitmap_ptr->bitmap_attr.bitmap_visible)
                    {
						Event->eventType    = EVT_BITMAP_SELECT;
                        Event->eventID      = BITMAP_PLAY_STOP;
                        Event->evtPBP       = NULL;
                    }
                }                                            
            }                                        
            else if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
            {
                if (FormGetObjectPointer(BITMAP_PLAY_X, &object_type, (void**)&bitmap_ptr) == TRUE)
                {
                    if (bitmap_ptr->bitmap_attr.bitmap_visible)
                    {
						Event->eventType    = EVT_BITMAP_SELECT;
                        Event->eventID      = BITMAP_PLAY_X;
                        Event->evtPBP       = NULL;
                    }
                }                                            
            }                       
            else if (Event->para2 == 0x214 || Event->para2 == 0x21F)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_PLAY, SCROLLBAR_UP_ARROW);            
                return TRUE;            
            }
            else if (Event->para2 == 0x217 || Event->para2 == 0x21e)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_PLAY, SCROLLBAR_DOWN_ARROW);            
                return TRUE;            
            }                                
        }       
    }                        
	
	switch (Event->eventType)
	{
	case POWER_EVENT:
		if (Event->eventID == BAT_MAIN_LOW)
		{
			FormGetObjectPointer(BITMAP_PLAY_PAUSE, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
			FormGetObjectPointer(BITMAP_PLAY_PLAY, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
			BitmapDrawBitmap(BITMAP_PLAY_PLAY);
			SndStop();
			play_pause_frame = 0;
			play_stop = TRUE;
			InlaySetEnableStatus(TRUE);
			AlarmMgrEnable(TRUE);
			SystemSetMappedHardwareKeyStatus(TRUE);
			BatteryWarningSetEnableStatus(TRUE);
			return TRUE;
		}
		return FALSE;
	case SND_MGR_EVT:
		if (Event->eventID == REC_END)
			if(alm_type != TYPE_VOICE)
			{
				FormGetObjectPointer(BITMAP_PLAY_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_PLAY_PLAY, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_PLAY_PLAY);
				SndStop();
				play_pause_frame = 0;
				play_stop = TRUE;
				InlaySetEnableStatus(TRUE);
				AlarmMgrEnable(TRUE);
				SystemSetMappedHardwareKeyStatus(TRUE);
				BatteryWarningSetEnableStatus(TRUE);
				return TRUE;
			}
			else   /* form load by alm hit */
			{
				play_stop = TRUE;
				play_pause_frame = 0;
				SndStop();
				DataCloseRecord(voice_playing_dbid, voice_playing_recid);
				InlaySetEnableStatus(TRUE);
				SystemSetMappedHardwareKeyStatus(TRUE);
				FormPopupForm(FORM_ALARMAPP);
				InlaySetEnableStatus(TRUE);
				AlarmMgrEnable(TRUE);
				SystemSetMappedHardwareKeyStatus(TRUE);
				BatteryWarningSetEnableStatus(TRUE);
				return TRUE;
			}
			return FALSE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			play_stop = TRUE;
			play_pause_frame = 0;
			SndStop();
			InlaySetEnableStatus(TRUE);
			SystemSetMappedHardwareKeyStatus(TRUE);
			DataCloseRecord(voice_playing_dbid, voice_playing_recid);
			DataCloseDB(voice_playing_dbid);
			FormPopupForm(FORM_ALARMAPP);
			InlaySetEnableStatus(TRUE);
			AlarmMgrEnable(TRUE);
			SystemSetMappedHardwareKeyStatus(TRUE);
			BatteryWarningSetEnableStatus(TRUE);
			AlarmMgrEnable(TRUE);
		}
		return TRUE;
	case EVT_BITMAP_SELECT:
		if (Event->eventID == BITMAP_PLAY_PAUSE)
		{
			FormGetObjectPointer(BITMAP_PLAY_PAUSE, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
			FormGetObjectPointer(BITMAP_PLAY_PLAY, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
			BitmapDrawBitmap(BITMAP_PLAY_PLAY);
			play_pause_frame = SndPause();
			return TRUE;
		}
		else if (Event->eventID == BITMAP_PLAY_PLAY)
		{
#ifdef DEBUG
			printf("\n Start to check battery");
#endif
			if (CheckBatteryLow() == 1)
			{
#ifdef DEBUG
				printf("\n Battery Low");
#endif
				SndStop();
				play_stop = TRUE;
				play_pause_frame = 0;
				FormGetObjectPointer(BITMAP_PLAY_PLAY, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_PLAY_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				BitmapDrawBitmap(BITMAP_PLAY_PLAY);
				InlaySetEnableStatus(TRUE);
				AlarmMgrEnable(TRUE);
				SystemSetMappedHardwareKeyStatus(TRUE);
				BatteryWarningSetEnableStatus(TRUE);
				FormPopupForm(FORM_ALARM_VOICE_LOW_BATTERY);
				return FALSE;
			}
#ifdef DEBUG
			printf("\n Battery Normal");
#endif
			FormGetObjectPointer(BITMAP_PLAY_PLAY, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
			FormGetObjectPointer(BITMAP_PLAY_PAUSE, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
			BitmapDrawBitmap(BITMAP_PLAY_PAUSE);
			
			if (play_stop == TRUE)
				SndPlay(play_pause_frame, voice_playing_dbid, voice_playing_recid, 0);
			else SndREPlay(play_pause_frame, voice_playing_dbid, voice_playing_recid, 0);
			
			play_stop = FALSE;
			InlaySetEnableStatus(FALSE);
			AlarmMgrEnable(FALSE);
			SystemSetMappedHardwareKeyStatus(FALSE);
			BatteryWarningSetEnableStatus(FALSE);
			return TRUE;
		}
		else if (Event->eventID == BITMAP_PLAY_STOP)
		{
			FormGetObjectPointer(BITMAP_PLAY_PAUSE, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
			FormGetObjectPointer(BITMAP_PLAY_PLAY, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
			BitmapDrawBitmap(BITMAP_PLAY_PLAY);
			SndStop();
			play_pause_frame = 0;
			play_stop = TRUE;
			InlaySetEnableStatus(TRUE);
			AlarmMgrEnable(TRUE);
			SystemSetMappedHardwareKeyStatus(TRUE);
			BatteryWarningSetEnableStatus(TRUE);
			return TRUE;
		}
		else
		{
			play_stop = TRUE;
			play_pause_frame = 0;
			SndStop();
			DataCloseRecord(voice_playing_dbid, voice_playing_recid);
			InlaySetEnableStatus(TRUE);
			SystemSetMappedHardwareKeyStatus(TRUE);
			FormPopupForm(FORM_ALARMAPP);
			InlaySetEnableStatus(TRUE);
			AlarmMgrEnable(TRUE);
			SystemSetMappedHardwareKeyStatus(TRUE);
			BatteryWarningSetEnableStatus(TRUE);
			return TRUE;
		}
		break;
		
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS && Event->para2 == IO_SOUND_PLAY)
		{
			FormGetObjectPointer(BITMAP_PLAY_PLAY, &object_type, (void**)&bitmap_ptr);
			if (bitmap_ptr->bitmap_attr.bitmap_visible == TRUE)
			{
				if (CheckBatteryLow() == 1)
				{
					SndStop();
					play_stop = TRUE;
					play_pause_frame = 0;
					FormGetObjectPointer(BITMAP_PLAY_PLAY, &object_type, (void**)&bitmap_ptr);
					bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
					bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
					FormGetObjectPointer(BITMAP_PLAY_PAUSE, &object_type, (void**)&bitmap_ptr);
					bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
					BitmapDrawBitmap(BITMAP_PLAY_PLAY);
					InlaySetEnableStatus(TRUE);
					AlarmMgrEnable(TRUE);
					SystemSetMappedHardwareKeyStatus(TRUE);
					BatteryWarningSetEnableStatus(TRUE);
					FormPopupForm(FORM_ALARM_VOICE_LOW_BATTERY);
					return FALSE;
				}
				FormGetObjectPointer(BITMAP_PLAY_PLAY, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_PLAY_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_PLAY_PAUSE);
				
				if (play_stop == TRUE)
					SndPlay(play_pause_frame, voice_playing_dbid, voice_playing_recid, 0);
				else SndREPlay(play_pause_frame, voice_playing_dbid, voice_playing_recid, 0);
				
				play_stop = FALSE;
				InlaySetEnableStatus(FALSE);
				AlarmMgrEnable(FALSE);
				SystemSetMappedHardwareKeyStatus(FALSE);
				BatteryWarningSetEnableStatus(FALSE);
				return TRUE;
			}
			else
			{
				FormGetObjectPointer(BITMAP_PLAY_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_PLAY_PLAY, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_PLAY_PLAY);
				play_pause_frame = SndPause();
				return TRUE;
			}
		}
		else if (Event->eventID == EVT_IO_KEY_PRESS && Event->para2 == IO_SOUND_STOP)
		{
			FormGetObjectPointer(BITMAP_PLAY_PAUSE, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
			FormGetObjectPointer(BITMAP_PLAY_PLAY, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
			BitmapDrawBitmap(BITMAP_PLAY_PLAY);
			SndStop();
			play_pause_frame = 0;
			play_stop = TRUE;
			InlaySetEnableStatus(TRUE);
			AlarmMgrEnable(TRUE);
			SystemSetMappedHardwareKeyStatus(TRUE);
			BatteryWarningSetEnableStatus(TRUE);
			return TRUE;
		}
		else if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_PLAY, SCROLLBAR_DOWN_ARROW);
			//					ScrollbarHardButtonSetScrollbar(SCROLLBAR_PLAY, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_PLAY, SCROLLBAR_UP_ARROW);
			//					ScrollbarHardButtonSetScrollbar(SCROLLBAR_PLAY, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
	case EVT_SCROLLBAR_SELECT:
		SchedulerReplayScrollbarSetVolume(Event);
		return TRUE;
	case EVT_SCROLLBAR_REPEAT:
		ScrollbarDrawScrollbar(SCROLLBAR_PLAY);
		return TRUE;
	case EVT_FORM_OPEN:
		play_stop = TRUE;
		play_pause_frame = 0;
		
		DataOpenDB(voice_playing_dbid, 0, OPEN_RW);
		DataRecIDtoNum(voice_playing_dbid, voice_playing_recid, &rec_num);
		DataOpenRecord(voice_playing_dbid, rec_num, &rec_id, NULL);
		
		FormGetObjectPointer(BITMAP_PLAY_PAUSE, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bounds.ycoord = 92;
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
		FormGetObjectPointer(BITMAP_PLAY_STOP, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
		bitmap_ptr->bounds.ycoord = 92;
		FormGetObjectPointer(BITMAP_PLAY_PLAY, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bounds.ycoord = 92;
		bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
		
		SySetupGetSoundSettings(&sound);
		FormGetObjectPointer(SCROLLBAR_PLAY, &object_type, (void**)&scroll_ptr);
		scroll_ptr->scrollbar_min = sound.vol_min;
		scroll_ptr->scrollbar_total_num_lines = sound.vol_max;
		scroll_ptr->scrollbar_max = sound.vol_max - 1;
		scroll_ptr->scrollbar_value = sound.vol_curr;
		FormDrawForm(FORM_PLAY_VOICE);
		return TRUE;
	default: return FALSE;
	}
}

/********************************************************
* Function:	SchedulerReplayScrollbarSetVolume
* Purpose: 	This function is called to handle the scrollbar 
event to set the volume
* Scope:		application/internal
* Input:		date				
* Output:		None
* Return:		TRUE		
FALSE		
* Comment: 	None
*********************************************************/
void SchedulerReplayScrollbarSetVolume(EvtType *Event)
{
	WORD value, max_value, min_value, pagesize, total_num_lines;
	
    ScrollbarGetScrollbar(SCROLLBAR_PLAY, &value, &max_value, 
						  &min_value, &pagesize, &total_num_lines);
	
    ScrollbarSetScrollbar(SCROLLBAR_PLAY, (Event->para2), max_value, 
						  min_value, pagesize, total_num_lines);
	
    ScrollbarDrawScrollbar(SCROLLBAR_PLAY);
#ifndef PC_SIM
    SySetupScrollbarSetVolSettings(min_value, max_value,(USHORT)(Event->para2));
#endif
	
}

/********************************************************
* Function:    AlarmgrLowBattery
* Purpose:     This function is called to handle the event to FORM_ALARM_VOICE_LOW_BATTERY
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN AlarmgrLowBattery(EvtType* Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }
        }
    }


    switch (Event->eventType)
    {
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_ALARM_VOICE_LOW_BATTERY);
		return TRUE;
	case EVT_BITMAP_SELECT:
		FormPopupForm(FORM_PLAY_VOICE);
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			FormPopupForm(FORM_PLAY_VOICE);
			return TRUE;
		}
		break;
	default:
		return FALSE;
    }
}