/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   annfunc.h
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef __ANNFUNC_H_
#define __ANNFUNC_H_

#include "uifunc.h"
#include "ui.h"
#include "mmu.h"
#include "SySetup.h"
#include "Ann.h"
#include "AnnDB.h"
#include "date.h"

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
extern DatabaseID		ann_dbid;
extern BYTE **			ann_field_buffer;
extern BYTE 			ann_text_buffer[5];
extern TableDisplay		anniver_list;
extern AppStatus		app_status;
extern CheckStatus		chk_status;
extern BYTE				alarm_date, alarm_set_by;
extern BYTE				week_click;
extern BYTE				table_string;
extern BOOLEAN			valid_input;
extern WORD				field_top_line, field_insert_pt_pos;
//extern SHORT			year_roundoff;

/*****************************************************************
********************** To Do List Application ********************
*****************************************************************/
BOOLEAN AnnSetTableTopRowNum(UWORD top_record);
BOOLEAN AnnSetScrollbar();
BOOLEAN AnnDisplayGetRecordID(TableDisplay *table_display, USHORT row_num,RecordID *rec_id, DatabaseID *dbid);
BOOLEAN AnnSetUpFieldScreen(ObjectID form_id);
BOOLEAN AnnEditSetField(ObjectID form_id, ObjectID field_id);
BOOLEAN AnnFieldSetScrollbar(ObjectID field_id, ObjectID scrollbar_id);
BOOLEAN AnnChangeFont();
BOOLEAN	AnnCheckAnyChange ();
BOOLEAN AnnTableSetScrollbar();
BOOLEAN AnnViewingSelectedLargeFontOnly();
void AnnSetTableFont();
void AnnScrollbarSetTable(EvtType *Event);
void AnnRecordToVariable();
void AnnViewingSetUpScreen();
void AnnInitFieldBuffer();
void AnnFieldToFieldBuffer();
void AnnAlarmSetUpScreen();
void AnnSetStartOfWeekScreen();
void AnnFieldBufferToField();
void AnnClearFieldBuffer();
void AnnUpperWeekSettingsUpdate(USHORT input_year, USHORT input_month, USHORT input_day);
void AnnLowerWeekSettingsUpdate(USHORT input_year, USHORT input_month, USHORT input_day);
void AnnUpperWeekSettingsOnOff(BOOLEAN case_on);
void AnnSetUpWeekNumber(BYTE add_key);
void AnnYearSettingUpdate(USHORT *input_year, ObjectID form_id);
BOOLEAN AnnYearShiftUpdate(BOOLEAN shift);
void AnnMenuSelectedAction(USHORT item_num);
void AnnNewSetUpVariable();
void AnnAlarmSetUpButton(BYTE *ptr, SHORT year, SHORT month, SHORT day, SHORT *len);
void AnnPackDueDate(BYTE *ptr, SHORT year, SHORT month, SHORT day);
void AnnDateSettingsUpdate(USHORT year, USHORT month, USHORT day);
void AnnScrollbarSetField(ObjectID field_id, ObjectID scrollbar_id, EvtType *Event);
void AnnFindOutAlarmSetBy();
void AnnYearUpdateDayMonth(BYTE start_of_week);
Err AnnGetClickedCell(ObjectID table_id,SHORT x_coord,SHORT y_coord,USHORT *row_number,
					  USHORT *col_number,USHORT *cell_number);
#endif
