/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   aplaunch.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"
#include "appfunc.h"

/********************************************************
* Function:	CalculatorAppLaunch
* Purpose: 	This function is called to launch the 
calculator application
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN CalculatorAppLaunch(WORD cmd, void *cmd_ptr)
{
	KeyboardSetKeyboardInvisible();
	
	switch(cmd)
	{
	case LAUNCH_CMD_NORMAL_LAUNCH:
		UIApplicationInit();
		MathsAppRestore(FALSE);
		EventLoop();
		if (MemoryNormal)
			MathsAppSave();
		UIDeleteAllAppObjects();
		return TRUE;
	case LAUNCH_CMD_FIND:
		pfree(cmd_ptr);
		return TRUE;
	case LAUNCH_CMD_GOTO_REC:
		if (((GotoRec*)cmd_ptr)->find_string)
	           pfree(((GotoRec*)cmd_ptr)->find_string);
		pfree(cmd_ptr);
		return TRUE;
	case LAUNCH_CMD_ALARM_HIT:
		pfree(cmd_ptr);
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}

