/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   exchange.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"
#include "exrate.h"

/********************************************************
* Function:	ExchangeSetStringExchange0Text
* Purpose: 	set the text of STRING_EXCHANGE_0
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void ExchangeSetStringExchange0Text()
{
	BYTE buffer[50];
	SHORT selected_item;
	
	ControlPopupGetSelectedItem(POPUP_TRIGGER_F, &selected_item);
    strcpy(buffer, country_name[selected_item]);
	buffer[3] = ':';
	buffer[4] = '\0';
	StringSetText(STRING_EXCHANGE_0, buffer);
	StringDrawString(STRING_EXCHANGE_0);
}

/********************************************************
* Function:	ExchangeSetStringExchange1Text
* Purpose: 	set the text of STRING_EXCHANGE_1
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void ExchangeSetStringExchange1Text()
{
	BYTE *string_text, buffer[50];
	SHORT selected_item;
	USHORT i;
	
	ControlPopupGetSelectedItem(POPUP_TRIGGER_S, &selected_item);	
	
	StringGetText(STRING_EXCHANGE_1, &string_text);
	strcpy(buffer, string_text);
	
	for (i = 0; i < 3; i++)
		buffer[i] = (country_name[selected_item])[i];
	
	StringSetText(STRING_EXCHANGE_1, buffer);
	StringDrawString(STRING_EXCHANGE_1);
}

/********************************************************
* Function:	ExchangeDisplayExchangeRate
* Purpose: 	set the text of exchange rate
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void ExchangeDisplayExchangeRate()
{
	SHORT 		f_selected_item, s_selected_item;
	BYTE  		rate[50], *result_rate, *add_zero;
	double 		exchange_rate;
	UWORD 		byte_read, i;
    Textbox 	*textbox_ptr;
    BYTE    	object_type;
	
    FormGetObjectPointer(TEXTBOX_EXCHANGE_RATE, &object_type, (void**)&textbox_ptr);
	ControlPopupGetSelectedItem(POPUP_TRIGGER_F, &f_selected_item);
	ControlPopupGetSelectedItem(POPUP_TRIGGER_S, &s_selected_item);
	
    exchange_rate = ExchangeGetExchangeRate(f_selected_item, s_selected_item);
	if (f_selected_item != s_selected_item)
        textbox_ptr->textbox_attr.textbox_enable = TRUE;        
	else
        textbox_ptr->textbox_attr.textbox_enable = FALSE;        
	
	dtoa(exchange_rate, (char*)(rate), 20);
	CalculatorChopDisplay(rate, 11, &result_rate);
	//------------ remove all unwanted zeros -------------
	i = strlen(result_rate) - 1;
	while (result_rate[i] == '0' && i >= 0)
	{
		result_rate[i] = '\0';
		i--;
	}
	MetricAddZeroBehindDecimal(result_rate, 2, 12, &add_zero);
	TextboxSetText(TEXTBOX_EXCHANGE_RATE, add_zero);
	qfree(add_zero);
	qfree(result_rate);
	
}

/********************************************************
* Function:	ExchangeCalculate
* Purpose: 	Calculate the result
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
BOOLEAN ExchangeCalculate()
{
	Textbox 	*textbox_ptr, *textbox_ptr1;
	BOOLEAN 	error = FALSE;
	BYTE 		*textbox_text, *textbox_text1, *string_text;
	BYTE 		*source_text, temp_text[100], *rate_text, *result_text, *add_zero;
	double 		source, exchange_rate, result;
	BYTE 		object_type;
	USHORT 		i;
    ObjectID 	active_form;
    BOOLEAN		found_decimal = FALSE;
	
	FormGetObjectPointer(TEXTBOX_EXCHANGE_INPUT, &object_type, (void**)&textbox_ptr);
	FormGetObjectPointer(TEXTBOX_EXCHANGE_RATE, &object_type, (void**)&textbox_ptr1);
	TextboxGetTextPointer(TEXTBOX_EXCHANGE_INPUT, &textbox_text);
	TextboxGetTextPointer(TEXTBOX_EXCHANGE_RATE, &textbox_text1);
	
	if (strlen(textbox_text1) == 0)
	{
		FormPopupForm(FORM_EXCHANGE_RATE);
		error = TRUE;
        return FALSE;
	}
	
	source = atod((char*)textbox_text);
	exchange_rate = atod((char*)textbox_text1);
	result = source * exchange_rate;
	
	/* overflow */
    if (result > 9999999999.0)
	{
		enter_form_id = FORM_EXCHANGE;
        FormGetActiveFormID(&active_form);
        if (active_form != FORM_METRIC_OVERFLOW)
        {
            FormInitAllFormObjects(FORM_METRIC_OVERFLOW);
            FormPopupForm(FORM_METRIC_OVERFLOW);
        }
        return FALSE;
	}
	
    if (strlen(textbox_text) == 0)
    {
        ExchangeSetStringExchange1Text();
        return FALSE;
    }
	strcpy(temp_text, textbox_text);
	
	CalculatorChopDisplay(temp_text, strlen(textbox_text), &source_text);
	
	TextboxSetText(TEXTBOX_EXCHANGE_INPUT, source_text);
	TextboxSetLeftCharPos(TEXTBOX_EXCHANGE_INPUT, 0);
	TextboxDrawTextbox(TEXTBOX_EXCHANGE_INPUT);
	
	qfree(source_text);
	
    if (error == TRUE) return FALSE;
	
	strcpy(temp_text, textbox_text1);
	CalculatorChopDisplay(temp_text, strlen(textbox_text1), &rate_text);
	
	TextboxSetText(TEXTBOX_EXCHANGE_RATE, rate_text);
	TextboxSetLeftCharPos(TEXTBOX_EXCHANGE_RATE, 0);
	TextboxDrawTextbox(TEXTBOX_EXCHANGE_RATE);
	
	qfree(rate_text);
	
	result = source * exchange_rate;
	dtoa(result, (char*)temp_text, 20);
	CalculatorChopDisplay(temp_text, 10, &result_text);
	
	//------------ remove all unwanted zeros in STRING_EXCHANGE_1 -------------
	i = 0;
	while (result_text[i] != 0)
	{
		if (result_text[i] == '.')
		{
			found_decimal = TRUE;
			break;
		}
		i++;
	}
	
	if (found_decimal == TRUE)
	{
		i = strlen(result_text) - 1;
		while (result_text[i] == '0' && i >= 0)
		{
			result_text[i] = '\0';
			i--;
		}
	}
	MetricAddZeroBehindDecimal(result_text, 2, 10,&add_zero);
	StringGetText(STRING_EXCHANGE_1, &string_text);
	strcpy(temp_text, string_text);
	temp_text[4] = 32;
	strcpy((temp_text + 5), add_zero);
	StringSetText(STRING_EXCHANGE_1, temp_text);
	StringDrawString(STRING_EXCHANGE_1);
	qfree(add_zero);
	qfree(result_text);
    return TRUE;
}


/********************************************************
* Function:	ExchangeUpdateExchangeRate
* Purpose: 	This function is called to check whether a exchange rate
is in the textbox or not
if yes, the database will be updated
if no, a form is popuped
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
BOOLEAN ExchangeUpdateExchangeRate()
{
	BYTE 	*textbox_text;
	SHORT 	f_selected_item, s_selected_item;
	double 	exchange_rate;
	
	TextboxGetTextPointer(TEXTBOX_EXCHANGE_RATE, &textbox_text);
	if (strlen(textbox_text) == 0)
	{
		FormPopupForm(FORM_EXCHANGE_RATE);
		return FALSE;
	}
	else
	{
		exchange_rate = atod((char*)textbox_text);
		ControlPopupGetSelectedItem(POPUP_TRIGGER_F, &f_selected_item);
		ControlPopupGetSelectedItem(POPUP_TRIGGER_S, &s_selected_item);
		
		if (f_selected_item > s_selected_item)
            ExchangeRate->exchange_rate_array[f_selected_item][s_selected_item] = exchange_rate;
		else if (f_selected_item < s_selected_item) 					
            ExchangeRate->exchange_rate_array[s_selected_item][f_selected_item] = 1/exchange_rate;
		return TRUE;
	}
}
