/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   ex_rate.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Exchange rate
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "exrate.h"
#include "math.h"
#include "app.h"

BYTE        country_name[NUM_OF_COUNTRIES][4] = {CUR1, CUR2, CUR3, CUR4, CUR5,
CUR6, CUR7, CUR8, CUR9, CUR10,
CUR11, CUR12, CUR13, CUR14, CUR15,        									 
CUR16, CUR17, CUR18, CUR19, CUR20,        									 
CUR21, CUR22, CUR23, CUR24, CUR25,
CUR26, CUR27, CUR28, CUR29, CUR30,
CUR31, CUR32, CUR33, CUR34, CUR35,
CUR36, CUR37, CUR38, CUR39, CUR40,
CUR41, CUR42, CUR43, CUR44, CUR45,
CUR46, CUR47, CUR48, CUR49, CUR50,
CUR51, CUR52, CUR53, CUR54, CUR55,
CUR56, CUR57, CUR58, CUR59, CUR60,
CUR61, CUR62, CUR63, CUR64};

//double        exchange_rate_array[NUM_OF_COUNTRIES][NUM_OF_COUNTRIES];
EXCHANGERATE    *ExchangeRate;
BOOLEAN         ex_rate_db_init = FALSE;

/********************************************************
* Function:	ExchangeInitExchangeRateDatabase
* Purpose: 	This function is called to initialise 
the exchange rate table 				
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void ExchangeInitExchangeRateDatabase()
{
	double 		rate;
	USHORT 		x, y;
    double 		exchange_rate[NUM_OF_COUNTRIES];
	
    exchange_rate[0] = R00;
    exchange_rate[1] = R01;
    exchange_rate[2] = R02;
    exchange_rate[3] = R03;
    exchange_rate[4] = R04;
    exchange_rate[5] = R05;
    exchange_rate[6] = R06;
    exchange_rate[7] = R07;
    exchange_rate[8] = R08;
    exchange_rate[9] = R09;
	
    exchange_rate[10] = R10;
    exchange_rate[11] = R11;
    exchange_rate[12] = R12;
    exchange_rate[13] = R13;
    exchange_rate[14] = R14;
    exchange_rate[15] = R15;
    exchange_rate[16] = R16;
    exchange_rate[17] = R17;
    exchange_rate[18] = R18;
    exchange_rate[19] = R19;
    exchange_rate[20] = R20;
	
    exchange_rate[21] = R21;
    exchange_rate[22] = R22;
    exchange_rate[23] = R23;
    exchange_rate[24] = R24;
    exchange_rate[25] = R25;
    exchange_rate[26] = R26;
    exchange_rate[27] = R27;
    exchange_rate[28] = R28;
    exchange_rate[29] = R29;
    exchange_rate[30] = R30;
	
    exchange_rate[31] = R31;
    exchange_rate[32] = R32;
    exchange_rate[33] = R33;
    exchange_rate[34] = R34;
    exchange_rate[35] = R35;
    exchange_rate[36] = R36;
    exchange_rate[37] = R37;
    exchange_rate[38] = R38;
    exchange_rate[39] = R39;
    exchange_rate[40] = R40;
	
    exchange_rate[41] = R41;
    exchange_rate[42] = R42;
    exchange_rate[43] = R43;
    exchange_rate[44] = R44;
    exchange_rate[45] = R45;
    exchange_rate[46] = R46;
    exchange_rate[47] = R47;
    exchange_rate[48] = R48;
    exchange_rate[49] = R49;
    exchange_rate[50] = R50;
	
    exchange_rate[51] = R51;
    exchange_rate[52] = R52;
    exchange_rate[53] = R53;
    exchange_rate[54] = R54;
    exchange_rate[55] = R55;
    exchange_rate[56] = R56;
    exchange_rate[57] = R57;
    exchange_rate[58] = R58;
    exchange_rate[59] = R59;
    exchange_rate[60] = R60;
	
    exchange_rate[61] = R61;
    exchange_rate[62] = R62;
    exchange_rate[63] = R63;
	
    if (!ex_rate_db_init)
    {
        ExchangeRate = (EXCHANGERATE*)qmalloc(sizeof(EXCHANGERATE));
		for (x = 1; x < NUM_OF_COUNTRIES; x++)
        {
            for (y = 0; y < x; y++)
            {
                rate = exchange_rate[x]/exchange_rate[y];
                ExchangeRate->exchange_rate_array[x][y] = rate;
            }
        }
        DataNewRecordWithID(maths_dbid, EXCHANGE_RATE, 0, 1);
        DataWriteField(maths_dbid, EXCHANGE_RATE, 0, sizeof(EXCHANGERATE), (BYTE*)ExchangeRate);
    }
	
    ex_rate_db_init = TRUE;
    DataWriteField(maths_dbid, EXCHANGE_INFO, 6, sizeof(BOOLEAN), (BYTE*)&ex_rate_db_init);
}

/********************************************************
* Function:	ExchangeGetExchangeRate
* Purpose: 	set the text of exchange rate
* Scope:	application/internal
* Input:	None
* Output	an exchange_rate
* Return:	None
* Comment: 	None
*********************************************************/
double ExchangeGetExchangeRate(USHORT first_country, USHORT second_country)
{
	if (first_country > second_country)
        return (ExchangeRate->exchange_rate_array[first_country][second_country]);
	else if (first_country < second_country)
        return (1/(ExchangeRate->exchange_rate_array[second_country][first_country]));
	else 
		return 1.0;
}

/********************************************************
* Function:	ExchangeUpdateDatabase
* Purpose: 	To update exchange rate database with new
exchange rates
* Scope:		application
* Input:		None
* Output		None
* Return:		None
* Comment: 	None
*********************************************************/
void ExchangeUpdateDatabase()
{
    DataWriteField(maths_dbid, EXCHANGE_RATE, 0, sizeof(EXCHANGERATE), (BYTE*)ExchangeRate);
    DataWriteField(maths_dbid, EXCHANGE_INFO, 6, sizeof(BOOLEAN), (BYTE*)&ex_rate_db_init);
}
