/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   app.h
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef _APP_H_
#define _APP_H_

#include "system.h"
#include "appfunc.h"
#include "atod.h"
#include "math.h"
#include "dcallang.h"


/*****************************************************************
**************** Application Save and Restore ********************
*****************************************************************/
#define MATHS_STATUS		0x80001000
#define CALCULATOR_INFO		0x80001001
#define METRIC_INFO			0x80001002
#define EXCHANGE_INFO		0x80001003
#define LOAN_INFO			0x80001004

#define EXCHANGE_CURRENCY	0x80005000		//CAD, GBP, HKD, USD
#define EXCHANGE_RATE0		0x80010000
	

/*=================== Low Memory ===================*/
#define     MemoryLow     MemoryCheckMemLow()
#define     MemoryNormal  !MemoryCheckMemLow()

/*=================== Maths application_status parameters ===================*/
#define RESTART				0
#define CALCULATOR			1
#define METRIC				2
#define EXCHANGE			3
#define LOAN				4

/*=================== MATHS_STATUS record Structure ===================*/
//Field 0 ------------------ application_status

/*=================== CALCULATOR_INFO record Structure ===================*/
//Field 0 ------------------ has_memory_content
//Field 1 ------------------ error_occured
//Field 2 ------------------ negative
//Field 3 ------------------ input_buffer
//Field 4 ------------------ memory_buffer
//Field 5 ------------------ temp_buffer
//Field 6 ------------------ temp_buffer1
//Field 7 ------------------ result_buffer
//Field 8 ------------------ operation
//Field 9 ------------------ last_input_type
//Field 10 ----------------- display_buffer
//Field 11 ----------------- operator_pressed;
//Field 12 ----------------- displaying_buffer
//Field 13 ----------------- DISPLAY text
//Field 14 ----------------- has_decimal
//Field 15 -----------------
//Field 16 ----------------- cal_icon_display
//Field 17 ----------------- percent_pressed

/*=================== METRIC_INFO record Structure ===================*/
//Field 0 ------------------ ObjectID of the selected push button
//Field 1 ------------------ selected item number of POPUP_TRIGGER_FIRST
//Field 2 ------------------ selected item number of POPUP_TRIGGER_SECOND
//Field 3 ------------------ text of TEXTBOX_METRIC_0
//Field 4 ------------------ text of TEXTBOX_METRIC_1

/*=================== EXCHANGE_INFO record Structure ===================*/
//Field 0 ------------------ STRING_EXCHANGE_0
//Field 1 ------------------ TEXTBOX_EXCHANGE_INPUT
//Field 2 ------------------ STRING_EXCHANGE_1
//Field 3 ------------------ TEXTBOX_EXCHANGE_RATE
//Field 4 ------------------ selected item number of POPUP_TRIGGER_F
//Field 5 ------------------ selected item number of POPUP_TRIGGER_S

/*=================== LOAN_INFO record Structure ===================*/
//Field 0 ------------------ TEXTBOX_LOAN_NUM_YEARS
//Field 1 ------------------ TEXTBOX_LOAN_INTEREST_RATE
//Field 2 ------------------ TEXTBOX_LOAN_LOAN_AMOUNT
//Field 3 ------------------ TEXTBOX_LOAN_MONTHLY_PAYMENT
//Field 4 ------------------ STRING_LOAN_TOTAL_PAYMENT_RESULT
//Field 5 ------------------ STRING_LOAN_TOTAL_INTEREST_RESULT
//Field 6 ------------------ calculating_item



/*==================== Menu Item ===========================*/
#define MENU_ITEM_COPY				0
#define MENU_ITEM_CUT				1
#define MENU_ITEM_PASTE				2
#define MENU_ITEM_COPY_RESULT		3
#define MENU_ITEM_TOTAL_PAYMENT		4
#define MENU_ITEM_TOTAL_INTEREST	5
#define MENU_ITEM_CALCULATING_ITEM  6
#define MENU_ITEM_CALCULATOR_PASTE  7

//------------- DisplayBufferToDisplay defines ---------
#define FROM_CALCULATION	0
#define FROM_INPUT			1


/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
extern AppID app_id;
extern DatabaseID maths_dbid;
extern ObjectID enter_form_id;

/*****************************************************************
****************** Global Variables (Calculator) *****************
*****************************************************************/
extern BOOLEAN has_memory_content;
extern BOOLEAN error_occured;
extern BOOLEAN negative;
extern double input_buffer, memory_buffer,
	   temp_buffer, temp_buffer1, result_buffer; 
extern double display_value;
extern BYTE operation;
extern BYTE last_input_type;
extern BOOLEAN operator_pressed;
extern BYTE *display_buffer;
extern BYTE displaying_buffer;
extern BYTE comma_type;
extern BOOLEAN has_decimal;
extern WORD num_digits;
extern BYTE cal_icon_display;
extern ObjectID invalid_paste_id;

/*****************************************************************
****************** Global Variables (Metric) *********************
*****************************************************************/
/*extern double	Length[7], Area[9], Volume[5], Weight[7], 
				Capacity[5], Velocity[3]/*, Temperature[2]*/;
extern double	Length[7][7], Area[9][9], Volume[5][5], Weight[7][7], 
				Capacity[5], Velocity[3]/*, Temperature[2]*/;

extern BYTE metric_enter_pressed;

struct _Metric_Insert_Pt_Info
{
	BOOLEAN insert_pt_on;
	ObjectID textbox_id;
};
typedef struct _Metric_Insert_Pt_Info MetricInsertPtInfo;
extern MetricInsertPtInfo metric_insert_pt;
#define SetMetricInsertPt(p1, p2) {metric_insert_pt.insert_pt_on = p1;\
								   metric_insert_pt.textbox_id = p2;}

/*****************************************************************
****************** Global Variables (Exchange) *********************
*****************************************************************/
extern USHORT exchange_rate_mapping[];
extern BYTE exchange_enter_pressed;
extern MetricInsertPtInfo metric_insert_pt1;
#define SetMetricInsertPt1(p1, p2) {metric_insert_pt1.insert_pt_on = p1;\
								   metric_insert_pt1.textbox_id = p2;}
#define NUM_OF_COUNTRIES		64


/*****************************************************************
****************** Global Variables (Loan) *********************
*****************************************************************/
extern BYTE calculating_item;
extern MetricInsertPtInfo metric_insert_pt2;
extern BYTE loan_enter_pressed;
#define SetMetricInsertPt2(p1, p2) {metric_insert_pt2.insert_pt_on = p1;\
								   metric_insert_pt2.textbox_id = p2;}
extern BYTE loan_error;

/*****************************************************************
******************** FORM CALCULATOR INVALID PASTE ***************
*****************************************************************/
#define FORM_CAL_INVALID_PASTE          105
#define BITMAP_CAL_INVALID_PASTE        106
#define STRING_CAL_INVALID_PASTE_0      107
#define STRING_CAL_INVALID_PASTE_1      108

/*****************************************************************
******************** FORM CALCULATOR DEFINES **********************
*****************************************************************/
#define FORM_CALCULATOR			0
#define MODE_SELECTOR			1
#define DISPLAY					2
#define	BITMAP_DISPLAY_M		3
#define	BITMAP_DISPLAY_MINUS	4
#define BITMAP_DISPLAY_ERROR	5
#define BITMAP_MC				6
#define BITMAP_MR				7
#define BITMAP_MPLUS			8
#define BITMAP_MMINUS			9
#define BITMAP_C				10
#define BITMAP_7				11
#define BITMAP_8				12
#define BITMAP_9				13
#define BITMAP_PERCENT			14
#define BITMAP_CE				15
#define BITMAP_4				16
#define BITMAP_5				17
#define BITMAP_6				18
#define BITMAP_MINUS			19
#define BITMAP_SQUROOT			20
#define BITMAP_1				21
#define BITMAP_2				22
#define BITMAP_3				23
#define BITMAP_PLUS				24
#define BITMAP_DIVIDE			25
#define BITMAP_0				26
#define BITMAP_DOT				27
#define BITMAP_EQUAL			28
#define BITMAP_TIMES			29
#define BITMAP_COMMA			30
#define BITMAP_POS_NEG			31

#define BITMAP_CAL_PLUS			95
#define BITMAP_CAL_SUB			96
#define BITMAP_CAL_MUL			97
#define BITMAP_CAL_DIV			98


/*****************************************************************
******************** FORM EX DB INIT DEFINES **********************
*****************************************************************/
#define FORM_EXCHANGE_DB_INIT			103
#define STRING_EXCHANGE_DB_INIT			104
#define BITMAP_CAL_NO_MEM				109

/*****************************************************************
******************** FORM METRIC DEFINES **********************
*****************************************************************/
#define FORM_METRIC						32
#define PUSHBUTTON_METRIC_LENGTH		33
#define PUSHBUTTON_METRIC_AREA			34
#define PUSHBUTTON_METRIC_VOLUME		35
#define PUSHBUTTON_METRIC_WEIGHT		36
#define PUSHBUTTON_METRIC_CAPACITY		37
#define PUSHBUTTON_METRIC_VELOCITY		38
#define PUSHBUTTON_METRIC_TEMPERATURE	39
#define POPUP_TRIGGER_FIRST				40
#define POPUP_TRIGGER_SECOND			41
#define TEXTBOX_METRIC_0				42
#define TEXTBOX_METRIC_1				43
#define BITMAP_METRIC_BACKGROUND		44
#define BITMAP_METRIC_LEFT				45
#define BITMAP_METRIC_RIGHT				46
#define	BITMAP_METRIC_C					47
#define	BITMAP_METRIC_1					48
#define	BITMAP_METRIC_2					49
#define	BITMAP_METRIC_3					50
#define	BITMAP_METRIC_4					51
#define	BITMAP_METRIC_5					52
#define	BITMAP_METRIC_6					53
#define	BITMAP_METRIC_7					54
#define	BITMAP_METRIC_8					55
#define	BITMAP_METRIC_9					56
#define BITMAP_METRIC_0					57
#define BITMAP_METRIC_LSYM				58
#define BITMAP_METRIC_RSYM				59
#define BITMAP_METRIC_ENTER				60


/*****************************************************************
******************** FORM EXCHANGED DEFINES **********************
*****************************************************************/
#define FORM_EXCHANGE					61
#define STRING_EXCHANGE_0				62
#define STRING_EXCHANGE_1				63
#define STRING_EXCHANGE_2				64
#define STRING_EXCHANGE_3				65
#define POPUP_TRIGGER_F					66
#define POPUP_TRIGGER_S					67
#define BUTTON_EXCHANGE_CHANGE			68
//#define BITMAP_METRIC_BACKGROUND		44
//#define BITMAP_METRIC_LEFT				45
//#define BITMAP_METRIC_RIGHT				46
//#define	BITMAP_METRIC_C					47
//#define	BITMAP_METRIC_1					48
//#define	BITMAP_METRIC_2					49
//#define	BITMAP_METRIC_3					50
//#define	BITMAP_METRIC_4					51
//#define	BITMAP_METRIC_5					52
//#define	BITMAP_METRIC_6					53
//#define	BITMAP_METRIC_7					54
//#define	BITMAP_METRIC_8					55
//#define	BITMAP_METRIC_9					56
//#define BITMAP_METRIC_0					57
//#define BITMAP_METRIC_LSYM				58
//#define BITMAP_METRIC_RSYM				59
//#define BITMAP_METRIC_ENTER				60
#define TEXTBOX_EXCHANGE_INPUT				69
#define TEXTBOX_EXCHANGE_RATE				70

/*****************************************************************
******************** FORM LOAN DEFINES ***************************
*****************************************************************/
#define FORM_LOAN						78
//#define BITMAP_METRIC_BACKGROUND		44
//#define BITMAP_METRIC_LEFT				45
//#define BITMAP_METRIC_RIGHT				46
//#define	BITMAP_METRIC_C					47
//#define	BITMAP_METRIC_1					48
//#define	BITMAP_METRIC_2					49
//#define	BITMAP_METRIC_3					50
//#define	BITMAP_METRIC_4					51
//#define	BITMAP_METRIC_5					52
//#define	BITMAP_METRIC_6					53
//#define	BITMAP_METRIC_7					54
//#define	BITMAP_METRIC_8					55
//#define	BITMAP_METRIC_9					56
//#define BITMAP_METRIC_0					57
//#define BITMAP_METRIC_LSYM				58
//#define BITMAP_METRIC_RSYM				59
//#define BITMAP_METRIC_ENTER				60
#define STRING_LOAN_NUM_YEARS				79
#define STRING_LOAN_INTEREST_RATE			80
#define STRING_LOAN_LOAN_AMOUNT				81
#define	STRING_LOAN_MONTHLY_PAYMENT			82
#define STRING_LOAN_TOTAL_PAYMENT			83
#define STRING_LOAN_TOTAL_PAYMENT_RESULT	84
#define STRING_LOAN_TOTAL_INTEREST			85
#define STRING_LOAN_TOTAL_INTEREST_RESULT	86
#define TEXTBOX_LOAN_NUM_YEARS				87
#define TEXTBOX_LOAN_INTEREST_RATE			88
#define TEXTBOX_LOAN_LOAN_AMOUNT			89
#define TEXTBOX_LOAN_MONTHLY_PAYMENT		90
#define BUTTON_LOAN_CLEAR_ALL				91
#define CHECKBOX_LOAN_NUM_YEARS             99
#define CHECKBOX_LOAN_INTEREST_RATE          100
#define CHECKBOX_LOAN_LOAN_AMOUNT           101
#define CHECKBOX_LOAN_MONTHLY_PAYMENT       102


/*****************************************************************
******************** FORM EXCHANGE RATE DEFINES **********************
*****************************************************************/
#define FORM_EXCHANGE_RATE					71
#define BITMAP_EXCHANGE_RATE_X				72
#define STRING_EXCHANGE_RATE				73

#define MENU_POPUP_0						74
#define MENU_POPUP_1						75
#define MENU_POPUP_2						76
#define MENU_POPUP_3						77

/*****************************************************************
******************** FORM METRIC OVERFLOW DEFINES **********************
*****************************************************************/
#define FORM_METRIC_OVERFLOW				92
#define BITMAP_METRIC_OVERFLOW				93
#define STRING_METRIC_OVERFLOW				94

/*****************************************************************
************** Global Defines (Calculator) ***********************
*****************************************************************/
#define NO_OPERATION	0
#define ADD				1
#define SUB				2
#define TIMES			3
#define EQUAL			4
#define PERCENT			5
#define SQUROOT			6
#define DIV				7

#define	NO_INPUT		0
#define CAL_EMPTY		1  /* when it is the start of a calculation*/
#define DIGITS			2
#define OPERATOR		3
#define UNKNOWN			7
#define MR				8
#define MPLUS			9
#define MMINUS			10
#define SQUROOT_R		11
#define SQUROOT_I		12

#define		INPUT		0
#define		RESULT		1


/*****************************************************************
************** Global Defines (METRIC) ***********************
*****************************************************************/
// =============== Length ======================
#define CM				0
#define FOOT			1
#define INCH			2
#define KM				3
#define M				4
#define MILE			5
#define YARD			6

// =============== Area ======================
#define ACRES			0
#define CM2				1
#define FOOT2			2
#define INCH2			3
#define HA				4
#define KM2				5
#define M2				6
#define MILE2			7
#define YARD2			8

// =============== Volume ======================
#define CM3				0
#define FOOT3			1
#define INCH3			2
#define M3				3
#define YARD3			4

// =============== Capacity ======================
#define FlOZ			0
#define GALLON			1
#define GILLS			2
#define LITRE			3
#define PINT			4

// =============== Weight ======================
#define G				0
#define GRAIN			1
#define KG				2
#define LB				3
#define OZ				4
#define STONE			5
#define TONNE			6

// =============== Velocity ======================
#define KMH				0
#define KNOT			1
#define MPH				2


// =============== Temperature ======================
#define C				0
#define F				1
#define K				2

/*****************************************************************
************** Global Defines (LOAN) ***********************
*****************************************************************/
//---------------- calculating result -----------------
#define NO_SELECTION		-1
#define NUM_YEARS			0
#define	INTEREST_RATE		1
#define LOAN_AMOUNT			2
#define MONTHLY_PAYMENT		3

//---------------- loan error -----------------
#define LOAN_NO_ERROR       -1
#define LOAN_CANT_SELECT    0
#define LOAN_NO_SOLUTION    1
#define LOAN_OUT_OF_RANGE	2

#endif
