/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   appfunc.h
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef __APPFUNC_H_
#define __APPFUNC_H_

/*#include "uifunc.h"
#include "ui.h"*/
#include "app.h"
#include "system.h"

/*****************************************************************
******************* Calculator Handle Functions ******************
*****************************************************************/
BOOLEAN CalculatorMain(EvtType *Event);
BOOLEAN MetricMain(EvtType *Event);
BOOLEAN MetricOverflow(EvtType *Event);
BOOLEAN ExchangeMain(EvtType *Event);
BOOLEAN ExchangeRateEnter(EvtType *Event);
BOOLEAN LoanPaymentMain(EvtType *Event);
BOOLEAN	ExchangeDBinitMain(EvtType *Event);
BOOLEAN CalculatorInvalidPaste(EvtType *Event);


void EventLoop();

/*****************************************************************
************************** Calculator Functions ******************
*****************************************************************/
void CalculatorClearDisplayBuffer();
void CalculatorDisplayBufferToDisplay(BYTE option);
void CalculatorNewDigitToDisplayBuffer(BYTE new_digit);
Err CalculatorCalculation(BYTE next_operation);
void CalculatorChopDisplay(BYTE *input_string, USHORT num_of_digits, BYTE **ouput_string);
void        MenuItemSelectedAction(USHORT item_num);
BOOLEAN     CalculatorBlockCopyCutPaste (EvtType *Event);
void CalculatorDrawSymbol();
BOOLEAN CalculatorFilterPasteText(BYTE *paste_text, BYTE **result_text, double *result_value, BOOLEAN *decimal_place);
BOOLEAN CalculatorCheckPasteText();
void CalculatorGetDisplay(BYTE	*input_string, BYTE option);

/*****************************************************************
************************** Metric Functions **********************
*****************************************************************/
void MetricChangePopupTriggerContent();
void MetricSetConversionTable();
BOOLEAN MetricConversion(ObjectID source_id, ObjectID result_id);
void MetricExchangeSetKeypadPos(ObjectID active_form_id);
void MetricAddZeroBehindDecimal(BYTE *input_string, USHORT num_of_zeros, USHORT total_num_chars, BYTE **output_string);

/*****************************************************************
************************** Exchange Functions **********************
*****************************************************************/
void ExchangeSetExchangeRateMappingArray();
USHORT ExchangeGetMappingNum(USHORT item_num);
BOOLEAN ExchangeCalculate();
void ExchangeInitExchangeRateDatabase();

void ExchangeSetStringExchange0Text();
void ExchangeSetStringExchange1Text();
void ExchangeDisplayExchangeRate();

BOOLEAN ExchangeUpdateExchangeRate();

/*****************************************************************
*********************** Loan Functions ***************************
*****************************************************************/
BOOLEAN LoanCalculation();


/*****************************************************************
*********** Calculator Application Save and Restore Functions ****
*****************************************************************/
void MathsAppSave();
void MathsAppRestore(BOOLEAN restart);
void MathsDatabaseChecking();
BOOLEAN MathsAppPartialRestore(ObjectID restored_form);

/*****************************************************************
**************** Calculator Application Launch *******************
*****************************************************************/
BOOLEAN CalculatorAppLaunch(WORD cmd, void *cmd_ptr);
#endif
