/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   ex_rate.h
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for exchange rate database handling
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef _EX_RATE_H_
#define _EX_RATE_H_

#include "system.h"

#define NUM_OF_COUNTRIES    64

typedef struct{
    double  exchange_rate_array[NUM_OF_COUNTRIES][NUM_OF_COUNTRIES];
}EXCHANGERATE;

extern BYTE         country_name[NUM_OF_COUNTRIES][4];
//extern double     exchange_rate_array[NUM_OF_COUNTRIES][NUM_OF_COUNTRIES];
extern EXCHANGERATE *ExchangeRate;
extern BOOLEAN     	ex_rate_db_init;    

//=========================================================
//============ EXCHANGE RATE Database Format ===============
#define EXCHANGE_RATE		0x80010000

//=========================================================
//============ EXCHANGE RATE function calls ===============
void 	ExchangeInitExchangeRateDatabase();
double 	ExchangeGetExchangeRate(USHORT first_country, USHORT second_country);
void 	ExchangeUpdateDatabase();

#endif

