/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"
#include "system.h"

/* ==================================================================== */
/* ========================= Function Prototypes ====================== */
/* ==================================================================== */
void EventLoop();
void MMUInit();
void KernelInit();
void ResInit();
static BOOLEAN ApplicationHandleEvent(EvtType *Event);

BOOLEAN (*FormDispatchEvent)(EvtType *Event);

extern UWORD *sys_page, *app_page;
extern REGISTRY app_reg[];

#ifdef PC_SIM
extern BOOL m_bIsExit;
#endif

//#define DEBUG

/* ==================================================================== */
/* ========================= Global Defines =========================== */
/* ==================================================================== */

/* ==================================================================== */
/* ========================= Global Variables ========================= */
/* ==================================================================== */
DatabaseID maths_dbid;
extern UBYTE res_data[];
UBYTE sysres_data[1];

/********************************************************
* Function:	ApplicationHandleEvent
* Purpose: 	This function is used to load the specific data of
form and set event handler of the form
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
static BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
	Form *form_ptr;
	ObjectID form_id;
	BYTE object_type;
	Err Error;
	
	if (Event->eventType == EVT_FORM_LOAD)
	{
		form_id = (ObjectID)Event->eventID;
		Error = UISearchForAddress(form_id,&object_type,(void**)&form_ptr);
		if (Event->para1 == 1 || Error != TRUE)
		{
			FormInitForm(form_id);
		}
		if (!UISearchForAddress(form_id,&object_type,(void**)&form_ptr)) return FALSE;
		switch (form_id)
		{
		case FORM_CALCULATOR:
			FormSetEventHandler(FORM_CALCULATOR, (void**)&FormDispatchEvent, (void*) CalculatorMain);
			break;
		case FORM_CAL_INVALID_PASTE:
			FormSetEventHandler(FORM_CAL_INVALID_PASTE, (void**)&FormDispatchEvent, (void*)CalculatorInvalidPaste);
			break;
		case FORM_METRIC:
			FormSetEventHandler(FORM_METRIC, (void**)&FormDispatchEvent, (void*) MetricMain);
			break;
		case FORM_EXCHANGE:
			FormSetEventHandler(FORM_EXCHANGE, (void**)&FormDispatchEvent, (void*) ExchangeMain);
			break;
		case FORM_EXCHANGE_RATE:
			FormSetEventHandler(FORM_EXCHANGE_RATE, (void**)&FormDispatchEvent, (void*) ExchangeRateEnter);
			break;
		case FORM_LOAN:
			FormSetEventHandler(FORM_LOAN, (void**)&FormDispatchEvent, (void*) LoanPaymentMain);
			break;
		case FORM_METRIC_OVERFLOW:
			FormSetEventHandler(FORM_METRIC_OVERFLOW, (void**)&FormDispatchEvent, (void*) MetricOverflow);
			break;
		case FORM_EXCHANGE_DB_INIT:
			FormSetEventHandler(FORM_EXCHANGE_DB_INIT, (void**)&FormDispatchEvent, (void*) ExchangeDBinitMain);
			break;
		}
		KeyboardSetKeyboardInvisible(FALSE);
#ifdef DEBUG
		printf("\n Application Handle Event ID = %ld", form_id);
#endif 	        
		
		FormSetActiveForm(form_id);
		
#ifdef DEBUG
		FormGetActiveFormID(&form_id);
		printf("\n Application Handle Event Get ID = %ld", form_id);
#endif 	        
		
		
		return TRUE;
	}
	return FALSE;
}

/********************************************************
* Function:	EventLoop
* Purpose: 	This function is a loop to get events from event
manager and then passes the event to different
event handler
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EventLoop(void)
{
	EvtType event;
	ObjectID id;
	
	do
	{
		EvtGetEvent (&event);
		if (!CalculatorBlockCopyCutPaste (&event))
			if (!SystemHandleEvent(&event))
				if (!MenuHandleEvent(&event))
					if (!ApplicationHandleEvent(&event))
						FormDispatchEvent(&event);
	}
#ifdef PC_SIM
	while (event.eventType != EVT_APP_STOP && m_bIsExit == FALSE);
#else
	while (event.eventType != EVT_APP_STOP);
#endif
}


/********************************************************
* Function:	main
* Purpose: 	main procedure of the application
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
__main(WORD cmd, void *cmd_ptr)
{
	CalculatorAppLaunch(cmd, (void*)cmd_ptr);
    DataCloseDB(maths_dbid);
}

