/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   eaddr.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"

//#define DEBUG_DB
//#define DEBUG

/********************************************************
* Function:	PhonebookBinarySearch
* Purpose: 	This function is called to implement a binary search
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE        handled
FALSE       not handled
* Comment: 	This function should be called in the StopApplication
*********************************************************/
BOOLEAN PhonebookBinarySearch(BYTE starting_char)
{
    UWORD   bottom, top, middle;
    UWORD   total_num_items;    
    BYTE    *item_text;
    UBYTE   temp;
	
    total_num_items = list_email_name.total_num_items;
    (UBYTE)starting_char   =   chartoupper((UBYTE)starting_char);
    
    if (total_num_items == 0)
		return FALSE;
    else if (total_num_items == 1)
    {            
        ListDisplayGetText(&list_email_name, 2, 0, &item_text);
        temp    =   chartoupper((UBYTE)(*item_text));
		
        if ((UBYTE)starting_char <= temp)
		{
            list_email_name.top_item_num  =   0;
			qfree(item_text);
			return TRUE;
		}
        else if ((UBYTE)starting_char > temp)
        {
			qfree(item_text);
			return FALSE;
		}
    }		
    else
    {
        bottom  =   0;
        top     =   total_num_items - 1;
        
        ListDisplayGetText(&list_email_name, 2, bottom, &item_text);
        temp    =   chartoupper((UBYTE)(*item_text));
        
        if ((UBYTE)starting_char <= temp)
		{
            list_email_name.top_item_num  =   bottom;
			qfree(item_text);
			return TRUE;
		}
        else
        {
			qfree(item_text);
            ListDisplayGetText(&list_email_name, 2, top, &item_text);
            temp    =   chartoupper((UBYTE)(*item_text));
            
            if ((UBYTE)starting_char > temp)
			{
				qfree(item_text);
				return FALSE;
			}
			else if ((UBYTE)starting_char == temp)
			{
                if (total_num_items == 2)
                {
                    list_email_name.top_item_num  =   top;
					qfree(item_text);
					return TRUE;
                }
                else
                {
                    qfree(item_text);        
                }                                    
            }		        
            else
            {
                if (total_num_items == 2)
                {
                    list_email_name.top_item_num  =   top;
					qfree(item_text);
					return TRUE;
                }		    	    
                else
                {
                    qfree(item_text);        
                }                                    
            }				
		}
        
		
        do
        {
            if (bottom == (top - 1))
            {               
                ListDisplayGetText(&list_email_name, 2, bottom, &item_text);
                temp    =   chartoupper((UBYTE)(*item_text));
				
                if ((UBYTE)starting_char <= temp)
				{
                    list_email_name.top_item_num  =   bottom;
					qfree(item_text);
					return TRUE;
				}
                else
                {
                    list_email_name.top_item_num  =   top;
					qfree(item_text);
					return TRUE;
				}            
            }
            else
            {
                middle  =   (top    +   bottom)/2;
				ListDisplayGetText(&list_email_name, 2, middle, &item_text);
				temp    =   chartoupper((UBYTE)(*item_text));       
                
                if ((UBYTE)starting_char <= temp)
				{
					top =   middle;
					qfree(item_text);
				}
                else if ((UBYTE)starting_char > temp)
                {
					bottom =   middle;
					qfree(item_text);			        
				}
            }          
        }while (top > bottom); 
    }        
}    


/********************************************************
* Function:	EmailGetRecNumWithCateName
* Purpose: 	This function is called to get all record numbers of the records that 
are with the same category name and have email addressS
* Scope:		application
* Input:		dbid			The database ID
cate_name		The required category
* Output:		rec_num			array of record number
num_rec			number of record returned
* Return:		TRUE			success
FALSE			error occure
* Comment: 	Database must be opened
*********************************************************/
BOOLEAN EmailGetRecNumWithCateName(DatabaseID dbid, BYTE *cate_name, UWORD rec_num[], UWORD *num_rec)
{
	UWORD total_num_rec;
	UWORD i;
	UBYTE cate_num;
	UBYTE rec_cate_num;
	RecordID rec_id;
	UWORD total_cate_rec = 0;
    BOOLEAN all = FALSE, found;
	UWORD byte_read;
	BYTE *buffer;
	
	if (EmailCompareTwoStrings(cate_name, EMALL) == SAME)
		all = TRUE;
	if (EmailCateNameToNum(email_dbid, cate_name, &cate_num) == FALSE && all == FALSE)
	{
		*num_rec = 0;
		return FALSE;
	}
	
	if (dbid == pb_dbid)
	{		
		DataTotalRecord(pb_dbid, &total_num_rec);
		for ( i = 0; i<total_num_rec; i++)
		{
			found = FALSE;
			DataNumtoRecID(pb_dbid, i, &rec_id);
			DataOpenRecord(pb_dbid, i, &rec_id, NULL);
			DataGetField(pb_dbid, rec_id, 8, &buffer, &byte_read);
			if (strlen(buffer) > 0) found = TRUE;
			qfree(buffer);
			DataGetField(pb_dbid, rec_id, 22, &buffer, &byte_read);
			if (strlen(buffer) > 0) found = TRUE;
			qfree(buffer);
			DataGetField(pb_dbid, rec_id, 26, &buffer, &byte_read);
			rec_cate_num = *(UBYTE*)(buffer);
			qfree(buffer);
			if ((rec_cate_num == cate_num || all == TRUE ) && found == TRUE)
			{
				rec_num[total_cate_rec] = i;
				total_cate_rec++;
			}
			DataCloseRecord(dbid, rec_id);
		}
		*num_rec = total_cate_rec;
		return TRUE;
	}
	else if (dbid == email_dbid)
	{
		DataTotalRecord(email_dbid, &total_num_rec);
		for ( i = 0; i<total_num_rec; i++)
		{
			DataNumtoRecID(email_dbid, i, &rec_id);
			DataRecordInfo(email_dbid, rec_id, NULL, &rec_cate_num, NULL, NULL, NULL);
			if ((rec_cate_num == cate_num) || all == TRUE)
			{
				rec_num[total_cate_rec] = i;
				total_cate_rec++;
			}
		}
		*num_rec = total_cate_rec;
		return TRUE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailRecordToAddressList
* Purpose: 	This function is used to show the correct records to 
the two list objects in the FORM_EMAIL_NAME_LIST page of the application		
* Scope:		application
* Input:		cate_name		The required category
starting_char	The starting character		
* Output:		None
* Return:		TRUE		Complete
FALSE		Error
* Comment: 	The list object must be initialised first
The database must be opened first
The function will update the scrollbar too
*********************************************************/
BOOLEAN EmailRecordToList(BYTE *cate_name, BYTE starting_char, BYTE *starting_string)
{
	
	UBYTE cate_number;
	UWORD email_total_num_rec, pb_total_num_rec,i;
	UWORD pb_index = 0, email_index = 0;
	UWORD email_rec_id, pb_rec_id;
	UWORD byte_read;
	UWORD *pb_rec_num, *email_rec_num;
	UWORD pb_num_rec, email_num_rec;
	BOOLEAN update = FALSE;
    BYTE *buffer1, *buffer2, first_name[200], last_name[200], *buffer;
	BOOLEAN compare = SAME;
	UWORD nth_record = 0;
	BOOLEAN preset = FALSE;
	BYTE result;
	
#ifdef DEBUG_DB
    printf("\n ======= In RecordToList ========");
#endif
	
	
	if (EmailCateNameToNum(email_dbid, cate_name, &cate_number) == FALSE && 
		EmailCompareTwoStrings(cate_name, EMALL) != SAME) return FALSE;
	
	ListDisplayDeleteAllRecordID(&list_email_name);
	
	DataTotalRecord(email_dbid, &email_total_num_rec);
	DataTotalRecord(pb_dbid, &pb_total_num_rec);
	
	pb_rec_num = (UWORD*)qmalloc(pb_total_num_rec*sizeof(UWORD));
	email_rec_num = (UWORD*)qmalloc(email_total_num_rec*sizeof(UWORD));
	
	EmailGetRecNumWithCateName(pb_dbid, cate_name, pb_rec_num, &pb_num_rec);
	EmailGetRecNumWithCateName(email_dbid, cate_name, email_rec_num, &email_num_rec);
	
#ifdef DEBUG_DB
    printf("\n DB 1 -- pb_num_rec = %ld", pb_num_rec);
    printf("\n DB 1 -- email_num_rec = %ld", email_num_rec);
#endif
	
	
	while (pb_index < pb_num_rec || email_index < email_num_rec)
	{
		if (pb_index < pb_num_rec && email_index < email_num_rec)
		{
			
			DataOpenRecord(pb_dbid, pb_rec_num[pb_index], &pb_rec_id, NULL);
			DataOpenRecord(email_dbid, email_rec_num[email_index], &email_rec_id, NULL);
            DataGetField(pb_dbid, pb_rec_id, 2, &buffer1, &byte_read);
            DataGetField(email_dbid, email_rec_id, 2, &buffer2, &byte_read);
			
#ifdef DEBUG_DB
            printf("\n ===== Sorting =====");
            printf("\n DB 2 -- pb dbid = %ld email dbid = %ld", pb_dbid, email_dbid);
            printf("\n DB 2 -- pb_index = %ld email_index = %ld", pb_index, email_index);
            printf("\n DB 2 -- rec_id = %ld buffer 1 = %s", pb_rec_id, buffer1);
            printf("\n DB 2 -- rec_id = %ld buffer 2 = %s", email_rec_id, buffer2);
#endif
			
            result = EmailCompareTwoStrings(buffer1, buffer2);
			
#ifdef DEBUG_DB
            printf("\n DB 3 -- result = %ld", result);
#endif
			switch (result)
			{
			case FIRST:
#ifdef DEBUG_DB
				printf("\n DB 4 -- result = FIRST %ld", pb_rec_id);
#endif
				ListDisplayInsertRecordID(&list_email_name, pb_rec_id, pb_dbid);
				compare = FIRST;
				pb_index ++;
				break;
			case SECOND:
#ifdef DEBUG_DB
				printf("\n DB 4 -- result = SECOND", email_rec_id);
#endif
				
				ListDisplayInsertRecordID(&list_email_name, email_rec_id, email_dbid);
				compare = SECOND;
				email_index++;
				break;
			case SAME:
#ifdef DEBUG_DB
				printf("\n DB 4 -- result = SAME a", pb_rec_id);
				printf("\n DB 4 -- result = SAME b", email_rec_id);
#endif
				
				ListDisplayInsertRecordID(&list_email_name, pb_rec_id, pb_dbid);
				pb_index ++;
				ListDisplayInsertRecordID(&list_email_name, email_rec_id, email_dbid);
				email_index++;
				compare = SECOND;
				break;
			}
#ifdef DEBUG_DB
            printf("\n DB 4 ---- result ----");
#endif
			if (starting_string != NULL && preset == FALSE)
			{
				if ((compare == FIRST && EmailCompareTwoStrings(buffer1, starting_string) == SAME) ||
					(compare == SECOND && EmailCompareTwoStrings(buffer2, starting_string) == SAME))
				{
					preset = TRUE;
					nth_record = list_email_name.total_num_items - 1;
				}
				else if (compare == SAME && EmailCompareTwoStrings(buffer1, starting_string) == SAME)
				{
					preset = TRUE;
					nth_record = list_email_name.total_num_items - 2;
				}
			}
            qfree(buffer1);
            qfree(buffer2);
			DataCloseRecord(pb_dbid, pb_rec_id);
			DataCloseRecord(email_dbid, email_rec_id);
		}
		else 
		{
			if (pb_index >= pb_num_rec)
			{
#ifdef DEBUG_DB
                printf("\n DB 5 pb_index >= pb_num_rec");
#endif
				for (i = email_index; i < email_num_rec; i++)
				{
                    DataOpenRecord(email_dbid, email_rec_num[i], &email_rec_id, NULL);
					ListDisplayInsertRecordID(&list_email_name, email_rec_id, email_dbid);
					if (starting_string != NULL  && preset == FALSE)
					{
                        DataGetField(email_dbid, email_rec_id, 2, &buffer1, &byte_read);
						if (EmailCompareTwoStrings(buffer1, starting_string) == SAME)
						{
							preset = TRUE;
							nth_record = list_email_name.total_num_items - 1;;
						}
                        qfree(buffer1);
                    }    
					DataCloseRecord(email_dbid, email_rec_id);
					email_index ++;
				}
			}
			else if (email_index >= email_num_rec)
			{
#ifdef DEBUG_DB
                printf("\n DB 5 email_index >= email_num_rec");
#endif
				for (i = pb_index; i < pb_num_rec; i++)
				{
                    DataOpenRecord(pb_dbid, pb_rec_num[i], &pb_rec_id, NULL);
					ListDisplayInsertRecordID(&list_email_name, pb_rec_id, pb_dbid);
#ifdef DEBUG_DB
                    printf("\n DB 6 rec_id = %ld", pb_rec_id);
#endif
					
					if (starting_string != NULL  && preset == FALSE)
					{
                        DataGetField(pb_dbid, pb_rec_id, 2, &buffer1, &byte_read);
#ifdef DEBUG_DB
                        printf("\n DB 7 buffer1 = %s", buffer1);
#endif
						
						if (EmailCompareTwoStrings(buffer1, starting_string) == SAME)
						{
							preset = TRUE;
							nth_record = list_email_name.total_num_items - 1;;
						}
                        qfree(buffer1);
					}
					DataCloseRecord(pb_dbid, pb_rec_id);
					pb_index++;
				}
			}
		}
	}
	EmailSetAddressListTopItemNum(starting_char, nth_record, preset);
	EmailAddressListSetScrollbar();
	EmailStartCharSetTab(starting_char);
	qfree(pb_rec_num);
	qfree(email_rec_num);
	return TRUE;
}

/********************************************************
* Function:	EmailListDisplayDrawAddressList
* Purpose: 	This function is called in order to draw 
the name and email address to the two list objects on
the screen
* Scope:		application
* Input:		list_display	list-display structure
dbid			DatabaseID
* Output:		None
* Return:		TRUE    handled
FALSE   not-handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailListDisplayDrawAddressList(ListDisplay *list_display)
{
	ObjectID list_id, list_id1;
	USHORT list_total_num_items;
	USHORT list_max_num_items;
	USHORT total_num_items;
	USHORT top_item_num;
	USHORT count = 0, i = 0;
	RecordIDBlock *temp = list_display->record_id_block;
	RecordID rec_id;
	UWORD rec_num;
	UWORD byte_read;
	BYTE *buffer;
	SHORT num_items_to_display;
	USHORT count1 = 0;
	Attribute secret_flag;
	BYTE *email1, *email2;
	UBYTE cate;
    BYTE first_name[200], last_name[200], buffer1[200];
	
	
	list_id = list_display->list_id;
	if (list_id == LIST_NAME)
		list_id1 = LIST_EMAIL;
	else if (list_id == LIST_FIND_RESULT_NAME)
		list_id1 = LIST_FIND_RESULT_EMAIL;
	
	
	ListRecalculateMaxNumItemsDisplay(list_id);
	ListGetMaxNumItemsDisplay (list_id, &list_max_num_items);
	list_display->max_num_items_display = list_max_num_items;
	
	total_num_items = list_display->total_num_items;
	top_item_num = list_display->top_item_num;
	
	ListGetTotalItems(list_id, &list_total_num_items);
	if (list_total_num_items != 0)
	{
		ListDeleteAllItems(list_id);
		ListDeleteAllItems(list_id1);
	}
	
	if ((top_item_num + list_max_num_items) <= total_num_items)
		list_display->num_items_display = list_max_num_items;
	else list_display->num_items_display = total_num_items - top_item_num;
	
	
	num_items_to_display = list_display->num_items_display;
	
	while (temp != NULL && num_items_to_display > 0)
	{
		if ((top_item_num >= count) && (top_item_num < (count + 20)))
		{
			DataRecIDtoNum(temp->dbid[top_item_num - count], temp->record_id[top_item_num - count], &rec_num);
			DataOpenRecord(temp->dbid[top_item_num - count], rec_num, &rec_id, NULL);
			DataGetField(temp->dbid[top_item_num - count], rec_id, 0, &buffer, &byte_read);
			strcpy(first_name, buffer);
			qfree(buffer);
			DataGetField(temp->dbid[top_item_num - count], rec_id, 1, &buffer, &byte_read);
			strcpy(last_name, buffer);
			qfree(buffer);
			PhonebookPrepareLastFirstNameForDisplay(first_name, last_name, buffer1);
			ListInsertItem(list_id, count1, buffer1);
			
			DataRecordInfo(temp->dbid[top_item_num - count], rec_id, NULL, &cate, &secret_flag, NULL, NULL);
			if (temp->dbid[top_item_num - count] == pb_dbid)
			{
				DataGetField(temp->dbid[top_item_num - count], rec_id, 8, &email1, &byte_read);
				DataGetField(temp->dbid[top_item_num - count], rec_id, 22, &email2, &byte_read);
				if (strlen(email1) == 0 && strlen(email2))
				{
					DataSetRecordAttribute(temp->dbid[top_item_num - count], rec_id, ATTR_CLR, ATTR_UNCHG, cate); 
					secret_flag = ATTR_CLR;
				}
				else if (strlen(email2) == 0 && strlen(email1))
				{
					DataSetRecordAttribute(temp->dbid[top_item_num - count], rec_id, ATTR_SET, ATTR_UNCHG, cate); 
					secret_flag = ATTR_SET;
				}
				
				if (strlen(email1) > 0 && strlen(email2) >0)
				{
					if (secret_flag == ATTR_SET)
						ListInsertItem(list_id1, count1, email1);
					else if (secret_flag == ATTR_CLR)
						ListInsertItem(list_id1, count1, email2);
				}
				else if (strlen(email1) > 0)
					ListInsertItem(list_id1, count1, email1);
				else if (strlen(email2) > 0)
					ListInsertItem(list_id1, count1, email2);
				qfree(email1);
				qfree(email2);
			}
			else
			{
				DataGetField(temp->dbid[top_item_num - count], rec_id, 3, &email1, &byte_read);
				ListInsertItem(list_id1, count1, email1);
				qfree(email1);
			}
			count1 ++;
			num_items_to_display --;
			top_item_num ++;
			DataCloseRecord(temp->dbid[top_item_num - count], rec_id);
		}
		else
		{
			count += 20;
			temp = temp->next;
		}
	}
	ListSetTopItemNum(list_id, 0);
	ListSetTopItemNum(list_id1, 0);
	ListSetNumItemsDisplay (list_id, list_display->num_items_display);
	ListSetNumItemsDisplay (list_id1, list_display->num_items_display);
	return TRUE;
}


/********************************************************
* Function:	EmailSetAddressListTopItemNum
* Purpose: 	This function is called to set the top item number
of the list object - LIST_NAME and LIST_EMAIL
* Scope:		application
* Input:		BYTE				the starting_char
* Output:		None
* Return:		TRUE			display of list is on
FALSE			display of list is off
* Comment: 	The top item number of the list objects are set
*********************************************************/
BOOLEAN EmailSetAddressListTopItemNum(BYTE start_char, UWORD nth_record, BOOLEAN preset)
{
	USHORT total_num_items;
	UWORD count = 0;
	BYTE *item_text;
	BOOLEAN enable,drawn,active,visible,set_scroll;
	Scrollbar *scroll_ptr;
	BYTE object_type;
    UBYTE temp;
    BOOLEAN temp1 = FALSE;
	
	total_num_items = list_email_name.total_num_items;
    if (start_char >= 'a' && start_char <= 'z')
        start_char -= 32;
	
	
	if (preset == FALSE)
	{
        if (PhonebookBinarySearch(start_char))
		{
			EmailListDisplayDrawAddressList(&list_email_name);
			ListGetAttribute(LIST_NAME, &enable, &drawn, &active, &visible, &set_scroll);
			ListSetAttribute(LIST_NAME, enable, drawn, active, TRUE, set_scroll);
			ListGetAttribute(LIST_EMAIL, &enable, &drawn, &active, &visible, &set_scroll);
			ListSetAttribute(LIST_EMAIL, enable, drawn, active, TRUE, set_scroll);
			EmailAddressListSetScrollbar();
			return TRUE;
		}
        else if (list_email_name.total_num_items > 0)
		{	
            list_email_name.top_item_num = 65535;
            EmailAddressListSetScrollbar();
            temp1 = TRUE;
		}
		
	}
	else
	{
		list_email_name.top_item_num = (USHORT)(nth_record);
		if ((list_email_name.total_num_items < list_email_name.max_num_items_display) &&
			(((UBYTE)start_char >= 'a' && (UBYTE)start_char <= 'c') || ((UBYTE)start_char >= 32 && (UBYTE)start_char <= 'C')))
			list_email_name.top_item_num = 0;			
		EmailListDisplayDrawAddressList(&list_email_name);
		ListGetAttribute(LIST_NAME, &enable, &drawn, &active, &visible, &set_scroll);
		ListSetAttribute(LIST_NAME, enable, drawn, active, TRUE, set_scroll);
		ListGetAttribute(LIST_EMAIL, &enable, &drawn, &active, &visible, &set_scroll);
		ListSetAttribute(LIST_EMAIL, enable, drawn, active, TRUE, set_scroll);
		EmailAddressListSetScrollbar();			
		return TRUE;
	}
	ListGetAttribute(LIST_NAME, &enable, &drawn, &active, &visible, &set_scroll);
	ListSetAttribute(LIST_NAME, enable, drawn, active, FALSE, set_scroll);
	ListGetAttribute(LIST_EMAIL, &enable, &drawn, &active, &visible, &set_scroll);
	ListSetAttribute(LIST_EMAIL, enable, drawn, active, FALSE, set_scroll);
	ListEraseList(LIST_NAME);
	ListEraseList(LIST_EMAIL);
	
    if (temp1 == FALSE)
    {
        if (total_num_items != 0)
        {
            ScrollbarSetScrollbar(SCROLLBAR_EMAIL_NAME_LIST , (list_email_name.total_num_items - list_email_name.num_items_display),
				(list_email_name.total_num_items - list_email_name.num_items_display), 0, 
				list_email_name.max_num_items_display, list_email_name.total_num_items);
            if (draw_scrollbar)
                ScrollbarDrawScrollbar(SCROLLBAR_EMAIL_NAME_LIST);
        }
        else
        {
            FormGetObjectPointer(SCROLLBAR_EMAIL_NAME_LIST , &object_type, (void**)&scroll_ptr);
            if (draw_scrollbar)
                ScrollbarEraseScrollbar(SCROLLBAR_EMAIL_NAME_LIST);
        }
    }
	return FALSE;	
}

/********************************************************
* Function:	EmailAddressListSetScrollbar
* Purpose: 	This function is called in order to set the values for a scrollbar		
* Scope:		application
* Input:		BYTE				the starting_char
* Output:		None
* Return:		TRUE		scrollbar is erased
FALSE		scrollbar is drawn
* Comment: 	If a scrollbar is not required, then the scrollbar will be erased 
If a scrollbar is required, the scrollbar will be displayed accordingly 
*********************************************************/
BOOLEAN EmailAddressListSetScrollbar()
{
	USHORT total_num_items;
	USHORT max_num_items_display;
	USHORT top_item_num;
	USHORT current_num_items_display;
	WORD max_value, min_value, pagesize, total_num_lines;
	BYTE object_type;
	Scrollbar *scroll_ptr;
	
	FormGetObjectPointer(SCROLLBAR_EMAIL_NAME_LIST , &object_type, (void**)&scroll_ptr);
	
	max_num_items_display = list_email_name.max_num_items_display;
	total_num_items = list_email_name.total_num_items;
	top_item_num = list_email_name.top_item_num;
	current_num_items_display = list_email_name.num_items_display;
	
	total_num_lines = total_num_items;
	min_value = 0;
	
	if (top_item_num == 65535)
	{
        ScrollbarSetScrollbarVisible(SCROLLBAR_EMAIL_NAME_LIST, TRUE);
		pagesize = 1;
		max_value = total_num_lines - pagesize;
		top_item_num = max_value;
		scroll_ptr->scrollbar_draw_pagesize = pagesize;
	}
	else if (top_item_num > 0 && total_num_items <= max_num_items_display)
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_EMAIL_NAME_LIST,TRUE);
		pagesize = total_num_items - top_item_num;
		max_value = total_num_lines - pagesize;
		scroll_ptr->scrollbar_draw_pagesize = pagesize;
	}
    else if (total_num_items > max_num_items_display)
	{	
		ScrollbarSetScrollbarVisible(SCROLLBAR_EMAIL_NAME_LIST ,TRUE);
		pagesize = max_num_items_display;
		max_value = total_num_lines - pagesize;	
		scroll_ptr->scrollbar_draw_pagesize = max_num_items_display;
	}
	else
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_EMAIL_NAME_LIST ,FALSE);
        if (draw_scrollbar)
            ScrollbarEraseScrollbar(SCROLLBAR_EMAIL_NAME_LIST );
		return FALSE;
	}
	
	if (top_item_num > (total_num_items - max_num_items_display) &&
		total_num_items >= max_num_items_display)
	{	
		pagesize = total_num_lines - top_item_num;	
		scroll_ptr->scrollbar_draw_pagesize = max_num_items_display;
		max_value = total_num_items - pagesize;
		ScrollbarSetScrollbar(SCROLLBAR_EMAIL_NAME_LIST , max_value, max_value, min_value,
			pagesize, total_num_lines);
	}
	else
		ScrollbarSetScrollbar(SCROLLBAR_EMAIL_NAME_LIST , top_item_num, max_value, min_value,
		pagesize, total_num_lines);
    if (draw_scrollbar)
        ScrollbarDrawScrollbar(SCROLLBAR_EMAIL_NAME_LIST );
	return TRUE;
	
}

/********************************************************
* Function:	EmailStartCharSetTab
* Purpose: 	This function is called to set the Email Name list
when the scrollbar is moved.
* Scope:		application
* Input:		Event		
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EmailStartCharSetTab(BYTE in_char)
{
	if (in_char >= 'a' && in_char <= 'z')
		in_char -= 32;
	
    if ((UBYTE)in_char >= 32 && (UBYTE)in_char <= 'C')
		FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_ABC);
	else if ((UBYTE)in_char >= 'D' && (UBYTE)in_char <= 'F')
		FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_DEF);				
	else if ((UBYTE)in_char >= 'G' && (UBYTE)in_char <= 'I')
		FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_GHI);				
	else if ((UBYTE)in_char >= 'J' && (UBYTE)in_char <= 'L')
		FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_JKL);				
	else if ((UBYTE)in_char >= 'M' && (UBYTE)in_char <= 'O')
		FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_MNO);				
	else if ((UBYTE)in_char >= 'P' && (UBYTE)in_char <= 'R')
		FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_PQR);				
	else if ((UBYTE)in_char >= 'S' && (UBYTE)in_char <= 'U')
		FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_STU);				
	else if ((UBYTE)in_char >= 'V' && (UBYTE)in_char <= 'X')
		FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_VWX);				
	else if ((UBYTE)in_char >= 'Y')
		FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_YZ);
}

/********************************************************
* Function:	EmailCateNameToPopupTrigger
* Purpose: 	This function is used to update teh items of the 
POPUP_TRIGGER_CATE
* Scope:		application
* Input:		dbid		THE dbid of a database
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EmailCateNameToPopupTrigger(DatabaseID dbid)
{
	UBYTE num_cate;
	UBYTE cate[255];
	BYTE *cate_name;
	SHORT i=0;
	
	num_cate = DataCategorySort(dbid, cate);
	ControlPopupDeleteAllItems(POPUP_TRIGGER_CATE);
	ControlPopupInsertItem(POPUP_TRIGGER_CATE,0,EMALL);
	ControlPopupInsertItem(POPUP_TRIGGER_CATE,1,EMUNFILED);
	cate_name = (BYTE*)qmalloc(30*sizeof(BYTE));
	for (i = 0; i<num_cate; i++)
	{
		DataCategoryName(dbid,cate[i],cate_name);
		ControlPopupInsertItem(POPUP_TRIGGER_CATE,(i+2),cate_name);
	}
	ControlPopupInsertItem(POPUP_TRIGGER_CATE,(num_cate+2),EMCAT);
	qfree(cate_name);
}

/********************************************************
* Function:	EmailScrollbarSetAddressList
* Purpose: 	This function is called to set the telephone list
when the scrollbar is moved.
* Scope:		application
* Input:		Event		
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EmailScrollbarSetAddressList(EvtType *Event)
{
	
	WORD max,min,value,pagesize;
	WORD scroll_total_lines;
	BYTE *list_text;
	BYTE object_type;
	Scrollbar *scroll_ptr;
	List *list_ptr, *list1_ptr;
	
	FormGetObjectPointer(SCROLLBAR_EMAIL_NAME_LIST, &object_type, (void**)&scroll_ptr);
	if (!scroll_ptr->scrollbar_attr.scrollbar_visible)
		return;
	
	ScrollbarGetScrollbar(SCROLLBAR_EMAIL_NAME_LIST, &value, &max, &min, &pagesize, &scroll_total_lines);
    FormGetObjectPointer(LIST_NAME, &object_type, (void**)&list_ptr);
	FormGetObjectPointer(LIST_EMAIL, &object_type, (void**)&list1_ptr);
	
	if (list_email_name.total_num_items > list_email_name.max_num_items_display)
	{
		if ((Event->para2 - Event->para1) >= pagesize && pagesize != 1)
		{
			ScrollbarSetScrollbar(SCROLLBAR_EMAIL_NAME_LIST, (Event->para2 - 1), max, min, pagesize, scroll_total_lines);
			list_email_name.top_item_num = (USHORT)(Event->para2) - 1;
		}
		else if ((Event->para1 - Event->para2) >= pagesize && pagesize != 1)
		{
			ScrollbarSetScrollbar(SCROLLBAR_EMAIL_NAME_LIST, (Event->para2 + 1), max, min, pagesize, scroll_total_lines);
			list_email_name.top_item_num = (USHORT)(Event->para2) + 1;
		}
		else
		{	
			ScrollbarSetScrollbar(SCROLLBAR_EMAIL_NAME_LIST, Event->para2, max, min, pagesize, scroll_total_lines);
			list_email_name.top_item_num = (USHORT)(Event->para2);
		}
		ScrollbarGetScrollbar(SCROLLBAR_EMAIL_NAME_LIST, &value, &max, &min, &pagesize, &scroll_total_lines);
		if (list_email_name.top_item_num >(scroll_total_lines - list_email_name.max_num_items_display))
			pagesize = scroll_total_lines - list_email_name.top_item_num;
		else pagesize = list_email_name.max_num_items_display;
		max = scroll_total_lines - pagesize;
		ScrollbarSetScrollbar(SCROLLBAR_EMAIL_NAME_LIST, value, max, min, pagesize, scroll_total_lines);
	}
	else
    {
		if (list_ptr->list_attr.list_visible == FALSE)
		{
            ScrollbarSetScrollbar(SCROLLBAR_EMAIL_NAME_LIST, Event->para1, max, min, pagesize, scroll_total_lines);
            list_email_name.top_item_num = (USHORT)(Event->para1);
		}
		else
		{	
            ScrollbarSetScrollbar(SCROLLBAR_EMAIL_NAME_LIST, Event->para2, max, min, pagesize, scroll_total_lines);
            list_email_name.top_item_num = (USHORT)(Event->para2);
		}
		//remark on 990730
		//scroll_ptr->scrollbar_draw_pagesize = pagesize;
		if (list_email_name.top_item_num == 0)
		{	
			scroll_ptr->scrollbar_attr.scrollbar_visible = FALSE;
            if (draw_scrollbar)
                ScrollbarEraseScrollbar(SCROLLBAR_EMAIL_NAME_LIST);
		}
		else
        {
            if (draw_scrollbar)
                ScrollbarDrawScrollbar(SCROLLBAR_EMAIL_NAME_LIST);
        }
	}
	
	if (scroll_ptr->scrollbar_total_num_lines > list_email_name.max_num_items_display)
    {
        if (draw_scrollbar)
            ScrollbarDrawScrollbar(SCROLLBAR_EMAIL_NAME_LIST);
    }
	
	list_ptr->list_attr.list_visible = TRUE;
	list1_ptr->list_attr.list_visible = TRUE;
	EmailListDisplayDrawAddressList(&list_email_name);
	
	
	
    if (Event->eventType == EVT_SCROLLBAR_SELECT ||
        (Event->eventType == EVT_SCROLLBAR_REPEAT && (Event->para1 != Event->para2 || scroll_ptr->scrollbar_total_num_lines == 1)))
    {
        ListDrawList(LIST_NAME);
        ListDrawList(LIST_EMAIL);
		
        ListDisplayGetText(&list_email_name, 2, list_email_name.top_item_num, &list_text);
		
        if ((UBYTE)*list_text >= 'a' && (UBYTE)*list_text <= 'z')
            *list_text -= 32;
		
		
        if ((UBYTE)*list_text >= 32 && (UBYTE)*list_text <= 'C')
        {
            FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_ABC);
            char_start = 'A';
        }
        else if ((UBYTE)*list_text >= 'D' && (UBYTE)*list_text <= 'F')
        {
            FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_DEF);
            char_start = 'D';
        }
        else if ((UBYTE)*list_text >= 'G' && (UBYTE)*list_text <= 'I')
        {
            FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_GHI);
            char_start = 'G';
        }
        else if ((UBYTE)*list_text >= 'J' && (UBYTE)*list_text <= 'L')
        {
            FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_JKL);
            char_start = 'J';
        }
        else if ((UBYTE)*list_text >= 'M' && (UBYTE)*list_text <= 'O')
        {
            FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_MNO);
            char_start = 'M';
        }
        else if ((UBYTE)*list_text >= 'P' && (UBYTE)*list_text <= 'R')
        {
            FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_PQR);
            char_start = 'P';
        }
        else if ((UBYTE)*list_text >= 'S' && (UBYTE)*list_text <= 'U')
        {
            FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_STU);
            char_start = 'S';
        }
        else if ((UBYTE)*list_text >= 'V' && (UBYTE)*list_text <= 'X')
        {
            FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_VWX);
            char_start = 'V';
        }
        else if ((UBYTE)*list_text >= 'Y')
        {
            FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST, PUSHBUTTON_YZ);
            char_start = 'Y';
        }
		
        qfree(list_text);
    }
}

/********************************************************
* Function:	EmailPopupCateActions
* Purpose: 	This function is called in order to take actions when the 
popup trigger of categories is changed
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE			success
FALSE			error occure
* Comment: 	None
*********************************************************/
BOOLEAN EmailPopupCateActions(SHORT selected_item)
{
	USHORT popup_total_num_items;
	UBYTE cate[256], num_cate;
	SHORT i = 0;
	BYTE *cate_name;
	BYTE *item_text;
	
	
	ControlPopupGetTotalItems(POPUP_TRIGGER_CATE, &popup_total_num_items);
	if (popup_total_num_items == ((USHORT)selected_item + 1))
	{		
		ListInitList(LIST_CATE);
		num_cate = DataCategorySort(email_dbid,cate);
		ListDeleteAllItems(LIST_CATE);
		cate_name = (BYTE*)qmalloc(30*sizeof(BYTE));
		for (i = 0; i < num_cate; i++)
		{
			DataCategoryName(email_dbid,cate[i],cate_name);
			ListInsertItem(LIST_CATE,i,cate_name);
		}
		qfree(cate_name);
		ScrollbarInitScrollbar(SCROLLBAR_CATE);
		EmailEditCateSetScrollbar();
		edit_cate_in_action = FROM_POPUP;
        MenuInitMenu(MENU_EDIT_CATE);
        EmailChangeFontSize(FORM_EDIT_CATE, font_size);
		FormPopupForm(FORM_EDIT_CATE);		
		return TRUE;
	}
	else
	{	
		ControlPopupGetPopupItem(POPUP_TRIGGER_CATE, (USHORT)selected_item, &item_text);
		strcpy(current_cate, item_text);
		EmailRecordToList(item_text, 'A',NULL);
		char_start = 'A';
		FormSetControlGroupSelection(FORM_EMAIL_NAME_LIST,PUSHBUTTON_ABC);		
		ListDrawList(LIST_NAME);
		ListDrawList(LIST_EMAIL);
		return TRUE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailListSelectedItemAction
* Purpose: 	This fucntion is called when an item is selected from the
LIST_NAME or LIST_EMAIL object, then a sequence of actions
are taken
* Scope:		application
* Input:		list_display	The corresponding list display structure
* Output:		None
* Return:		TRUE			success
FALSE			error occure
* Comment: 	None
*********************************************************/
BOOLEAN EmailListSelectedItemAction(ListDisplay *list_display, EvtType *Event)
{ 
	UWORD byte_read;
    BYTE *buffer1, *buffer2, *buffer, *buffer3, buffer4[200];
	BYTE *email1, *email2;
	RecordID rec_id;
	UWORD rec_num;
	UBYTE cate_num;
	BYTE *cate_name;
	USHORT item_num;
	BYTE *field_string;
	WORD enter_pos = 0;
	WORD count = 0;
	BYTE object_type;
	Field *field_ptr;
	Attribute secret_flag;
	Control *control_ptr;
	
#ifdef DEBUG
	printf("\n ======== inside EmailListSelectedItemAction =====================");
	printf("\n pt 1");
#endif
	
	if (Event->para1 == -1)
		return TRUE;
	ListDisplayGetRecordID(list_display, 
		(USHORT)(Event->para1 + list_display->top_item_num), 
		&(ve_email_name_status.rec_id), 
		&(ve_email_name_status.dbid));
	if (name_list_in_action == MAIL_LIST)
	{
		FieldGetTextPointer(mail_list_insert_pt.field_id, &field_string);
		DataRecIDtoNum(ve_email_name_status.dbid, ve_email_name_status.rec_id, &rec_num);
		DataOpenRecord(ve_email_name_status.dbid, rec_num, &rec_id, NULL);
		if (ve_email_name_status.dbid == email_dbid)
		{
			DataGetField(ve_email_name_status.dbid, ve_email_name_status.rec_id, 3, &buffer, &byte_read);
		}
		else if (ve_email_name_status.dbid == pb_dbid)
		{
			DataRecordInfo(ve_email_name_status.dbid, ve_email_name_status.rec_id, NULL, NULL,
				&secret_flag, NULL, NULL);
			if (secret_flag == ATTR_SET)
				DataGetField(ve_email_name_status.dbid, ve_email_name_status.rec_id, 8, &buffer, &byte_read);
			else
                DataGetField(ve_email_name_status.dbid, ve_email_name_status.rec_id, 22, &buffer, &byte_read);
		}
		DataCloseRecord(ve_email_name_status.dbid, ve_email_name_status.rec_id);
		
#ifdef DEBUG
		printf("\n pt 2");
#endif
		if (strlen(field_string) == 0)
		{
			FieldSetText(mail_list_insert_pt.field_id, buffer);
			FormGetObjectPointer(mail_list_insert_pt.field_id, &object_type, (void**)&field_ptr);
			field_ptr->field_insert_pt_char_pos += strlen(buffer);
		}
		else if (mail_list_insert_pt.insert_pt_char_pos == (WORD)(strlen(field_string)))
		{
			buffer1 = (BYTE*)qmalloc((strlen(buffer) + strlen(field_string) + 2)*sizeof(BYTE));			
			strcpy(buffer1, field_string);
			buffer2 = buffer1;
			buffer1 += strlen(field_string);
			*buffer1 = '\r';
			buffer1++;
			strcpy(buffer1, buffer);
			qfree(buffer);
			
			FieldSetText(mail_list_insert_pt.field_id, buffer2);
			FormGetObjectPointer(mail_list_insert_pt.field_id, &object_type, (void**)&field_ptr);
			field_ptr->field_insert_pt_char_pos = strlen(buffer2);
			qfree(buffer2);
			FormSetFormActiveObject(FORM_MAIL_LIST, mail_list_insert_pt.field_id);
			FieldSetInsertPointOn(mail_list_insert_pt.field_id);
			return TRUE;
		}
		else
		{
			buffer1 = (BYTE*)qmalloc((strlen(buffer) + strlen(field_string) + 2)*sizeof(BYTE));			
			for (count = 0; count <(WORD)(strlen(field_string)); count++)
			{
				if (count == mail_list_insert_pt.insert_pt_char_pos)
				{
					buffer2 = buffer1;
					buffer1 += enter_pos;
					strcpy(buffer1, buffer);
					buffer1 += strlen(buffer);
					*buffer1 = '\r';
					buffer1++;
					buffer3 = field_string + enter_pos;
					strcpy(buffer1, buffer3);
					FieldSetText(mail_list_insert_pt.field_id, buffer2);
					qfree(buffer2);
					break;
				}
				else
				{
					if (field_string[count] == '\r')
						enter_pos = count + 1;
					buffer1[count] = field_string[count];
				}
			}
			FormGetObjectPointer(mail_list_insert_pt.field_id, &object_type, (void**)&field_ptr);
			field_ptr->field_insert_pt_char_pos += strlen(buffer) + 1;
		}
		qfree(buffer);
		FormSetFormActiveObject(FORM_MAIL_LIST, mail_list_insert_pt.field_id);
		FieldSetInsertPointOn(mail_list_insert_pt.field_id);
		return TRUE;
	}
#ifdef DEBUG
	printf("\n pt 3");
#endif
	FormInitAllFormObjects(FORM_VE_EMAIL_NAME);
	if (ve_email_name_status.dbid == pb_dbid)
	{
		SetVEEmailNameStatus(VIEW, TRUE, TRUE, ve_email_name_status.rec_id, ve_email_name_status.dbid, FALSE);
		DataRecIDtoNum(pb_dbid, ve_email_name_status.rec_id, &rec_num);
		DataOpenRecord(pb_dbid, rec_num, &rec_id, NULL);
		DataGetField(pb_dbid, ve_email_name_status.rec_id, 8, &email1, &byte_read);
		DataGetField(pb_dbid, ve_email_name_status.rec_id, 22, &email2, &byte_read);
		FieldSetText(FIELD_C_EMAIL, email1);
		FieldSetText(FIELD_H_EMAIL, email2);
		DataGetField(pb_dbid, ve_email_name_status.rec_id, 0, &buffer1, &byte_read);
		DataGetField(pb_dbid, ve_email_name_status.rec_id, 1, &buffer2, &byte_read);
		TextboxSetText(TEXTBOX_FIRST_NAME, buffer1);
		TextboxSetText(TEXTBOX_LAST_NAME, buffer2);
        PhonebookPrepareFirstLastName(buffer1, buffer2, buffer4);
        StringSetText(STRING_VE_NAME, buffer4);
		qfree(buffer1); qfree(buffer2); qfree(email1); qfree(email2);
        
		DataRecordInfo(pb_dbid, ve_email_name_status.rec_id, NULL, NULL,
			&secret_flag, NULL, NULL);
		if (secret_flag == ATTR_SET)
		{
			FormGetObjectPointer(CHECKBOX_VE_C, &object_type, (void**)&control_ptr);
			((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = TRUE;
			FormGetObjectPointer(CHECKBOX_VE_H, &object_type, (void**)&control_ptr);
			((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
		}
		else
		{
			FormGetObjectPointer(CHECKBOX_VE_C, &object_type, (void**)&control_ptr);
			((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = FALSE;
			FormGetObjectPointer(CHECKBOX_VE_H, &object_type, (void**)&control_ptr);
			((ControlTemplateCheckBox*)(control_ptr->control_template))->control_value = TRUE;
		}			
		DataCloseRecord(pb_dbid, ve_email_name_status.rec_id);
	}
	else if (ve_email_name_status.dbid == email_dbid)
	{
		SetVEEmailNameStatus(VIEW, TRUE, FALSE, ve_email_name_status.rec_id, ve_email_name_status.dbid, FALSE);
		DataRecIDtoNum(email_dbid, ve_email_name_status.rec_id, &rec_num);
		DataOpenRecord(email_dbid, rec_num, &rec_id, NULL);
		DataGetField(email_dbid, ve_email_name_status.rec_id, 3, &email1, &byte_read);
		FieldSetText(FIELD_C_EMAIL, email1);
        DataGetField(email_dbid, ve_email_name_status.rec_id, 0, &buffer1, &byte_read);
		DataGetField(email_dbid, ve_email_name_status.rec_id, 1, &buffer2, &byte_read);
		TextboxSetText(TEXTBOX_FIRST_NAME, buffer1);
		TextboxSetText(TEXTBOX_LAST_NAME, buffer2);
        PhonebookPrepareFirstLastName(buffer1, buffer2, buffer4);
        StringSetText(STRING_VE_NAME, buffer4);
		qfree(buffer1); qfree(buffer2); qfree(email1);
		DataCloseRecord(email_dbid, ve_email_name_status.rec_id);
	}
	
#ifdef DEBUG
	printf("\n pt 4");
#endif
	EmailCateNameToPopupTrigger(email_dbid);
	ControlPopupDeleteItem(POPUP_TRIGGER_CATE, 0);
	
	if (ve_email_name_status.dbid == email_dbid)
	{
		DataRecordInfo(email_dbid, ve_email_name_status.rec_id, NULL, &cate_num,
			NULL, NULL, NULL);
		cate_name = (BYTE*)qmalloc(30*sizeof(BYTE));
		DataCategoryName(email_dbid, cate_num, cate_name);
		if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, cate_name,
			&item_num) == TRUE) 
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
		else
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
	}
	else if (ve_email_name_status.dbid == pb_dbid)
	{
		DataRecIDtoNum(pb_dbid, ve_email_name_status.rec_id, &rec_num);
		DataOpenRecord(pb_dbid, rec_num, &rec_id, NULL);
		DataGetField(pb_dbid, rec_id, 26, &buffer, &byte_read);
		cate_name = (BYTE*)qmalloc(30*sizeof(BYTE));
		DataCategoryName(email_dbid, *(UBYTE*)buffer, cate_name);
		qfree(buffer);
		if (ControlPopupFindItemNum(POPUP_TRIGGER_CATE, cate_name,
			&item_num) == TRUE) 
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, (SHORT)item_num);
		else
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
	}
#ifdef DEBUG
	printf("\n pt 5");
#endif
	if (temp_cate != NULL)
		qfree(temp_cate);
	temp_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
	strcpy(temp_cate, cate_name);
	StringSetText(STRING_CATE, cate_name);
	qfree(cate_name);		
	if (save_cate != NULL)
		qfree(save_cate);
	save_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
	strcpy (save_cate, current_cate);
	EmailSetupViewEditEmailNameScreen();
#ifdef DEBUG
	printf("\n pt 6");
	printf("\n =========== end ==============");
#endif
	return TRUE;
}

/********************************************************
* Function:    EmailChangeListFont
* Purpose: 	This function is called to change the font of the list
object 
* Scope:		application
* Input:		Event		
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EmailChangeListFont(void)
{
	ObjectID 		active_form_id;
	List			*list_ptr, *list_ptr1;
	Scrollbar		*scroll_ptr;
    BYTE            object_type, *list_text;
	
	FormGetActiveFormID(&active_form_id);
	
	switch (active_form_id)
	{
	case FORM_EMAIL_NAME_LIST:
		FormGetObjectPointer(LIST_NAME, &object_type, (void**)&list_ptr);
		FormGetObjectPointer(LIST_EMAIL, &object_type, (void**)&list_ptr1);
		FormGetObjectPointer(SCROLLBAR_EMAIL_NAME_LIST, &object_type, (void**)&scroll_ptr);
		if (list_ptr->list_text_font == SMALL_FONT)
		{
			ListSetFont(LIST_NAME, MEDIUM_FONT);
			ListSetFont(LIST_EMAIL, MEDIUM_FONT);
			font_size = MEDIUM_FONT;
		}
		else
		{
			ListSetFont(LIST_NAME, SMALL_FONT);
			ListSetFont(LIST_EMAIL, SMALL_FONT);
			font_size = SMALL_FONT;
		}
		
		list_email_name.max_num_items_display = list_ptr->list_max_num_items_on_display;
		
		if (list_email_name.total_num_items > list_ptr->list_max_num_items_on_display)
		{
			if (list_email_name.top_item_num > (list_email_name.total_num_items - list_ptr->list_max_num_items_on_display))
				list_email_name.num_items_display = (list_email_name.total_num_items - list_email_name.top_item_num);
			else list_email_name.num_items_display = list_ptr->list_max_num_items_on_display;
		}
		else if (list_email_name.total_num_items == list_ptr->list_max_num_items_on_display)
			list_email_name.num_items_display = list_ptr->list_max_num_items_on_display;
		else list_email_name.num_items_display = list_email_name.total_num_items;
		
		EmailListDisplayDrawAddressList(&list_email_name);
		
		EmailAddressListSetScrollbar();
		
		if (list_ptr->list_attr.list_visible == TRUE)
		{                                             
			ListDisplayGetText(&list_email_name, 2, list_email_name.top_item_num, &list_text);
			EmailStartCharSetTab(list_text[0]);
			qfree(list_text);
		}
		
		if (list_ptr->list_text_font == SMALL_FONT)
		{
			MenuDeleteItem(MENU_EMAIL_NAME_LIST, 0);
			MenuInsertItem(MENU_EMAIL_NAME_LIST, 0, EMLFONT);
			ControlSetLabel(BUTTON_EMAIL_NAME_LIST_ZOOMIN, EMLFONT);
		}
		else
		{
			MenuDeleteItem(MENU_EMAIL_NAME_LIST, 0);
			MenuInsertItem(MENU_EMAIL_NAME_LIST, 0, EMSFONT);
			ControlSetLabel(BUTTON_EMAIL_NAME_LIST_ZOOMIN, EMSFONT);
		}
		
		ControlDrawControl(BUTTON_EMAIL_NAME_LIST_ZOOMIN);
		ListDrawList(LIST_NAME);
		ListDrawList(LIST_EMAIL);
		if (draw_scrollbar)
			ScrollbarDrawScrollbar(SCROLLBAR_EMAIL_NAME_LIST);                                   
		break;
	case FORM_FIND_RESULT:
		FormGetObjectPointer(LIST_FIND_RESULT_NAME, &object_type, (void**)&list_ptr);
		FormGetObjectPointer(LIST_FIND_RESULT_EMAIL, &object_type, (void**)&list_ptr1);
		FormGetObjectPointer(SCROLLBAR_FIND_RESULT, &object_type, (void**)&scroll_ptr);
		if (list_ptr->list_text_font == SMALL_FONT)
		{
			ListSetFont(LIST_FIND_RESULT_NAME, MEDIUM_FONT);
			ListSetFont(LIST_FIND_RESULT_EMAIL, MEDIUM_FONT);
			font_size = MEDIUM_FONT;
		}
		else
		{
			ListSetFont(LIST_FIND_RESULT_NAME, SMALL_FONT);
			ListSetFont(LIST_FIND_RESULT_EMAIL, SMALL_FONT);
			font_size = SMALL_FONT;
		}
		
		list_find.max_num_items_display = list_ptr->list_max_num_items_on_display;
		
		if (list_find.total_num_items > list_ptr->list_max_num_items_on_display)
		{
			if (list_find.top_item_num > (list_find.total_num_items - list_ptr->list_max_num_items_on_display))
				list_find.num_items_display = (list_find.total_num_items - list_find.top_item_num);
			else list_find.num_items_display = list_ptr->list_max_num_items_on_display;
		}
		else if (list_find.total_num_items == list_ptr->list_max_num_items_on_display)
			list_find.num_items_display = list_ptr->list_max_num_items_on_display;
		else list_find.num_items_display = list_find.total_num_items;
		
		EmailListDisplayDrawAddressList(&list_find);
		
		
		if (list_ptr->list_total_num_items > list_ptr->list_max_num_items_on_display)
		{
			scroll_ptr->scrollbar_attr.scrollbar_visible = TRUE;
			if (list_ptr->list_top_item_num >= (list_ptr->list_total_num_items - list_ptr->list_max_num_items_on_display))
				list_ptr->list_top_item_num = (list_ptr->list_total_num_items - list_ptr->list_max_num_items_on_display);           
			
			list_ptr1->list_top_item_num = list_ptr->list_top_item_num;				
			
			scroll_ptr->scrollbar_value 	= list_ptr->list_top_item_num;
			scroll_ptr->scrollbar_min		= 0;
			scroll_ptr->scrollbar_pagesize  = list_ptr->list_max_num_items_on_display;
			scroll_ptr->scrollbar_draw_pagesize 	= scroll_ptr->scrollbar_pagesize;
			scroll_ptr->scrollbar_max		= list_ptr->list_total_num_items - scroll_ptr->scrollbar_pagesize;
			scroll_ptr->scrollbar_total_num_lines = list_ptr->list_total_num_items;      
		}
		else
		{
			scroll_ptr->scrollbar_attr.scrollbar_visible = FALSE;
			if (draw_scrollbar)
				ScrollbarEraseScrollbar(SCROLLBAR_CATE);
			list_ptr->list_top_item_num = 0;
		}
		
		
		if (list_ptr->list_text_font == SMALL_FONT)							
		{
			MenuDeleteItem(MENU_FIND_RESULT, 0);
			MenuInsertItem(MENU_FIND_RESULT, 0, EMLFONT);
			ControlSetLabel(BUTTON_FIND_RESULT_ZOOMIN, EMLFONT);
		}
		else
		{			
			MenuDeleteItem(MENU_FIND_RESULT, 0);
			MenuInsertItem(MENU_FIND_RESULT, 0, EMSFONT);			
			ControlSetLabel(BUTTON_FIND_RESULT_ZOOMIN, EMSFONT);
		}
		
		ControlDrawControl(BUTTON_FIND_RESULT_ZOOMIN);
		ListDrawList(LIST_FIND_RESULT_NAME);
		ListDrawList(LIST_FIND_RESULT_EMAIL);
		if (draw_scrollbar)
			ScrollbarDrawScrollbar(SCROLLBAR_FIND_RESULT);
		break;
	case FORM_EDIT_CATE:
		FormGetObjectPointer(LIST_CATE, &object_type, (void**)&list_ptr);
		FormGetObjectPointer(SCROLLBAR_CATE, &object_type, (void**)&scroll_ptr);
		if (list_ptr->list_text_font == SMALL_FONT)
		{
			ListSetFont(LIST_CATE, MEDIUM_FONT);
			font_size = MEDIUM_FONT;
		}
		else
		{
			ListSetFont(LIST_CATE, SMALL_FONT);
			font_size = SMALL_FONT;
		}
		
		if (list_ptr->list_total_num_items > list_ptr->list_max_num_items_on_display)
		{
			scroll_ptr->scrollbar_attr.scrollbar_visible = TRUE;
			
			if (list_ptr->list_highlighted_item > 0 && list_ptr->list_highlighted_item < list_ptr->list_top_item_num)
				list_ptr->list_top_item_num = list_ptr->list_highlighted_item;
			else if (list_ptr->list_highlighted_item >= (list_ptr->list_top_item_num + list_ptr->list_max_num_items_on_display))
				list_ptr->list_top_item_num = list_ptr->list_highlighted_item;
			
			if (list_ptr->list_top_item_num >= (list_ptr->list_total_num_items - list_ptr->list_max_num_items_on_display))
				list_ptr->list_top_item_num = (list_ptr->list_total_num_items - list_ptr->list_max_num_items_on_display);           
			
			scroll_ptr->scrollbar_value 	= list_ptr->list_top_item_num;
			scroll_ptr->scrollbar_min		= 0;
			scroll_ptr->scrollbar_pagesize  = list_ptr->list_max_num_items_on_display;
			scroll_ptr->scrollbar_draw_pagesize 	= scroll_ptr->scrollbar_pagesize;
			scroll_ptr->scrollbar_max		= list_ptr->list_total_num_items - scroll_ptr->scrollbar_pagesize;
			scroll_ptr->scrollbar_total_num_lines = list_ptr->list_total_num_items;      
		}
		else
		{
			scroll_ptr->scrollbar_attr.scrollbar_visible = FALSE;
			if (draw_scrollbar)
				ScrollbarEraseScrollbar(SCROLLBAR_CATE);
			list_ptr->list_top_item_num = 0;
		}
		
		
		if (list_ptr->list_text_font == SMALL_FONT)							
		{
			MenuDeleteItem(MENU_EDIT_CATE, 0);
			MenuInsertItem(MENU_EDIT_CATE, 0, EMLFONT);
			ControlSetLabel(BUTTON_CATE_ZOOMIN, EMLFONT);
		}
		else
		{
			MenuDeleteItem(MENU_EDIT_CATE, 0);
			MenuInsertItem(MENU_EDIT_CATE, 0, EMSFONT);
			ControlSetLabel(BUTTON_CATE_ZOOMIN, EMSFONT);
		}
		
		ControlDrawControl(BUTTON_CATE_ZOOMIN);
		ListDrawList(LIST_CATE);
		if (draw_scrollbar)
			ScrollbarDrawScrollbar(SCROLLBAR_CATE);
		break;
	default: break;
	}
}

/********************************************************
* Function:    EmailChangefontSize
* Purpose:     None
* Scope:		application
* Input:		Event		
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EmailChangeFontSize(ObjectID form_id, BYTE required_font_size)
{
	ObjectID 		active_form_id;
	List			*list_ptr, *list_ptr1;
	Scrollbar		*scroll_ptr;
    BYTE            object_type, *list_text;
    Field           *field_ptr;
    Table           *table_ptr;
    USHORT          count;
    SHORT           line_height;
    WORD            acc_num_lines = 0;
    WORD            num_lines_displayed = 0;
	
    active_form_id = form_id;
	
	switch (active_form_id)
	{
	case FORM_MAIL_LIST:
		if (mail_list_table_font_size == required_font_size)
			break;
		if (mail_list_table_font_size == MEDIUM_FONT)
			mail_list_table_font_size = SMALL_FONT;
		else mail_list_table_font_size = MEDIUM_FONT;
		
		FormGetObjectPointer(TABLE_MAIL_LIST, &object_type, (void**)&table_ptr);
		FormGetObjectPointer(SCROLLBAR_MAIL_LIST, &object_type, (void**)&scroll_ptr);
		line_height = SysGetFontHeight(mail_list_table_font_size) + SPACE_LINE;
		
		switch (mail_list_table_font_size)
		{
		case SMALL_FONT:
			MenuDeleteItem(MENU_POPUP1, 4);
			MenuInsertItem(MENU_POPUP1, 4, EMLFONT);
			for (count = 0; count < (table_ptr->table_num_row); count++)
			{
				table_ptr->table_row_height[count] = SysGetFontHeight(SMALL_FONT) + SPACE_LINE;
				FormGetObjectPointer((ObjectID)(FIELD_MAIL_LIST_TO + count), &object_type, (void**)&field_ptr);
				field_ptr->bounds.height = table_ptr->table_row_height[count];
				field_ptr->field_font_id = SMALL_FONT;
				TableUpdateObjectScreenBounds(TABLE_MAIL_LIST, (ObjectID)(FIELD_MAIL_LIST_TO + count));
				StrAnalyzeLine(field_ptr);
			}
			break;
		case MEDIUM_FONT:
			MenuDeleteItem(MENU_POPUP1, 4);
			MenuInsertItem(MENU_POPUP1, 4, EMSFONT);
			for (count = 0; count < (table_ptr->table_num_row); count++)
			{
				table_ptr->table_row_height[count] = SysGetFontHeight(MEDIUM_FONT) + SPACE_LINE;
				FormGetObjectPointer((ObjectID)(FIELD_MAIL_LIST_TO + count), &object_type, (void**)&field_ptr);
				field_ptr->bounds.height = table_ptr->table_row_height[count];
				field_ptr->field_font_id = MEDIUM_FONT;
				TableUpdateObjectScreenBounds(TABLE_MAIL_LIST, (ObjectID)(FIELD_MAIL_LIST_TO + count));
				StrAnalyzeLine(field_ptr);
			}
			break;
		default: return;
		}
		EmailSetEditTable(FORM_MAIL_LIST, TABLE_MAIL_LIST);
		EmailEditTableSetScrollbar(TABLE_MAIL_LIST, SCROLLBAR_MAIL_LIST);
		break;
        case FORM_EDIT:
            if (edit_table_font_size == required_font_size)
                break;
            if (edit_table_font_size == MEDIUM_FONT)
                edit_table_font_size = SMALL_FONT;
            else edit_table_font_size = MEDIUM_FONT;
			
            FormGetObjectPointer(TABLE_EDIT, &object_type, (void**)&table_ptr);
            FormGetObjectPointer(SCROLLBAR_EDIT, &object_type, (void**)&scroll_ptr);
            line_height = SysGetFontHeight(edit_table_font_size) + SPACE_LINE;
			
            switch (edit_table_font_size)
            {
			case SMALL_FONT:
				MenuDeleteItem(MENU_POPUP1, 4);
				MenuInsertItem(MENU_POPUP1, 4, EMLFONT);
				for (count = 0; count < (table_ptr->table_num_row); count++)
				{
					table_ptr->table_row_height[count] = SysGetFontHeight(SMALL_FONT) + SPACE_LINE;
					FormGetObjectPointer((ObjectID)(FIELD_EDIT_0 + count), &object_type, (void**)&field_ptr);
					field_ptr->bounds.height = table_ptr->table_row_height[count];
					field_ptr->field_font_id = SMALL_FONT;
					TableUpdateObjectScreenBounds(TABLE_EDIT, (ObjectID)(FIELD_EDIT_0 + count));
					StrAnalyzeLine(field_ptr);
				}
				break;
			case MEDIUM_FONT:
				MenuDeleteItem(MENU_POPUP1, 4);
				MenuInsertItem(MENU_POPUP1, 4, EMSFONT);
				for (count = 0; count < (table_ptr->table_num_row); count++)
				{
					table_ptr->table_row_height[count] = SysGetFontHeight(MEDIUM_FONT) + SPACE_LINE;
					FormGetObjectPointer((ObjectID)(FIELD_EDIT_0 + count), &object_type, (void**)&field_ptr);
					field_ptr->bounds.height = table_ptr->table_row_height[count];
					field_ptr->field_font_id = MEDIUM_FONT;
					TableUpdateObjectScreenBounds(TABLE_EDIT, (ObjectID)(FIELD_EDIT_0 + count));
					StrAnalyzeLine(field_ptr);
				}
				break;
			default: return;
            }
            EmailSetEditTable(FORM_EDIT, TABLE_EDIT);
            EmailEditTableSetScrollbar(TABLE_EDIT, SCROLLBAR_EDIT);
            break;
			case FORM_EMAIL_NAME_LIST:
				FormGetObjectPointer(LIST_NAME, &object_type, (void**)&list_ptr);
				FormGetObjectPointer(LIST_EMAIL, &object_type, (void**)&list_ptr1);
				FormGetObjectPointer(SCROLLBAR_EMAIL_NAME_LIST, &object_type, (void**)&scroll_ptr);
				if (list_ptr->list_text_font == required_font_size)
					break;                
				
				if (list_ptr->list_text_font == SMALL_FONT)
				{
					ListSetFont(LIST_NAME, MEDIUM_FONT);
					ListSetFont(LIST_EMAIL, MEDIUM_FONT);
				}
				else
				{
					ListSetFont(LIST_NAME, SMALL_FONT);
					ListSetFont(LIST_EMAIL, SMALL_FONT);
				}
				
				list_email_name.max_num_items_display = list_ptr->list_max_num_items_on_display;
				
				if (list_email_name.total_num_items > list_ptr->list_max_num_items_on_display)
				{
					if (list_email_name.top_item_num > (list_email_name.total_num_items - list_ptr->list_max_num_items_on_display))
						list_email_name.num_items_display = (list_email_name.total_num_items - list_email_name.top_item_num);
					else list_email_name.num_items_display = list_ptr->list_max_num_items_on_display;
				}
				else if (list_email_name.total_num_items == list_ptr->list_max_num_items_on_display)
					list_email_name.num_items_display = list_ptr->list_max_num_items_on_display;
				else list_email_name.num_items_display = list_email_name.total_num_items;
				
				EmailListDisplayDrawAddressList(&list_email_name);
				
				EmailAddressListSetScrollbar();
				
				if (list_ptr->list_attr.list_visible == TRUE)
				{                                             
					ListDisplayGetText(&list_email_name, 2, list_email_name.top_item_num, &list_text);
					EmailStartCharSetTab(list_text[0]);
					qfree(list_text);
				}
				
				if (list_ptr->list_text_font == SMALL_FONT)
				{
					MenuDeleteItem(MENU_EMAIL_NAME_LIST, 0);
					MenuInsertItem(MENU_EMAIL_NAME_LIST, 0, EMLFONT);
					ControlSetLabel(BUTTON_EMAIL_NAME_LIST_ZOOMIN, EMLFONT);
				}
				else
				{
					MenuDeleteItem(MENU_EMAIL_NAME_LIST, 0);
					MenuInsertItem(MENU_EMAIL_NAME_LIST, 0, EMSFONT);
					ControlSetLabel(BUTTON_EMAIL_NAME_LIST_ZOOMIN, EMSFONT);
				}
				
				break;
			case FORM_FIND_RESULT:
				FormGetObjectPointer(LIST_FIND_RESULT_NAME, &object_type, (void**)&list_ptr);
				FormGetObjectPointer(LIST_FIND_RESULT_EMAIL, &object_type, (void**)&list_ptr1);
				FormGetObjectPointer(SCROLLBAR_FIND_RESULT, &object_type, (void**)&scroll_ptr);
				if (list_ptr->list_text_font == required_font_size)
					break;                
				
				if (list_ptr->list_text_font == SMALL_FONT)
				{
					ListSetFont(LIST_FIND_RESULT_NAME, MEDIUM_FONT);
					ListSetFont(LIST_FIND_RESULT_EMAIL, MEDIUM_FONT);
				}
				else
				{
					ListSetFont(LIST_FIND_RESULT_NAME, SMALL_FONT);
					ListSetFont(LIST_FIND_RESULT_EMAIL, SMALL_FONT);
				}
				
				list_find.max_num_items_display = list_ptr->list_max_num_items_on_display;
				
				if (list_find.total_num_items > list_ptr->list_max_num_items_on_display)
				{
					if (list_find.top_item_num > (list_find.total_num_items - list_ptr->list_max_num_items_on_display))
						list_find.num_items_display = (list_find.total_num_items - list_find.top_item_num);
					else list_find.num_items_display = list_ptr->list_max_num_items_on_display;
				}
				else if (list_find.total_num_items == list_ptr->list_max_num_items_on_display)
					list_find.num_items_display = list_ptr->list_max_num_items_on_display;
				else list_find.num_items_display = list_find.total_num_items;
				
				EmailListDisplayDrawAddressList(&list_find);
				
				
				if (list_ptr->list_total_num_items > list_ptr->list_max_num_items_on_display)
				{
					scroll_ptr->scrollbar_attr.scrollbar_visible = TRUE;
					if (list_ptr->list_top_item_num >= (list_ptr->list_total_num_items - list_ptr->list_max_num_items_on_display))
						list_ptr->list_top_item_num = (list_ptr->list_total_num_items - list_ptr->list_max_num_items_on_display);           
					
					list_ptr1->list_top_item_num = list_ptr->list_top_item_num;				
					
					scroll_ptr->scrollbar_value 	= list_ptr->list_top_item_num;
					scroll_ptr->scrollbar_min		= 0;
					scroll_ptr->scrollbar_pagesize  = list_ptr->list_max_num_items_on_display;
					scroll_ptr->scrollbar_draw_pagesize 	= scroll_ptr->scrollbar_pagesize;
					scroll_ptr->scrollbar_max		= list_ptr->list_total_num_items - scroll_ptr->scrollbar_pagesize;
					scroll_ptr->scrollbar_total_num_lines = list_ptr->list_total_num_items;      
				}
				else
				{
					scroll_ptr->scrollbar_attr.scrollbar_visible = FALSE;
					if (draw_scrollbar)
						ScrollbarEraseScrollbar(SCROLLBAR_CATE);
					list_ptr->list_top_item_num = 0;
				}
				
				
				if (list_ptr->list_text_font == SMALL_FONT)							
				{
					MenuDeleteItem(MENU_FIND_RESULT, 0);
					MenuInsertItem(MENU_FIND_RESULT, 0, EMLFONT);
					ControlSetLabel(BUTTON_FIND_RESULT_ZOOMIN, EMLFONT);
				}
				else
				{			
					MenuDeleteItem(MENU_FIND_RESULT, 0);
					MenuInsertItem(MENU_FIND_RESULT, 0, EMSFONT);			
					ControlSetLabel(BUTTON_FIND_RESULT_ZOOMIN, EMSFONT);
				}
				
				break;
			case FORM_EDIT_CATE:
				FormGetObjectPointer(LIST_CATE, &object_type, (void**)&list_ptr);
				FormGetObjectPointer(SCROLLBAR_CATE, &object_type, (void**)&scroll_ptr);
				
				if (list_ptr->list_text_font == required_font_size)
					break;                
				
				if (list_ptr->list_text_font == SMALL_FONT)
					ListSetFont(LIST_CATE, MEDIUM_FONT);
				else ListSetFont(LIST_CATE, SMALL_FONT);
				
				if (list_ptr->list_total_num_items > list_ptr->list_max_num_items_on_display)
				{
					scroll_ptr->scrollbar_attr.scrollbar_visible = TRUE;
					
					if (list_ptr->list_highlighted_item > 0 && list_ptr->list_highlighted_item < list_ptr->list_top_item_num)
						list_ptr->list_top_item_num = list_ptr->list_highlighted_item;
					else if (list_ptr->list_highlighted_item >= (list_ptr->list_top_item_num + list_ptr->list_max_num_items_on_display))
						list_ptr->list_top_item_num = list_ptr->list_highlighted_item;
					
					if (list_ptr->list_top_item_num >= (list_ptr->list_total_num_items - list_ptr->list_max_num_items_on_display))
						list_ptr->list_top_item_num = (list_ptr->list_total_num_items - list_ptr->list_max_num_items_on_display);           
					
					scroll_ptr->scrollbar_value 	= list_ptr->list_top_item_num;
					scroll_ptr->scrollbar_min		= 0;
					scroll_ptr->scrollbar_pagesize  = list_ptr->list_max_num_items_on_display;
					scroll_ptr->scrollbar_draw_pagesize 	= scroll_ptr->scrollbar_pagesize;
					scroll_ptr->scrollbar_max		= list_ptr->list_total_num_items - scroll_ptr->scrollbar_pagesize;
					scroll_ptr->scrollbar_total_num_lines = list_ptr->list_total_num_items;      
				}
				else
				{
					scroll_ptr->scrollbar_attr.scrollbar_visible = FALSE;
					if (draw_scrollbar)
						ScrollbarEraseScrollbar(SCROLLBAR_CATE);
					list_ptr->list_top_item_num = 0;
				}
				
				
				if (list_ptr->list_text_font == SMALL_FONT)							
				{
					MenuDeleteItem(MENU_EDIT_CATE, 0);
					MenuInsertItem(MENU_EDIT_CATE, 0, EMLFONT);
					ControlSetLabel(BUTTON_CATE_ZOOMIN, EMLFONT);
				}
				else
				{
					MenuDeleteItem(MENU_EDIT_CATE, 0);
					MenuInsertItem(MENU_EDIT_CATE, 0, EMSFONT);
					ControlSetLabel(BUTTON_CATE_ZOOMIN, EMSFONT);
				}
				
				break;
			default: break;
	}
}

