/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   econnect.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"

/********************************************************
* Function:	EmailConnectSetScreen
* Purpose: 	This function is called to set the screen FORM_CONNECT
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
void EmailConnectSetScreen()
{
	BOOLEAN control_value;
	BYTE *dial_num, *dial_out_num;
	BYTE *temp, *temp1;
	
	/*set up the dial out number */
	FormGetControlValue(CHECKBOX_DIAL_OUT, &control_value);
	TextboxGetTextPointer(TEXTBOX_DIAL, &dial_num);
	TextboxGetTextPointer(TEXTBOX_DIAL_OUT, &dial_out_num);
	StringInitString(STRING_CONNECT_NUM);
	if (control_value == FALSE)
		StringSetText(STRING_CONNECT_NUM, dial_num);
	else
	{
		temp = (BYTE*)qmalloc((strlen(dial_num) + strlen(dial_out_num) + 10)*sizeof(BYTE));
		temp1 = temp;
		strcpy(temp, dial_out_num);
		temp += strlen(dial_out_num);
		strcpy(temp, dial_num);
		StringSetText(STRING_CONNECT_NUM, temp1);
		qfree(temp1);
	}
	
	FieldInitField(FIELD_CONNECT);
	FieldSetText(FIELD_CONNECT, EMSTR15);
	FieldSetTopLineNum(FIELD_CONNECT, 0);
}	

/********************************************************
* Function:	EmailConnectInsertTextToField
* Purpose: 	This fucntion is specifically written to 
append a line of text to the field object
* Scope:		application/internal
* Input:		in_text		
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EmailConnectInsertTextToField(BYTE *in_text)
{
	BYTE *buffer, *buffer1;
	BYTE *field_text;
	BYTE object_type;
	Field *field_ptr;
	
	FieldGetTextPointer(FIELD_CONNECT, &field_text);
	buffer = (BYTE*)qmalloc((strlen(field_text) + strlen(in_text) + 10)*sizeof(BYTE));
	buffer1 = buffer;
	strcpy(buffer, field_text);
	buffer += strlen(field_text);
	*buffer = '\r';
	buffer ++;
	strcpy(buffer, in_text);
	FieldSetText(FIELD_CONNECT, buffer1);
	qfree(buffer1);
	
	FormGetObjectPointer(FIELD_CONNECT, &object_type, (void**)&field_ptr);
	if (field_ptr->field_total_num_lines > field_ptr->field_num_lines_displayed)
	{
		field_ptr->field_top_line_num = field_ptr->field_total_num_lines - field_ptr->field_num_lines_displayed;
		EmailConnectFieldSetScrollbar();
	}
}

/********************************************************
* Function:	EmailConnectFieldSetScrollbar
* Purpose: 	This function is called if the field is changed and the 
scrollbar is required to set correspondingly
* Scope:		application/internal
* Input:		none
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EmailConnectFieldSetScrollbar()
{
	Field *field_ptr;
	Scrollbar *scroll_ptr;
	BYTE object_type;
	
	FormGetObjectPointer(FIELD_CONNECT, &object_type, (void**)&field_ptr);
	FormGetObjectPointer(SCROLLBAR_CONNECT, &object_type, (void**)&scroll_ptr);
	if (field_ptr->field_num_lines_displayed <= (field_ptr->bounds.height/SysGetFontHeight(field_ptr->field_font_id)))
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_CONNECT, FALSE);
		ScrollbarEraseScrollbar(SCROLLBAR_CONNECT);
		return;
	}
	else ScrollbarSetScrollbarVisible(SCROLLBAR_CONNECT, TRUE);

	if (scroll_ptr->scrollbar_value == field_ptr->field_top_line_num)
		return;

	ScrollbarSetScrollbar(SCROLLBAR_CONNECT, field_ptr->field_top_line_num, 
			(field_ptr->field_total_num_lines - field_ptr->field_num_lines_displayed),
			0, field_ptr->field_num_lines_displayed,
			field_ptr->field_total_num_lines);
	ScrollbarSetScrollbarDrawPagesize(SCROLLBAR_CONNECT, (field_ptr->bounds.height/SysGetFontHeight(field_ptr->field_font_id)));
	ScrollbarSetScrollbarDrawPagesize(SCROLLBAR_CONNECT, field_ptr->field_num_lines_displayed);
	ScrollbarDrawScrollbar(SCROLLBAR_CONNECT);
}

/********************************************************
* Function:	EmailConnectScrollbarSetField
* Purpose: 	This function is called to set the content of the field object
when the SCROLLBAR_CONNECT is moved
* Scope:		application/internal
* Input:		Event
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EmailConnectScrollbarSetField(EvtType *Event)
{
	WORD value, max_value, min_value, pagesize, total_num_lines;
	
	ScrollbarGetScrollbar(SCROLLBAR_CONNECT, &value, &max_value, &min_value, &pagesize, &total_num_lines);
	ScrollbarSetScrollbar(SCROLLBAR_CONNECT, Event->para2, max_value, min_value, pagesize, total_num_lines);
	ScrollbarDrawScrollbar(SCROLLBAR_CONNECT);
	FieldSetTopLineNum(FIELD_CONNECT, Event->para2);
	
    if (Event->eventType == EVT_SCROLLBAR_SELECT 
			|| (Event->eventType == EVT_SCROLLBAR_REPEAT 
			&& (Event->para1 != Event->para2)))
	{
        FieldDrawField(FIELD_CONNECT);
	}
}
