/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   edial.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"

/********************************************************
* Function:	EmailDialSetScreen
* Purpose: 	This function is called to set up the screen 
FORM_DIAL
* Scope:		application/internal
* Input:		none
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EmailDialSetScreen()
{
	EmailSettings email0, email1, email2, email3;
	
	SySetupGetEmailSettings(&email0, EMAIL1);
	SySetupGetEmailSettings(&email1, EMAIL2);
	SySetupGetEmailSettings(&email2, EMAIL3);
	SySetupGetEmailSettings(&email3, EMAIL4);
	
	if (email0.isp == NULL)
		ControlSetLabel(PUSHBUTTON_ACCOUNT_0,(BYTE*)(""));
	else ControlSetLabel(PUSHBUTTON_ACCOUNT_0,email0.isp);
	
	if (email1.isp == NULL)
		ControlSetLabel(PUSHBUTTON_ACCOUNT_1,(BYTE*)(""));
	else ControlSetLabel(PUSHBUTTON_ACCOUNT_1,email1.isp);
	
	if (email2.isp == NULL)
		ControlSetLabel(PUSHBUTTON_ACCOUNT_2,(BYTE*)(""));
	else ControlSetLabel(PUSHBUTTON_ACCOUNT_2,email2.isp);
	
	if (email3.isp == NULL)
		ControlSetLabel(PUSHBUTTON_ACCOUNT_3,(BYTE*)(""));
	else ControlSetLabel(PUSHBUTTON_ACCOUNT_3,email3.isp);
	
}

/********************************************************
* Function:	EmailDialPushButtonAction
* Purpose: 	This function is called to set up the screen 
FORM_DIAL
* Scope:		application/internal
* Input:		none
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EmailDialPushButtonAction(UWORD push_button)
{
    EmailSettings           email;
    BYTE                    object_type;
    Control                 *ptr;
	ControlTemplateCheckBox *addr;
    Textbox                 *textbox_ptr, *textbox_ptr1;
	
	SySetupGetEmailSettings(&email, push_button);
	
	TextboxSetText(TEXTBOX_DIAL, email.tel);
    if (FormGetObjectPointer(TEXTBOX_DIAL, &object_type, (void**)&textbox_ptr) != TRUE)
        return;
    if (FormGetObjectPointer(TEXTBOX_DIAL_OUT, &object_type, (void**)&textbox_ptr1) != TRUE)
        return;
	
    if (textbox_ptr->textbox_attr.textbox_highlight)
    {
        textbox_ptr->textbox_attr.textbox_highlight =   FALSE;
        textbox_ptr->textbox_highlight_start_char   =   0;
        textbox_ptr->textbox_highlight_end_char     =   0;
        textbox_ptr->textbox_highlight_length       =   0;
    }
	
    if (textbox_ptr1->textbox_attr.textbox_highlight)
    {
        textbox_ptr1->textbox_attr.textbox_highlight =   FALSE;
        textbox_ptr1->textbox_highlight_start_char   =   0;
        textbox_ptr1->textbox_highlight_end_char     =   0;
        textbox_ptr1->textbox_highlight_length       =   0;
    }               
	
	TextboxDrawTextbox(TEXTBOX_DIAL);
    TextboxDrawTextbox(TEXTBOX_DIAL_OUT);
	
	
    TextboxSetInsertPointOff(TEXTBOX_DIAL);
    TextboxSetInsertPointOff(TEXTBOX_DIAL_OUT); 
	
    TextboxSetInsertPointPositionByCharPos(TEXTBOX_DIAL, 0);
    TextboxSetInsertPointPositionByCharPos(TEXTBOX_DIAL_OUT, 0);
    LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT); 
}