/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   emeslist.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"


/********************************************************
* Function:	EmailCateNameToPopupTriggerEmailBox
* Purpose: 	This function is used to update teh items of the 
POPUP_TRIGGER_EMAIL_BOX
* Scope:		application
* Input:		dbid		THE dbid of a database
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EmailCateNameToPopupTriggerEmailBox()
{
	
	ControlPopupDeleteAllItems(POPUP_TRIGGER_EMAIL_BOX);
	ControlPopupInsertItem(POPUP_TRIGGER_EMAIL_BOX,0,EMINBOX);
	ControlPopupInsertItem(POPUP_TRIGGER_EMAIL_BOX,1,EMOUTBOX);
	ControlPopupInsertItem(POPUP_TRIGGER_EMAIL_BOX,2,EMSENT);
	ControlPopupInsertItem(POPUP_TRIGGER_EMAIL_BOX,3,EMDRAFT);
	ControlPopupInsertItem(POPUP_TRIGGER_EMAIL_BOX,4,EMADDLIST);
}

/********************************************************
* Function:	EmailGetEMessRecNumWithCateName
* Purpose: 	This function is called to get all record numbers of the records that 
are with the same category name
* Scope:		application
* Input:		dbid			The database ID
cate_name		The required category
* Output:		rec_num			array of record number
num_rec			number of record returned
* Return:		TRUE			success
FALSE			error occure
* Comment: 	Database must be opened
*********************************************************/
BOOLEAN EmailGetEMessRecNumWithCateName(DatabaseID dbid, BYTE *cate_name, UWORD rec_num[], UWORD *num_rec)
{
	UWORD total_num_rec;
	UWORD i;
	UBYTE cate_num;
	UBYTE rec_cate_num;
	RecordID rec_id;
	UWORD total_cate_rec = 0;
	
	if (EmailCateNameToNum(emess_dbid, cate_name, &cate_num) == FALSE)
	{
		*num_rec = 0;
		return FALSE;
	}
	
	DataTotalRecord(emess_dbid, &total_num_rec);
	for ( i = 0; i<total_num_rec; i++)
	{
		DataNumtoRecID(emess_dbid, i, &rec_id);
		DataRecordInfo(emess_dbid, rec_id, NULL, &rec_cate_num, NULL, NULL, NULL);
		if (rec_cate_num == cate_num)
		{
			rec_num[total_cate_rec] = i;
			total_cate_rec++;
		}
	}
	*num_rec = total_cate_rec;
	return TRUE;
}

/********************************************************
* Function:	EmailRecordToEmailMessageList
* Purpose: 	This function is called in order to place
email message record to a list object
* Scope:		application
* Input:		dbid		THE dbid of a database
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
BOOLEAN EmailRecordToEmailMessageList(BYTE *cate_name, BYTE starting_char)
{
	UBYTE cate_number;
	UWORD total_num_rec, i;
	UWORD rec_id;
	UWORD *rec_num;
	UWORD num_rec;
	BOOLEAN update = FALSE;
	USHORT old_sort_field;
	
	if (EmailCateNameToNum(emess_dbid, cate_name, &cate_number) == FALSE) return FALSE;
	
	DataGetDBSortField(emess_dbid, &old_sort_field);
	
	if ((cate_number == OUTBOX || cate_number == SENT || cate_number == DRAFT) && old_sort_field != TIME_INDEX)
	{
		DataCloseDB(emess_dbid);
		DataOpenDB(emess_dbid, 1, OPEN_RW);
	}
	else if (cate_number == INBOX && old_sort_field != DATE)
	{
		DataCloseDB(emess_dbid);
		DataOpenDB(emess_dbid, 0, OPEN_RW);
	}
	ListDisplayDeleteAllRecordID(&list_email_mess);
	DataTotalRecord(emess_dbid, &total_num_rec);
	rec_num = (UWORD*)qmalloc(total_num_rec*sizeof(UWORD));
	EmailGetEMessRecNumWithCateName(emess_dbid, cate_name, rec_num, &num_rec);
	if (num_rec != 0)
	{
		for (i = (num_rec - 1); i>=0; i--)
		{
			DataNumtoRecID(emess_dbid, rec_num[i], &rec_id);
			ListDisplayInsertRecordID(&list_email_mess, rec_id, emess_dbid);
			if (i == 0) break;
		}
	}
	
	qfree(rec_num);
	EmailSetEmailMessageListTopItemNum(starting_char);
	EmailEmailMessageListSetScrollbar();
	return TRUE;
}

/********************************************************
* Function:	EmailSetEmailMessageListTopItemNum
* Purpose: 	This function is called to set the top item number
of the list object - LIST_EMAIL_MESS_NAME and LIST_EMAIL_MESSAGE_CON
* Scope:		application
* Input:		BYTE				the starting_char
* Output:		None
* Return:		TRUE			display of list is on
FALSE			display of list is off
* Comment: 	The top item number of the list objects are set
*********************************************************/
BOOLEAN EmailSetEmailMessageListTopItemNum(BYTE start_char)
{
	USHORT total_num_items;
	USHORT count = 0;
	BOOLEAN enable,drawn,active,visible,set_scroll;
	Scrollbar *scroll_ptr;
	BYTE object_type;
	RecordID rec_id;
	DatabaseID dbid;
	BOOLEAN found = FALSE;
	ObjectID	temp;
	Bitmap *bitmap_ptr;
	
	total_num_items = list_email_mess.total_num_items;
	list_email_mess.top_item_num = 0;
	if (email_mess_top.preset == TRUE && total_num_items != 0)
	{
		for (count = 0; count<total_num_items; count++)
		{
			ListDisplayGetRecordID(&list_email_mess, count, &rec_id, &dbid);
			if (rec_id == email_mess_top.rec_id)
			{
				list_email_mess.top_item_num = count;
				email_mess_top.preset = FALSE;
				ListGetAttribute(LIST_EMAIL_MESS_NAME, &enable, &drawn, &active, &visible, &set_scroll);
				ListSetAttribute(LIST_EMAIL_MESS_NAME, enable, drawn, active, TRUE, set_scroll);
				ListGetAttribute(LIST_EMAIL_MESS_SUB, &enable, &drawn, &active, &visible, &set_scroll);
				ListSetAttribute(LIST_EMAIL_MESS_SUB, enable, drawn, active, TRUE, set_scroll);
				if (EmailCompareTwoStrings(current_email_box, EMINBOX) == SAME)
				{
					ListGetAttribute(LIST_EMAIL_MESS_TIME, &enable, &drawn, &active, &visible, &set_scroll);
					ListSetAttribute(LIST_EMAIL_MESS_TIME, enable, drawn, active, TRUE, set_scroll);
				}
				else
				{
					ListGetAttribute(LIST_EMAIL_MESS_TIME, &enable, &drawn, &active, &visible, &set_scroll);
					ListSetAttribute(LIST_EMAIL_MESS_TIME, enable, drawn, active, FALSE, set_scroll);
				}
				found = TRUE;
				break;
			}
		}
		if (found == FALSE)
		{
			list_email_mess.top_item_num = 0;
			ListGetAttribute(LIST_EMAIL_MESS_NAME, &enable, &drawn, &active, &visible, &set_scroll);
			ListSetAttribute(LIST_EMAIL_MESS_NAME, enable, drawn, active, TRUE, set_scroll);
			ListGetAttribute(LIST_EMAIL_MESS_SUB, &enable, &drawn, &active, &visible, &set_scroll);
			ListSetAttribute(LIST_EMAIL_MESS_SUB, enable, drawn, active, TRUE, set_scroll);
			if (EmailCompareTwoStrings(current_email_box, EMINBOX) == SAME)
			{
				ListGetAttribute(LIST_EMAIL_MESS_TIME, &enable, &drawn, &active, &visible, &set_scroll);
				ListSetAttribute(LIST_EMAIL_MESS_TIME, enable, drawn, active, TRUE, set_scroll);
			}
			else
			{
				ListGetAttribute(LIST_EMAIL_MESS_TIME, &enable, &drawn, &active, &visible, &set_scroll);
				ListSetAttribute(LIST_EMAIL_MESS_TIME, enable, drawn, active, FALSE, set_scroll);
			}
		}
	}
	else if (email_mess_top.preset == FALSE && total_num_items != 0)
	{
		list_email_mess.top_item_num = 0;
		ListGetAttribute(LIST_EMAIL_MESS_NAME, &enable, &drawn, &active, &visible, &set_scroll);
		ListSetAttribute(LIST_EMAIL_MESS_NAME, enable, drawn, active, TRUE, set_scroll);
		ListGetAttribute(LIST_EMAIL_MESS_SUB, &enable, &drawn, &active, &visible, &set_scroll);
		ListSetAttribute(LIST_EMAIL_MESS_SUB, enable, drawn, active, TRUE, set_scroll);
		if (EmailCompareTwoStrings(current_email_box, EMINBOX) == SAME)
		{
			ListGetAttribute(LIST_EMAIL_MESS_TIME, &enable, &drawn, &active, &visible, &set_scroll);
			ListSetAttribute(LIST_EMAIL_MESS_TIME, enable, drawn, active, TRUE, set_scroll);
		}
		else
		{
			ListGetAttribute(LIST_EMAIL_MESS_TIME, &enable, &drawn, &active, &visible, &set_scroll);
			ListSetAttribute(LIST_EMAIL_MESS_TIME, enable, drawn, active, FALSE, set_scroll);
		}
	}
	else if (total_num_items == 0)
	{
		ListGetAttribute(LIST_EMAIL_MESS_NAME, &enable, &drawn, &active, &visible, &set_scroll);
		ListSetAttribute(LIST_EMAIL_MESS_NAME, enable, drawn, active, FALSE, set_scroll);
		ListGetAttribute(LIST_EMAIL_MESS_SUB, &enable, &drawn, &active, &visible, &set_scroll);
		ListSetAttribute(LIST_EMAIL_MESS_SUB, enable, drawn, active, FALSE, set_scroll);
		ListGetAttribute(LIST_EMAIL_MESS_TIME, &enable, &drawn, &active, &visible, &set_scroll);
		ListSetAttribute(LIST_EMAIL_MESS_TIME, enable, drawn, active, FALSE, set_scroll);
		ListEraseList(LIST_EMAIL_MESS_NAME);
		ListEraseList(LIST_EMAIL_MESS_SUB);
		ListEraseList(LIST_EMAIL_MESS_TIME);
		for (temp = BITMAP_EMAIL_MESS_0; temp <= BITMAP_EMAIL_MESS_10; temp++)
		{
			FormGetObjectPointer(temp, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			BitmapEraseBitmap(temp);
		}
		
	}
	if (list_email_mess.total_num_items <= list_email_mess.max_num_items_display)
		list_email_mess.top_item_num = 0;
	else if ((list_email_mess.total_num_items - list_email_mess.max_num_items_display) < list_email_mess.top_item_num)
		list_email_mess.top_item_num = (list_email_mess.total_num_items - list_email_mess.max_num_items_display);
	if (total_num_items != 0)
		EmailListDisplayDrawEmailMessageList(&list_email_mess);
	if (total_num_items > list_email_mess.max_num_items_display)
	{
		ScrollbarSetScrollbar(SCROLLBAR_EMAIL_MESS , (list_email_mess.total_num_items - list_email_mess.num_items_display),
			(list_email_mess.total_num_items - list_email_mess.num_items_display), 0, 
			list_email_mess.max_num_items_display, list_email_mess.total_num_items);
        if (draw_scrollbar)
            ScrollbarDrawScrollbar(SCROLLBAR_EMAIL_MESS);
	}
	else
	{
		FormGetObjectPointer(SCROLLBAR_EMAIL_MESS , &object_type, (void**)&scroll_ptr);
        if (draw_scrollbar)
            ScrollbarEraseScrollbar(SCROLLBAR_EMAIL_MESS);
	}
	return FALSE;	
}

/********************************************************
* Function:	EmailEmailMessageListSetScrollbar
* Purpose: 	This function is called in order to set the values for a scrollbar		
* Scope:		application
* Input:		BYTE				the starting_char
* Output:		None
* Return:		TRUE		scrollbar is erased
FALSE		scrollbar is drawn
* Comment: 	If a scrollbar is not required, then the scrollbar will be erased 
If a scrollbar is required, the scrollbar will be displayed accordingly 
*********************************************************/
BOOLEAN EmailEmailMessageListSetScrollbar()
{
	USHORT total_num_items;
	USHORT max_num_items_display;
	USHORT top_item_num;
	USHORT current_num_items_display;
	WORD max_value, min_value, pagesize, total_num_lines;
	BYTE object_type;
	Scrollbar *scroll_ptr;
	
	max_num_items_display = list_email_mess.max_num_items_display;
	total_num_items = list_email_mess.total_num_items;
	top_item_num = list_email_mess.top_item_num;
	current_num_items_display = list_email_mess.num_items_display;
	
	total_num_lines = total_num_items;
	pagesize = max_num_items_display;
	min_value = 0;
	max_value = total_num_lines - pagesize;	
	
	if (total_num_items > max_num_items_display)
		ScrollbarSetScrollbarVisible(SCROLLBAR_EMAIL_MESS ,TRUE);
	else
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_EMAIL_MESS ,FALSE);
        if (draw_scrollbar)
            ScrollbarEraseScrollbar(SCROLLBAR_EMAIL_MESS );
		return FALSE;
	}
	
	if (top_item_num > (total_num_items - max_num_items_display))
		ScrollbarSetScrollbar(SCROLLBAR_EMAIL_MESS , max_value, max_value, min_value,
		pagesize, total_num_lines);
	else if ((total_num_items - max_num_items_display) < top_item_num)
		top_item_num = (total_num_items - max_num_items_display);
	else ScrollbarSetScrollbar(SCROLLBAR_EMAIL_MESS , top_item_num, max_value, min_value,
		pagesize, total_num_lines);
	
	FormGetObjectPointer(SCROLLBAR_EMAIL_MESS , &object_type, (void**)&scroll_ptr);
	scroll_ptr->scrollbar_draw_pagesize = pagesize;
    if (draw_scrollbar)
        ScrollbarDrawScrollbar(SCROLLBAR_EMAIL_MESS );
	return TRUE;
}

/********************************************************
* Function:	EmailListDisplayDrawEmailMessageList
* Purpose: 	This function is called in order to draw
the list object				
* Scope:		application
* Input:		list_display	list-display structure
dbid			DatabaseID
* Output:		None
* Return:		TRUE    handled
FALSE   not-handled
* Comment: 	None
*********************************************************/
BOOLEAN EmailListDisplayDrawEmailMessageList(ListDisplay *list_display)
{
	ObjectID list_id, list_id1, list_id2, count_id;
	Bitmap *bitmap_ptr;
	USHORT list_total_num_items;
	USHORT list_max_num_items;
	USHORT total_num_items;
	USHORT top_item_num;
	USHORT count = 0, i = 0;
	RecordIDBlock *temp = list_display->record_id_block;
	RecordID rec_id;
	UWORD rec_num;
	UWORD byte_read;
	BYTE *buffer;
	BYTE *buffer3, *buffer4;
	SHORT num_items_to_display;
	USHORT count1 = 0;
	UBYTE cat;
	BYTE **names;
	BYTE **emails;
	USHORT num_items;
	BYTE object_type;
	List *list_ptr;
	CountrySettings country;
	ObjectBounds bounds = {3, 18, 4, 118};
	Attribute secret_flag;
    BOOLEAN one_digit_month = FALSE;
	
	list_id = list_display->list_id;
	if (list_id == LIST_EMAIL_MESS_NAME)
	{
		list_id1 = LIST_EMAIL_MESS_SUB;
		list_id2 = LIST_EMAIL_MESS_TIME;
	}
	for (count_id = BITMAP_EMAIL_MESS_0; count_id <= BITMAP_EMAIL_MESS_10; count_id++)
	{
		FormGetObjectPointer(count_id, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
	}
	
	if (EmailCompareTwoStrings(current_email_box, EMINBOX) == SAME)
	{
		for (count_id = BITMAP_EMAIL_MESS_0; count_id <= BITMAP_EMAIL_MESS_10; count_id++)
			BitmapEraseBitmap(count_id);
		FormGetObjectPointer(list_id, &object_type, (void**)&list_ptr);
		list_ptr->bounds.xcoord = 7;
		list_ptr->bounds.width = 56;
		FormGetObjectPointer(list_id1, &object_type, (void**)&list_ptr);
		list_ptr->bounds.xcoord = 62;
		list_ptr->bounds.width = 60;
		FormGetObjectPointer(list_id2, &object_type, (void**)&list_ptr);
		list_ptr->bounds.xcoord = 121;
		list_ptr->bounds.width = 26;
	}
	else
	{
		FormGetObjectPointer(list_id, &object_type, (void**)&list_ptr);
		list_ptr->bounds.xcoord = 3;
		list_ptr->bounds.width = 75;
		FormGetObjectPointer(list_id1, &object_type, (void**)&list_ptr);
		list_ptr->bounds.xcoord = 77;
		list_ptr->bounds.width = 71;
	}
	ListRecalculateMaxNumItemsDisplay(list_id);
	ListGetMaxNumItemsDisplay (list_id, &list_max_num_items);
	list_display->max_num_items_display = list_max_num_items;
	total_num_items = list_display->total_num_items;
	top_item_num = list_display->top_item_num;
	
	ListGetTotalItems(list_id, &list_total_num_items);
	if (list_total_num_items != 0)
	{
		ListDeleteAllItems(list_id);
		ListDeleteAllItems(list_id1);
		ListDeleteAllItems(list_id2);
	}
	if ((top_item_num + list_max_num_items) <= total_num_items)
		list_display->num_items_display = list_max_num_items;
	else list_display->num_items_display = total_num_items - top_item_num;
	
	num_items_to_display = list_display->num_items_display;
	while (temp != NULL && num_items_to_display > 0)
	{
		if ((top_item_num >= count) && (top_item_num < (count + 20)))
		{
			
			DataRecIDtoNum(temp->dbid[top_item_num - count], temp->record_id[top_item_num - count], &rec_num);
			DataOpenRecord(temp->dbid[top_item_num - count], rec_num, &rec_id, NULL);
            DataRecordInfo(temp->dbid[top_item_num - count], rec_id, NULL, &cat, NULL, NULL, NULL);
			if (cat == INBOX)
			{
				DataGetField(temp->dbid[top_item_num - count], rec_id, FROM, &buffer, &byte_read);
				EmailMessageGetNameEmail(buffer, (BYTE***)&names, (BYTE***)&emails,
					&num_items, FALSE);
				qfree(buffer);
			}
			else 
			{
				DataGetField(temp->dbid[top_item_num - count], rec_id, TO, &buffer, &byte_read);
				EmailMessageGetNameEmail(buffer, (BYTE***)&names, (BYTE***)&emails,
					&num_items, FALSE);
				qfree(buffer);
			}
			if (num_items == 0)
				ListInsertItem(list_id, count1, EMNONAME1);
			else	
			{
				if (strlen(names[0]) > 0)
					ListInsertItem(list_id, count1, names[0]);
				else ListInsertItem(list_id, count1, emails[0]);
				for (i = 0; i <num_items; i++)
				{
					qfree(names[i]);
					qfree(emails[i]);
				}
				qfree(names);
				qfree(emails);
			}
			if (EmailCompareTwoStrings(current_email_box, EMINBOX) == SAME)
			{
				DataRecordInfo(temp->dbid[top_item_num - count], rec_id, NULL, NULL, &secret_flag, NULL, NULL);
				if (secret_flag == ATTR_CLR)
				{
					FormGetObjectPointer((BITMAP_EMAIL_MESS_0 + count1), &object_type, (void**)&bitmap_ptr);
					bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				}
				DataGetField(temp->dbid[top_item_num - count], rec_id, DATE, &buffer, &byte_read);
                SySetupGetCountrySettings(&country);
				EmailPrepareCorrectDateFormat(buffer, &buffer4);
                if (buffer[4] == '0')
                    one_digit_month = TRUE;       
				qfree(buffer);
				buffer = buffer4;
				if (strlen(buffer) != 0)
				{
					buffer3 = buffer;
					switch(country.date_fmt)
					{
					case SYSETUP_YMD:
						buffer += 5;
						if (!one_digit_month)
							buffer[10] = 0;
						else buffer[9] = 0;                            
						break;
					case SYSETUP_DMY:
						if (!one_digit_month)
							buffer[5] = '\0';
						else buffer[4] = '\0';
						break;
					case SYSETUP_MDY:
						if (!one_digit_month)
							buffer[5] = '\0';
						else buffer[4] = '\0';
						break;
					default: break;
					}
					ListInsertItem(list_id2, count1, buffer3);
					qfree(buffer3);
				}
				else ListInsertItem(list_id2, count1, (BYTE*)(""));
			}
			DataGetField(temp->dbid[top_item_num - count], rec_id, 6, &buffer, &byte_read);
			if (strlen(buffer) != 0)
				ListInsertItem(list_id1, count1, buffer);
			else ListInsertItem(list_id1, count1, EMNOSUBJ);
			qfree(buffer);
			count1 ++;
			num_items_to_display --;
			top_item_num ++;
			DataCloseRecord(temp->dbid[top_item_num - count], rec_id);
		}
		else
		{
			count += 20;
			temp = temp->next;
		}
	}
	ListSetTopItemNum(list_id, 0);
	ListSetTopItemNum(list_id1, 0);
	ListSetNumItemsDisplay (list_id, list_display->num_items_display);
	ListSetNumItemsDisplay (list_id1, list_display->num_items_display);
	//ListSetTotalItems (list_id, list_display->num_items_display);
	if (EmailCompareTwoStrings(current_email_box, EMINBOX) == SAME)
	{
		ListSetTopItemNum(list_id2, 0);
		ListSetNumItemsDisplay (list_id2, list_display->num_items_display);
		//ListSetTotalItems (list_id2, list_display->num_items_display);
	}
	return TRUE;
}

/********************************************************
* Function:	EmailScrollbarSetEmailMessageList
* Purpose: 	This function is called to set the email message list
when the scrollbar is moved.
* Scope:		application
* Input:		Event		
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EmailScrollbarSetEmailMessageList(EvtType *Event)
{
	
	WORD max,min,value,pagesize;
	WORD scroll_total_lines;
	BYTE object_type;
	Scrollbar *scroll_ptr;
	List *list_ptr;
	ObjectID count_id;
	
	ScrollbarGetScrollbar(SCROLLBAR_EMAIL_MESS, &value, &max, &min, &pagesize, &scroll_total_lines);
	if ((Event->para2 - Event->para1) >= pagesize)
	{
		ScrollbarSetScrollbar(SCROLLBAR_EMAIL_MESS, (Event->para2 - 1), max, min, pagesize, scroll_total_lines);
		list_email_mess.top_item_num = (USHORT)(Event->para2) - 1;
	}
	else if ((Event->para1 - Event->para2) >= pagesize)
	{
		ScrollbarSetScrollbar(SCROLLBAR_EMAIL_MESS, (Event->para2 + 1), max, min, pagesize, scroll_total_lines);
		list_email_mess.top_item_num = (USHORT)(Event->para2) + 1;
	}
	else
	{	
		ScrollbarSetScrollbar(SCROLLBAR_EMAIL_MESS, Event->para2, max, min, pagesize, scroll_total_lines);
		list_email_mess.top_item_num = (USHORT)(Event->para2);
	}	
	
	FormGetObjectPointer(LIST_EMAIL_MESS_NAME, &object_type, (void**)&list_ptr);
	list_ptr->list_attr.list_visible = TRUE;
	FormGetObjectPointer(LIST_EMAIL_MESS_SUB, &object_type, (void**)&list_ptr);
	list_ptr->list_attr.list_visible = TRUE;
	EmailListDisplayDrawEmailMessageList(&list_email_mess);
	
	
	for (count_id = BITMAP_EMAIL_MESS_0; count_id <= BITMAP_EMAIL_MESS_10; count_id++)
		BitmapDrawBitmap(count_id);
	
	
    if (Event->eventType == EVT_SCROLLBAR_SELECT ||
        (Event->eventType == EVT_SCROLLBAR_REPEAT && (Event->para1 != Event->para2)))
    {
        ListDrawList(LIST_EMAIL_MESS_NAME);
        ListDrawList(LIST_EMAIL_MESS_SUB);
        ListDrawList(LIST_EMAIL_MESS_TIME);
    }
	
	FormGetObjectPointer(SCROLLBAR_EMAIL_MESS, &object_type, (void**)&scroll_ptr);
	scroll_ptr->scrollbar_draw_pagesize = pagesize;
    if (draw_scrollbar)
        ScrollbarDrawScrollbar(SCROLLBAR_EMAIL_MESS);
}

/********************************************************
* Function:	EmailEmailMessagePopupCateActions
* Purpose: 	This function is called in order to take actions when the 
popup trigger of categories of message box is changed
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE			success
FALSE			error occure
* Comment: 	None
*********************************************************/
BOOLEAN EmailEmailMessagePopupCateActions(SHORT selected_item)
{
	USHORT popup_total_num_items;
	SHORT i = 0;
	BYTE *item_text;
	ObjectID count_id;
	ObjectBounds bounds = {3, 18, 4, 118};
	
	
	ControlPopupGetTotalItems (POPUP_TRIGGER_EMAIL_BOX, &popup_total_num_items);
	
	if (popup_total_num_items == ((USHORT)(selected_item) + 1))
	{		
		ListInitList(LIST_NAME);
		ListInitList(LIST_EMAIL);
		ControlInitControl(POPUP_TRIGGER_CATE);
		ScrollbarInitScrollbar(SCROLLBAR_EMAIL_NAME_LIST);
		name_list_in_action = ADDRESS_LIST;
		if (current_cate != NULL)
			qfree(current_cate);
		current_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
		
		strcpy(current_cate,EMALL);
		char_start = 'A';
		EmailRecordToList(current_cate, char_start,NULL);
		EmailCateNameToPopupTrigger(email_dbid);
		ControlPopupSetSelectedItem(POPUP_TRIGGER_CATE, 0);
        EmailChangeFontSize(FORM_EMAIL_NAME_LIST, font_size);
		FormPopupForm(FORM_EMAIL_NAME_LIST);
		return TRUE;
	}
	else
	{	
		ControlPopupGetPopupItem(POPUP_TRIGGER_EMAIL_BOX, (USHORT)selected_item, &item_text);
		if (current_email_box != NULL)
			qfree(current_email_box);
		current_email_box = (BYTE*)qmalloc(30*sizeof(BYTE));
		strcpy(current_email_box, item_text);
		char_start_email_box = 'A';
		EmailRecordToEmailMessageList(item_text, 'A');
		ListDrawList(LIST_EMAIL_MESS_NAME);
		ListDrawList(LIST_EMAIL_MESS_SUB);
		ListDrawList(LIST_EMAIL_MESS_TIME);
		if (selected_item == 0)
			LcdEraseRegion(&bounds);
		for (count_id = BITMAP_EMAIL_MESS_0; count_id <= BITMAP_EMAIL_MESS_10; count_id++)
			BitmapDrawBitmap(count_id);
		return TRUE;
	}
	return FALSE;
}

/********************************************************
* Function:	EmailMessListSelectedItemAction
* Purpose: 	This fucntion is called when an item is selected from the
LIST_EMAIL_MESS_NAME or LIST_EMAIL_MESS_SUB object, then a sequence of actions
are taken
* Scope:		application
* Input:		list_display	The corresponding list display structure
* Output:		None
* Return:		TRUE			success
FALSE			error occure
* Comment: 	None
*********************************************************/
BOOLEAN EmailMessListSelectedItemAction(ListDisplay *list_display, EvtType *Event)
{ 
	SHORT item_num;
	UWORD byte_read;
	RecordID rec_id;
	DatabaseID temp_dbid;
	UWORD rec_num;
	BYTE *buffer;
	BYTE **names;
	BYTE **emails;
	USHORT num_items;
	UWORD count = 0;
	BYTE *output_date;
    ObjectBounds bounds={3, 18, 4, 118};
	
	if (Event->para1 == -1)
		return FALSE;
	edit_table_font_size = SMALL_FONT;
	mail_list_table_font_size = SMALL_FONT;
	ListDisplayGetRecordID(list_display, 
		(USHORT)(Event->para1 + list_display->top_item_num), 
		&(edit_entry_status.rec_id), &(temp_dbid));
	ControlPopupGetSelectedItem(POPUP_TRIGGER_EMAIL_BOX, &item_num);
	
    if (DataRecordInfo(temp_dbid, edit_entry_status.rec_id, NULL, NULL, NULL, NULL, NULL) != TRUE)
		return FALSE;
	
	item_num++;
	FormInitAllFormObjects(FORM_EDIT);
	
	DataRecIDtoNum(temp_dbid, edit_entry_status.rec_id, &rec_num);
	DataOpenRecord(temp_dbid, rec_num, &rec_id, NULL);
	
	if (temp_from)        qfree(temp_from);
	if (temp_to)          qfree(temp_to);
	if (temp_cc)          qfree(temp_cc);
	if (temp_bcc)         qfree(temp_bcc);
	
	DataGetField(temp_dbid, rec_id, TO, &temp_to, &byte_read);
	DataGetField(temp_dbid, rec_id, FROM, &temp_from, &byte_read);
	DataGetField(temp_dbid, rec_id, CC, &temp_cc, &byte_read);
	DataGetField(temp_dbid, rec_id, BCC, &temp_bcc, &byte_read);
	
    FieldSetMaxNumChars(FIELD_EDIT_0, 100);
    if (item_num == INBOX)
	{
        FieldSetMaxNumChars(FIELD_EDIT_1, 100);
        FieldSetMaxNumChars(FIELD_EDIT_2, 2048);
        FieldSetMaxNumChars(FIELD_EDIT_3, 100);
        FieldSetMaxNumChars(FIELD_EDIT_4, 32768);
	}
	else
	{
        FieldSetMaxNumChars(FIELD_EDIT_1, 2048);
        FieldSetMaxNumChars(FIELD_EDIT_2, 32768);
	}
	
	
	if (item_num == INBOX)
	{
        LcdEraseRegion(&bounds);
		DataSetRecordAttribute(temp_dbid, rec_id, ATTR_SET, ATTR_UNCHG, 0xFF);
		SetEditEntryStatus(VIEW, edit_entry_status.rec_id, INBOX, FALSE);
		
		/* put TO data */
        EmailMessageGetNameEmail(temp_to, &names, &emails, &num_items, FALSE);
		if (num_items == 0)
			FieldSetText(FIELD_EDIT_0, (BYTE*)(""));
		else if (strlen(names[0]) == 0)
			FieldSetText(FIELD_EDIT_0, emails[0]);
		else FieldSetText(FIELD_EDIT_0, names[0]);
		if (num_items > 0)
		{
			qfree(emails[0]); qfree(names[0]); qfree(names); qfree(emails);
		}
		
		/* put FROM data */
        EmailMessageGetNameEmail(temp_from, &names, &emails, &num_items, FALSE);
		if (num_items == 0)
			FieldSetText(FIELD_EDIT_1, (BYTE*)(""));
		else if (strlen(names[0]) == 0)
			FieldSetText(FIELD_EDIT_1, emails[0]);
		else FieldSetText(FIELD_EDIT_1, names[0]);
		if (num_items > 0)
		{
			qfree(emails[0]); qfree(names[0]); qfree(names); qfree(emails);
		}
		DataGetField(temp_dbid, rec_id, 6, &buffer, &byte_read);
		FieldSetText(FIELD_EDIT_2, buffer);
		qfree(buffer);
		DataGetField(temp_dbid, rec_id, 0, &buffer, &byte_read);
		EmailPrepareCorrectDateFormat(buffer, &output_date);
		qfree(buffer);
		FieldSetText(FIELD_EDIT_3, output_date);
		qfree(output_date);
		DataGetField(temp_dbid, rec_id, 7, &buffer, &byte_read);
		FieldSetText(FIELD_EDIT_4, buffer);
		qfree(buffer);
	}	
	else
	{
		if (item_num == DRAFT) SetEditEntryStatus(VIEW, edit_entry_status.rec_id, DRAFT, FALSE);
		if (item_num == SENT || item_num == OUTBOX)
			SetEditEntryStatus(VIEW, edit_entry_status.rec_id, (BYTE)(item_num), FALSE);
		FormInitAllFormObjects(FORM_MAIL_LIST);
		
		/* put TO data */
		DataGetField(temp_dbid, rec_id, TO, &buffer, &byte_read);
		FieldSetText(FIELD_MAIL_LIST_TO, buffer);
		while (buffer[count] != '\r' && buffer[count] != '\0')
			count++;
		buffer[count] = '\0';
		FieldSetText(FIELD_EDIT_0, buffer);
        qfree(buffer);
        FieldSetText(FIELD_MAIL_LIST_CC, temp_cc);
        FieldSetText(FIELD_MAIL_LIST_BCC, temp_bcc);
		DataGetField(temp_dbid, rec_id, 6, &buffer, &byte_read);
		FieldSetText(FIELD_EDIT_1, buffer);
		qfree(buffer);
		DataGetField(temp_dbid, rec_id, 7, &buffer, &byte_read);
		FieldSetText(FIELD_EDIT_2, buffer);
		qfree(buffer);
		/*        if (item_num == DRAFT)
        {
		FieldSetInsertPointOn(FIELD_EDIT_1);
		FieldSetInsertPointPositionByCharPos(FIELD_EDIT_1, 0);
		FormSetFormActiveObject(FORM_EDIT, FIELD_EDIT_1);
        }    
		*/        
	}
	DataCloseRecord(temp_dbid, rec_id);
	return TRUE;
}

/*****************************************************************************
* Function:	EmailPrepareCorrectDateFormat
* Purpose: 	This function is called in order to prepare
the correct data format for display
* Scope:		application
* Input:		input_date
* Output:		output_date
* Return:		TRUE			success
FALSE			error occure
* Comment: 	The input date is in the format that is stored in the database
*****************************************************************************/
void EmailPrepareCorrectDateFormat(BYTE *input_date, BYTE **output_date)
{
	CountrySettings country;
	BYTE year[10];
	BYTE day[10];
	BYTE hour[20];
	BYTE minute[20];
	BYTE second[20];
	BYTE month[10];
	WORD i;
	BYTE *temp;
	WORD hours;
	BYTE am_pm;
	
	SySetupGetCountrySettings(&country);
	*output_date = (BYTE*)qmalloc(100*sizeof(BYTE));
	temp = *output_date;
	
	for (i = 0; i < 4; i++)
		year[i] = input_date[i];
	year[4] = '\0';
    if (input_date[4] == '0')
    {
        month[0] = input_date[5];
        month[1] = '\0';
    }
    else
    {
        month[0] = input_date[4];
        month[1] = input_date[5];
        month[2] = '\0';
    }
	day[0] = input_date[6];
	day[1] = input_date[7];
	day[2] = '\0';
	hour[0] = input_date[8];
	hour[1] = input_date[9];
	hour[2] = '\0';
	minute[0] = input_date[10];
	minute[1] = input_date[11];
	minute[2] = '\0';
	second[0] = input_date[12];
	second[1] = input_date[13];
	second[2] = '\0';
	
	switch(country.date_fmt)
	{
	case SYSETUP_YMD:
		strcpy(temp, year);
		temp += 4;
		*temp = '/';
		temp ++;
		strcpy(temp, month);
		temp += strlen(month);
		*temp = '/';
		temp ++;
		strcpy(temp, day);
		temp += 2;
		*temp = 32;
		temp ++;
		break;
	case SYSETUP_DMY:
		strcpy(temp, day);
		temp += 2;
		*temp = '/';
		temp ++;
		strcpy(temp, month);
		temp += strlen(month);
		*temp = '/';
		temp ++;
		strcpy(temp, year);
		temp += 4;
		*temp = 32;
		temp ++;
		break;
	case SYSETUP_MDY:
		strcpy(temp, month);
		temp += strlen(month);
		*temp = '/';
		temp ++;
		strcpy(temp, day);
		temp += 2;
		*temp = '/';
		temp ++;
		strcpy(temp, year);
		temp += 4;
		*temp = 32;
		temp ++;
		break;
	default: break;
	}
	
	switch(country.time_fmt)
	{
	case SYSETUP_12HR_DISPLAY:
		hours = atol((char*)hour);
		if (hours >= 12)
		{
			hours -= 12;
			am_pm = 1;
		}
		else am_pm = 0;
		ltoa(hours, (char*)hour, 10 );
		strcpy(temp, hour);
		temp += strlen(hour);
		*temp = ':';
		temp ++;
		strcpy(temp, minute);
		temp += 2;
		*temp = ':';
		temp ++;
		strcpy(temp, second);
		temp += 2;
		*temp = 32;
		temp ++;
		if (am_pm == 0)
			strcpy(temp,EMAM);
		else strcpy(temp,EMPM);
		break;
	case SYSETUP_24HR_DISPLAY:
		strcpy(temp, hour);
		temp += 2;
		*temp = ':';
		temp ++;
		strcpy(temp, minute);
		temp += 2;
		*temp = ':';
		temp ++;
		strcpy(temp, second);
		break;
	default: break;
	}
 }
 
 
