/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   findin.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"
#include "appfunc.h"

/********************************************************
* Function:	EmailSearchForText
* Purpose: 	This function is called to search a string from a long text.
* Scope:		application
* Input:		short_string		a short text for searching
whole_string		the string to be searched			
* Output:		None
* Return:		TRUE			if the short_string can be found in the whole_string
FALSE			if the shrot_string does not exists
* Comment: 	
*********************************************************/
BOOLEAN EmailSearchForText(BYTE *short_string, BYTE *whole_string)
{
	UWORD length_short;
	UWORD length_whole;
	BYTE  *buffer, *buffer1, *buffer2;
	UWORD count, letter_count;
	BOOLEAN match = TRUE;
	
	
	length_short = strlen(short_string);
	length_whole = strlen(whole_string);
	buffer2 = whole_string;
	
	for (count = 0; count <= length_whole; count++)
	{
		match = TRUE;
		buffer1 = buffer2;
		buffer = short_string;
		if (strlen(buffer1) < length_short)
			return FALSE;
		
		if (*buffer == *buffer1)
		{	
			buffer++;
			buffer1++;
			buffer2 = buffer1;
			for (letter_count = 0; letter_count<(length_short - 1); letter_count++)
			{
				if (*buffer != *buffer1)
				{	
					match = FALSE;
					break;
				}
				buffer++;
				buffer1++;
			}
		}
		else
		{
			match = FALSE;
			buffer2++;
		}
		if (match == TRUE)
			return TRUE;
	}
	return FALSE;
}


/********************************************************
* Function:	InputFindCharInCheck
* Purpose:		to check the input catergory
* Scope:		internal
* Input:       Event 		received event
* Output:		None
* Return:		TRUE handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN InputFindCharInCheck()
{
	WORD textbox_num_chars;
	BYTE *textbox_string;
	BYTE *string, *string1;
	UWORD i,j;
	BOOLEAN update = FALSE;
	UWORD pb_total_num_rec, email_total_num_rec;
	RecordID pb_rec_id, email_rec_id;
	UWORD byte_read;
	USHORT max_num_items = 0;
	BYTE *temp;
	BYTE object_type;
	Scrollbar *scroll_ptr;
	UWORD *pb_rec_num, *email_rec_num;
	UWORD pb_num_rec, email_num_rec;
	UWORD pb_index = 0, email_index = 0;
	BOOLEAN found1 = FALSE, found2 = FALSE;
    BYTE    *first_name1, *first_name2, *last_name1, *last_name2, out_string1[200], out_string2[200];
	
	TextboxGetNumOfChars(TEXTBOX_FIND_INPUT,&textbox_num_chars);
	TextboxGetTextPointer(TEXTBOX_FIND_INPUT,&textbox_string);
    strcpy(find_string, textbox_string);
	
	
	FormInitAllFormObjects(FORM_FIND_RESULT);
	ListDeleteAllItems(LIST_FIND_RESULT_NAME);
	ListDeleteAllItems(LIST_FIND_RESULT_EMAIL);
	ListDisplayDeleteAllRecordID(&list_find);
	temp = (BYTE*)qmalloc((strlen(textbox_string)+1)*sizeof(BYTE));
	strcpy(temp,textbox_string);
	for (i = 0; i < strlen(textbox_string);i++)
	{
		if (temp[i] >= 'a' && temp[i] <= 122)
			temp[i] -= 32;
	}
	if (textbox_num_chars == 0)
	{
		FormEraseForm(FORM_FIND_INPUT);
		FormPopupForm(FORM_NOT_FOUND);
		return TRUE;
	}
	DataTotalRecord(email_dbid, &email_total_num_rec);
	DataTotalRecord(pb_dbid, &pb_total_num_rec);
	pb_rec_num = (UWORD*)qmalloc(pb_total_num_rec*sizeof(UWORD));
	email_rec_num = (UWORD*)qmalloc(email_total_num_rec*sizeof(UWORD));
	EmailGetRecNumWithCateName(pb_dbid, EMALL, pb_rec_num, &pb_num_rec);
	EmailGetRecNumWithCateName(email_dbid, EMALL, email_rec_num, &email_num_rec);
	while (pb_index < pb_num_rec || email_index < email_num_rec)
	{
		if (pb_index < pb_num_rec && email_index < email_num_rec)
		{
			DataOpenRecord(pb_dbid, pb_rec_num[pb_index], &pb_rec_id, NULL);
			DataOpenRecord(email_dbid, email_rec_num[email_index], &email_rec_id, NULL);
			DataGetField(pb_dbid, pb_rec_id, 0, &first_name1, &byte_read);
			DataGetField(pb_dbid, pb_rec_id, 1, &last_name1, &byte_read);
            PhonebookPrepareFirstLastName(first_name1, last_name1, out_string1);
			qfree(first_name1);
			qfree(last_name1);
			
			DataGetField(email_dbid, email_rec_id, 0, &first_name2, &byte_read);
			DataGetField(email_dbid, email_rec_id, 1, &last_name2, &byte_read);
            PhonebookPrepareFirstLastName(first_name2, last_name2, out_string2);
			qfree(first_name2);
			qfree(last_name2);
			
			for (j = 0; j < strlen(out_string1);j++)
			{
				if (out_string1[j] >= 'a' && out_string1[j] <= 122)
					out_string1[j] -= 32;
			}
			for (j = 0; j < strlen(out_string2);j++)
			{
				if (out_string2[j] >= 'a' && out_string2[j] <= 122)
					out_string2[j] -= 32;
			}
			
			if (found1 == FALSE)
			{
                if (EmailSearchForText(temp, out_string1) == TRUE)
					found1 = TRUE;
                else if (EmailSearchForText(temp, out_string1) == FALSE)
					pb_index++;
			}
			
			if (found2 == FALSE)
			{
                if (EmailSearchForText(temp, out_string2) == TRUE)
					found2 = TRUE;
                else if (EmailSearchForText(temp, out_string2) == FALSE)
					email_index++;
			}
			
			
			if (found1 == TRUE && found2 == TRUE)
			{
				DataGetField(pb_dbid, pb_rec_id, 0, &first_name1, &byte_read);
				DataGetField(pb_dbid, pb_rec_id, 1, &last_name1, &byte_read);
                PhonebookPrepareLastFirstName(first_name1, last_name1, out_string1);
				qfree(first_name1);
				qfree(last_name1);
				
				DataGetField(email_dbid, email_rec_id, 0, &first_name2, &byte_read);
				DataGetField(email_dbid, email_rec_id, 1, &last_name2, &byte_read);
                PhonebookPrepareLastFirstName(first_name2, last_name2, out_string2);
				qfree(first_name2);
				qfree(last_name2);
				
				update = TRUE;
				if (EmailCompareTwoStrings(out_string1, out_string2) == FIRST)
				{
					ListDisplayInsertRecordID(&list_find, pb_rec_id, pb_dbid);
					found1 = FALSE;
					pb_index ++;
				}
				else if (EmailCompareTwoStrings(out_string1, out_string2) == SECOND)
				{	
					ListDisplayInsertRecordID(&list_find, email_rec_id, email_dbid);
					found1 = FALSE;
					email_index++;
				}
				else
				{
					ListDisplayInsertRecordID(&list_find, pb_rec_id, pb_dbid);
					found1 = FALSE;
					pb_index ++;
					ListDisplayInsertRecordID(&list_find, email_rec_id, email_dbid);
					found1 = FALSE;
					email_index++;
				}
			}
			DataCloseRecord(pb_dbid, pb_rec_id);
			DataCloseRecord(email_dbid, email_rec_id);
		}
		else 
		{
			if (pb_index >= pb_num_rec)
			{
				for (i = email_index; i < email_num_rec; i++)
				{
                    DataOpenRecord(email_dbid, email_rec_num[i], &email_rec_id, NULL);
					DataGetField(email_dbid, email_rec_id, 0, &first_name2, &byte_read);
					DataGetField(email_dbid, email_rec_id, 1, &last_name2, &byte_read);
					PhonebookPrepareFirstLastName(first_name2, last_name2, out_string2);
					qfree(first_name2);
					qfree(last_name2);
					
					for (j = 0; j < strlen(out_string2);j++)
					{
						if (out_string2[j] >= 'a' && out_string2[j] <= 122)
							out_string2[j] -= 32;
					}
					if (EmailSearchForText(temp, out_string2) == TRUE)
					{
						ListDisplayInsertRecordID(&list_find, email_rec_id, email_dbid);
						update = TRUE;
					}
					DataCloseRecord(email_dbid, email_rec_id);
					email_index ++;
				}
			}
			else if (email_index >= email_num_rec)
			{
				for (i = pb_index; i < pb_num_rec; i++)
				{
                    DataOpenRecord(pb_dbid, pb_rec_num[i], &pb_rec_id, NULL);
					DataGetField(pb_dbid, pb_rec_id, 0, &first_name1, &byte_read);
					DataGetField(pb_dbid, pb_rec_id, 1, &last_name1, &byte_read);
					PhonebookPrepareFirstLastName(first_name1, last_name1, out_string1);
					qfree(first_name1);
					qfree(last_name1);
					
					for (j = 0; j < strlen(out_string1);j++)
					{
						if (out_string1[j] >= 'a' && out_string1[j] <= 122)
							out_string1[j] -= 32;
					}
					
					if (EmailSearchForText(temp, out_string1) == TRUE)
					{
						ListDisplayInsertRecordID(&list_find, pb_rec_id, pb_dbid);
						update = TRUE;
					}
					DataCloseRecord(pb_dbid, pb_rec_id);
					pb_index ++;
				}
			}
		}
    }              
	
	if (update == TRUE)
	{
		
		ListRecalculateMaxNumItemsDisplay(LIST_FIND_RESULT_NAME);
		ListGetMaxNumItemsDisplay(LIST_FIND_RESULT_NAME, &max_num_items);
		FormGetObjectPointer(SCROLLBAR_FIND_RESULT, &object_type, (void**)&scroll_ptr);
		scroll_ptr->scrollbar_draw_pagesize = max_num_items;
		if (list_find.total_num_items > max_num_items)
		{
			ScrollbarSetScrollbarVisible(SCROLLBAR_FIND_RESULT, TRUE);
			ScrollbarSetScrollbar(SCROLLBAR_FIND_RESULT, 0, (list_find.total_num_items - max_num_items),
				0, max_num_items, list_find.total_num_items);
		}
		string = (BYTE*)qmalloc((textbox_num_chars + 14 + 1)*sizeof(BYTE));		
		string1 = string;
		strcpy(string, EMSTR18);
		string +=13;
		strcpy(string, (BYTE*)(textbox_string));
		string += textbox_num_chars;
		strcpy(string,(BYTE*)("\"\0"));
		StringSetText(STRING_FIND_RESULT,string1);
		qfree(string1);
		list_find.top_item_num = 0;
		EmailListDisplayDrawAddressList(&list_find);
		if (KeyboardCheckKeyboardStatus() == TRUE)
		{
			KeyboardRestoreBitBehind();
			KeyboardSetKeyboardStatus(FALSE);
		}
		FormEraseForm(FORM_FIND_INPUT);
        EmailChangeFontSize(FORM_FIND_RESULT, font_size);
		FormPopupForm(FORM_FIND_RESULT);
		qfree(temp);
		
		return TRUE;
	}
	else
	{
		
        if (KeyboardCheckKeyboardStatus() == TRUE)
		{
			KeyboardRestoreBitBehind();
			KeyboardSetKeyboardStatus(FALSE);
		}
		FormEraseForm(FORM_FIND_INPUT);
		FormPopupForm(FORM_NOT_FOUND);
		
		qfree(temp);
		return TRUE;
	}
	
	return TRUE;
}

/********************************************************
* Function:	EmailScrollbarSetFindResult
* Purpose:		This funtion is called in order to change the list objects in 
FIND RESULT screen of the application when the scrollbar is moved
* Scope:		internal
* Input:       Event 		received event
* Output:		None
* Return:		TRUE handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN EmailScrollbarSetFindResult(EvtType *Event)
{
	USHORT num_items_display;
	USHORT total_num_items;
	BYTE object_type;
	Scrollbar *scroll_ptr;
	
	FormGetObjectPointer(SCROLLBAR_FIND_RESULT, &object_type, (void**)&scroll_ptr);
	num_items_display = list_find.num_items_display;
	scroll_ptr->scrollbar_draw_pagesize = num_items_display;
	total_num_items = list_find.total_num_items;
	if ((Event->para2 - Event->para1) >= (WORD)num_items_display)
	{
		ScrollbarSetScrollbar(SCROLLBAR_FIND_RESULT, (WORD)(Event->para2) - 1,
			(WORD)(total_num_items - num_items_display), 0,
			(WORD)(num_items_display),(WORD)(total_num_items));
		ListDisplaySetTopItemNum(&list_find, (USHORT)(Event->para2) - 1);
	}
	else if ((Event->para1 - Event->para2) >= (WORD)num_items_display)
	{
		ScrollbarSetScrollbar(SCROLLBAR_FIND_RESULT, (WORD)(Event->para2) + 1,
			(WORD)(total_num_items - num_items_display), 0,
			(WORD)(num_items_display),(WORD)(total_num_items));
		ListDisplaySetTopItemNum(&list_find, (USHORT)(Event->para2) + 1);
	}
	else
	{	
		ScrollbarSetScrollbar(SCROLLBAR_FIND_RESULT, (WORD)(Event->para2),
			(WORD)(total_num_items - num_items_display), 0,
			(WORD)(num_items_display),(WORD)(total_num_items));
		ListDisplaySetTopItemNum(&list_find, (USHORT)(Event->para2));
	}	
	ScrollbarDrawScrollbar(SCROLLBAR_FIND_RESULT);
	EmailListDisplayDrawAddressList(&list_find);
	
	
    if (Event->eventType == EVT_SCROLLBAR_SELECT ||
        (Event->eventType == EVT_SCROLLBAR_REPEAT))
    {    
        ListDrawList(LIST_FIND_RESULT_NAME);
        ListDrawList(LIST_FIND_RESULT_EMAIL);
    }
	return TRUE;
}

