/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   app.h
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef __APP_H_
#define __APP_H_

#include "system.h"
#include "appfunc.h"
#include "listdis.h"
#include "SySetup.h"
#include "emlang.h"
#include "emsize.h"

#define     MemoryLow     MemoryCheckMemLow()
#define     MemoryNormal  !MemoryCheckMemLow()

//===============================TCPIP DataStructure ====================
typedef struct _TCPIP_LAUNCH_STRUCT
{
	BOOLEAN		dial_out;
	BYTE		*dial_num;
	BYTE		*dial_out_code;
	UWORD		email_account_no;
}TCPIPLaunchStruct;


/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
extern AppID        app_id;
extern BYTE         app_status;
extern DatabaseID   pb_dbid;
extern DatabaseID   email_dbid;
extern DatabaseID   emess_dbid;

extern BYTE         *current_cate;
extern BYTE         char_start;

extern BYTE         *current_email_box;
extern BYTE         char_start_email_box;

extern BYTE         *save_cate;
extern BYTE         save_first_letter;

extern BYTE         *temp_cate;

extern ListDisplay  list_email_name;
extern ListDisplay  list_email_mess;
extern ListDisplay  list_find;

extern ObjectID     pressed_object;
extern BYTE         name_list_in_action;
extern BYTE         edit_cate_in_action;
extern BYTE         new_name_in_action;
extern BYTE         dial_in_action;
extern RecordID     del_rec_id;


extern BOOLEAN      rf_action;			/* reply forward action */
extern BYTE         *own_email;

extern BYTE         edit_table_font_size;
extern BYTE         mail_list_table_font_size;

extern BYTE         addr_edit_dirty;
extern BYTE         emess_edit_dirty;

extern BYTE         *temp_from;
extern BYTE         *temp_to;
extern BYTE         *temp_cc;
extern BYTE         *temp_bcc;

extern BYTE         find_string[];
extern BYTE         font_size;
extern BOOLEAN      draw_scrollbar;
extern BOOLEAN      gf_entry;
extern ObjectID     gf_in_form_id, gf_in_pressed_object;

/*==================== Menu Item ===========================*/
#define MENU_ITEM_COPY			0
#define MENU_ITEM_CUT			1
#define MENU_ITEM_PASTE			2
#define MENU_ITEM_UNDO			3
#define MENU_ITEM_ZOOM			4
#define MENU_ITEM_FONT			0


/****************************************************************
**************** Email Application Save and Restore *************
*****************************************************************/
#define EMAIL_STATUS		0x80001002
#define EMAIL_EMAIL_MESS	0x80001003
#define EMAIL_MESS_TO		0x80001004
#define EMAIL_MESS_EDIT		0x80001005
#define EMAIL_EMAIL_NAME	0x80001006
#define EMAIL_NAME_EDIT     0x80001007
#define EMAIL_DIAL			0x80001008

//======================= Phonebook Database ========================
#define PB_STATUS		0x80001000
#define PB_EDIT_INFO	0x80001001
#define PB_ADDR_LIST	0x80001002

/*==================== Application status ===================*/
#define RESTART                 0
#define EMAIL_MESS_LISTING	1
#define EDIT_EMAIL_MESS		2
#define EDIT_EMAIL_TO		3
#define EMAIL_NAME_LISTING	4
#define EDIT_EMAIL_NAME     5
#define EMAIL_DIAL_KEYIN	6

/*===================== EMAIL_STATUS =========================*/
//Field 0  ------------------ Email Status
//Field 1  ------------------ addr_edit_dirty
//Field	2  ------------------ emess_edit_dirty
//Field 3  ------------------ find_string

/*==================== EMAIL_MESS_LIST ======================*/
//Field 0 -------------------- current_email_box

/*==================== EDIT_EMAIL_MESS ======================*/
//Field 0 -------------------- FIELD_EDIT_0
//Field 1 -------------------- FIELD_EDIT_1
//Field 2 -------------------- FIELD_EDIT_2
//Field 3 -------------------- FIELD_EDIT_3
//Field 4 -------------------- FIELD_EDIT_4
//Field 5 -------------------- edit_entry_status
//Field 6 -------------------- temp_from
//Field 7 -------------------- temp_to
//Field 8 -------------------- temp_cc
//Field 9 -------------------- temp_bcc

/*==================== EDIT_EMAIL_TO ========================*/
//Field 0 -------------------- FIELD_MAIL_LIST_TO
//Field 1 -------------------- FIELD_MAIL_LIST_CC
//Field 2 -------------------- FIELD_MAIL_LIST_BCC
//Field 3 -------------------- mail_list_entry_status

/*==================== EDIT_NAME_LIST ========================*/
//Field 0 -------------------- current_cate
//Field 1 -------------------- char_start
//Field 2 -------------------- name_list_in_action
//Field 3 -------------------- temp_cate

/*==================== EDIT_EMAIL_NAME ========================*/
//Field 0 -------------------- TEXTBOX_LAST_NAME
//Field 1 -------------------- TEXTBOX_FIRST_NAME
//Field 2 -------------------- FIELD_C_EMAIL
//Field 3 -------------------- FIELD_H_EMAIL
//Field 4 -------------------- CHECKBOX_C
//Field 5 -------------------- CHECKBOX_H
//Field 6 -------------------- ve_email_name_status

/*==================== EMAIL_DIAL ========================*/
//Field 0 -------------------- TEXTBOX_DIAL
//Field 1 -------------------- TEXTBOX_DIAL_OUT
//Field 2 -------------------- CHECKBOX_DIAL_OUT
//Field 3 -------------------- dial_in_action;


/*****************************************************************
*********************** Global Defines ***************************
*****************************************************************/
//#define EL32(x)     ((x <<24) | ((x &0xff00) <<8) | ((x &0xff0000) >>8) | (x>>24))
#define TIME_INDEX_RECID	0x80001001

/* app_status */
#define EMAIL_NAME_LIST		0
#define EDIT_CATE			1
#define FIND				2
#define VE_EMAIL_NAME		3
#define EMAIL_MESS_LIST		4

/*Email Box*/
#define INBOX			1
#define OUTBOX			2
#define SENT			3
#define DRAFT			4

/*reply and forward defines*/
#define REPLY			1
#define FORWARD			2
#define REPLY_TO_ALL	3
#define REPLY_TO_SENDER	4


/* field */
#define DATE			0
#define TIME_INDEX		1
#define FROM			2
#define TO				3
#define CC				4
#define BCC				5
#define SUBJECT			6
#define BODY			7

/* name_list_in_action */
#define ADDRESS_LIST	1
#define MAIL_LIST		2

/* edit_cate_in_action */
#define FROM_POPUP		1
#define FROM_EDIT		2

/* new_name_in_action */
#define ADDRESS_LIST	1
#define MAIL_LIST		2

/* dial_in_action */
#define FROM_EMESS_LIST	1
#define FROM_EDIT		2


/* Compare two Strings*/
#define FIRST				0
#define SECOND				1
#define SAME				2


/*==================== MAIL_LIST_INSERT_PT =====================*/
typedef struct _MAIL_LIST_INSERT_PT
{
	BOOLEAN insert_pt_on;
	ObjectID field_id;
	WORD insert_pt_char_pos;
}MailListInsertPt;

extern MailListInsertPt mail_list_insert_pt;

#define SetMailListInsertPt(p1, p2, p3) { mail_list_insert_pt.insert_pt_on = p1;\
									      mail_list_insert_pt.field_id = p2;\
										  mail_list_insert_pt.insert_pt_char_pos = p3;}

/*==================== DIAL_INSERT_PT =====================*/
typedef struct _DIAL_INSERT_PT
{
	BOOLEAN insert_pt_on;
	ObjectID textbox_id;
	WORD insert_pt_char_pos;
}DialInsertPt;

extern DialInsertPt dial_insert_pt;

#define SetDialInsertPt(p1, p2, p3) {dial_insert_pt.insert_pt_on = p1;\
								     dial_insert_pt.textbox_id = p2;\
									 dial_insert_pt.insert_pt_char_pos = p3;}


/*==================== VE_EMAIL_NAME ===========================*/
typedef struct _VE_EMAIL_NAME_STATUS
{
	BYTE status;
	BOOLEAN company;	/*whether the company section is opened*/
	BOOLEAN home;		/*whether the home section is opened */
	RecordID rec_id;	/*the rec_id if the data is passed from
						  database to field objects */
	DatabaseID dbid;	/*the database id of the record if that data is passed from 
						  database to field object */
	BOOLEAN new_record;
}VEEmailNameStatus;

extern VEEmailNameStatus ve_email_name_status;

#define VIEW		0
#define EDIT		1
#define SetVEEmailNameStatus(p1, p2, p3, p4, p5 , p6) { ve_email_name_status.status = p1;\
												        ve_email_name_status.company = p2;\
											            ve_email_name_status.home = p3; \
											            ve_email_name_status.rec_id = p4; \
											            ve_email_name_status.dbid = p5; \
													    ve_email_name_status.new_record = p6;}	

/*==================== Email_Mess_Top ===========================*/
typedef struct _Email_Mess_Top
{
	RecordID rec_id;
	BOOLEAN preset;
}EmailMessTop;

extern EmailMessTop email_mess_top;

#define SetEmailMessTop(p1, p2) { email_mess_top.rec_id = p1;\
								  email_mess_top.preset = p2; }

/*==================== Del Entry Status ===========================*/
typedef struct _Del_Entry_Status
{
	ObjectID prev_form;
	RecordID rec_id;
}DelEntryStatus;

extern DelEntryStatus del_entry_status;

#define SetDelEntryStatus(p1, p2) {del_entry_status.prev_form = p1; \
								   del_entry_status.rec_id = p2;}



/*==================== Edit Entry Status ===========================*/
typedef struct _Edit_Entry_Status
{
	BYTE status;		/*VIEW or EDIT*/
	RecordID rec_id;
	UBYTE email_box;
	BOOLEAN new_record;
}EditEntryStatus;

extern EditEntryStatus edit_entry_status;

#define SetEditEntryStatus(p1, p2, p3, p4) {edit_entry_status.status = p1;\
											edit_entry_status.rec_id = p2;\
											edit_entry_status.email_box = p3;\
											edit_entry_status.new_record = p4;}

/*==================== Mail List Entry Status ===========================*/
typedef struct _Mail_List_Entry_Status
{
	BYTE        status;
	ObjectID    prev_form;
	RecordID    rec_id;
	BOOLEAN     new_record;
}MailListEntryStatus;

extern MailListEntryStatus mail_list_entry_status;

#define SetMailListEntryStatus(p0,p1, p2, p3) {mail_list_entry_status.status    = p0;\
                                               mail_list_entry_status.prev_form = p1;\
											   mail_list_entry_status.rec_id = p2;\
											   mail_list_entry_status.new_record = p3; }

/*****************************************************************
********************** OBJECT ID Defines **************************
*****************************************************************/
//==================== FORM_EMAIL_NAME_LIST ===================================
#define FORM_EMAIL_NAME_LIST            0
#define POPUP_TRIGGER_CATE              1
#define PUSHBUTTON_ABC                  2
#define PUSHBUTTON_DEF                  3
#define PUSHBUTTON_GHI                  4
#define PUSHBUTTON_JKL                  5
#define PUSHBUTTON_MNO                  6
#define PUSHBUTTON_PQR                  7
#define PUSHBUTTON_STU                  8
#define PUSHBUTTON_VWX                  9
#define PUSHBUTTON_YZ                   10
#define LIST_NAME                       11
#define LIST_EMAIL		                12
#define SCROLLBAR_EMAIL_NAME_LIST       13
#define BUTTON_NEW_EMAIL_NAME_RECORD    14
#define BUTTON_EMAIL_NAME_LIST_FIND		15
#define BUTTON_EMAIL_NAME_LIST_ZOOMIN   217

//==================== FORM_EDIT_CATE ===================================
#define FORM_EDIT_CATE                  16
#define LIST_CATE                       17
#define SCROLLBAR_CATE                  18
#define BUTTON_CATE_NEW                 19
#define BUTTON_CATE_DEL                 20
#define BUTTON_CATE_RENAME              21
#define STRING_EDIT_CATE				22
#define BUTTON_CATE_ZOOMIN              218

//==================== FORM_INPUT_CATE ===================================
#define FORM_INPUT_CATE                 23
#define BITMAP_INPUT_CATE_X             24
#define STRING_INPUT_CATE               25
#define TEXTBOX_INPUT_CATE              26

//==================== FORM_NO_CATE ======================================
#define FORM_NO_CATE                    27
#define BITMAP_NO_CATE_X                28
#define STRING_NO_CATE                  29

//==================== FORM_CATE_NAME_EXISTS =============================
#define FORM_CATE_NAME_EXISTS           30
#define BITMAP_CATE_NAME_EXISTS_X       31
#define STRING_CATE_NAME_EXISTS_0       32
#define STRING_CATE_NAME_EXISTS_1       33
#define STRING_CATE_NAME_EXISTS_2       34

//==================== FORM_ERASE_CATE =============================
#define FORM_ERASE_CATE                 35
#define STRING_ERASE_CATE               36
#define BUTTON_ERASE_CATE_YES           37
#define BUTTON_ERASE_CATE_NO            38

//==================== FORM_REMOVE_CATE =============================
#define FORM_REMOVE_CATE                39
#define STRING_REMOVE_CATE_0            40
#define STRING_REMOVE_CATE_1            41
#define STRING_REMOVE_CATE_2            42
#define STRING_REMOVE_CATE_3            43
#define BUTTON_REMOVE_CATE_YES          44
#define BUTTON_REMOVE_CATE_NO           45

//==================== FORM_CATE_FULL =============================
#define FORM_CATE_FULL           46
#define BITMAP_CATE_FULL_X       47
#define STRING_CATE_FULL_0       48
#define STRING_CATE_FULL_1       49
#define STRING_CATE_FULL_2       50

//==================== FORM_FIND_BACKGROUND =============================
#define FORM_FIND_BACKGROUND	 51
#define STRING_FIND_IND			 52

//==================== FORM_FIND_INPUT =============================
#define FORM_FIND_INPUT				53
#define BITMAP_FIND_INPUT_X			54
#define TEXTBOX_FIND_INPUT			55

//==================== FORM_NOT_FOUND =============================
#define FORM_NOT_FOUND				56
#define BITMAP_NOT_FOUND_X			57
#define STRING_NOT_FOUND			58

//==================== FORM_FIND_RESULT =============================
#define FORM_FIND_RESULT			59
#define BITMAP_FIND_RESULT			60
#define STRING_FIND_RESULT			61
#define LIST_FIND_RESULT_NAME		62
#define LIST_FIND_RESULT_EMAIL		63
#define SCROLLBAR_FIND_RESULT		64
#define BUTTON_FIND_RESULT_NEW		65
#define BUTTON_FIND_RESULT_ZOOMIN   219

//==================== FORM_VE_EMAIL_ADDR =============================
#define FORM_VE_EMAIL_NAME			66
#define	STRING_CATE					67
#define STRING_LAST_NAME			68
#define	STRING_FIRST_NAME			69
#define STRING_C_EMAIL_1			70
#define STRING_C_EMAIL_2			71
#define STRING_H_EMAIL_1			72
#define	STRING_H_EMAIL_2			73
#define TEXTBOX_LAST_NAME			74
#define TEXTBOX_FIRST_NAME			75
#define	FIELD_C_EMAIL				76
#define FIELD_H_EMAIL				77
#define STRING_VE					78
#define CHECKBOX_VE_C				79
#define CHECKBOX_VE_H				80
#define STRING_VE_C					81
#define STRING_VE_H					82
#define	BUTTON_VE_DEL				83
#define STRING_VE_DEFAULT			84
#define STRING_VE_NAME              223

//==================== FORM_SAVE_CHANGES =============================
#define FORM_SAVE_CHANGES			85
#define BITMAP_SAVE_CHANGES			86
#define STRING_SAVE_CHANGES			87
#define BUTTON_SAVE_CHANGES_YES		88
#define BUTTON_SAVE_CHANGES_NO		89

//==================== FORM_ADD_ERASE =============================
#define FORM_ADD_ERASE				90
#define STRING_ADD_ERASE_0			91
#define STRING_ADD_ERASE_1			92
#define CHECKBOX_ADD_ERASE			93
#define BUTTON_ADD_ERASE_YES		94
#define BUTTON_ADD_ERASE_NO			95

//==================== FORM_EMAIL_MESS_LIST =============================
#define FORM_EMAIL_MESS_LIST            96 
#define POPUP_TRIGGER_EMAIL_BOX		97
#define SCROLLBAR_EMAIL_MESS		98
#define LIST_EMAIL_MESS_NAME		99
#define LIST_EMAIL_MESS_SUB			100
#define LIST_EMAIL_MESS_TIME		101
#define BUTTON_EMAIL_MESS_NEW		102
#define BUTTON_EMAIL_MESS_CONNECT	103
#define BITMAP_EMAIL_MESS_0			203
#define BITMAP_EMAIL_MESS_1			204
#define BITMAP_EMAIL_MESS_2			205
#define BITMAP_EMAIL_MESS_3			206
#define BITMAP_EMAIL_MESS_4			207
#define BITMAP_EMAIL_MESS_5			208
#define BITMAP_EMAIL_MESS_6			209
#define BITMAP_EMAIL_MESS_7			210
#define BITMAP_EMAIL_MESS_8			211
#define BITMAP_EMAIL_MESS_9			212
#define BITMAP_EMAIL_MESS_10		213


//==================== FORM_EDIT_EMAIL =============================
#define FORM_EDIT				104	
#define STRING_EDIT				105
#define SCROLLBAR_EDIT			106
#define BITMAP_EDIT_TO			107
#define STRING_EDIT_0			108
#define STRING_EDIT_1			109
#define	STRING_EDIT_2			110
#define	STRING_EDIT_3			111
#define STRING_EDIT_4			112
#define FIELD_EDIT_0			113
#define FIELD_EDIT_1			114
#define FIELD_EDIT_2			115
#define FIELD_EDIT_3			116
#define FIELD_EDIT_4			117
#define TABLE_EDIT				118
#define BUTTON_EDIT_SEND		119
#define BUTTON_EDIT_SAVE		120
#define BUTTON_EDIT_DEL			121
#define BUTTON_EDIT_RESEND		122
#define BUTTON_EDIT_CONNECT		123
#define BUTTON_EDIT_REPLY		124
#define BUTTON_EDIT_FORWARD		125


//==================== FORM_MAIL_LIST =============================
#define FORM_MAIL_LIST				126
#define STRING_MAIL_LIST			127
#define SCROLLBAR_MAIL_LIST			128
#define STRING_MAIL_LIST_TO			129
#define STRING_MAIL_LIST_CC			130
#define	STRING_MAIL_LIST_BCC		131
#define FIELD_MAIL_LIST_TO			132
#define FIELD_MAIL_LIST_CC			133
#define FIELD_MAIL_LIST_BCC			134
#define TABLE_MAIL_LIST				135
#define BUTTON_MAIL_LIST			136
#define BUTTON_MAIL_LIST_ADD		137


//==================== FORM_EMAIL_ERASE =============================
#define FORM_EMAIL_ERASE			138
#define STRING_EMAIL_ERASE_0		139
#define STRING_EMAIL_ERASE_1		140
#define CHECKBOX_EMAIL_ERASE		141
#define BUTTON_EMAIL_ERASE_YES		142
#define BUTTON_EMAIL_ERASE_NO		143

//==================== FORM_REPLY_TO =============================
#define FORM_REPLY_TO				144
#define BUTTON_REPLY_TO_ALL			145
#define BUTTON_REPLY_TO_SENDER		146
#define BITMAP_REPLY_TO_X			147

//==================== FORM_EMESS_SAVE_CHANGES =============================
#define FORM_EMESS_SAVE_CHANGES				148
#define BITMAP_EMESS_SAVE_CHANGES			149
#define STRING_EMESS_SAVE_CHANGES			150
#define BUTTON_EMESS_SAVE_CHANGES_YES		151
#define BUTTON_EMESS_SAVE_CHANGES_NO		152

//==================== FORM_PROGRAM_MISSING =============================
#define FORM_PROGRAM_MISSING				154
#define BITMAP_PROGRAM_MISSING_X			155
#define STRING_PROGRAM_MISSING_0			156
#define STRING_PROGRAM_MISSING_1			157

//==================== FORM_DIAL =============================
#define FORM_DIAL							158
#define STRING_DIAL_CONNECT					159
#define	STRING_DIAL_DIAL					160
#define STRING_DIAL_DIAL_OUT				161
#define STRING_DIAL_ACCOUNT_0				162
#define STRING_DIAL_ACCOUNT_1				163
#define TEXTBOX_DIAL						164
#define TEXTBOX_DIAL_OUT					165
#define PUSHBUTTON_ACCOUNT_0				166
#define PUSHBUTTON_ACCOUNT_1				167
#define PUSHBUTTON_ACCOUNT_2				168
#define PUSHBUTTON_ACCOUNT_3				169
#define BUTTON_DIAL							170
#define BITMAP_BACKGROUND					171
#define BITMAP_DIAL_LEFT					172
#define BITMAP_DIAL_RIGHT					173
#define	BITMAP_DIAL_C						174
#define	BITMAP_DIAL_1						175
#define	BITMAP_DIAL_2						176
#define	BITMAP_DIAL_3						177
#define	BITMAP_DIAL_4						178
#define	BITMAP_DIAL_5						179
#define	BITMAP_DIAL_6						180
#define	BITMAP_DIAL_7						181
#define	BITMAP_DIAL_8						182
#define	BITMAP_DIAL_9						183
#define BITMAP_DIAL_0						184
#define BITMAP_DIAL_LSYM					185
#define BITMAP_DIAL_RSYM					186
#define BITMAP_DIAL_ENTER					187
#define CHECKBOX_DIAL_OUT					188

//==================== FORM_COMM_ERROR =============================
#define FORM_COMM_ERROR						189
#define BITMAP_COMM_ERROR					190
#define STRING_COMM_ERROR_0					191
#define	STRING_COMM_ERROR_1					192
#define	STRING_COMM_ERROR_2					193

//==================== FORM_CONNECT =============================
#define FORM_CONNECT						194
#define STRING_CONNECT_CONNECT				195
#define STRING_CONNECT_DIAL					196
#define STRING_CONNECT_NUM					197
#define LINE_CONNECT						198
#define FIELD_CONNECT						199
#define SCROLLBAR_CONNECT					200
#define BUTTON_CONNECT_DISCONNECT			201

//==================== FORM_NO_TO_ADDR ======================================
#define FORM_NO_TO_ADDR                     214
#define BITMAP_NO_TO_ADDR	                215
#define STRING_NO_TO_ADDR                   216


#define MENU_POPUP							153
#define MENU_POPUP1							202
#define MENU_EMAIL_NAME_LIST				220
#define MENU_FIND_RESULT					221
#define MENU_EDIT_CATE						222

//==================== FORM_EM_LOW_MEMORY =============================
#define FORM_EM_LOW_MEMORY					224
#define BITMAP_EM_LOW_MEMORY				225
#define STRING_EM_LOW_MEMORY_0				226
#define STRING_EM_LOW_MEMORY_1				227


//==================== FORM_EM_DISCARD_CHANGES =============================
#define FORM_EM_DISCARD_CHANGES 	    228
#define STRING_EM_DISCARD_CHANGES_0	    229
#define STRING_EM_DISCARD_CHANGES_1	    230
#define STRING_EM_DISCARD_CHANGES_2	    231
#define BUTTON_EM_DISCARD_CHANGES_YES   232
#define BUTTON_EM_DISCARD_CHANGES_NO    233
#define BITMAP_EM_DISCARD_CHANGES       234

#endif
