/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   listdis.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"

/********************************************************
* Function:	ListDisplaySetNumItemsDisplay
* Purpose: 	This function is called in order to set the value of 
num of items on display of a list object
* Scope:		application
* Input:		list_display	list_display structure
num_items		number of items on the display of a list object
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void ListDisplaySetNumItemsDisplay(ListDisplay *list_display, USHORT num_items)
{
	list_display->num_items_display = num_items;
	
}

/********************************************************
* Function:	ListDisplaySetTotalNumItems
* Purpose: 	This function is called in order to set the value of 
total number of items
* Scope:		application
* Input:		list_display	list_display structure
num_items		total number of items
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void ListDisplaySetTotalNumItems(ListDisplay *list_display, USHORT num_items)
{
	list_display->total_num_items = num_items;
	
}

/********************************************************
* Function:	ListDisplaySetTopItemNum
* Purpose: 	This function is called in order to set 
the top item number of a list object
* Scope:		application
* Input:		list_display	list_display structure
item_num		the top item number
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void ListDisplaySetTopItemNum(ListDisplay *list_display, USHORT item_num)
{
	list_display->top_item_num = item_num;
}


/********************************************************
* Function:	ListDisplayInsertRecordID
* Purpose: 	This function is called in order to insert a record ID	
* Scope:		application
* Input:		list_display	list_display structure
record_id		record_id being inserted
dbid			DBID of the record
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void ListDisplayInsertRecordID(ListDisplay *list_display, RecordID record_id, DatabaseID dbid)
{
	USHORT i;
	BOOLEAN create = FALSE;
	RecordIDBlock *temp;
	
	
	if (list_display->record_id_block == NULL)
	{
		list_display->record_id_block = (RecordIDBlock*)qmalloc(sizeof(RecordIDBlock));
		temp = list_display->record_id_block;
		create = TRUE;
	}
	else
	{
		temp = list_display->record_id_block;
		while (temp != NULL)
		{
			if (temp->num_records != 20)
				break;
			if (temp->next == NULL)
			{	
				create = TRUE;
				temp ->next = (RecordIDBlock*)qmalloc(sizeof(RecordIDBlock));
				temp = temp->next;
				break;
			}
			else temp = temp->next;
		}
	}
	
	if (create == TRUE)
	{
		temp->next = NULL;
		temp->num_records = 0;
		for (i = 0; i<20; i++)
			temp->record_id[i] = 0;
	}
	
	temp->num_records ++;
	list_display->total_num_items ++;
	temp->record_id[temp->num_records - 1] = record_id;		
	temp->dbid[temp->num_records - 1] = dbid;
}



/********************************************************
* Function:	ListDisplayDelete
* Purpose: 	This function is called in order to insert a record ID	
* Scope:		application
* Input:		list_display	list_display structure
record_id		record_id being inserted
* Output:		None
* Return:		TRUE    handled
FALSE   not-handled
* Comment: 	None
*********************************************************/
BOOLEAN ListDisplayDeleteAllRecordID(ListDisplay *list_display)
{
	RecordIDBlock *temp = list_display->record_id_block;
	RecordIDBlock *temp1 = NULL;
	
	if (temp != NULL)
	{
		temp1 = temp->next;
		if (temp1 == NULL)
		{
			qfree(temp);
			list_display->max_num_items_display = 10;
			list_display->num_items_display = 0;
			list_display->total_num_items = 0;
			list_display->top_item_num = 0;
			list_display->record_id_block = NULL;
			return TRUE;
		}
		while (temp1 != NULL)
		{
			qfree(temp);
			temp = temp1;
			temp1 = temp->next;
		}
		if (temp1 == NULL)
			qfree(temp);
	}
	list_display->max_num_items_display = 10;
	list_display->num_items_display = 0;
	list_display->total_num_items = 0;
	list_display->top_item_num = 0;
	list_display->record_id_block = NULL;
	return TRUE;
}



/********************************************************
* Function:	ListDisplayGetText
* Purpose: 	This function is called to get the text of LIST_NAME or 
LIST_FIND_RESULT_NAME
* Scope:		application
* Input:		list_display	list-display structure
item_num		item number
* Output:		text			Pointer reference to text
* Return:		TRUE    handled
FALSE   not-handled
* Comment: 	None
*********************************************************/
BOOLEAN ListDisplayGetText(ListDisplay *list_display, USHORT field_num, USHORT item_num, BYTE **text)
{
	RecordIDBlock *temp = list_display->record_id_block;
	USHORT count = 0;
	UWORD rec_num;
	RecordID rec_id;
	BYTE *buffer;
	UWORD byte_read;
    BYTE *first_name, *last_name, *out_string;
	
	if (item_num >= list_display->total_num_items) return FALSE;
	if (list_display->record_id_block == NULL) return FALSE;
	
	
	while (temp != NULL)
	{
		if ((item_num >= count) && (item_num < (count + 20)))
		{
			DataRecIDtoNum(temp->dbid[item_num - count], temp->record_id[item_num - count], &rec_num);
			DataOpenRecord(temp->dbid[item_num - count], rec_num, &rec_id, NULL);
            if (field_num != 2)
            {
                DataGetField(temp->dbid[item_num - count], rec_id, field_num, &buffer, &byte_read);
                *text = buffer;
            }
            else
            {
                DataGetField(temp->dbid[item_num - count], rec_id, 0, &first_name, &byte_read);
                DataGetField(temp->dbid[item_num - count], rec_id, 1, &last_name, &byte_read);
                out_string = (BYTE*)qmalloc(200 * sizeof(BYTE));
                PhonebookPrepareLastFirstNameForDisplay(first_name, last_name, out_string);
                *text = out_string;
				qfree(first_name);
				qfree(last_name);
            }
			DataCloseRecord(temp->dbid[item_num - count], rec_id);
			return TRUE;
		}
		else
		{
			count += 20;
			temp = temp->next;
		}
	}
	return FALSE;
}

/********************************************************
* Function:	ListDisplayGetRecordID
* Purpose: 	This function is called in order to get the record ID 
of a particular list item in teh list object
* Scope:		application
* Input:		list_display	list-display structure
item_num		item number
* Output:		rec_id			Pointer to record ID of the list object
* Return:		TRUE    handled
FALSE   not-handled
* Comment: 	None
*********************************************************/
BOOLEAN ListDisplayGetRecordID(ListDisplay *list_display, USHORT item_num, RecordID *rec_id, DatabaseID *dbid)
{
	
	RecordIDBlock *temp = list_display->record_id_block;
	USHORT count = 0;
	
	if (item_num >= list_display->total_num_items) return FALSE;
	if (list_display->record_id_block == NULL) return FALSE;
	
	
	while (temp != NULL)
	{
		if ((item_num >= count) && (item_num < (count + 20)))
		{
			*rec_id = temp->record_id[item_num-count];
			*dbid = temp->dbid[item_num-count];
			return TRUE;
		}
		else
		{
			count += 20;
			temp = temp->next;
		}
	}
	return FALSE;
}
