/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "system.h"
#include "app.h"

//extern UWORD _fdata, etext, _fbss, ebss;

/* ==================================================================== */
/* ========================= Function Prototypes ====================== */
/* ==================================================================== */
void EventLoop();
void MMUInit();
void KernelInit();
void ResInit();
static BOOLEAN ApplicationHandleEvent(EvtType *Event);

BOOLEAN (*FormDispatchEvent)(EvtType *Event);

extern REGISTRY app_reg[];


#ifdef PC_SIM
extern BOOL m_bIsExit;
#endif

/* ==================================================================== */
/* ========================= Global Variables ========================= */
/* ==================================================================== */
AppID app_id;
DatabaseID pb_dbid;
DatabaseID email_dbid;
DatabaseID emess_dbid;
DatabaseID sys_dbid;
extern UBYTE res_data [];
UBYTE sysres_data[1];

/********************************************************
* Function:	ApplicationHandleEvent
* Purpose: 	This function is used to load the specific data of
form and set event handler of the form
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
static BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
	Form *form_ptr;
	ObjectID form_id;
	BYTE object_type;
	Err Error;
	
	if (Event->eventType == EVT_FORM_LOAD)
	{
		form_id = (ObjectID)Event->eventID;
		Error = UISearchForAddress(form_id,&object_type,(void**)&form_ptr);
		if (Event->para1 == 1 || Error != TRUE)
		{
			FormInitForm(form_id);
		}
		if (!UISearchForAddress(form_id,&object_type,(void**)&form_ptr))
		{
			return FALSE;
		}
		switch (form_id)
		{
		case FORM_EMAIL_NAME_LIST:
			FormSetEventHandler(FORM_EMAIL_NAME_LIST,(void**) &FormDispatchEvent, (void*)EmailEmailNameList);
			break;
		case FORM_EDIT_CATE:		 FormSetEventHandler(FORM_EDIT_CATE,(void**) &FormDispatchEvent, (void*)EmailEditCate);
							 			 break;
		case FORM_INPUT_CATE:		 FormSetEventHandler(FORM_INPUT_CATE,(void**) &FormDispatchEvent, (void*)EmailInputCate);
							 			 break;
		case FORM_NO_CATE:		     FormSetEventHandler(FORM_NO_CATE,(void**) &FormDispatchEvent, (void*)EmailNoCate);
							 			 break;
		case FORM_CATE_NAME_EXISTS:    
			FormSetEventHandler(FORM_CATE_NAME_EXISTS,(void**) &FormDispatchEvent, (void*)EmailNameExists);
							 			 break;
		case FORM_ERASE_CATE:		 FormSetEventHandler(FORM_ERASE_CATE,(void**) &FormDispatchEvent, (void*)EmailEraseCate);
							 			 break;
		case FORM_REMOVE_CATE: 		 FormSetEventHandler(FORM_REMOVE_CATE,(void**) &FormDispatchEvent, (void*)EmailRemoveCate);
							 			 break;
		case FORM_CATE_FULL:		 FormSetEventHandler(FORM_CATE_FULL,(void**) &FormDispatchEvent, (void*)EmailCateFull);
							 			 break;
		case FORM_FIND_BACKGROUND:  
			FormSetEventHandler(FORM_FIND_BACKGROUND,(void**) &FormDispatchEvent, (void*)EmailFindBackground);
							 			 break;
		case FORM_FIND_INPUT:		 FormSetEventHandler(FORM_FIND_INPUT,(void**) &FormDispatchEvent, (void*)EmailFindInput);
							 			 break;
		case FORM_NOT_FOUND:		 FormSetEventHandler(FORM_NOT_FOUND,(void**) &FormDispatchEvent, (void*)EmailNameNotFound);
							 			 break;
		case FORM_FIND_RESULT:  	 FormSetEventHandler(FORM_FIND_RESULT,(void**) &FormDispatchEvent, (void*)EmailFindResult);
							 			 break;
		case FORM_VE_EMAIL_NAME:	 FormSetEventHandler(FORM_VE_EMAIL_NAME,(void**) &FormDispatchEvent, (void*)EmailVEEmailName);
							 			 break;
		case FORM_SAVE_CHANGES:		 FormSetEventHandler(FORM_SAVE_CHANGES, (void**) &FormDispatchEvent, (void*)EmailSaveChanges);
							 			 break;
		case FORM_ADD_ERASE:		 FormSetEventHandler(FORM_ADD_ERASE, (void**) &FormDispatchEvent, (void*)EmailVEEmailNameDelConfirm);
							 			 break;
		case FORM_EMAIL_MESS_LIST:
			FormSetEventHandler(FORM_EMAIL_MESS_LIST, (void**) &FormDispatchEvent, (void*)EmailEmailMessageList);
			break;
		case FORM_EDIT:				 FormSetEventHandler(FORM_EDIT, (void**) &FormDispatchEvent, (void*)EmailEdit);	  
							 			 break;
		case FORM_MAIL_LIST:		 FormSetEventHandler(FORM_MAIL_LIST, (void**) &FormDispatchEvent, (void*)EmailMailList);	  
							 			 break;
		case FORM_REPLY_TO:			 FormSetEventHandler(FORM_REPLY_TO, (void**) &FormDispatchEvent, (void*)EmailReplyTo);	  
							 			 break;
		case FORM_EMAIL_ERASE:		 FormSetEventHandler(FORM_EMAIL_ERASE, (void**) &FormDispatchEvent, (void*)EmailEmailErase);	  
							 			 break;
		case FORM_EMESS_SAVE_CHANGES:FormSetEventHandler(FORM_EMESS_SAVE_CHANGES, (void**) &FormDispatchEvent, (void*)EmailMessageSaveChanges);	  
							 			 break;
		case FORM_PROGRAM_MISSING:   FormSetEventHandler(FORM_PROGRAM_MISSING, (void**) &FormDispatchEvent, (void*)EmailProgramMissing);	  
							 			 break;
		case FORM_DIAL:				 FormSetEventHandler(FORM_DIAL, (void**) &FormDispatchEvent, (void*)EmailDial);	  
							 			 break;
		case FORM_COMM_ERROR:	     FormSetEventHandler(FORM_COMM_ERROR, (void**) &FormDispatchEvent, (void*)EmailCommError);	  
							 			 break;
		case FORM_CONNECT:			 FormSetEventHandler(FORM_CONNECT, (void**) &FormDispatchEvent, (void*)EmailConnect);	  
							 			 break;
		case FORM_NO_TO_ADDR:        FormSetEventHandler(FORM_NO_TO_ADDR, (void**) &FormDispatchEvent, (void*)EmailEmptyToField);     
							 			 break;
		case FORM_EM_LOW_MEMORY:     FormSetEventHandler(FORM_EM_LOW_MEMORY, (void**) &FormDispatchEvent, (void*)EmailLowMemoryHandle);     
							 			 break; 			 
		case FORM_EM_DISCARD_CHANGES:FormSetEventHandler(FORM_EM_DISCARD_CHANGES, (void**) &FormDispatchEvent, (void*)EmailDiscardChangesHandle);     
							 			 break; 			 							 			 
		}
		FormSetActiveForm(form_id);
		return TRUE;
	}
	return FALSE;
}
/********************************************************
* Function:	EventLoop
* Purpose: 	This function is a loop to get events from event
manager and then passes the event to different
event handler
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EventLoop(void)
{
	EvtType event;
	do
	{
		EvtGetEvent (&event);
		if (!SystemHandleEvent(&event))
			if (!MenuHandleEvent(&event))
				if (!ApplicationHandleEvent(&event))
					FormDispatchEvent(&event);
	}
#ifdef PC_SIM
	while (event.eventType != EVT_APP_STOP && m_bIsExit == FALSE);
#else
	while (event.eventType != EVT_APP_STOP);
#endif
}
/********************************************************
* Function:	main
* Purpose: 	main procedure of the application
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
__main(WORD cmd, void*cmd_ptr)
{
	//    SysEnableDebug();
	EmailAppLaunch(cmd, (void*)cmd_ptr);
	//    DataCloseDB(sys_dbid);
	//    DataCloseDB(pb_dbid);
	//    DataCloseDB(email_dbid);
	//    DataCloseDB(emess_dbid);
}     
