/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   messdb.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"

//#define DEBUG
/*****************************************************************
**************** Email Message Database Initialisation ***********
*****************************************************************/

/********************************************************
* Function:	EmailMessageDatabaseClose
* Purpose: 	This fucntion is called in order to close 
email database				
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	This function should be called in the StopApplication
*********************************************************/
void EmailMessageDatabaseClose()
{
	
}

/********************************************************
* Function:	EmailMessageDatabaseInit
* Purpose: 	This function is used to simulate and initialse the 
the datebase in the PDA.Try to preset some records in 
the database
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	This function should be called in the StartApplication() function.
*********************************************************/
void EmailMessageDatabaseInit()
{
}

/********************************************************
* Function:	EmailConvertDate
* Purpose: 	This function is called in order to convert
the received data
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	This function should be called in the StartApplication() function.
*********************************************************/
void EmailConvertDate(BYTE *input_date, BYTE *output_date)
{
	BYTE	*sbuffer;
	BYTE	count = 0;
	BYTE	num_char = 0;
	BYTE	*month;
	BYTE	*hour;
	BYTE	*temp, *temp1;
	BYTE	*day;
	BYTE	last_found = 0;
	BYTE	*year;
	WORD	i,j,k;
	BOOLEAN found = FALSE;
	WORD	num_of_colon = 0;
	RTM		time;
	WORD	length;
	BYTE	day_start_char = 0;
	BYTE	day_end_char = 0;
	WORD	length1 = 0;
	BOOLEAN	found_start = FALSE;
	BOOLEAN found_end = FALSE;
	BOOLEAN	complete_date = TRUE;
	BOOLEAN	colon_found = FALSE;
	
    sbuffer = (BYTE*)qmalloc((strlen(input_date) + 50)*sizeof(BYTE));
    month   = (BYTE*)qmalloc((strlen(input_date) + 50)*sizeof(BYTE));
    day             = (BYTE*)qmalloc((strlen(input_date) + 50)*sizeof(BYTE));
    hour    = (BYTE*)qmalloc((strlen(input_date) + 50)*sizeof(BYTE));
    year    = (BYTE*)qmalloc((strlen(input_date) + 50)*sizeof(BYTE));
	
	length1 = strlen(input_date);
	
	month[0] = '\0';
	if (EmailSearchForText(EMJAN, input_date) == TRUE) strcpy(month, (BYTE*)("01")); 
	else if (EmailSearchForText(EMFEB, input_date) == TRUE) strcpy(month, (BYTE*)("02"));
	else if (EmailSearchForText(EMMAR, input_date) == TRUE) strcpy(month, (BYTE*)("03")); 
	else if (EmailSearchForText(EMAPR, input_date) == TRUE) strcpy(month, (BYTE*)("04")); 
	else if (EmailSearchForText(EMMAY, input_date) == TRUE) strcpy(month, (BYTE*)("05")); 
	else if (EmailSearchForText(EMJUN, input_date) == TRUE) strcpy(month, (BYTE*)("06")); 
	else if (EmailSearchForText(EMJUL, input_date) == TRUE) strcpy(month, (BYTE*)("07")); 
	else if (EmailSearchForText(EMAUG, input_date) == TRUE) strcpy(month, (BYTE*)("08")); 
	else if (EmailSearchForText(EMSEP, input_date) == TRUE) strcpy(month, (BYTE*)("09")); 
	else if (EmailSearchForText(EMOCT, input_date) == TRUE) strcpy(month, (BYTE*)("10")); 
	else if (EmailSearchForText(EMNOV, input_date) == TRUE) strcpy(month, (BYTE*)("11")); 
	else if (EmailSearchForText(EMDEC, input_date) == TRUE) strcpy(month, (BYTE*)("12")); 
	else if (EmailSearchForText(EMLJAN, input_date) == TRUE) strcpy(month, (BYTE*)("01")); 
	else if (EmailSearchForText(EMLFEB, input_date) == TRUE) strcpy(month, (BYTE*)("02"));
	else if (EmailSearchForText(EMLMAR, input_date) == TRUE) strcpy(month, (BYTE*)("03")); 
	else if (EmailSearchForText(EMLAPR, input_date) == TRUE) strcpy(month, (BYTE*)("04")); 
	else if (EmailSearchForText(EMLMAY, input_date) == TRUE) strcpy(month, (BYTE*)("05")); 
	else if (EmailSearchForText(EMLJUN, input_date) == TRUE) strcpy(month, (BYTE*)("06")); 
	else if (EmailSearchForText(EMLJUL, input_date) == TRUE) strcpy(month, (BYTE*)("07")); 
	else if (EmailSearchForText(EMLAUG, input_date) == TRUE) strcpy(month, (BYTE*)("08")); 
	else if (EmailSearchForText(EMLSEP, input_date) == TRUE) strcpy(month, (BYTE*)("09")); 
	else if (EmailSearchForText(EMLOCT, input_date) == TRUE) strcpy(month, (BYTE*)("10")); 
	else if (EmailSearchForText(EMLNOV, input_date) == TRUE) strcpy(month, (BYTE*)("11")); 
	else if (EmailSearchForText(EMLDEC, input_date) == TRUE) strcpy(month, (BYTE*)("12")); 
	else 
		complete_date = FALSE;
	
	
	/* search for hour */
	hour[0] = '\0';
	temp = input_date;
	temp1 = hour;
	
	for (count = 0; count < length1; count++)
	{
		if (*temp == ':')
			num_of_colon ++;
		temp++;
	}
	temp = input_date;
	for (count = 0; count < length1; count++)
	{
		if (*temp == ':')
			break;
		else temp ++;
	}
	temp = input_date + count - 2;
	
	for (count = 0; count <= num_of_colon; count++)
	{
		strcpy(hour,temp);
		hour += 2;
		temp += 3;
	}
	hour = temp1;
	
	length = strlen(hour);
	if (hour[0] == 32)
		hour[0] = '0';
	
	for (count = 0; count < length; count++)
	{
		if (hour[count] == '+'  ||
			hour[count] == 32   ||
			hour[count] == '\r' ||
			hour[count] == '\n')
		{
			hour[count] = 0;			
			break;
		}
	}
	
	if (strlen(hour) == 0)
		complete_date = FALSE;
	
	/* search for year */
	i = 0;
	found = FALSE;
	while (i < length1)
	{
		if (input_date[i] == 32 || input_date[i] == ',')
		{
			j = i + 1;
			while (input_date[j] <= 57 && input_date[j] >= 48)
				j++;
			if ((j - i) == 5)
			{
				for (k = i + 1; k < i + 5; k++)
					year[k - i - 1] = input_date[k];
				year[k - i - 1] = '\0';
				found = TRUE;
				break;
			}
			else i = j - 1;
		}
		if (found)
			break;
		else i++;
	}
	if (found == FALSE)
	{
		year = 0;
		complete_date = FALSE;
	}
	
	
	/* search for day */
	colon_found = FALSE;
	for (num_char = 0; num_char < length1; num_char ++)
	{
		if (input_date[num_char] == ':')
			colon_found = TRUE;
		else if (input_date[num_char] && colon_found &&
			(input_date[num_char] == ',' || input_date[num_char] == 32))
			colon_found = FALSE;				 
		
		if (!found_start && input_date[num_char] >= '0' && input_date[num_char] <= '9' && !colon_found)		
		{
			found_start = TRUE;
			day_start_char = num_char;
			day_end_char = num_char;
		}
		else if (found_start)
		{
			if (input_date[num_char] == ',' || input_date[num_char] == 32)
			{
				if (day_end_char - day_start_char > 4)
				{
					found_start = FALSE;
					found_end = FALSE;
				}
				else if (day_end_char - day_start_char <= 2)
				{
					day_end_char ++;
					found_end = TRUE;
					break;
				}
			}
			else if (input_date[num_char] == ':' || input_date[num_char] < '0' || input_date[num_char] > '9')
			{
				found_start = FALSE;
				found_end = FALSE;
			}
			else
				day_end_char ++;
		}
	}
	
	if (found_start && found_end)
	{
		for (num_char = day_start_char; num_char < day_end_char; num_char ++)
			day[num_char - day_start_char] = input_date[num_char];
		day[day_end_char - day_start_char] = 0;
	}
	else 
	{
		complete_date = FALSE;
		day[0] = 0;
	}
	
	
	temp = sbuffer;
	if (complete_date)
	{
		if (strlen(year) == 4 && strlen(month) == 2 && strlen(day) == 2 && complete_date)
		{
			strcpy(sbuffer, year);
			sbuffer += 4;
			strcpy(sbuffer, month);
			sbuffer += 2;
			strcpy(sbuffer, day);
			sbuffer += 2;
			if (strlen(hour) == 6)
				strcpy(sbuffer, hour);
			else strcpy(sbuffer, (BYTE*)("000000"));
			strcpy(output_date, temp);
		}
	}
	else
	{
		RtcGetTime(&time);
		if (time.year)
			j = sprintf((char*)sbuffer, "%d", time.year);
		else
			j = sprintf((char*)sbuffer, "%d", time.year);
		time.mon ++;
		if (time.mon < 10)
			j += sprintf((char*)sbuffer + j, "0%d", time.mon);
		else
			j += sprintf((char*)sbuffer + j, "%d", time.mon);
		if (time.mday < 10)
			j += sprintf((char*)sbuffer + j, "0%d", time.mday);
		else
			j += sprintf((char*)sbuffer + j, "%d", time.mday);
		if (time.hour < 10)
			j += sprintf((char*)sbuffer + j, "0%d", time.hour);
		else
			j += sprintf((char*)sbuffer + j, "%d", time.hour);
		if (time.min < 10)
			j += sprintf((char*)sbuffer + j, "0%d", time.min);
		else
			j += sprintf((char*)sbuffer + j, "%d", time.min);
		if (time.sec < 10)
			j += sprintf((char*)sbuffer + j, "0%d", time.sec);
		else
			j += sprintf((char*)sbuffer + j, "%d", time.sec);
		strcpy(output_date, sbuffer);
	}
	qfree(day);
	qfree(month);
	qfree(hour);
	qfree(year);
	qfree(temp);
}


/********************************************************
* Function:	EmailMessageGetNameEmail
* Purpose: 	This function is called in order to get the name and email address
of To, CC or BCC fields
* Scope:		application
* Input:		dbid			The DatabaseID
rec_id			The record id of the record
field			To, CC or BCC
all_data		if TRUE, then it returns all possible TO, FROM, CC or BCC users
* Output:		name			array of names
emails			array of emails
num_items		how many items in the array
* Return:		None
* Comment: 	None
*********************************************************/
BOOLEAN EmailMessageGetNameEmail(BYTE *buffer0, BYTE ***name, BYTE ***emails, USHORT *num_items,
								 BOOLEAN all_data)
{
	BYTE        *buffer, *buffer1, *buffer2, *buffer3, *buffer4, *buffer5;
	UWORD       prev_count = 0, count = 0, temp = 0, current_num = 0, max_num_chars = 0;
	BOOLEAN     start_found = FALSE, end_found = FALSE;
	UWORD       name_length = 0, email_length = 0, spaces = 0;
	BYTE        **y;
	BOOLEAN     all_spaces = TRUE;
	WORD 		pos_count;
	UWORD		length_buffer0;
	UWORD		buffer_length;
	
	
	
	if (strlen(buffer0) == 0)
	{
		*num_items = 0;
		*name = NULL;
		*emails = NULL;
		return TRUE;
	}
	
	
	buffer_length = strlen(buffer0);
	
    buffer = (BYTE*)qmalloc((buffer_length + 1)*sizeof(BYTE));
	strcpy(buffer, buffer0);
	
	buffer1 = buffer;  /* buffer1 must point to the start of buffer */
	if (buffer_length == 0)
	{
		*num_items = 0;
		*name = NULL;
		*emails = NULL;
		return TRUE;
	}
	*num_items = 1;
	max_num_chars = 2000;
	
	if (all_data == TRUE)	
	{
		prev_count = 0;
		max_num_chars = 0;
		for (count = 0; count <= buffer_length; count++)
		{			
			if (buffer1[count] == '\r' || buffer1[count] == ',')
			{				
				*num_items = *num_items + 1;
				if (max_num_chars < (count - prev_count + 1))
					max_num_chars = (count - prev_count + 1);
				prev_count = count + 1;
				
			}				
			
		}
	}
	
	y = (BYTE**)qmalloc(*num_items * sizeof(BYTE*));
	*name = y;
	y = (BYTE**)qmalloc(*num_items * sizeof(BYTE*));
	*emails = y;
	for (count = 0; count < *num_items; count++)
	{
		(*name)[count] = (BYTE*)qmalloc(max_num_chars *sizeof(BYTE));
		(*emails)[count] = (BYTE*)qmalloc(max_num_chars *sizeof(BYTE));
	}
	buffer1 = buffer;
	
	
	//========================================================
	for (count = 0; count < strlen(buffer); count ++)
	{
		if (buffer[count] != 32)
		{
			all_spaces = FALSE;
			break;
		}
	}
	
	if (all_spaces == TRUE & (*num_items) == 1)
	{
		*((*name)[0]) = 0;
		strcpy(((*emails)[0]), buffer0);
		return TRUE;
	}
	//=========================================================	
	
	while (current_num < *num_items)
	{
		buffer3 = NULL;
		buffer4 = NULL;
		buffer5 = NULL;
		start_found = FALSE;
		end_found = FALSE;
		name_length = 0;
		email_length = 0;
		temp = 0;
		spaces = 0;
		while (buffer[temp] != '\r' && buffer[temp] != '\0' && buffer[temp] != ',')
			temp++;
		buffer5 = (BYTE*)qmalloc(buffer_length*sizeof(BYTE));
		buffer2 = buffer5;
		
		strcpy(buffer5, buffer);
		
		buffer5[temp] = '\0';
		buffer += temp + 1;
		while (*buffer5 == 32)
			buffer5 ++;
		
		count = 0;
		while (buffer5[count] != '<' && count < strlen(buffer5))
			count ++;
		
		if (count == 0)
			buffer5 ++;
		else if (count != 0 && count != strlen(buffer5))
		{
			buffer3 = (BYTE*)qmalloc(buffer_length * sizeof(BYTE));
			strcpy(buffer3, buffer5);
			buffer3[count] = '\0';
			buffer5 += count + 1;
		}
		buffer4 = (BYTE*)qmalloc(buffer_length*sizeof(BYTE));
		strcpy(buffer4, buffer5);
		
		if (buffer3)
		{
			pos_count = strlen(buffer3) - 1;	
			while (pos_count >= 0 && buffer3[pos_count] == 32)
			{
				buffer3[pos_count] = '\0';
				pos_count --;
			}
		}
		
		if (buffer4)
		{
			pos_count = strlen(buffer4) - 1;	
			while (pos_count >= 0 && (buffer4[pos_count] == 32 || buffer4[pos_count] == '>'))
			{
				buffer4[pos_count] = '\0';
				pos_count --;
			}				
		}
		
		
		if (buffer3) 
			strcpy(((*name)[current_num]), buffer3);
        else 
			(*(*name)[current_num]) = '\0';
		
		if (buffer4) 
			strcpy(((*emails)[current_num]), buffer4);
		else 
			(*(*emails)[current_num]) = '\0';
		
		if (buffer3 != NULL)
			qfree(buffer3);
		if (buffer4 != NULL)
			qfree(buffer4);
		if (buffer2 != NULL)
			qfree(buffer2);
		
		current_num ++;
		
		if (all_data == FALSE)
		{
			qfree(buffer1);
			return TRUE;
		}
	}
	qfree(buffer1);
	return TRUE;
}
