/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   veemdel.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"

/********************************************************
* Function:	EmailVEEmailNameDeleteRecord
* Purpose: 	This function is called in order to delete 
email address record in VE Email Name Screen				
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE		Success
FALSE		NotHandled
* Comment: 	
*********************************************************/
BOOLEAN EmailVEEmailNameDeleteRecord(BOOLEAN archive)
{
	UWORD rec_num;
	RecordID rec_id;
	
    if (DataRecordInfo(ve_email_name_status.dbid, ve_email_name_status.rec_id,
		NULL, NULL, NULL, NULL, NULL) != TRUE)
        return FALSE;
    else DataCloseRecord(ve_email_name_status.dbid, ve_email_name_status.rec_id);
	if (ve_email_name_status.dbid == email_dbid)
		DataDeleteRecord(email_dbid, ve_email_name_status.rec_id, archive);
	else
	{
		DataRecIDtoNum(ve_email_name_status.dbid, ve_email_name_status.rec_id, &rec_num);
		DataOpenRecord(ve_email_name_status.dbid, rec_num, &rec_id, NULL);
		DataWriteField(ve_email_name_status.dbid, ve_email_name_status.rec_id, 
			8, 1, (BYTE*)("\0"));
		DataWriteField(ve_email_name_status.dbid, ve_email_name_status.rec_id, 
			22, 1, (BYTE*)("\0"));
		DataWriteField(ve_email_name_status.dbid, ve_email_name_status.rec_id, 
			26, 1, (BYTE*)("\0"));
		DataCloseRecord(ve_email_name_status.dbid, rec_id);
	}
	return TRUE;
}

/********************************************************
* Function:	EmailVEEmailNameDelSetupScreen
* Purpose: 	This function is called in order to 
setup the screen for different deleting environment
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE		Success
FALSE		NotHandled
* Comment: 	
*********************************************************/
BOOLEAN EmailVEEmailNameDelSetupScreen()
{
	BYTE object_type;
	Control *control_ptr;
	String *string_ptr;
	
	
	if (ve_email_name_status.dbid == email_dbid)
	{
		StringSetText(STRING_ADD_ERASE_0, EMSTR19);
		FormGetObjectPointer(STRING_ADD_ERASE_0, &object_type, (void**)&string_ptr);
		string_ptr->bounds.xcoord = VEEMDEL_XCOORD1;
		string_ptr->bounds.width = VEEMDEL_WIDTH1;
		StringSetText(STRING_ADD_ERASE_1, EMSTR20);
		FormGetObjectPointer(STRING_ADD_ERASE_1, &object_type, (void**)&string_ptr);
		string_ptr->bounds.xcoord = VEEMDEL_XCOORD2;
		string_ptr->bounds.width = VEEMDEL_WIDTH2;
		FormGetObjectPointer(CHECKBOX_ADD_ERASE, &object_type, (void**)&control_ptr);
		control_ptr->control_attr.control_visible = TRUE;
	}
	else
	{
		StringSetText(STRING_ADD_ERASE_0, EMSTR21);
		FormGetObjectPointer(STRING_ADD_ERASE_0, &object_type, (void**)&string_ptr);
		string_ptr->bounds.xcoord = VEEMDEL_XCOORD3;
		string_ptr->bounds.width = VEEMDEL_WIDTH3;
		StringSetText(STRING_ADD_ERASE_1, EMSTR22);
		FormGetObjectPointer(STRING_ADD_ERASE_1, &object_type, (void**)&string_ptr);
		string_ptr->bounds.xcoord = VEEMDEL_XCOORD4;
		string_ptr->bounds.width = VEEMDEL_WIDTH4;
		FormGetObjectPointer(CHECKBOX_ADD_ERASE, &object_type, (void**)&control_ptr);
		control_ptr->control_attr.control_visible = FALSE;
	}
	return TRUE;
}

