/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   veename.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"

/********************************************************
* Function:	EmailSetupViewEditEmailName
* Purpose: 	This function is called in order to 
setup the FORM_VE_EMAIL_NAME screen
when it is called to popup
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	The whole process follows the lead of the 
parameter ve_email_name_status
*********************************************************/
BOOLEAN EmailSetupViewEditEmailNameScreen()
{
	BYTE object_type;
	BYTE *string;
	String *string_ptr;
	Textbox *textbox_ptr;
	Field *field_ptr;
	Control *control_ptr;
	SHORT item_num;
	USHORT field_length1;
	USHORT field_length2;
	
	/* Initialisation of POPUP_TRIGGER_CATE */
	FormGetObjectPointer(POPUP_TRIGGER_CATE, &object_type, (void **)&control_ptr);
	if (ve_email_name_status.status == VIEW)
	{
		control_ptr->control_attr.control_visible = FALSE;
		control_ptr->control_attr.control_enable = FALSE;
	}
	else
	{
		control_ptr->control_attr.control_visible = TRUE;
		control_ptr->control_attr.control_enable = TRUE;
	}
	
	
	FormGetObjectPointer(STRING_CATE, &object_type, (void **)&string_ptr);
	if (ve_email_name_status.status == VIEW)
	{
		string_ptr->string_attr.string_visible = TRUE;
		ControlPopupGetSelectedItem(POPUP_TRIGGER_CATE, &item_num);
		if (item_num == -1)
			StringSetText(STRING_CATE,EMALL);
		else
		{
			ControlPopupGetPopupItem(POPUP_TRIGGER_CATE, (USHORT)(item_num), &string);
			StringSetText(STRING_CATE,string);
		}
	}
	else string_ptr->string_attr.string_visible = FALSE;
	
    /* Initialisation of STRING_VE_NAME */
    FormGetObjectPointer(STRING_VE_NAME, &object_type, (void **)&string_ptr);
    if (ve_email_name_status.status == VIEW)
        string_ptr->string_attr.string_visible = TRUE;
    else string_ptr->string_attr.string_visible = FALSE;
	
	
	/* Initialisation of STRING_FIRST_NAME */
	FormGetObjectPointer(STRING_FIRST_NAME, &object_type, (void **)&string_ptr);
    if (ve_email_name_status.status == VIEW)
        string_ptr->string_attr.string_visible = FALSE;
    else string_ptr->string_attr.string_visible = TRUE;
	
	/* Initialisation of STRING_LAST_NAME */
	FormGetObjectPointer(STRING_LAST_NAME, &object_type, (void **)&string_ptr);
    if (ve_email_name_status.status == VIEW)
        string_ptr->string_attr.string_visible = FALSE;
    else string_ptr->string_attr.string_visible = TRUE;
	
	
	/* Initialisation of TEXTBOX_FIRST_NAME */
	FormGetObjectPointer(TEXTBOX_FIRST_NAME, &object_type, (void **)&textbox_ptr);
	if (ve_email_name_status.status == VIEW)
	{
        textbox_ptr->textbox_attr.textbox_visible = FALSE;
		textbox_ptr->textbox_back_line = NO_LINE;
		textbox_ptr->textbox_attr.textbox_enable = FALSE;
	}
    else
	{
		textbox_ptr->textbox_attr.textbox_visible = TRUE;
        if (ve_email_name_status.dbid == email_dbid)
            textbox_ptr->textbox_back_line = GREY_LINE;
        else textbox_ptr->textbox_back_line = NO_LINE;
		textbox_ptr->textbox_attr.textbox_enable = TRUE;
		if (ve_email_name_status.new_record == FALSE && ve_email_name_status.dbid == pb_dbid)
			textbox_ptr->textbox_attr.textbox_enable = FALSE;
		else textbox_ptr->textbox_attr.textbox_enable = TRUE;
	}
	
	/* Initialisation of TEXTBOX_LAST_NAME */
	FormGetObjectPointer(TEXTBOX_LAST_NAME, &object_type, (void **)&textbox_ptr);
	if (ve_email_name_status.status == VIEW)
	{
        textbox_ptr->textbox_attr.textbox_visible = FALSE;
		textbox_ptr->textbox_back_line = NO_LINE;
		textbox_ptr->textbox_attr.textbox_enable = FALSE;
	}
	else
	{
		textbox_ptr->textbox_attr.textbox_visible = TRUE;
        if (ve_email_name_status.dbid == email_dbid)
            textbox_ptr->textbox_back_line = GREY_LINE;
        else textbox_ptr->textbox_back_line = NO_LINE;
		
		if (ve_email_name_status.new_record == FALSE && ve_email_name_status.dbid == pb_dbid)
			textbox_ptr->textbox_attr.textbox_enable = FALSE;
		else
			textbox_ptr->textbox_attr.textbox_enable = TRUE;
	}
	
	/* Initialisation of FIELD_C_EMAIL */
	FormGetObjectPointer(FIELD_C_EMAIL, &object_type, (void **)&field_ptr);
	field_ptr->field_attr.field_visible = TRUE;
	if (ve_email_name_status.status == VIEW)
	{
		field_ptr->field_back_line = NO_LINE;
		field_ptr->field_attr.field_enable = FALSE;
	}
	else
	{
		if (new_name_in_action == MAIL_LIST)
		{
			field_ptr->field_back_line = NO_LINE;
			field_ptr->field_attr.field_enable = FALSE;
		}
		else
		{
			field_ptr->field_back_line = GREY_LINE;
			field_ptr->field_attr.field_enable = TRUE;			
		}			
	}
	
	/* Initialisation of FIELD_H_EMAIL */
	FormGetObjectPointer(FIELD_H_EMAIL, &object_type, (void **)&field_ptr);
	if (ve_email_name_status.home == TRUE) field_ptr->field_attr.field_visible = TRUE;
	else field_ptr->field_attr.field_visible = FALSE;
	if (ve_email_name_status.status == VIEW)
	{
		field_ptr->field_back_line = NO_LINE;
		field_ptr->field_attr.field_enable = FALSE;
	}
	else
	{
		if (new_name_in_action == MAIL_LIST)
		{
			field_ptr->field_back_line = NO_LINE;
			field_ptr->field_attr.field_enable = FALSE;
		}
		else
		{
			field_ptr->field_back_line = GREY_LINE;
			field_ptr->field_attr.field_enable = TRUE;			
		}			
	}
	
	/* Initialisation of STRING_C_EMAIL_1 */
	FormGetObjectPointer(STRING_C_EMAIL_1, &object_type, (void **)&string_ptr);
	string_ptr->string_attr.string_visible = TRUE;
	
	/* Initialisation of STRING_C_EMAIL_2 */
	FormGetObjectPointer(STRING_C_EMAIL_2, &object_type, (void **)&string_ptr);
	if (ve_email_name_status.new_record == TRUE || (ve_email_name_status.new_record == FALSE && ve_email_name_status.dbid == email_dbid))
		string_ptr->string_attr.string_visible = FALSE;
    else string_ptr->string_attr.string_visible = FALSE;
	
	/* Initialisation of STRING_H_EMAIL_1 */
	FormGetObjectPointer(STRING_H_EMAIL_1, &object_type, (void **)&string_ptr);
	if (ve_email_name_status.new_record == TRUE || (ve_email_name_status.new_record == FALSE && ve_email_name_status.dbid == email_dbid))
		string_ptr->string_attr.string_visible = FALSE;
	else string_ptr->string_attr.string_visible = TRUE;
	
	/* Initialisation of STRING_H_EMAIL_2 */
	FormGetObjectPointer(STRING_H_EMAIL_2, &object_type, (void **)&string_ptr);
	if (ve_email_name_status.new_record == TRUE || (ve_email_name_status.new_record == FALSE && ve_email_name_status.dbid == email_dbid))
		string_ptr->string_attr.string_visible = FALSE;
    else string_ptr->string_attr.string_visible = FALSE;
	
	/* Initialisation of STRING_VE */
	FormGetObjectPointer(STRING_VE, &object_type, (void **)&string_ptr);
	if (ve_email_name_status.new_record == TRUE || (ve_email_name_status.new_record == FALSE && ve_email_name_status.dbid == email_dbid))
		string_ptr->string_attr.string_visible = FALSE;
	else string_ptr->string_attr.string_visible = TRUE;
	
	FormGetObjectPointer(FIELD_C_EMAIL, &object_type, (void **)&field_ptr);
	field_length1= strlen(field_ptr->field_string);
	FormGetObjectPointer(FIELD_H_EMAIL, &object_type, (void **)&field_ptr);
	field_length2= strlen(field_ptr->field_string);
	
	
	/* Initialisation of CHECKBOX_VE_C */
	FormGetObjectPointer(CHECKBOX_VE_C, &object_type, (void **)&control_ptr);
	if (ve_email_name_status.status == VIEW)
		control_ptr->control_attr.control_enable = FALSE;
	else control_ptr->control_attr.control_enable = TRUE;
	if (ve_email_name_status.new_record == FALSE && field_length1 >0 && field_length2 >0)
		control_ptr->control_attr.control_visible = TRUE;
	else
		control_ptr->control_attr.control_visible = FALSE;
	
	/* Initialisation of CHECKBOX_VE_H */
	FormGetObjectPointer(CHECKBOX_VE_H, &object_type, (void **)&control_ptr);
	if (ve_email_name_status.status == VIEW)
		control_ptr->control_attr.control_enable = FALSE;
	else control_ptr->control_attr.control_enable = TRUE;
	if (ve_email_name_status.new_record == FALSE && field_length1 >0 && field_length2 >0)
		control_ptr->control_attr.control_visible = TRUE;
	else
		control_ptr->control_attr.control_visible = FALSE;
	
	/* Initialisation of STRING_VE_C */
	FormGetObjectPointer(STRING_VE_C, &object_type, (void **)&string_ptr);
	if (ve_email_name_status.new_record == FALSE && field_length1 >0 && field_length2 >0)
		string_ptr->string_attr.string_visible = TRUE;
	else string_ptr->string_attr.string_visible = FALSE;
	
	/* Initialisation of STRING_VE_H */
	FormGetObjectPointer(STRING_VE_H, &object_type, (void **)&string_ptr);
	if (ve_email_name_status.new_record == FALSE && field_length1 >0 && field_length2 >0)
		string_ptr->string_attr.string_visible = TRUE;
	else string_ptr->string_attr.string_visible = FALSE;
	
	/* Initialisation of STRING_VE_DEFAULT */
	FormGetObjectPointer(STRING_VE_DEFAULT, &object_type, (void **)&string_ptr);
	if (ve_email_name_status.new_record == FALSE && (field_length1 ==0 || field_length2 ==0) &&
		ve_email_name_status.dbid == pb_dbid)
	{
		string_ptr->string_attr.string_visible = TRUE;
		if (field_length1 == 0 && field_length2 == 0)
		{
			FormSetControlGroupSelection(FORM_VE_EMAIL_NAME, CHECKBOX_VE_C);
			StringSetText(STRING_VE_DEFAULT,EMNONE);
		}
		else if (field_length1 > 0 && field_length2 == 0)
		{
			FormSetControlGroupSelection(FORM_VE_EMAIL_NAME, CHECKBOX_VE_C);		
			StringSetText(STRING_VE_DEFAULT,EMCOM);
		}
		else
		{
			FormSetControlGroupSelection(FORM_VE_EMAIL_NAME, CHECKBOX_VE_H);
			StringSetText(STRING_VE_DEFAULT,EMHOME);
		}
	}
	else string_ptr->string_attr.string_visible = FALSE;
	
	/* Initialisation of BUTTON_VE_DEL */
	FormGetObjectPointer(BUTTON_VE_DEL, &object_type, (void **)&control_ptr);
	if (ve_email_name_status.new_record == TRUE || ve_email_name_status.status == EDIT)
	{
		control_ptr->control_attr.control_enable = FALSE;
		control_ptr->control_attr.control_visible = FALSE;
	}
	else
	{
		control_ptr->control_attr.control_visible = TRUE;
		control_ptr->control_attr.control_enable = TRUE;
	}
	return TRUE;
}

/********************************************************
* Function:	EmailVEEmailNameDrawObjects
* Purpose: 	This fucntion is called in order to draw
particular objects in the upper region again
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	
*********************************************************/
BOOLEAN EmailVEEmailNameDrawObjects()
{
	USHORT num_objects;
	BYTE object_type;
	void *addr;
	USHORT count;
	ObjectBounds bounds;
	ObjectID object_id;
	
	FormGetObjectPointer(FORM_VE_EMAIL_NAME, &object_type, (void**)&addr);
	num_objects = ((Form*)addr)->form_num_objects;
	
	bounds.xcoord = 3;
	bounds.ycoord = 75;
	bounds.width = 150;
	bounds.height = 23; 
	LcdEraseRegion(&bounds);
	
	for (count = 0; count < num_objects; count++)
	{
		object_id = ((Form*)addr)->form_objects_list[count].object_id;
		object_type = ((Form*)addr)->form_objects_list[count].object_type;
		
		switch (object_type)
		{
		case STRING:
			if (object_id == STRING_VE || object_id == STRING_VE_C ||
				object_id == STRING_VE_H || object_id == STRING_VE_DEFAULT)
				StringDrawString(object_id);
			break;
		case CONTROL:
			if (object_id == CHECKBOX_VE_C || CHECKBOX_VE_H)
				ControlDrawControl(object_id);
			break;
		default: break;
		}
	}
	return TRUE;
}

/********************************************************
* Function:	EmailVEEmailNameSaveRecord
* Purpose: 	This function is called in order to save the edited 
record 
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	
*********************************************************/
BOOLEAN EmailVEEmailNameSaveRecord()
{
	BYTE *cate_name = NULL;
	UBYTE cate_num;
	RecordID rec_id;
	SHORT item_num;
	UWORD rec_num;
	BYTE object_type;
	Textbox *textbox_ptr, *textbox_ptr1;
	Field *field_ptr, *field_ptr1;
    BYTE whole_name[200];
	BOOLEAN control_value;
	
	if (ve_email_name_status.new_record == TRUE)
	{
		ControlPopupGetSelectedItem(POPUP_TRIGGER_CATE, &item_num);
		if ((item_num == -1) || (item_num == 0))
		{
			DataNewRecord(email_dbid,0,4,&rec_id);
			if (save_cate != NULL)
				qfree(save_cate);
			save_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
			strcpy(save_cate, EMUNFILED);
		}
		else
		{
			ControlPopupGetPopupItem(POPUP_TRIGGER_CATE, item_num, &cate_name);
			EmailCateNameToNum(email_dbid, cate_name, &cate_num);
			DataNewRecord(email_dbid,cate_num,4,&rec_id);
			if (save_cate != NULL)
				qfree(save_cate);
			save_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
			strcpy(save_cate, cate_name);
		}
		ve_email_name_status.dbid = email_dbid;
		ve_email_name_status.rec_id = rec_id;
	}
	else
	{
        if (DataRecordInfo(ve_email_name_status.dbid, ve_email_name_status.rec_id,
			NULL, NULL, NULL, NULL, NULL) != TRUE)
        {
            DataNewRecord(ve_email_name_status.dbid, 0,4,&rec_id);
            ve_email_name_status.rec_id = rec_id;
        }
        else
        {
            DataRecIDtoNum(ve_email_name_status.dbid, ve_email_name_status.rec_id, &rec_num);
            DataOpenRecord(ve_email_name_status.dbid, rec_num, &rec_id, NULL);
        }
		ControlPopupGetSelectedItem(POPUP_TRIGGER_CATE, &item_num);
		if ((item_num == -1) || (item_num == 0))
		{
			if (save_cate != NULL)
				qfree(save_cate);
			save_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
			DataCategoryName(email_dbid, 0, save_cate);
			if (ve_email_name_status.dbid == email_dbid)
				DataSetRecordAttribute(ve_email_name_status.dbid, ve_email_name_status.rec_id,
				ATTR_UNCHG, ATTR_UNCHG, 0);
			else DataWriteField(ve_email_name_status.dbid, ve_email_name_status.rec_id,
				26, 1, (BYTE*)("\0"));
		}
		else
		{
			ControlPopupGetPopupItem(POPUP_TRIGGER_CATE, item_num, &cate_name);
			if (save_cate != NULL)
				qfree(save_cate);
			save_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
			strcpy(save_cate, cate_name);
			EmailCateNameToNum(email_dbid, cate_name, &cate_num);
			if (ve_email_name_status.dbid == email_dbid)
				DataSetRecordAttribute(ve_email_name_status.dbid, ve_email_name_status.rec_id, ATTR_UNCHG, ATTR_UNCHG, cate_num);
			else DataWriteField(ve_email_name_status.dbid, ve_email_name_status.rec_id, 26, 1, (BYTE*)(&cate_num));
		}
	}
	FormGetObjectPointer(TEXTBOX_LAST_NAME, &object_type, (void**)&textbox_ptr);
	FormGetObjectPointer(TEXTBOX_FIRST_NAME, &object_type, (void**)&textbox_ptr1);
	FormGetObjectPointer(FIELD_C_EMAIL, &object_type, (void**)&field_ptr);
	FormGetObjectPointer(FIELD_H_EMAIL, &object_type, (void**)&field_ptr1);
	save_first_letter = *(textbox_ptr->textbox_string);
	DataWriteField(ve_email_name_status.dbid,
		ve_email_name_status.rec_id,
		0,(strlen(textbox_ptr1->textbox_string) + 1),textbox_ptr1->textbox_string);
	DataWriteField(ve_email_name_status.dbid,
		ve_email_name_status.rec_id,
		1,(strlen(textbox_ptr->textbox_string) + 1),textbox_ptr->textbox_string);
	
	//EmailCombineFirstLastName(textbox_ptr1->textbox_string, textbox_ptr->textbox_string, &whole_name);	
	if (strlen(textbox_ptr->textbox_string) == 0 || strlen(textbox_ptr1->textbox_string) == 0)
		PhonebookPrepareLastFirstNameForDisplay(textbox_ptr1->textbox_string, textbox_ptr->textbox_string, whole_name);
	else PhonebookPrepareLastFirstNameForDisplay1(textbox_ptr1->textbox_string, textbox_ptr->textbox_string, whole_name);
	
	DataWriteField(ve_email_name_status.dbid,
		ve_email_name_status.rec_id,
		2,(strlen(whole_name) + 1),whole_name);
	//qfree(whole_name);
	if (ve_email_name_status.dbid == email_dbid)
		DataWriteField(ve_email_name_status.dbid,
					   ve_email_name_status.rec_id,
					   3,(strlen(field_ptr->field_string) + 1),field_ptr->field_string);
	else
	{
		DataWriteField(ve_email_name_status.dbid,
			ve_email_name_status.rec_id,
			8,(strlen(field_ptr->field_string) + 1),field_ptr->field_string);
		DataWriteField(ve_email_name_status.dbid,
			ve_email_name_status.rec_id,
			22,(strlen(field_ptr1->field_string) + 1),field_ptr1->field_string);
		FormGetControlValue(CHECKBOX_VE_C, &control_value);
		if (control_value == TRUE)
			DataSetRecordAttribute(ve_email_name_status.dbid, ve_email_name_status.rec_id, ATTR_SET, ATTR_UNCHG, 0xFF);		
		else 
			DataSetRecordAttribute(ve_email_name_status.dbid, ve_email_name_status.rec_id, ATTR_CLR, ATTR_UNCHG, 0xFF);		
	}
	DataCloseRecord(pb_dbid,rec_id);
	return TRUE;
}


/********************************************************
* Function:	EmailCombineFirstLastName
* Purpose: 	This function is called in order to combine two text strings
into one
* Scope:		application
* Input:		in_string1
*				in_string2
* Output:		out_string
* Return:		TRUE		Success
FALSE		NotHandled
* Comment: 	
*********************************************************/
void EmailCombineFirstLastName(BYTE *in_string1, BYTE *in_string2, BYTE **out_string)
{
	BYTE *temp, *temp1;
	
	temp = (BYTE*)qmalloc((strlen(in_string1) + strlen(in_string2) + 2)*sizeof(BYTE));			
	temp1 = temp;
	if (strlen(in_string1) != 0)
	{
		strcpy(temp,in_string1);
		temp += strlen(in_string1);
		*temp = 32;
		temp++;
	}
	strcpy(temp,in_string2);
	*out_string = (BYTE*)qmalloc((strlen(temp1) + 1)*sizeof(BYTE));
	if (*temp1 >= 97 && *temp1 <= 122)
		*temp1 -= 32;
	strcpy(*out_string,temp1);
	qfree(temp1);
}

/********************************************************
* Function:	EmailVEEmailNameCheckRecordEmpty
* Purpose: 	This function is called to check whether the 
editing screen is all empty or not
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	
*********************************************************/
BOOLEAN EmailVEEmailNameCheckRecordEmpty()
{
	Textbox			*textbox_ptr;
	Field			*field_ptr;
	
	BYTE			object_type;
	
	FormGetObjectPointer(TEXTBOX_LAST_NAME, &object_type, (void**)&textbox_ptr);
	if (strlen(textbox_ptr->textbox_string))
		return FALSE;
	FormGetObjectPointer(TEXTBOX_FIRST_NAME, &object_type, (void**)&textbox_ptr);
	if (strlen(textbox_ptr->textbox_string))
		return FALSE;
	
	if (ve_email_name_status.dbid == email_dbid)
	{
		FormGetObjectPointer(FIELD_C_EMAIL, &object_type, (void**)&field_ptr);
		if (strlen(field_ptr->field_string) == 0)
			return TRUE;
		else return FALSE;
	}
	else
	{
		FormGetObjectPointer(FIELD_C_EMAIL, &object_type, (void**)&field_ptr);
		if (strlen(field_ptr->field_string))
			return FALSE;
		FormGetObjectPointer(FIELD_H_EMAIL, &object_type, (void**)&field_ptr);
		if (strlen(field_ptr->field_string) == 0)
			return TRUE;
		else return FALSE;
	}
}

/********************************************************
* Function:	PhonebookPrepareFirstLastName
* Purpose: 	
* Scope:		application
* Input:		in_string1
*				in_string2
* Output:		None
* Return:		TRUE		Success
FALSE		NotHandled
* Comment: 	The string will be put to field_buffers[0], field_buffers[1] and
field_buffers[2]
*********************************************************/
void PhonebookPrepareFirstLastName(BYTE *in_string1, BYTE *in_string2, BYTE *out_string)
{
	BYTE *temp;
	USHORT count;
	
	temp = out_string;
	
	if (strlen(in_string1) != 0)
	{
		strcpy(temp,in_string1);
		temp += strlen(in_string1);
		*temp = 32;
		temp++;
	}
	strcpy(temp,in_string2);	
}

/********************************************************
* Function:	PhonebookPrepareLastFirstName
* Purpose: 	
* Scope:		application
* Input:		in_string1
*				in_string2
* Output:		None
* Return:		TRUE		Success
FALSE		NotHandled
* Comment: 	The string will be put to field_buffers[0], field_buffers[1] and
field_buffers[2]
*********************************************************/
void PhonebookPrepareLastFirstName(BYTE *in_string1, BYTE *in_string2, BYTE *out_string)
{
	BYTE *temp;
	USHORT count;
	
	temp = out_string;
	
	if (strlen(in_string2) != 0)
	{
		strcpy(temp,in_string2);
		temp += strlen(in_string2);
		*temp = 32;
		temp++;
	}
	strcpy(temp,in_string1);	
}

/********************************************************
* Function:	PhonebookPrepareLastFirstNameForDisplay
* Purpose: 	
* Scope:		application
* Input:		in_string1
*				in_string2
* Output:		None
* Return:		TRUE		Success
FALSE		NotHandled
* Comment: 	The string will be put to field_buffers[0], field_buffers[1] and
field_buffers[2]
*********************************************************/
void PhonebookPrepareLastFirstNameForDisplay(BYTE *in_string1, BYTE *in_string2, BYTE *out_string)
{
	BYTE *temp;
	USHORT count;
	
	temp = out_string;
	
	if (strlen(in_string1) == 0 && strlen(in_string2) == 0)
		out_string[0] = 0;
	else if (strlen(in_string1) != 0 && strlen(in_string2) == 0)
		strcpy(out_string, in_string1);
	else if (strlen(in_string1) == 0 && strlen(in_string2) != 0)
		strcpy(out_string, in_string2);
	else
	{
		strcpy(temp, in_string2);
		temp += strlen(in_string2);
		*temp = ',';
		temp ++;
		*temp = 32;
		temp ++;
		strcpy(temp, in_string1);
	}
}

/********************************************************
* Function:	PhonebookPrepareLastFirstNameForDisplay1
* Purpose: 	
* Scope:		application
* Input:		in_string1
*				in_string2
* Output:		None
* Return:		TRUE		Success
FALSE		NotHandled
* Comment: 	The string will be put to field_buffers[0], field_buffers[1] and
field_buffers[2]
*********************************************************/
void PhonebookPrepareLastFirstNameForDisplay1(BYTE *in_string1, BYTE *in_string2, BYTE *out_string)
{
	BYTE *temp;
	USHORT count;
	
	temp = out_string;
	
	if (strlen(in_string1) == 0 && strlen(in_string2) == 0)
		out_string[0] = 0;
	else if (strlen(in_string1) != 0 && strlen(in_string2) == 0)
		strcpy(out_string, in_string1);
	else
	{
		strcpy(temp, in_string2);
		temp += strlen(in_string2);
		*temp = ',';
		temp ++;
		strcpy(temp, in_string1);
	}
}
