/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   expmain.c
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "platform.h"
#include "expdef.h"
#include "expense.h"
#include "sysetup.h"
#include "system.h"
#include "atod.h"

#ifdef PC_SIM
#include "resource.h"
#include "pdaemu.h"
#include "PdaEmuDlg.h"
extern CPDAEmuDlg* m_EmuDlg;
#endif

//#define DEBUG_MICH
//#define DEBUG
/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
BYTE			OldCatText[20], CatText[20], *CatNameInEdCat, LargeFontInEdcat;
SHORT			CatHighlightInList;
USHORT			prev_row_num, prev_col_num, NewItemNumInList, DelItemNum;
BOOLEAN			dialogX_selected, RenameCat, reset_unDeletedID = FALSE;
ObjectID		ActiveTextboxID;
ObjectID		G_active_form_id;

//t==============================================================
UWORD			G_del_expense_type;
UWORD			G_rename_expense_type;
UWORD			G_add_expense_type;
BYTE			G_today_button_press;

//t==============================================================

extern BYTE		ListHighlightStatus;
extern SHORT	HighlightRecNumInList;
extern WORD		RecIDInList[11];
extern RecordID		NewExpense_rec_id, UnDelete_rec_id, Highlighted_rec_id;

/*****************************************************************
* Function:	ExpenseInitMainGlobal
* Purpose: 	This function is used to initialize the global variables
and being called at start up
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
******************************************************************/
void ExpenseInitMainGlobal(BOOLEAN is_restart)
{
	BYTE	*buffer;
	SHORT	item_num;
	UWORD	byte_read;
	DatabaseID	Expense_dbid;
	
	
	DataFindDB(EXPDB, &Expense_dbid);
	
	if (is_restart)
	{
		prev_row_num = 0;
		prev_col_num = 0;
		NewItemNumInList = EXPENSE_INVALID_REC_NUM;
		RenameCat = FALSE;
		CatText[0] = 0;
		CatHighlightInList = -1;
		DelItemNum = EXPENSE_INVALID_REC_NUM;
		dialogX_selected = FALSE;
		LargeFontInEdcat = 0;
		item_num = 0;
		
		//t==============================================================
		G_del_expense_type = NO_SELECT;
		G_rename_expense_type = NO_SELECT;
		G_add_expense_type = NO_SELECT;
		G_today_button_press = 0;
		//t==============================================================
		
		DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_PopupItemNum, sizeof(SHORT), (BYTE*)&item_num);
		DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_LargeFontInEdcat, sizeof(BYTE), (BYTE*)&LargeFontInEdcat);
		
		ExpenseCatToList(CatText, TRUE);
	}
	else
	{
		
		DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_CatText, &buffer, &byte_read);
		strcpy(CatText, buffer);
		qfree(buffer);
		DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_prev_row_num, &buffer, &byte_read);
		prev_row_num = *(USHORT*)buffer;
		qfree(buffer);
		DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_prev_col_num, &buffer, &byte_read);
		prev_col_num = *(USHORT*)buffer;
		qfree(buffer);
		DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_NewItemNumInList, &buffer, &byte_read);
		NewItemNumInList = *(USHORT*)buffer;
		qfree(buffer);
		DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_DelItemNum, &buffer, &byte_read);
		DelItemNum = *(USHORT*)buffer;
		qfree(buffer);
		DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_dialogX_selected, &buffer, &byte_read);
		dialogX_selected = *(BOOLEAN*)buffer;
		qfree(buffer);
		DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_RenameCat, &buffer, &byte_read);
		RenameCat = *(BOOLEAN*)buffer;
		qfree(buffer);
		DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ActiveTextboxID, &buffer, &byte_read);
		ActiveTextboxID = *(ObjectID*)buffer;
		qfree(buffer);
		DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_CatHighlightInList, &buffer, &byte_read);
		CatHighlightInList = *(SHORT*)buffer;
		qfree(buffer);
		
		//DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ActiveFormID, &buffer, &byte_read);
		ExpenseCatToList(CatText, TRUE);
		//qfree(buffer);
		
		DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_PopupItemNum, &buffer, &byte_read);
		ControlPopupSetSelectedItem(POPUP_EXPENSE_LIST, *(SHORT*)buffer);
		qfree(buffer);
		
		DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_LargeFontInEdcat, &buffer, &byte_read);
		LargeFontInEdcat = *(BYTE*)buffer;
		qfree(buffer);
		
		DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_G_del_expense_type, &buffer, &byte_read);
		G_del_expense_type = *(UWORD*)buffer;
		qfree(buffer);
		DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_G_rename_expense_type, &buffer, &byte_read);
		G_rename_expense_type = *(UWORD*)buffer;
		qfree(buffer);
		DataGetField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_G_add_expense_type, &buffer, &byte_read);
		G_add_expense_type = *(UWORD*)buffer;
		qfree(buffer);
	}
	
	return;
}


/*****************************************************************
* Function:	ExpenseMainAppSave
* Purpose: 	This function is called to save the data in 
the expense database when it is called to stopped
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseMainAppSave(void)
{
	BYTE		*textbox_string, *item_text;
	BYTE		bchar_pos, visible;
	SHORT		item_num;
	WORD		char_pos;
	ObjectID	active_form_id;
	BOOLEAN		drawn_attr, enable_attr, active_attr, visible_attr, set_scroll_attr;
	DatabaseID	Expense_dbid;
	
	
#ifdef DEBUG_MICH
	printf("\n\n In ExpenseMainAppSave()");
#endif
	
	if (!DataFindDB(EXPDB, &Expense_dbid))
		return FALSE;
	
	FormGetActiveFormID(&active_form_id);
	if (active_form_id == FORM_EXPENSE_EDCAT || active_form_id == FORM_EXPENSE_DIALOG_EDCAT 
		|| active_form_id == FORM_EXPENSE_DIALOG_REMOVE || active_form_id == FORM_EXPENSE_DIALOG_EXIST
		|| active_form_id == FORM_EXPENSE_DIALOG_SELCAT)
	{
		// ====================================================================
		// modified at 14062000
		//	    item_num = CatHighlightInList + 1;
		item_num = CatHighlightInList + 2;
		// ====================================================================
	}
	else
    {
		ControlPopupGetSelectedItem(POPUP_EXPENSE_LIST, &item_num);
	}
    ControlPopupGetPopupItem(POPUP_EXPENSE_LIST, (USHORT)item_num, &item_text);
	
    if (item_text[0] == 0)
		CatText[0] = 0;
	else
		strcpy(CatText, item_text);
	if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_PopupItemNum, sizeof(SHORT), (BYTE*)&item_num) != TRUE)
		return FALSE;
	if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_CatText, 20*sizeof(BYTE), (BYTE*)CatText) != TRUE)
		return FALSE;
	if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_CatHighlightInList, sizeof(SHORT), (BYTE*)&CatHighlightInList) != TRUE)
		return FALSE;
	if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_prev_row_num, sizeof(USHORT), (BYTE*)&prev_row_num) != TRUE)
		return FALSE;
	if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_prev_col_num, sizeof(USHORT), (BYTE*)&prev_col_num) != TRUE)
		return FALSE;
	if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_NewItemNumInList, sizeof(USHORT), (BYTE*)&NewItemNumInList) != TRUE)
		return FALSE;
	if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_DelItemNum, sizeof(USHORT), (BYTE*)&DelItemNum) != TRUE)
		return FALSE;
	if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_dialogX_selected, sizeof(BOOLEAN), (BYTE*)&dialogX_selected) != TRUE)
		return FALSE;
	if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_RenameCat, sizeof(BOOLEAN), (BYTE*)&RenameCat) != TRUE)
		return FALSE;
	if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ActiveTextboxID, sizeof(ObjectID), (BYTE*)&ActiveTextboxID) != TRUE)
		return FALSE;
	if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ActiveFormID, sizeof(ObjectID), (BYTE*)&active_form_id) != TRUE)
		return FALSE;
	if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_G_del_expense_type, sizeof(UWORD), (BYTE*)&G_del_expense_type) != TRUE)
		return FALSE;
	if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_G_rename_expense_type, sizeof(UWORD), (BYTE*)&G_rename_expense_type) != TRUE)
		return FALSE;
	if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_G_add_expense_type, sizeof(UWORD), (BYTE*)&G_add_expense_type) != TRUE)
		return FALSE;
	
#ifdef DEBUG_MICH
	printf("\n G_rename_expense_type = %ld", G_rename_expense_type);
	printf("\n G_add_expense_type = %ld", G_add_expense_type);
#endif
	
	if (active_form_id == FORM_EXPENSE_LIST	|| active_form_id == FORM_EXPENSE_DIALOG_SAVE)
	{
		TextboxGetTextPointer(ActiveTextboxID, &textbox_string);
		TextboxGetInsertPointPosition(ActiveTextboxID, &char_pos);
		ListGetAttribute(LIST_EXPENSE_LIST_DATE, &enable_attr, &drawn_attr, &active_attr, &visible_attr, &set_scroll_attr);
		
		if (!enable_attr)
		{
			if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ExpTextboxString, 15*sizeof(BYTE), (BYTE*)textbox_string) != TRUE)
				return FALSE;
			bchar_pos = (BYTE)char_pos;
			if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ExpTextboxCharPos, sizeof(BYTE), (BYTE*)&bchar_pos) != TRUE)
				return FALSE;
		}
	}
	else if(active_form_id == FORM_EXPENSE_DIALOG_INPUT_TYPE)
	{
#ifdef DEBUG_MICH
		printf("\n active_form_id == FORM_EXPENSE_DIALOG_INPUT_TYPE");
#endif
		
		TextboxGetTextPointer(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE, &textbox_string);
		TextboxGetInsertPointPosition(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE, &char_pos);
		
#ifdef DEBUG_MICH
		printf("\n TextboxTextPointer = %s", textbox_string);
		printf("\n InsertPointPosition = %ld", char_pos);
#endif
		
		if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ExpTextboxString, 15*sizeof(BYTE), (BYTE*)textbox_string) != TRUE)
			return FALSE;
		bchar_pos = (BYTE)char_pos;
		if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ExpTextboxCharPos, sizeof(BYTE), (BYTE*)&bchar_pos) != TRUE)
			return FALSE;
	}
	else
	{
		TextboxGetTextPointer(TEXTBOX_EXPENSE_DIALOG_EDCAT, &textbox_string);
		TextboxGetInsertPointPosition(TEXTBOX_EXPENSE_DIALOG_EDCAT, &char_pos);
		if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ExpTextboxString, 15*sizeof(BYTE), (BYTE*)textbox_string) != TRUE)
			return FALSE;
		bchar_pos = (BYTE)char_pos;
		if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ExpTextboxCharPos, sizeof(BYTE), (BYTE*)&bchar_pos) != TRUE)
			return FALSE;
	}
	
	visible = (BYTE)enable_attr;
	if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_ExpKeypadInvisible, sizeof(BYTE), (BYTE*)&visible) != TRUE)
		return FALSE;
	
	if (DataWriteField(Expense_dbid, EXPENSE_MAIN_APP_SAVE, F_LargeFontInEdcat, sizeof(BYTE), (BYTE*)&LargeFontInEdcat) != TRUE)
		return FALSE;
	
	return TRUE;
}



/*****************************************************************
***************** Application Event Handle Function **************
*****************************************************************/


/*****************************************************************
* Function:	ExpenseList
* Purpose: 	This function is the event handler for the list
*				settings page of the expense application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseList(EvtType *Event)
{
	BYTE		null_buf[1] = {0}, null = 0;
	BYTE		*amount_text_ptr, editcate[20], *item_text;
	SHORT		item_num;
	USHORT		num_items, total_items;
	WORD		insert_ptr_pos;
	double		amount;
    static double   static_amount=0.0;
    AppID		app_id;
    BYTE		object_type;
    Textbox		*textbox_ptr;
    ObjectID	active_id;
	
	BYTE		temp[50];
	UWORD		UnDelete_rec_num, byte_read;
	RecordID	UnDelete_temp_rec_id;
	BYTE		*buffer;
	DatabaseID	Expense_dbid;
	Err			Error;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		if (!dialogX_selected)
		{
			//KeyboardSetKeyboardInvisible();
			ControlPopupGetSelectedItem(POPUP_EXPENSE_LIST, &item_num);
			strcpy(editcate, EXPEFOLD);
			strcpy(OldCatText, CatText);
			ControlPopupGetPopupItem(POPUP_EXPENSE_LIST, (USHORT)item_num, &item_text);
			strcpy(CatText, item_text);
			if (!strcmp(CatText, editcate))
			{
				strcpy(CatText, OldCatText);
				ExpenseCatToList(CatText, FALSE);
				FormPopupForm(FORM_EXPENSE_EDCAT);
				return TRUE;
			}
			
			ExpenseLoadRecord(CatText, reset_unDeletedID);
			ExpenseRecordToList(&NewItemNumInList);
			ExpenseKeypadInvisible();
		}
		else
			dialogX_selected = FALSE;
		if (ExpenseIsKeypadVisible())
			ExpenseKeypadInvisible();
		FormDrawForm(FORM_EXPENSE_LIST);
		return TRUE;
		
	case EVT_MENU_SELECT_ITEM:
		if (ExpenseIsKeypadVisible())
			return TRUE;
		
		switch((USHORT)(Event->para1))
		{
		case MENU_ITEM_DELETE:
			ListHighlightStatus = EXPENSE_NO_HIGHLIGHT;
			DelItemNum = HighlightRecNumInList;
			HighlightRecNumInList = (SHORT)EXPENSE_INVALID_REC_NUM;
			if (DelItemNum < EXPENSE_INVALID_REC_NUM)
			{
				if (ExpenseDeleteExpense(DelItemNum) != TRUE)
					return TRUE;
				NewItemNumInList = EXPENSE_INVALID_REC_NUM;
				
				ExpenseLoadRecord(CatText, FALSE);
				ExpenseRecordToList(&NewItemNumInList);
				DelItemNum = NewItemNumInList;
				ActiveTextboxID = NewItemNumInList + TEXTBOX_EXPENSE_LIST_AMT1;
				FormDrawForm(FORM_EXPENSE_LIST);
			}
			else
				return TRUE;
			break;
		case MENU_ITEM_UNDELETE:
			if (UnDelete_rec_id != 0x80001200)
			{
				// ================================================================================
				// modified at 21062000
				DataFindDB(EXPDB, &Expense_dbid);
				DataRecIDtoNum(Expense_dbid, UnDelete_rec_id, &UnDelete_rec_num);
				if (DataOpenRecord(Expense_dbid, UnDelete_rec_num, &UnDelete_temp_rec_id, NULL) == TRUE)
				{
					DataGetField(Expense_dbid, UnDelete_temp_rec_id, F_AMT, &buffer, &byte_read);
					DataWriteField(Expense_dbid, UnDelete_temp_rec_id, F_AMT, sizeof(double), buffer);
					qfree(buffer);
					DataCloseRecord(Expense_dbid, UnDelete_temp_rec_id);
				}
				
				// ================================================================================
				Highlighted_rec_id = UnDelete_rec_id;
				UnDelete_rec_id = 0x80001200;
				ListHighlightStatus = EXPENSE_DATE_HIGHLIGHT;
				HighlightRecNumInList = EXPENSE_INVALID_REC_NUM;
				FormPopupForm(FORM_EXPENSE_LIST);
			}
			break;
		case MENU_ITEM_DELALL:
			ListGetNumItemsDisplay(LIST_EXPENSE_LIST_DATE, &num_items);
			if (num_items > 0)
				FormPopupForm(FORM_EXPENSE_DIALOG_ERASE);
			return TRUE;
			//t==============================================================
			
		case MENU_ITEM_DEL_TYPE:
#ifdef DEBUG
			printf("\n\n MENU_ITEM_DEL_TYPE");
#endif
			// ================================================================================
			// modified at 08072000
			ExpenseLoadExpenseType();
			ListGetTotalItems(LIST_EXPENSE_TYPE_LIST1, &total_items);
			if (total_items)
			{
				G_del_expense_type = 1;
				FormPopupForm(FORM_EXPENSE_TYPE);
			}
			break;
			// ================================================================================
		case MENU_ITEM_RENAME_TYPE:
			ExpenseLoadExpenseType();
			ListGetTotalItems(LIST_EXPENSE_TYPE_LIST1, &total_items);
			if (total_items)
			{
				G_rename_expense_type = 1;
				FormPopupForm(FORM_EXPENSE_TYPE);
			}
			break;
			
		case MENU_ITEM_ADD_TYPE:
			if (ExpenseCheckMemoryEmpty())
			{
				FormPopupForm(FORM_EXPENSE_DIALOG_LOW_MEMORY);
				break;
			}
			G_add_expense_type = 1;
			TextboxSetInsertPointOn(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE);
			TextboxSetText(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE, &null);
			FormPopupForm(FORM_EXPENSE_DIALOG_INPUT_TYPE);
			break;
			
			
			//t==============================================================
			
		default:
			break;
			
		}
		
		return TRUE;
		
		case EVT_CONTROL_POPUP_SELECT:
			switch(Event->eventID)
			{
			case POPUP_EXPENSE_LIST:
			/*					if (ListHighlightStatus == EXPENSE_TYPE_HIGHLIGHT)
			{
			
			  if (ExpenseGetNewExpenseType() == EXPENSE_TYPE)
			  {
			  // =========================================================================
			  // modified at 13062000
			  if (CatHighlightInList > -1)
			  {
			  //								ControlPopupSetSelectedItem(POPUP_EXPENSE_LIST, CatHighlightInList + 1);
			  ControlPopupSetSelectedItem(POPUP_EXPENSE_LIST, CatHighlightInList);
			  }
			  else
			  ControlPopupSetSelectedItem(POPUP_EXPENSE_LIST, 1);
			  // =========================================================================
			  FormPopupForm(FORM_EXPENSE_DIALOG_SELTYPE);
			  return TRUE;
			  }
			  }
				*/
				NewItemNumInList = EXPENSE_INVALID_REC_NUM;
				DelItemNum = EXPENSE_INVALID_REC_NUM;
				HighlightRecNumInList = EXPENSE_INVALID_REC_NUM;
				ExpenseScrollbarSetList(0);
				FormPopupForm(FORM_EXPENSE_LIST);
				return TRUE;
				
			default:	return FALSE;	
			}
			
			case EVT_SCROLLBAR_REPEAT:
				if (Event->para1 == Event->para2)
					return TRUE;
					/*			if (ListHighlightStatus == EXPENSE_TYPE_HIGHLIGHT)
					if (ExpenseGetNewExpenseType() == EXPENSE_TYPE)
					{
					FormPopupForm(FORM_EXPENSE_DIALOG_SELTYPE);
					return TRUE;
					}
				*/
				NewItemNumInList = EXPENSE_INVALID_REC_NUM;
				switch(ListHighlightStatus)
				{
				case EXPENSE_DATE_HIGHLIGHT:
					ListGetSelectedItem(LIST_EXPENSE_LIST_DATE, &HighlightRecNumInList);
					break;
					
				case EXPENSE_TYPE_HIGHLIGHT:
					ListGetSelectedItem(LIST_EXPENSE_LIST_TYPE, &HighlightRecNumInList);
					break;
					
					
				case EXPENSE_CURR_HIGHLIGHT:
					ListGetSelectedItem(LIST_EXPENSE_LIST_CURR, &HighlightRecNumInList);
					break;
					
				default:
					HighlightRecNumInList = -1;
				}
				ExpenseScrollbarSetList((USHORT)Event->para2);
				FormDrawForm(FORM_EXPENSE_LIST);
				return TRUE;
				
#ifdef PR31700
				case EVT_IO_KEY_CTRL:
					if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
					{
						if (Event->para2 == IO_UP_ARROW)
							ScrollbarHardButtonSetScrollbar(SCROLLBAR_EXPENSE_LIST, SCROLLBAR_UP_ARROW);
						else if (Event->para2 == IO_DOWN_ARROW)
							ScrollbarHardButtonSetScrollbar(SCROLLBAR_EXPENSE_LIST, SCROLLBAR_DOWN_ARROW);
						return TRUE;
					}
					return FALSE;
#endif
					
				case EVT_SCROLLBAR_SELECT:
					ScrollbarDrawScrollbar((USHORT)Event->eventID);
					/*
					if (ListHighlightStatus == EXPENSE_TYPE_HIGHLIGHT)
					if (ExpenseGetNewExpenseType() == EXPENSE_TYPE)
					{
					FormPopupForm(FORM_EXPENSE_DIALOG_SELTYPE);
					return TRUE;
					}
					NewItemNumInList = EXPENSE_INVALID_REC_NUM;
					switch(ListHighlightStatus)
					{
					case EXPENSE_DATE_HIGHLIGHT:
					ListGetSelectedItem(LIST_EXPENSE_LIST_DATE, &HighlightRecNumInList);
					break;
					
					  case EXPENSE_TYPE_HIGHLIGHT:
					  ListGetSelectedItem(LIST_EXPENSE_LIST_TYPE, &HighlightRecNumInList);
					  break;
					  
						case EXPENSE_CURR_HIGHLIGHT:
						ListGetSelectedItem(LIST_EXPENSE_LIST_CURR, &HighlightRecNumInList);
						break;
						
						  default:
						  HighlightRecNumInList = -1;
						  }
						  ExpenseScrollbarSetList((USHORT)Event->para2);
						  FormDrawForm(FORM_EXPENSE_LIST);
					*/			return TRUE;
					
				case EVT_CONTROL_SELECT:
					switch(Event->eventID)
					{	
					case BUTTON_EXPENSE_LIST_NEW:
#ifdef DEBUG_MICH
						printf("\n In ExpenseList()");
						printf("\n New entry");
#endif
						if (ExpenseCheckMemoryEmpty())
						{
							FormPopupForm(FORM_EXPENSE_DIALOG_LOW_MEMORY);
							return TRUE;
						}
						
						
#ifdef DEBUG_MICH
						printf("\n ListHighlightStatus = %ld", ListHighlightStatus);
#endif
						/*	if (ListHighlightStatus == EXPENSE_TYPE_HIGHLIGHT)
						if (ExpenseGetNewExpenseType() == EXPENSE_TYPE)
						{
						FormPopupForm(FORM_EXPENSE_DIALOG_SELTYPE);
						return TRUE;
						}
						*/
						static_amount = 0.0;
						ControlPopupGetSelectedItem(POPUP_EXPENSE_LIST, &item_num);
						if (item_num < 1)
							return TRUE;
						
						if (ExpenseNewExpense() != TRUE)
						{
#ifdef DEBUG_MICH
							Error = ExpenseNewExpense();
							printf("\n Error = %ld", Error);
							printf("\n NewExpenseTypeRecID = %ld", NewExpense_rec_id);
#endif
							return TRUE;
						}
						
#ifdef DEBUG_MICH
						printf("\n NewExpenseTypeRecID = %ld", NewExpense_rec_id);
#endif
						ExpenseKeypadVisible();
						KeyboardSetKeyboardInvisible();
						ExpenseLoadRecord(CatText, FALSE);
						ExpenseRecordToList(&NewItemNumInList);
						
#ifdef DEBUG_MICH
						printf("\n NewItemNumInList = %ld", NewItemNumInList);
#endif
						
						
						DelItemNum = NewItemNumInList;
						ActiveTextboxID = NewItemNumInList + TEXTBOX_EXPENSE_LIST_AMT1;
						FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
						for(item_num=TEXTBOX_EXPENSE_LIST_AMT1; item_num<=TEXTBOX_EXPENSE_LIST_AMT11; item_num++)
							TextboxDrawTextbox(item_num);
						StringDrawString(STRING_EXPENSE_LIST_TOTAL);
						StringDrawString(STRING_EXPENSE_LIST_TOTAL_AMT);
						StringDrawString(STRING_EXPENSE_LIST_HEADER);
						ControlDrawControl(BUTTON_EXPENSE_LIST_NEW);
						ListDrawList(LIST_EXPENSE_LIST_CURR);
						//FormDrawForm(FORM_EXPENSE_LIST);
						return TRUE;
						/*
						case BUTTON_EXPENSE_LIST_DEL:
						ListHighlightStatus = EXPENSE_NO_HIGHLIGHT;
						// ----------------------------------------------------------------------**
						// --------------------------------------------------------- NewEdit 041799
						DelItemNum = HighlightRecNumInList;
						// ----------------------------------------------------------------------**
						HighlightRecNumInList = (SHORT)EXPENSE_INVALID_REC_NUM;
						if (DelItemNum < EXPENSE_INVALID_REC_NUM)
						{
						if (ExpenseDeleteExpense(DelItemNum) != TRUE)
						return TRUE;
						//ExpenseSetCatPopupEnable();
						// ----------------------------------------------------------------------**
						// --------------------------------------------------------- NewEdit 041799
						NewItemNumInList = EXPENSE_INVALID_REC_NUM;
						// ----------------------------------------------------------------------**
						break;
						}
						else
						return TRUE;
						
						  case BUTTON_EXPENSE_LIST_DELALL:
						  ListGetNumItemsDisplay(LIST_EXPENSE_LIST_DATE, &num_items);
						  if (num_items > 0)
						  FormPopupForm(FORM_EXPENSE_DIALOG_ERASE);
						  return TRUE;
						*/
						
					default:	return FALSE;
					}
					return TRUE;
					
					
					case EVT_LIST_SELECT:
						//------------------------------------------------------New edit 040299
						
						//			if (Event->para1 == NewItemNumInList)
						if (Event->para1 == HighlightRecNumInList)
						{
							switch(Event->eventID)
							{
							case LIST_EXPENSE_LIST_DATE:
							/*						if (ListHighlightStatus == EXPENSE_TYPE_HIGHLIGHT)
							if (ExpenseGetNewExpenseType() == EXPENSE_TYPE)
							{
							FormPopupForm(FORM_EXPENSE_DIALOG_SELTYPE);
							return TRUE;					
							}
								*/
								ListHighlightStatus = EXPENSE_DATE_HIGHLIGHT;
								ListGetSelectedItem(LIST_EXPENSE_LIST_DATE, &HighlightRecNumInList);
								FormPopupForm(FORM_EXPENSE_DATE);
								return TRUE;
								
							case LIST_EXPENSE_LIST_TYPE:
								ListHighlightStatus = EXPENSE_TYPE_HIGHLIGHT;
								ListGetSelectedItem(LIST_EXPENSE_LIST_TYPE, &HighlightRecNumInList);
								FormPopupForm(FORM_EXPENSE_TYPE);
								return TRUE;
								
							case LIST_EXPENSE_LIST_CURR:
							/*						if (ListHighlightStatus == EXPENSE_TYPE_HIGHLIGHT)
							if (ExpenseGetNewExpenseType() == EXPENSE_TYPE)
							{
							FormPopupForm(FORM_EXPENSE_DIALOG_SELTYPE);
							return TRUE;					
							}*/
								ListHighlightStatus = EXPENSE_CURR_HIGHLIGHT;
								ListGetSelectedItem(LIST_EXPENSE_LIST_CURR, &HighlightRecNumInList);
								FormPopupForm(FORM_EXPENSE_CURR);
								return TRUE;
								
							default:	return FALSE;
							}
						}
						else
						{
						/*				if (ListHighlightStatus == EXPENSE_TYPE_HIGHLIGHT)
						if (ExpenseGetNewExpenseType() == EXPENSE_TYPE)
						{
						FormPopupForm(FORM_EXPENSE_DIALOG_SELTYPE);
						return TRUE;					
						}*/
							switch(Event->eventID)
							{
							case LIST_EXPENSE_LIST_DATE:
								HighlightRecNumInList = (USHORT)Event->para1;
								NewExpense_rec_id = RecIDInList[HighlightRecNumInList];
								DelItemNum = (USHORT)Event->para1;
								NewItemNumInList = EXPENSE_INVALID_REC_NUM;
								//						ListGetSelectedItem(LIST_EXPENSE_LIST_DATE, &HighlightRecNumInList);
								ListHighlightStatus = EXPENSE_DATE_HIGHLIGHT;
								ListSetHighlightedItem(LIST_EXPENSE_LIST_DATE, HighlightRecNumInList);					
								ListDrawList((USHORT)Event->eventID);
								return TRUE;
								
							case LIST_EXPENSE_LIST_TYPE:
								HighlightRecNumInList = (USHORT)Event->para1;
								NewExpense_rec_id = RecIDInList[HighlightRecNumInList];
								DelItemNum = (USHORT)Event->para1;
								NewItemNumInList = EXPENSE_INVALID_REC_NUM;
								//						ListGetSelectedItem(LIST_EXPENSE_LIST_TYPE, &HighlightRecNumInList);
								ListHighlightStatus = EXPENSE_TYPE_HIGHLIGHT;
								ListSetHighlightedItem(LIST_EXPENSE_LIST_TYPE, HighlightRecNumInList);
								ListDrawList((USHORT)Event->eventID);
								return TRUE;
								
							case LIST_EXPENSE_LIST_CURR:
								ListGetNumItemsDisplay(LIST_EXPENSE_LIST_DATE, &num_items);
								//						ListGetSelectedItem(LIST_EXPENSE_LIST_CURR, &item_num);
								if ((USHORT)Event->para1 < 11 && (USHORT)Event->para1 < num_items)
								{
									//							NewItemNumInList = (USHORT)Event->para1;
									//							NewExpense_rec_id = RecIDInList[NewItemNumInList];
									ListHighlightStatus = EXPENSE_CURR_HIGHLIGHT;
									ListGetListItem(LIST_EXPENSE_LIST_CURR, (USHORT)Event->para1, &amount_text_ptr);
									if (*amount_text_ptr != 0)
									{
										HighlightRecNumInList = (USHORT)Event->para1;
										NewExpense_rec_id = RecIDInList[HighlightRecNumInList];
										DelItemNum = (USHORT)Event->para1;
										NewItemNumInList = EXPENSE_INVALID_REC_NUM;
										
										ListSetHighlightedItem(LIST_EXPENSE_LIST_CURR, HighlightRecNumInList);
										ListDrawList((USHORT)Event->eventID);
									}
									//							FormPopupForm(FORM_EXPENSE_CURR);
									return TRUE;
								}
								
								HighlightRecNumInList = EXPENSE_INVALID_REC_NUM;
								NewExpense_rec_id = HighlightRecNumInList;
								NewItemNumInList = EXPENSE_INVALID_REC_NUM;
								ListHighlightStatus = EXPENSE_NO_HIGHLIGHT;
								
								if(Event->para1 == 11)
									FormPopupForm(FORM_EXPENSE_CURR);
								
								return TRUE;
								
							default:	return FALSE;
							}
							return TRUE;
						}
						//---------------------------------------------------------------------------------------
						
		case EVT_TEXTBOX_SELECT:
			FormGetObjectPointer((SHORT)Event->eventID, &object_type, (void**)&textbox_ptr);
			if (textbox_ptr->textbox_highlight_length < 0)
				insert_ptr_pos = -textbox_ptr->textbox_highlight_length;
			else
				insert_ptr_pos = textbox_ptr->textbox_highlight_length;
			if (insert_ptr_pos != textbox_ptr->textbox_num_chars_displayed)
			{
				textbox_ptr->textbox_highlight_start_char = 0;
				textbox_ptr->textbox_highlight_end_char = 0;
				textbox_ptr->textbox_highlight_length = 0;
				textbox_ptr->textbox_attr.textbox_highlight = FALSE;
				TextboxDrawTextbox((SHORT)Event->eventID);
				// bug fixed - 140400
				TextboxSetInsertPointOn((SHORT)Event->eventID);
				//			TextboxSetInsertPointOn(ActiveTextboxID);
			}
			
			if (ExpenseIsKeypadVisible())
			{
				if (ActiveTextboxID == Event->eventID)
					return TRUE;
				// ----------------------------------------------------------------------------------------**
				// ----------------------------------------------------------------------------- New Edit 042699
				FormGetObjectPointer((SHORT)Event->eventID, &object_type, (void**)&textbox_ptr);
				textbox_ptr->textbox_highlight_start_char = 0;
				textbox_ptr->textbox_highlight_end_char = 0;
				textbox_ptr->textbox_highlight_length = 0;
				textbox_ptr->textbox_attr.textbox_highlight = FALSE;
				TextboxDrawTextbox((SHORT)Event->eventID);
				// ----------------------------------------------------------------------------------------**
				
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				TextboxSetInsertPointOn(ActiveTextboxID);
				
				return TRUE;
			}
			/*		if (ListHighlightStatus == EXPENSE_TYPE_HIGHLIGHT)
			if (ExpenseGetNewExpenseType() == EXPENSE_TYPE)
			{
			FormPopupForm(FORM_EXPENSE_DIALOG_SELTYPE);
			return TRUE;
				}*/
			ListGetNumOfItems(LIST_EXPENSE_LIST_DATE, &num_items);
			if (num_items < (USHORT)(Event->eventID - TEXTBOX_EXPENSE_LIST_AMT1 + 1))
			{
				TextboxSetInsertPointOff((ObjectID)Event->eventID);
				return TRUE;
			}
			ActiveTextboxID = (ObjectID)Event->eventID;		
			TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
			static_amount = atod((const char*)amount_text_ptr);
			//			static_amount = atod((const char*)sbuf);
			
			ListHighlightStatus = EXPENSE_OLD_AMT_HIGHLIGHT;
			//			NewItemNumInList = EXPENSE_INVALID_REC_NUM;
			HighlightRecNumInList =  ActiveTextboxID - TEXTBOX_EXPENSE_LIST_AMT1;
			NewItemNumInList = (USHORT)(Event->eventID - TEXTBOX_EXPENSE_LIST_AMT1);
			NewExpense_rec_id = RecIDInList[NewItemNumInList];
			ExpenseKeypadVisible();
			// ==================================================
			// modified at 28062000
			KeyboardSetKeyboardInvisible();
			// ==================================================
			FormDrawForm(FORM_EXPENSE_LIST);
			return TRUE;
			
			
		case EVT_KEY:
			if (Event->para2 & 0x00000300)
				return TRUE;
			
			FormGetActiveObject(FORM_EXPENSE_LIST, &active_id);
			if (active_id < TEXTBOX_EXPENSE_LIST_AMT1 || active_id > TEXTBOX_EXPENSE_LIST_AMT11)
				return TRUE;			
			if (Event->eventID == SOFT_KEY)
			{
				switch(Event->para1)
				{
				case '\r':
				case '\n':
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EXPENSE_LIST_KEYEN, 0, 0, NULL);
					break;					
				case '0':
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EXPENSE_LIST_KEY0, 0, 0, NULL);
					break;
				case '1':
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EXPENSE_LIST_KEY1, 0, 0, NULL);
					break;
				case '2':
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EXPENSE_LIST_KEY2, 0, 0, NULL);
					break;
				case '3':
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EXPENSE_LIST_KEY3, 0, 0, NULL);
					break;
				case '4':
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EXPENSE_LIST_KEY4, 0, 0, NULL);
					break;
				case '5':
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EXPENSE_LIST_KEY5, 0, 0, NULL);
					break;
				case '6':
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EXPENSE_LIST_KEY6, 0, 0, NULL);
					break;
				case '7':
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EXPENSE_LIST_KEY7, 0, 0, NULL);
					break;
				case '8':
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EXPENSE_LIST_KEY8, 0, 0, NULL);
					break;
				case '9':
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EXPENSE_LIST_KEY9, 0, 0, NULL);
					break;
				case '.':
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EXPENSE_LIST_KEYD, 0, 0, NULL);
					break;
				case KEY_LEFT:
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EXPENSE_LIST_KEYB, 0, 0, NULL);
					break;
				case KEY_BACKSPACE:
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EXPENSE_LIST_KEYC, 0, 0, NULL);
					break;
				case KEY_RIGHT:
					EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EXPENSE_LIST_KEYF, 0, 0, NULL);
					break;
				default:
					break;
				}		
				return TRUE;
			}
			
			
		case EVT_BITMAP_SELECT:	
			FormGetObjectPointer(ActiveTextboxID, &object_type, (void**)&textbox_ptr);
			switch(Event->eventID)
			{
			case BITMAP_EXPENSE_LIST_KEYB:
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				TextboxSetInsertPointOn(ActiveTextboxID);
				KeyboardSendEvent(KEY_LEFT, FALSE, FALSE, FALSE);
				return TRUE;
				
			case BITMAP_EXPENSE_LIST_KEYC:
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				//------ 12082000 ------------
				if (!textbox_ptr->textbox_attr.textbox_highlight)
					TextboxSetInsertPointOn(ActiveTextboxID);
				//----------------------------
				TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
				TextboxGetInsertPointPosition(ActiveTextboxID, &insert_ptr_pos);
				if (insert_ptr_pos > 0)
					insert_ptr_pos--;
				if (amount_text_ptr[insert_ptr_pos] == '.')
				{
					if (amount_text_ptr[insert_ptr_pos+1] != 0)
					{
						if (amount_text_ptr[insert_ptr_pos+2] != 0)
						{
							KeyboardSendEvent(KEY_RIGHT, FALSE, FALSE, FALSE);
							KeyboardSendEvent(KEY_RIGHT, FALSE, FALSE, FALSE);
							KeyboardSendEvent(KEY_BACKSPACE, FALSE, FALSE, FALSE);
							KeyboardSendEvent(KEY_BACKSPACE, FALSE, FALSE, FALSE);
						}
						else
						{
							KeyboardSendEvent(KEY_RIGHT, FALSE, FALSE, FALSE);
							KeyboardSendEvent(KEY_BACKSPACE, FALSE, FALSE, FALSE);
						}
					}
				}
				KeyboardSendEvent(KEY_BACKSPACE, FALSE, FALSE, FALSE);
				return TRUE;
				
			case BITMAP_EXPENSE_LIST_KEYF:
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				TextboxSetInsertPointOn(ActiveTextboxID);
				KeyboardSendEvent(KEY_RIGHT, FALSE, FALSE, FALSE);
				return TRUE;
				
			case BITMAP_EXPENSE_LIST_KEY7:
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				//------ 12082000 ------------
				if (!textbox_ptr->textbox_attr.textbox_highlight)
					TextboxSetInsertPointOn(ActiveTextboxID);
				//----------------------------
				TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
				TextboxGetInsertPointPosition(ActiveTextboxID, &insert_ptr_pos);
				if (ExpenseCheckTextboxDigitOver(ActiveTextboxID, amount_text_ptr, insert_ptr_pos, 2))
					return TRUE;
				TextboxAddKeyInChar(ActiveTextboxID, '7');
				return TRUE;
				
			case BITMAP_EXPENSE_LIST_KEY8:
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				//------ 12082000 ------------
				if (!textbox_ptr->textbox_attr.textbox_highlight)
					TextboxSetInsertPointOn(ActiveTextboxID);
				//----------------------------
				TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
				TextboxGetInsertPointPosition(ActiveTextboxID, &insert_ptr_pos);
				if (ExpenseCheckTextboxDigitOver(ActiveTextboxID, amount_text_ptr, insert_ptr_pos, 2))
					return TRUE;
				TextboxAddKeyInChar(ActiveTextboxID, '8');
				return TRUE;
				
			case BITMAP_EXPENSE_LIST_KEY9:
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				//------ 12082000 ------------
				if (!textbox_ptr->textbox_attr.textbox_highlight)
					TextboxSetInsertPointOn(ActiveTextboxID);
				//-----------------------------
				TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
				TextboxGetInsertPointPosition(ActiveTextboxID, &insert_ptr_pos);
				if (ExpenseCheckTextboxDigitOver(ActiveTextboxID, amount_text_ptr, insert_ptr_pos, 2))
					return TRUE;
				TextboxAddKeyInChar(ActiveTextboxID, '9');
				return TRUE;
				
			case BITMAP_EXPENSE_LIST_KEY4:
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				//------ 12082000 ------------
				if (!textbox_ptr->textbox_attr.textbox_highlight)
					TextboxSetInsertPointOn(ActiveTextboxID);
				//-----------------------------
				TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
				TextboxGetInsertPointPosition(ActiveTextboxID, &insert_ptr_pos);
				if (ExpenseCheckTextboxDigitOver(ActiveTextboxID, amount_text_ptr, insert_ptr_pos, 2))
					return TRUE;
				TextboxAddKeyInChar(ActiveTextboxID, '4');
				return TRUE;
				
			case BITMAP_EXPENSE_LIST_KEY5:
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				//------ 12082000 ------------
				if (!textbox_ptr->textbox_attr.textbox_highlight)
					TextboxSetInsertPointOn(ActiveTextboxID);
				//-----------------------------
				TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
				TextboxGetInsertPointPosition(ActiveTextboxID, &insert_ptr_pos);
				if (ExpenseCheckTextboxDigitOver(ActiveTextboxID, amount_text_ptr, insert_ptr_pos, 2))
					return TRUE;
				TextboxAddKeyInChar(ActiveTextboxID, '5');
				return TRUE;
				
			case BITMAP_EXPENSE_LIST_KEY6:
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				//------ 12082000 ------------
				if (!textbox_ptr->textbox_attr.textbox_highlight)
					TextboxSetInsertPointOn(ActiveTextboxID);
				//----------------------------
				TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
				TextboxGetInsertPointPosition(ActiveTextboxID, &insert_ptr_pos);
				if (ExpenseCheckTextboxDigitOver(ActiveTextboxID, amount_text_ptr, insert_ptr_pos, 2))
					return TRUE;
				TextboxAddKeyInChar(ActiveTextboxID, '6');
				return TRUE;
				
			case BITMAP_EXPENSE_LIST_KEY1:
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				//------ 12082000 ------------
				if (!textbox_ptr->textbox_attr.textbox_highlight)
					TextboxSetInsertPointOn(ActiveTextboxID);
				//----------------------------
				TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
				TextboxGetInsertPointPosition(ActiveTextboxID, &insert_ptr_pos);
				if (ExpenseCheckTextboxDigitOver(ActiveTextboxID, amount_text_ptr, insert_ptr_pos, 2))
					return TRUE;
				TextboxAddKeyInChar(ActiveTextboxID, '1');
				return TRUE;
				
			case BITMAP_EXPENSE_LIST_KEY2:
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				//------ 12082000 ------------
				if (!textbox_ptr->textbox_attr.textbox_highlight)
					TextboxSetInsertPointOn(ActiveTextboxID);
				TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
				TextboxGetInsertPointPosition(ActiveTextboxID, &insert_ptr_pos);
				if (ExpenseCheckTextboxDigitOver(ActiveTextboxID, amount_text_ptr, insert_ptr_pos, 2))
					return TRUE;
				TextboxAddKeyInChar(ActiveTextboxID, '2');
				return TRUE;
				
			case BITMAP_EXPENSE_LIST_KEY3:
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				//------ 12082000 ------------
				if (!textbox_ptr->textbox_attr.textbox_highlight)
					TextboxSetInsertPointOn(ActiveTextboxID);
				//----------------------------
				TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
				TextboxGetInsertPointPosition(ActiveTextboxID, &insert_ptr_pos);
				if (ExpenseCheckTextboxDigitOver(ActiveTextboxID, amount_text_ptr, insert_ptr_pos, 2))
					return TRUE;
				TextboxAddKeyInChar(ActiveTextboxID, '3');
				return TRUE;
				
			case BITMAP_EXPENSE_LIST_KEYD:
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				//------ 12082000 ------------
				if (!textbox_ptr->textbox_attr.textbox_highlight)
					TextboxSetInsertPointOn(ActiveTextboxID);
				//----------------------------
				TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
				TextboxGetInsertPointPosition(ActiveTextboxID, &insert_ptr_pos);
				if (ExpenseCheckTextboxDigitOver(ActiveTextboxID, amount_text_ptr, insert_ptr_pos, 0))
					return TRUE;
				TextboxAddKeyInChar(ActiveTextboxID, '.');
				return TRUE;
				
			case BITMAP_EXPENSE_LIST_KEY0:
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				//------ 12082000 ------------
				if (!textbox_ptr->textbox_attr.textbox_highlight)
					TextboxSetInsertPointOn(ActiveTextboxID);
				//----------------------------
				TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
				TextboxGetInsertPointPosition(ActiveTextboxID, &insert_ptr_pos);
				if (ExpenseCheckTextboxDigitOver(ActiveTextboxID, amount_text_ptr, insert_ptr_pos, 2))
					return TRUE;
				TextboxAddKeyInChar(ActiveTextboxID, '0');
				return TRUE;
				
			case BITMAP_EXPENSE_LIST_KEYA:
				FormSetFormActiveObject(FORM_EXPENSE_LIST, ActiveTextboxID);
				//------ 12082000 ------------
				if (!textbox_ptr->textbox_attr.textbox_highlight)
					TextboxSetInsertPointOn(ActiveTextboxID);
				//----------------------------
				TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
				TextboxGetInsertPointPosition(ActiveTextboxID, &insert_ptr_pos);
				if (ExpenseCheckTextboxDigitOver(ActiveTextboxID, amount_text_ptr, insert_ptr_pos, 1))
					return TRUE;
				TextboxAddKeyInChar(ActiveTextboxID, '0');
				TextboxAddKeyInChar(ActiveTextboxID, '0');
				return TRUE;
				
			case BITMAP_EXPENSE_LIST_KEYEN:
				TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
				item_num = strlen(amount_text_ptr);
				if (item_num < 1)
				{
					TextboxSetInsertPointOn(ActiveTextboxID);
					return TRUE;
				}
				
				item_num--;
				while(item_num > -1)
				{
					if ((amount_text_ptr[item_num] != '.') && !(amount_text_ptr[item_num] >= '0' && amount_text_ptr[item_num] <= '9'))
					{
						TextboxSetInsertPointOn(ActiveTextboxID);
						return TRUE;
					}
					item_num--;
				}
				amount = atod((const char*)amount_text_ptr);
				if (amount >= 0.01)
				{
					//K==================================================
					KeyboardSetKeyboardVisible();
					//K==================================================
					ExpenseSetAmount(ActiveTextboxID - (ObjectID)TEXTBOX_EXPENSE_LIST_AMT1, amount);
					TextboxSetInsertPointOff(ActiveTextboxID);
					ExpenseKeypadInvisible();
					if (ListHighlightStatus == EXPENSE_OLD_AMT_HIGHLIGHT)
					{
						ListHighlightStatus = EXPENSE_CURR_HIGHLIGHT;
						//							ListHighlightStatus = EXPENSE_TYPE_HIGHLIGHT;
						ExpenseSetCatPopupEnable();
						
						HighlightRecNumInList =  ActiveTextboxID - TEXTBOX_EXPENSE_LIST_AMT1;
						ExpenseLoadRecord(CatText, FALSE);
						ExpenseRecordToList(&NewItemNumInList);
						ExpenseKeypadInvisible();
						// ----------------------------------------------------------------------------------------**
						FormGetObjectPointer(ActiveTextboxID, &object_type, (void**)&textbox_ptr);
						textbox_ptr->textbox_highlight_start_char = 0;
						textbox_ptr->textbox_highlight_end_char = 0;
						textbox_ptr->textbox_highlight_length = 0;
						textbox_ptr->textbox_attr.textbox_highlight = FALSE;
						// ----------------------------------------------------------------------------------------**
						FormDrawForm(FORM_EXPENSE_LIST);
						return TRUE;
					}
					else
						ListHighlightStatus = EXPENSE_TYPE_HIGHLIGHT;
					HighlightRecNumInList =  ActiveTextboxID - TEXTBOX_EXPENSE_LIST_AMT1;
					ExpenseLoadRecord(CatText, FALSE);
					ExpenseRecordToList(&NewItemNumInList);
					ExpenseKeypadInvisible();
					// ----------------------------------------------------------------------------------------**
					FormGetObjectPointer(ActiveTextboxID, &object_type, (void**)&textbox_ptr);
					textbox_ptr->textbox_highlight_start_char = 0;
					textbox_ptr->textbox_highlight_end_char = 0;
					textbox_ptr->textbox_highlight_length = 0;
					textbox_ptr->textbox_attr.textbox_highlight = FALSE;
					// ----------------------------------------------------------------------------------------**
					
					ListDrawList(LIST_EXPENSE_LIST_DATE);
					ControlDrawControl(BUTTON_EXPENSE_LIST_NEW);
					FormPopupForm(FORM_EXPENSE_TYPE);
				}
				else
					TextboxSetInsertPointOn(ActiveTextboxID);
				
				return TRUE;
				
			default:	return FALSE;
			}
			
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				// =================================================================
				// modified at 28062000
				//KeyboardSetKeyboardVisible();
				// =================================================================
				if (!ExpenseIsKeypadVisible())
				{
					//						ListHighlightStatus = EXPENSE_NO_HIGHLIGHT;
					//						HighlightRecNumInList =  (SHORT)0x80001000;
					ExpenseAppSave();
					
#ifdef PR31700
					SysGetAppID(MAINMENU, &app_id);
					EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
					EvtAppendEvt(EVT_APP_LAUNCH, app_id, 0, 0, NULL);
#endif
					return TRUE;
				}
				
				EvtAppendEvt(EVT_BITMAP_SELECT, BITMAP_EXPENSE_LIST_KEYEN, 0, 0, NULL);
				return TRUE;
				
			case INLAY_EXIT:
				if (ExpenseIsKeypadVisible())
				{
					TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
					amount = atod((const char*)amount_text_ptr);
					if (static_amount == amount)
					{
						//if (*amount_text_ptr == 0)
						if (amount < 0.01)
						{
							if (DelItemNum < EXPENSE_INVALID_REC_NUM)
							{
								if (ExpenseDeleteExpense(DelItemNum) != TRUE)
									return TRUE;
							}
							ListHighlightStatus = EXPENSE_NO_HIGHLIGHT;
							HighlightRecNumInList = (SHORT)EXPENSE_INVALID_REC_NUM;
							DelItemNum = EXPENSE_INVALID_REC_NUM;
							ExpenseListSetScrollbar();
							// =================================================================
							// modified 26062000
							reset_unDeletedID = TRUE;
							// =================================================================
						}
						else
						{
							ListHighlightStatus = EXPENSE_TYPE_HIGHLIGHT;
							DelItemNum = NewItemNumInList;
							// =================================================================
							// modified 26062000
							reset_unDeletedID = FALSE;
							// =================================================================
						}
						
						// modified at 27052000
						//							reset_unDeletedID = TRUE;
						ExpenseLoadRecord(CatText, reset_unDeletedID);
						reset_unDeletedID = FALSE;
						//dialogX_selected = TRUE;
						ExpenseRecordToList(&NewItemNumInList);
						ActiveTextboxID = NewItemNumInList + TEXTBOX_EXPENSE_LIST_AMT1;
						//							ListHighlightStatus = EXPENSE_NO_HIGHLIGHT;
						//							HighlightRecNumInList = (SHORT)EXPENSE_INVALID_REC_NUM;
						//							ExpenseListSetScrollbar();
						ExpenseSetCatPopupEnable();
						// ----------------------------------------------------------------------------------------**
						// ----------------------------------------------------------------------------- New Edit 042699
						FormGetObjectPointer(ActiveTextboxID, &object_type, (void**)&textbox_ptr);
						textbox_ptr->textbox_highlight_start_char = 0;
						textbox_ptr->textbox_highlight_end_char = 0;
						textbox_ptr->textbox_highlight_length = 0;
						textbox_ptr->textbox_attr.textbox_highlight = FALSE;
						// ----------------------------------------------------------------------------------------**
						// ========================================================================================
						// add at 15062000
						FormSetFormActiveObject(FORM_EXPENSE_LIST, BUTTON_EXPENSE_LIST_NEW);
						// ========================================================================================
						FormPopupForm(FORM_EXPENSE_LIST);
					}
					else
						FormPopupForm(FORM_EXPENSE_DIALOG_SAVE);
				}
				else
				{
					ExpenseAppSave();
#ifdef PR31700
					SysGetAppID(MAINMENU, &app_id);
					EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
					EvtAppendEvt(EVT_APP_LAUNCH, app_id, 0, 0, NULL);
#endif
					return TRUE;
				}
				// =================================================================
				// modified at 28062000
				KeyboardSetKeyboardVisible();
				// =================================================================
				return TRUE;
			}
		default:	return FALSE;	
	}
	return FALSE;
}


/*****************************************************************
* Function:	ExpenseDate
* Purpose: 	This function is the event handler for the date
*				settings page of the expense application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseDate(EvtType *Event)
{
	
	BYTE	*list_string, day_text[3] = {0}, text[60];
	SHORT	year, month, day;
	RTM				time_source;
	EXPENSE_DATE	date;
	CountrySettings country;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		SySetupGetCountrySettings(&country);
		switch(country.start_of_week)
		{
		case SYSETUP_SUN:
			strcpy(text, EXPSTR1);
			break;
		case SYSETUP_MON:
			strcpy(text, EXPSTR2);
			break;
		default:	return FALSE;	
		}
		StringSetText(STRING_EXPENSE_DATE_WDAY, text);
		if (G_today_button_press)
		{
			SySetupRestoreDateSettings(FORM_EXPENSE_DATE, TABLE_EXPENSE_DATE, PUSH_EXPENSE_DATE_Y1, 
				PUSH_EXPENSE_DATE_JAN, &prev_row_num, &prev_col_num);
			
			G_today_button_press = 0;
		}
		else
		{
			ExpRestoreDateSettings(FORM_EXPENSE_DATE, TABLE_EXPENSE_DATE, PUSH_EXPENSE_DATE_Y1,
				PUSH_EXPENSE_DATE_JAN, &prev_row_num, &prev_col_num);
		}
		FormDrawForm(FORM_EXPENSE_DATE);
		return TRUE;
		
		case EVT_BITMAP_SELECT:
			SySetupGetCountrySettings(&country);
			switch (Event->eventID)
			{
			case BITMAP_EXPENSE_DATE_LEFT:
				SySetupDateUpdateYearBar(PUSH_EXPENSE_DATE_Y1, BUTTON_EXPENSE_DATE_DISABLE_BKGRD, SYSETUP_YEAR_LEFT);
				SySetupGetDateSettings(FORM_EXPENSE_DATE, TABLE_EXPENSE_DATE, PUSH_EXPENSE_DATE_JAN, GROUP_ID_EXPENSE_DATE_YEAR,
					GROUP_ID_EXPENSE_DATE_MONTH, prev_row_num, prev_col_num, &year, &month, &day);
				SySetupDateUpdateTable(TABLE_EXPENSE_DATE, year, month, day, (SHORT)country.start_of_week, &prev_row_num, &prev_col_num);
				TableEraseTable(TABLE_EXPENSE_DATE);
				TableDrawTable(TABLE_EXPENSE_DATE);
				return TRUE;
				
			case BITMAP_EXPENSE_DATE_RIGHT:
				SySetupDateUpdateYearBar(PUSH_EXPENSE_DATE_Y1, BUTTON_EXPENSE_DATE_DISABLE_BKGRD, SYSETUP_YEAR_RIGHT);
				SySetupGetDateSettings(FORM_EXPENSE_DATE, TABLE_EXPENSE_DATE, PUSH_EXPENSE_DATE_JAN, GROUP_ID_EXPENSE_DATE_YEAR,
					GROUP_ID_EXPENSE_DATE_MONTH, prev_row_num, prev_col_num, &year, &month, &day);
				SySetupDateUpdateTable(TABLE_EXPENSE_DATE, year, month, day, (SHORT)country.start_of_week, &prev_row_num, &prev_col_num);
				TableEraseTable(TABLE_EXPENSE_DATE);
				TableDrawTable(TABLE_EXPENSE_DATE);
				return TRUE;
				
				
			default:	return FALSE;
			}
			
			case EVT_CONTROL_SELECT:
				switch(Event->eventID)
				{	
				case BUTTON_EXPENSE_DATE_TODAY:
					G_today_button_press = 1;
					FormPopupForm(FORM_EXPENSE_DATE);
					return TRUE;
					
				default:
					SySetupGetCountrySettings(&country);
					SySetupGetDateSettings(FORM_EXPENSE_DATE, TABLE_EXPENSE_DATE, PUSH_EXPENSE_DATE_JAN, GROUP_ID_EXPENSE_DATE_YEAR,
						GROUP_ID_EXPENSE_DATE_MONTH, prev_row_num, prev_col_num, &year, &month, &day);
					SySetupDateUpdateTable(TABLE_EXPENSE_DATE, year, month, day, (SHORT)country.start_of_week, &prev_row_num, &prev_col_num);
					TableEraseTable(TABLE_EXPENSE_DATE);
					TableDrawTable(TABLE_EXPENSE_DATE);
					return TRUE;
				}
				
				
				case EVT_TABLE_SELECT:			
					TableGetItemText(TABLE_EXPENSE_DATE, (USHORT)Event->para1, (USHORT)Event->para2, &list_string);
					if (list_string[0] != 0)
					{
						if ((prev_row_num == (USHORT)Event->para1) && (prev_col_num == (USHORT)Event->para2))
							TableSetHighlightCell(TABLE_EXPENSE_DATE, prev_row_num, prev_col_num, TRUE);
						else
						{
							TableSetHighlightCell(TABLE_EXPENSE_DATE, prev_row_num, prev_col_num, FALSE);
							prev_row_num = (USHORT)Event->para1;
							prev_col_num = (USHORT)Event->para2;		
						}
						TableDrawTable(TABLE_EXPENSE_DATE);
					}
					return TRUE;
					
				case EVT_INLAY_SELECT:
					switch(Event->para1)
					{	
					case INLAY_OK:
						SySetupGetDateSettings(FORM_EXPENSE_DATE, TABLE_EXPENSE_DATE, PUSH_EXPENSE_DATE_JAN, GROUP_ID_EXPENSE_DATE_YEAR,
							GROUP_ID_EXPENSE_DATE_MONTH, prev_row_num, prev_col_num, &year, &month, &day);
						date.year= (BYTE)(year - SYSETUP_YEAR_OFFSET);
						date.mon = (BYTE)(month+1);
						date.day = (BYTE)day;
						RtcGetTime(&time_source);
						date.hr  = (BYTE)time_source.hour;
						date.min = (BYTE)time_source.min;
						date.sec = (BYTE)time_source.sec;
						//					date.hr  = 0;
						//					date.min = 0;
						//					date.sec = 0;
						ExpenseSetDate(date);
						FormPopupForm(FORM_EXPENSE_LIST);
						return TRUE;
						
					case INLAY_EXIT:
						FormPopupForm(FORM_EXPENSE_LIST);
						return TRUE;
						
					default:	return FALSE;
					}
					
	}
	
	return FALSE;
}

/*****************************************************************
* Function:	ExpenseType
* Purpose: 	This function is the event handler for the expense
*				type settings page of the expense application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseType(EvtType *Event)
{
    BYTE		object_type;
    Control		*control_ptr;
	SHORT		item_num;
	USHORT		total_num_item;
	BYTE		null = 0;
	DatabaseID	Expense_type_dbid;
	RecordID	Expense_type_rec_id;
	List		*list_ptr;
	UWORD		total_rec;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormGetObjectPointer(POPUP_EXPENSE_LIST, &object_type, (void**)&control_ptr);
		control_ptr->control_attr.control_enable = FALSE;
		control_ptr->control_attr.control_drawn = FALSE;
		control_ptr->control_attr.control_active = FALSE;
		control_ptr->control_attr.control_visible = FALSE;
		// --------------------------------------------------------------------
		// ----------------- modified at 20052000 -----------------------------
		if (ExpenseUpdateExpenseType() == -1)
		{
#ifdef DEBUG
			printf("\n\n In ExpenseType");
			printf("\n ExpenseUpdateExpenseType() == -1");
#endif
			ExpenseLoadExpenseType();
		}
#ifdef DEBUG
		ListGetHighlightedItem(LIST_EXPENSE_TYPE_LIST1, &item_num);
		printf("\n highlightedItem in List = %ld", item_num);
#endif
		
		// --------------------------------------------------------------------
		
		FormDrawForm(FORM_EXPENSE_LIST);
		FormDrawForm(FORM_EXPENSE_TYPE);
		return TRUE;
		
	case EVT_LIST_SELECT:
		ListGetSelectedItem((ObjectID)Event->eventID, &item_num);
		if (G_del_expense_type != NO_SELECT|| G_rename_expense_type != NO_SELECT)
		{
			if (G_del_expense_type != NO_SELECT)
			{
				G_del_expense_type = item_num;
				
				DataFindDB(EXPTYPEDB, &Expense_type_dbid);
				DataOpenDB(Expense_type_dbid, F_TypeID | SORT_TEXT_MODE, OPEN_RW);
				DataNumtoRecID(Expense_type_dbid, item_num, &Expense_type_rec_id);
				
				DataDeleteRecord(Expense_type_dbid, Expense_type_rec_id, FALSE);
				G_del_expense_type = Expense_type_rec_id;
				DataCloseDB(Expense_type_dbid);
				//ExpenseUpdateExpenseType();
				
				// ===============================================================
				// modified 28062000
				if (ExpenseUpdateExpenseType() == -1)
					ExpenseLoadExpenseType();
				// ===============================================================
				
				FormDrawForm(FORM_EXPENSE_LIST);
				FormPopupForm(FORM_EXPENSE_DIALOG_DEL_TYPE);
			}
			else if(G_rename_expense_type != NO_SELECT)
			{
				G_rename_expense_type = item_num;
				FormDrawForm(FORM_EXPENSE_LIST);
				TextboxSetInsertPointOn(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE);
				TextboxSetText(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE, &null);
				FormPopupForm(FORM_EXPENSE_DIALOG_INPUT_TYPE);
			}
			else
				FormPopupForm(FORM_EXPENSE_TYPE);
			
			return TRUE;
		}
		
		if (item_num == 0)
		{
			ListGetTopItemNum((ObjectID)Event->eventID, &total_num_item);
			if (total_num_item < 256)
			{
				FormDrawForm(FORM_EXPENSE_LIST);
				TextboxSetInsertPointOn(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE);
				TextboxSetText(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE, &null);
				FormPopupForm(FORM_EXPENSE_DIALOG_INPUT_TYPE);
			}
			else
				FormPopupForm(FORM_EXPENSE_TYPE);
			
			return TRUE;
		}
		
		if (item_num == 1)
			ExpenseSetType((UBYTE)(OTHER));
		else
			ExpenseSetType((UBYTE)(item_num - 2));
		
		ListHighlightStatus = EXPENSE_TYPE_HIGHLIGHT;
		ExpenseSetCatPopupEnable();
		FormPopupForm(FORM_EXPENSE_LIST);
		return TRUE;
		
	case PEN_EVENT:
		if (Event->eventID == PEN_DOWN)
		{
#ifdef DEBUG
			printf("\n PEN_DOWN event");
#endif
			ListGetHighlightedItem(LIST_EXPENSE_TYPE_LIST1, &item_num);
#ifdef DEBUG
			printf("\n highlight item in list = %ld", item_num);
			printf("\n G_rename_expense_type = %ld", G_rename_expense_type);
			printf("\n G_del_expense_type = %ld", G_del_expense_type);
#endif
			
			//modified 10072000
			if (item_num != -1 && G_del_expense_type != 1 && G_rename_expense_type != 1)
			{
				if (item_num > 1)
					ExpenseSetType((UBYTE)(item_num-2));
				else
					ExpenseSetType((UBYTE)(OTHER));
			}
			
			FormGetObjectPointer(POPUP_EXPENSE_LIST, &object_type, (void**)&control_ptr);
			control_ptr->control_attr.control_enable = FALSE;
			control_ptr->control_attr.control_drawn = FALSE;
			control_ptr->control_attr.control_active = FALSE;
			control_ptr->control_attr.control_visible = FALSE;
			
			ListHighlightStatus = EXPENSE_TYPE_HIGHLIGHT;
			G_del_expense_type = NO_SELECT;
			G_add_expense_type = NO_SELECT;
			G_rename_expense_type = NO_SELECT;
			ExpenseSetCatPopupEnable();
			FormPopupForm(FORM_EXPENSE_LIST);
		}
		return TRUE;
		
	case EVT_INLAY_SELECT:
		switch(Event->para1)
		{	
		case INLAY_OK:
		case INLAY_EXIT:
			ListGetHighlightedItem(LIST_EXPENSE_TYPE_LIST1, &item_num);
			
			if (item_num != -1 && G_del_expense_type != 1 && G_rename_expense_type != 1)
			{
				if (item_num > 1)
					ExpenseSetType((UBYTE)(item_num-2));
				else
					ExpenseSetType((UBYTE)(OTHER));
			}
			
			G_del_expense_type = NO_SELECT;
			G_add_expense_type = NO_SELECT;
			G_rename_expense_type = NO_SELECT;
			ListHighlightStatus = EXPENSE_TYPE_HIGHLIGHT;
			
			FormGetObjectPointer(POPUP_EXPENSE_LIST, &object_type, (void**)&control_ptr);
			control_ptr->control_attr.control_enable = TRUE;
			control_ptr->control_attr.control_drawn = TRUE;
			control_ptr->control_attr.control_active = TRUE;
			control_ptr->control_attr.control_visible = TRUE;
			
			ExpenseSetCatPopupEnable();
			FormPopupForm(FORM_EXPENSE_LIST);
			return TRUE;
			
		default:	return FALSE;
		}
		
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	ExpenseCurr
* Purpose: 	This function is the event handler for the expense
*				currenices settings page of the expense application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseCurr(EvtType *Event)
{
    BYTE		object_type;
    Control		*control_ptr;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormGetObjectPointer(POPUP_EXPENSE_LIST, &object_type, (void**)&control_ptr);
		control_ptr->control_attr.control_enable = FALSE;
		control_ptr->control_attr.control_drawn = FALSE;
		control_ptr->control_attr.control_active = FALSE;
		control_ptr->control_attr.control_visible = FALSE;
		FormDrawForm(FORM_EXPENSE_LIST);
		FormDrawForm(FORM_EXPENSE_CURR);
		return TRUE;
		
	case EVT_LIST_SELECT:
		switch(Event->eventID)
		{
		case LIST_EXPENSE_CURR_LIST1:
			ExpenseSetCurr((BYTE)Event->para1);
			FormPopupForm(FORM_EXPENSE_LIST);
			return TRUE;
			
		case LIST_EXPENSE_CURR_LIST2:
			ExpenseSetCurr((BYTE)(Event->para1+13));
			FormPopupForm(FORM_EXPENSE_LIST);
			return TRUE;
			
		default:	return FALSE;
		}
		
		
		
		case PEN_EVENT:
			if (Event->eventID == PEN_DOWN)
			{
				if (Event->para1 < 160 && Event->para2 < 160)
				{
					FormGetObjectPointer(POPUP_EXPENSE_LIST, &object_type, (void**)&control_ptr);
					control_ptr->control_attr.control_enable = TRUE;
					control_ptr->control_attr.control_drawn = TRUE;
					control_ptr->control_attr.control_active = TRUE;
					control_ptr->control_attr.control_visible = TRUE;
					FormPopupForm(FORM_EXPENSE_LIST);
				}
			}
			return TRUE;
			
			
			
			
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
			/*
			ListGetSelectedItem(LIST_EXPENSE_CURR_LIST1, &item_num1);
			ListGetSelectedItem(LIST_EXPENSE_CURR_LIST2, &item_num2);
			if (item_num1 < 0 && item_num2 > -1)
			{
			ExpenseSetCurr((BYTE)(item_num2));
			//						ListHighlightStatus = EXPENSE_DATE_HIGHLIGHT;
			}
			else if(item_num1 > -1 && item_num2 < 0)
			{
			ExpenseSetCurr((BYTE)(item_num1));
			//						ListHighlightStatus = EXPENSE_DATE_HIGHLIGHT;
			}
			//					else
			ListHighlightStatus = EXPENSE_NO_HIGHLIGHT;
			
			  ExpenseSetCatPopupEnable();
			  FormPopupForm(FORM_EXPENSE_LIST);
			  return TRUE;
				*/
			case INLAY_EXIT:
				
				FormGetObjectPointer(POPUP_EXPENSE_LIST, &object_type, (void**)&control_ptr);
				control_ptr->control_attr.control_enable = TRUE;
				control_ptr->control_attr.control_drawn = TRUE;
				control_ptr->control_attr.control_active = TRUE;
				control_ptr->control_attr.control_visible = TRUE;
				FormPopupForm(FORM_EXPENSE_LIST);
				return TRUE;
				
			default:	return FALSE;
			}
			
	}
	
	return FALSE;
}

/*****************************************************************
* Function:	ExpenseDialogSave
* Purpose: 	This function is the event handler for the saving
*				dialog box of the expense application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseDialogSave(EvtType *Event)
{
	BYTE	*amount_text_ptr;
	double	amount;
	Err		Error;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_EXPENSE_DIALOG_SAVE);
		return TRUE;
		
	case EVT_BITMAP_SELECT:
		switch(Event->eventID)
		{	
		case BITMAP_EXPENSE_DIALOG_SAVE_X:
			if (ExpenseCheckNewRecord())
			{
				if (DelItemNum < EXPENSE_INVALID_REC_NUM)
				{
					if (ExpenseDeleteExpense(DelItemNum) != TRUE)
						return TRUE;
				}
			}
			// ==================================================
			// modified at 28062000
			KeyboardSetKeyboardVisible();
			// ==================================================
			
			// M-----------------------------------------------------
			// modified at 29052000
			reset_unDeletedID = TRUE;
			ExpenseLoadRecord(CatText, reset_unDeletedID);
			reset_unDeletedID = FALSE;
			// M------------------------------------------------------
			ExpenseRecordToList(&NewItemNumInList);
			DelItemNum = NewItemNumInList;
			ActiveTextboxID = NewItemNumInList + TEXTBOX_EXPENSE_LIST_AMT1;
			ListHighlightStatus = EXPENSE_NO_HIGHLIGHT;
			HighlightRecNumInList = (SHORT)EXPENSE_INVALID_REC_NUM;
			//					ExpenseListSetScrollbar();
			ExpenseSetCatPopupEnable();
			FormPopupForm(FORM_EXPENSE_LIST);
			return TRUE;
		default:	return FALSE;
		}
		
		
		case EVT_CONTROL_SELECT:
			switch(Event->eventID)
			{	
			case BUTTON_EXPENSE_DIALOG_SAVE_YES:
				TextboxGetTextPointer(ActiveTextboxID, &amount_text_ptr);
				amount = atod((const char*)amount_text_ptr);
				//					dtoa(amount, (char*)sbuf, 2);
				//					amount = atod((const char*)sbuf);
				if (amount >= 0.01)
				{
					ExpenseSetAmount(ActiveTextboxID - TEXTBOX_EXPENSE_LIST_AMT1, amount);
					TextboxSetInsertPointOff(ActiveTextboxID);
					ExpenseKeypadInvisible();
					ListHighlightStatus = EXPENSE_TYPE_HIGHLIGHT;
					HighlightRecNumInList =  ActiveTextboxID - TEXTBOX_EXPENSE_LIST_AMT1;
					//FormPopupForm(FORM_EXPENSE_LIST);
					FormDrawForm(FORM_EXPENSE_LIST);
					FormPopupForm(FORM_EXPENSE_TYPE);
				}
				else if(*amount_text_ptr == 0)
				{
					if (DelItemNum < EXPENSE_INVALID_REC_NUM)
					{
						if (ExpenseDeleteExpense(DelItemNum) != TRUE)
							return TRUE;
					}
					ListHighlightStatus = EXPENSE_NO_HIGHLIGHT;
					HighlightRecNumInList = (SHORT)EXPENSE_INVALID_REC_NUM;
					DelItemNum = EXPENSE_INVALID_REC_NUM;
					TextboxSetInsertPointOff(ActiveTextboxID);
					ExpenseKeypadInvisible();
					FormPopupForm(FORM_EXPENSE_LIST);
				}
				else
					TextboxSetInsertPointOn(ActiveTextboxID);
				
				return TRUE;
				
			case BUTTON_EXPENSE_DIALOG_SAVE_NO:
				if (ExpenseCheckNewRecord())
				{
					if (DelItemNum < EXPENSE_INVALID_REC_NUM)
					{
						if (ExpenseDeleteExpense(DelItemNum) != TRUE)
							return TRUE;
					}
				}
				// ==================================================
				// modified at 28062000
				KeyboardSetKeyboardVisible();
				// ==================================================
				
				// M-----------------------------------------------------
				// modified at 29052000
				reset_unDeletedID = TRUE;
				ExpenseLoadRecord(CatText, reset_unDeletedID);
				reset_unDeletedID = FALSE;
				// M------------------------------------------------------
				ExpenseRecordToList(&NewItemNumInList);
				DelItemNum = NewItemNumInList;
				ActiveTextboxID = NewItemNumInList + TEXTBOX_EXPENSE_LIST_AMT1;
				ListHighlightStatus = EXPENSE_NO_HIGHLIGHT;
				HighlightRecNumInList = (SHORT)EXPENSE_INVALID_REC_NUM;
				//					ExpenseListSetScrollbar();
				ExpenseSetCatPopupEnable();
				FormPopupForm(FORM_EXPENSE_LIST);
				return TRUE;
				
			default:	return FALSE;
			}
			
			case EVT_INLAY_SELECT:
				switch(Event->para1)
				{	
				case INLAY_OK:
					//					EvtAppendEvt(EVT_CONTROL_SELECT, BUTTON_EXPENSE_DIALOG_SAVE_YES, 0, 0, NULL);
					//					FormPopupForm(FORM_EXPENSE_EDCAT);
					return TRUE;
					
				case INLAY_EXIT:
					//					dialogX_selected = TRUE;
					//					FormPopupForm(FORM_EXPENSE_LIST);
					return TRUE;
					
				default:	return FALSE;
				}
				
	}
	
	return FALSE;
}

/*****************************************************************
* Function:	ExpenseDialogSelectCat
* Purpose: 	This function is the event handler for the selecting
*				category name dialog box of the expense application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseDialogSelectCat(EvtType *Event)
{
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_EXPENSE_DIALOG_SELCAT);
		return TRUE;
		
	case EVT_BITMAP_SELECT:
		switch(Event->eventID)
		{	
		case BITMAP_EXPENSE_DIALOG_SELCAT_X:
			FormPopupForm(FORM_EXPENSE_EDCAT);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
			case INLAY_EXIT:
				FormPopupForm(FORM_EXPENSE_EDCAT);
				return TRUE;
				
			default:	return FALSE;
			}
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	ExpenseDialogSelectType
* Purpose: 	This function is the event handler for the selecting
*				Expense type dialog box of the expense application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseDialogSelectType(EvtType *Event)
{
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_EXPENSE_DIALOG_SELTYPE);
		return TRUE;
		
	case EVT_BITMAP_SELECT:
		switch(Event->eventID)
		{	
		case BITMAP_EXPENSE_DIALOG_SELTYPE_X:
			FormPopupForm(FORM_EXPENSE_LIST);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
			case INLAY_EXIT:
				FormPopupForm(FORM_EXPENSE_LIST);
				return TRUE;
				
			default:	return FALSE;
			}
	}
	
	return FALSE;
}

/*****************************************************************
* Function:	ExpenseDialogErase
* Purpose: 	This function is the event handler for the erase
*				confirmation dialog box of the expense application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseDialogErase(EvtType *Event)
{
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_EXPENSE_DIALOG_ERASE);
		return TRUE;
		
	case EVT_CONTROL_SELECT:
		switch(Event->eventID)
		{	
		case BUTTON_EXPENSE_DIALOG_ERASE_YES:
			if (ExpenseDeleteAllExpense())
				FormPopupForm(FORM_EXPENSE_LIST);
			return TRUE;
			
		case BUTTON_EXPENSE_DIALOG_ERASE_NO:
			FormPopupForm(FORM_EXPENSE_LIST);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				if (ExpenseDeleteAllExpense())
					FormPopupForm(FORM_EXPENSE_LIST);
				return TRUE;
			case INLAY_EXIT:
				FormPopupForm(FORM_EXPENSE_LIST);
				return TRUE;
				
			default:	return FALSE;
			}
	}
	
	return FALSE;
}

/*****************************************************************
* Function:	ExpenseDialogExist
* Purpose: 	This function is the event handler for the exist
*				confirmation dialog box of the expense application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseDialogExist(EvtType *Event)
{
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_EXPENSE_DIALOG_EXIST);
		return TRUE;
		
	case EVT_INLAY_SELECT:
		switch(Event->para1)
		{	
		case INLAY_OK:
			FormPopupForm(FORM_EXPENSE_EDCAT);
			return TRUE;
			
		case INLAY_EXIT:
			FormPopupForm(FORM_EXPENSE_EDCAT);
			return TRUE;
			
		default:	return FALSE;
		}
		
	}
	
	return FALSE;
}

/*****************************************************************
* Function:	ExpenseDialogEditCat
* Purpose: 	This function is the event handler for the edit categories
*				dialog box of the expense application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseDialogEditCat(EvtType *Event)
{
	
	BYTE	*textbox_string, *list_string;
	SHORT	num_valid_cat, item_num;
	UBYTE	cat[NUM_FLODERS];
	WORD	char_pos;
	BYTE	unfiled[10];
	DatabaseID	Expense_dbid;
	
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
	/*
	KeyboardSetKeyboardVisible();
	FormSetFormActiveObject(FORM_EXPENSE_DIALOG_EDCAT, TEXTBOX_EXPENSE_DIALOG_EDCAT);
	TextboxSetText(TEXTBOX_EXPENSE_DIALOG_EDCAT, null_buf);
	TextboxSetInsertPointOn(TEXTBOX_EXPENSE_DIALOG_EDCAT);
		*/
		if (RenameCat == TRUE)
		{
			ListGetSelectedItem(LIST_EXPENSE_EDCAT, &item_num);
			ListGetListItem(LIST_EXPENSE_EDCAT, (USHORT)item_num, &textbox_string);
			FormSetFormActiveObject(FORM_EXPENSE_DIALOG_EDCAT, TEXTBOX_EXPENSE_DIALOG_EDCAT);
			//				TextboxSetText(TEXTBOX_EXPENSE_DIALOG_EDCAT, textbox_string);
			TextboxSetInsertPointOn(TEXTBOX_EXPENSE_DIALOG_EDCAT);
			char_pos = strlen(textbox_string);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_EXPENSE_DIALOG_EDCAT, char_pos);
			TextboxSetHighlightSelection(TEXTBOX_EXPENSE_DIALOG_EDCAT, 0, char_pos);
		}
		else
		{
			FormSetFormActiveObject(FORM_EXPENSE_DIALOG_EDCAT, TEXTBOX_EXPENSE_DIALOG_EDCAT);
			// ===========================================================================================
			// modified at 14062000
			//				strcpy(unfiled, EXPUNFILED);
			//				TextboxSetText(TEXTBOX_EXPENSE_DIALOG_EDCAT, unfiled);
			TextboxSetHighlightSelection(TEXTBOX_EXPENSE_DIALOG_EDCAT, 0, 7);
			TextboxSetInsertPointOff(TEXTBOX_EXPENSE_DIALOG_EDCAT);
			// ===========================================================================================
		}
		FormDrawForm(FORM_EXPENSE_DIALOG_EDCAT);
		return TRUE;
		
		
	case EVT_BITMAP_SELECT:
		switch(Event->eventID)
		{	
		case BITMAP_EXPENSE_DIALOG_EDCAT_X:
			FormPopupForm(FORM_EXPENSE_EDCAT);
			RenameCat = FALSE;
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_KEY:
			if (Event->para2 & 0x00000300)
				return TRUE;
			if (Event->eventID == SOFT_KEY)
			{
				if (Event->para1 == '\r' || Event->para1 == '\n')
				{
					EvtAppendEvt(EVT_INLAY_SELECT, 0, INLAY_OK, 0, NULL);
					return TRUE;
				}
				
				TextboxAddKeyInChar(TEXTBOX_EXPENSE_DIALOG_EDCAT, (BYTE)(Event->para1));
				return TRUE;
			}
			break;
			
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				TextboxGetTextPointer(TEXTBOX_EXPENSE_DIALOG_EDCAT, &textbox_string);
				if (textbox_string[0] == 0)
					return TRUE;
				if (RenameCat == TRUE)
				{
					ListGetSelectedItem(LIST_EXPENSE_EDCAT, &item_num);
					ListGetListItem(LIST_EXPENSE_EDCAT, (USHORT)item_num, &list_string);
					if (!strcmp(list_string, textbox_string))
					{
						FormPopupForm(FORM_EXPENSE_EDCAT);
						RenameCat = FALSE;
						return TRUE;
					}
				}
				if (!ExpenseNewCat(RenameCat))
				{
					FormPopupForm(FORM_EXPENSE_EDCAT);
					FormPopupForm(FORM_EXPENSE_DIALOG_EXIST);
				}
				else if (RenameCat == TRUE)
					FormPopupForm(FORM_EXPENSE_EDCAT);
				else
				{
					
					if (!DataFindDB(EXPDB, &Expense_dbid))
						return TRUE;
					num_valid_cat = DataCategorySort(Expense_dbid, cat);
					if (num_valid_cat == 0)
						return TRUE;
					// ========================================================================
					// modified at 14062000
					if (CatHighlightInList > -1)
					{
						//							ControlPopupSetSelectedItem(POPUP_EXPENSE_LIST, CatHighlightInList + 1);
						ControlPopupSetSelectedItem(POPUP_EXPENSE_LIST, CatHighlightInList + 2);
					}
					else
						ControlPopupSetSelectedItem(POPUP_EXPENSE_LIST, 1);
					// ========================================================================
					FormPopupForm(FORM_EXPENSE_LIST);
					EvtAppendEvt(EVT_CONTROL_SELECT, BUTTON_EXPENSE_LIST_NEW, 0, 0, NULL);
					
				}
				RenameCat = FALSE;
				return TRUE;
				
			case INLAY_EXIT:
				FormPopupForm(FORM_EXPENSE_EDCAT);
				RenameCat = FALSE;
				return TRUE;
				
			default:	return FALSE;
			}
			
	}
	
	return FALSE;
}

/*****************************************************************
* Function:	ExpenseDialogRemove
* Purpose: 	This function is the event handler for the remvoe category
*				dialog box of the expense application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseDialogRemove(EvtType *Event)
{
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_EXPENSE_DIALOG_REMOVE);
		return TRUE;
		
	case EVT_CONTROL_SELECT:
		switch(Event->eventID)
		{	
		case BUTTON_EXPENSE_DIALOG_REMOVE_YES:
			if (ExpenseDeleteCat())
				FormPopupForm(FORM_EXPENSE_EDCAT);
			return TRUE;
			
		case BUTTON_EXPENSE_DIALOG_REMOVE_NO:
			FormPopupForm(FORM_EXPENSE_EDCAT);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				if (ExpenseDeleteCat())
					FormPopupForm(FORM_EXPENSE_EDCAT);
				return TRUE;
			case INLAY_EXIT:
				FormPopupForm(FORM_EXPENSE_EDCAT);
				return TRUE;
				
			default:	return FALSE;
			}
	}
	
	
	return FALSE;
}


/*****************************************************************
* Function:	ExpenseDialogLowMemory
* Purpose: 	This function is the event handler for the low memory
*				dialog box of the expense application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseDialogLowMemory(EvtType *Event)
{
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_EXPENSE_DIALOG_LOW_MEMORY);
		return TRUE;
		
	case EVT_BITMAP_SELECT:
		switch(Event->eventID)
		{		
		case BITMAP_EXPENSE_DIALOG_LOW_MEMORY_X:
			FormPopupForm(G_active_form_id);
			return TRUE;
			
		default:	return FALSE;
		}
		
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
			case INLAY_EXIT:
				FormPopupForm(G_active_form_id);
				return TRUE;
				
			default:	return FALSE;
			}
			
	}
	
	
	return FALSE;
}


/*****************************************************************
* Function:	ExpenseEditCate
* Purpose: 	This function is the event handler for the edit 
*				categories page of the expense application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseEditCate(EvtType *Event)
{
	SHORT	item_num, num_valid_cat;
	USHORT	num_items;
	UBYTE	cat[NUM_FLODERS+1];
	BYTE	null_buf[1] = {0}, *item_text;
	AppID	app_id;
	DatabaseID	Expense_dbid;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		if (LargeFontInEdcat)
			ExpenseSetEdcatListFont(LIST_EXPENSE_EDCAT, MEDIUM_FONT);
		else
			ExpenseSetEdcatListFont(LIST_EXPENSE_EDCAT, SMALL_FONT);
		FormDrawForm(FORM_EXPENSE_EDCAT);
		return TRUE;
		
	case EVT_MENU_SELECT_ITEM:
		if (Event->para1 == MENU_ITEM_DELETE)
		{
			MenuGetMenuItem(MENU_EXPENSE_EDCAT, MENU_ITEM_FONT, &item_text);
			if (item_text[0] == EXPFONT_INT)
			{
				LargeFontInEdcat = 1;
				ExpenseSetEdcatListFont(LIST_EXPENSE_EDCAT, MEDIUM_FONT);
			}
			else
			{
				LargeFontInEdcat = 0;
				ExpenseSetEdcatListFont(LIST_EXPENSE_EDCAT, SMALL_FONT);
			}
			ListGetNumItemsDisplay(LIST_EXPENSE_EDCAT, &num_items);
			
			if (num_items > 8)
			{
			/*
			ListGetHighlightedItem(LIST_EXPENSE_EDCAT, &item_num);
			if (item_num > -1)
			ListGetListItem(LIST_EXPENSE_EDCAT, (USHORT)item_num, &item_text);
			else
			ListGetListItem(LIST_EXPENSE_EDCAT, 0, &item_text);
				*/
				ExpenseCatToList((BYTE*)"", FALSE);
				ScrollbarDrawScrollbar(SCROLLBAR_EXPENSE_EDCAT);
			}
			ListDrawList(LIST_EXPENSE_EDCAT);
			
			
		}
		return TRUE;
		
		
	case EVT_CONTROL_SELECT:
		switch(Event->eventID)
		{	
		case BUTTON_EXPENSE_EDCAT_NEW:
			if (ExpenseCheckMemoryEmpty())
			{
				FormPopupForm(FORM_EXPENSE_DIALOG_LOW_MEMORY);
				return TRUE;
			}
			
			if (!DataFindDB(EXPDB, &Expense_dbid))
				return TRUE;
			num_valid_cat = DataCategorySort(Expense_dbid, cat);
			if (num_valid_cat > NUM_FLODERS)
				return TRUE;
			//KeyboardSetKeyboardVisible();
			FormSetFormActiveObject(FORM_EXPENSE_DIALOG_EDCAT, TEXTBOX_EXPENSE_DIALOG_EDCAT);
			TextboxSetText(TEXTBOX_EXPENSE_DIALOG_EDCAT, null_buf);
			TextboxSetInsertPointOn(TEXTBOX_EXPENSE_DIALOG_EDCAT);
			FormPopupForm(FORM_EXPENSE_DIALOG_EDCAT);
			return TRUE;
			
		case BUTTON_EXPENSE_EDCAT_DEL:
			ListGetNumOfItems(LIST_EXPENSE_EDCAT, &num_items);
			if (num_items < 1)
				return TRUE;
			ListGetSelectedItem(LIST_EXPENSE_EDCAT, &item_num);
			if (item_num < 0)	FormPopupForm(FORM_EXPENSE_DIALOG_SELCAT);
			else				FormPopupForm(FORM_EXPENSE_DIALOG_REMOVE);
			return TRUE;
			
		case BUTTON_EXPENSE_EDCAT_RENAME:
			ListGetNumOfItems(LIST_EXPENSE_EDCAT, &num_items);
			if (num_items < 1)
				return TRUE;
			//KeyboardSetKeyboardVisible();
			ListGetSelectedItem(LIST_EXPENSE_EDCAT, &item_num);
			if (item_num < 0)
			{	
				RenameCat = FALSE;
				FormPopupForm(FORM_EXPENSE_DIALOG_SELCAT);
			}
			else
			{
				RenameCat = TRUE;
				FormPopupForm(FORM_EXPENSE_DIALOG_EDCAT);
			}
			return TRUE;
			/*
			case BUTTON_EXPENSE_EDCAT_LARGE_FONT:
			LargeFontInEdcat = 1;
			ExpenseSetEdcatListFont(LIST_EXPENSE_EDCAT, MEDIUM_FONT);
			ControlDrawControl(BUTTON_EXPENSE_EDCAT_LARGE_FONT);
			ControlDrawControl(BUTTON_EXPENSE_EDCAT_SMALL_FONT);
			ListDrawList(LIST_EXPENSE_EDCAT);
			return TRUE;
			
			  case BUTTON_EXPENSE_EDCAT_SMALL_FONT:
			  LargeFontInEdcat = 0;
			  ExpenseSetEdcatListFont(LIST_EXPENSE_EDCAT, SMALL_FONT);
			  ControlDrawControl(BUTTON_EXPENSE_EDCAT_LARGE_FONT);
			  ControlDrawControl(BUTTON_EXPENSE_EDCAT_SMALL_FONT);
			  ListDrawList(LIST_EXPENSE_EDCAT);
			  return TRUE;
			*/
		default:	return FALSE;
		}
		
		case EVT_LIST_SELECT:
			if (Event->para1 < 0)
				CatHighlightInList = -1;
			else
			{
				ListGetListItem(LIST_EXPENSE_EDCAT, (USHORT)Event->para1, &CatNameInEdCat);
				CatHighlightInList = ExpenseCatSelectedNameToNum(CatNameInEdCat);
				// ----------------------------------------------------------New edit 040299
				ListGetSelectedItem(LIST_EXPENSE_EDCAT, &item_num);
				ListSetHighlightedItem(LIST_EXPENSE_EDCAT, item_num);
				ListDrawList((USHORT)Event->eventID);
				// -------------------------------------------------------------------------
			}
			return TRUE;
			
		case EVT_SCROLLBAR_REPEAT:
			if (Event->para1 == Event->para2)
				return TRUE;
			ExpenseScrollbarSetCat((USHORT)Event->para2);
			FormDrawForm(FORM_EXPENSE_EDCAT);
			return TRUE;
			
#ifdef PR31700
		case EVT_IO_KEY_CTRL:
			if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
            {
                if (Event->para2 == IO_UP_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_EXPENSE_EDCAT, SCROLLBAR_UP_ARROW);
                else if (Event->para2 == IO_DOWN_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_EXPENSE_EDCAT, SCROLLBAR_DOWN_ARROW);
				return TRUE;
			}
			return FALSE;
#endif
			
			
		case EVT_SCROLLBAR_SELECT:
			ExpenseScrollbarSetCat((USHORT)Event->para2);
			FormDrawForm(FORM_EXPENSE_EDCAT);
			return TRUE;
			
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
			/*
			ListGetNumOfItems(LIST_EXPENSE_EDCAT, &num_items);
			if (num_items < 1)
			{
			#ifdef PR31700
			SysGetAppID(MAINMENU, &app_id);
            EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
            EvtAppendEvt(EVT_APP_LAUNCH, app_id, 0, 0, NULL);
			#endif
			return TRUE;
			}
			
			  if (!DataFindDB(EXPDB, &Expense_dbid))
			  return TRUE;
			  num_valid_cat = DataCategorySort(Expense_dbid, cat);
			  if (num_valid_cat == 0)
			  return TRUE;
				*/
				// ==============================================================================
				// modified at 13062000
				if (CatHighlightInList > -1)
				{
					//						ControlPopupSetSelectedItem(POPUP_EXPENSE_LIST, CatHighlightInList + 1);
					ControlPopupSetSelectedItem(POPUP_EXPENSE_LIST, CatHighlightInList + 2);
				}
				else
					ControlPopupSetSelectedItem(POPUP_EXPENSE_LIST, 1);
				// ==============================================================================
				FormPopupForm(FORM_EXPENSE_LIST);
				return TRUE;
				
			case INLAY_EXIT:
				ListGetNumOfItems(LIST_EXPENSE_EDCAT, &num_items);
				if (num_items < 1)
				{
#ifdef PR31700
					SysGetAppID(MAINMENU, &app_id);
					EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
					EvtAppendEvt(EVT_APP_LAUNCH, app_id, 0, 0, NULL);
#endif
					
					return TRUE;
				}
				if (!DataFindDB(EXPDB, &Expense_dbid))
					return TRUE;
				num_valid_cat = DataCategorySort(Expense_dbid, cat);
				if (num_valid_cat == 0)
					return TRUE;
				// ==============================================================================
				// modified at 13062000
				if (CatHighlightInList > -1)
				{
					//						ControlPopupSetSelectedItem(POPUP_EXPENSE_LIST, CatHighlightInList + 1);
					ControlPopupSetSelectedItem(POPUP_EXPENSE_LIST, CatHighlightInList + 2);
				}
				else
					ControlPopupSetSelectedItem(POPUP_EXPENSE_LIST, 1);
				FormPopupForm(FORM_EXPENSE_LIST);
				// ==============================================================================
				return TRUE;
				
			default:	return FALSE;
			}
			
			
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	ExpenseHandleKeyInStatus
* Purpose: 	This function is used to handle the status of the data input
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
*****************************************************************/
BOOLEAN ExpenseHandleKeyInStatus(EvtType *Event)
{
	ObjectID	active_form_id;
	
	if (FormGetActiveFormID(&active_form_id) != TRUE)
		return FALSE;
	if (active_form_id != FORM_EXPENSE_LIST)
		return FALSE;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)	
	{
		if ((Event->para2 & 0x00000200))
			return FALSE;
		Event->para2 &= 0x000000ff;
		if (Event->para2 != 0)
			switch(Event->para2)
		{
				case KEY_UNDO:
					return TRUE;
				case KEY_COPY:
					return TRUE;
				case KEY_PASTE:
					return TRUE;
				case KEY_CUT:
					return TRUE;
				default:
					return FALSE;
		}
	}
	else if(Event->eventType == EVT_FIELD_JOT_PASTE_STRING || Event->eventType == EVT_TEXTBOX_JOT_PASTE_STRING)
    {
        pfree(Event->evtPBP);
		return TRUE;
    }
	
	return FALSE;
}



//t=============================================================
/*****************************************************************
* Function:	ExpenseDialogInputType
* Purpose: 	This function is the event handler for inputting expense type
*				dialog box of the expense application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseDialogInputType(EvtType *Event)
{
	
	BYTE	*textbox_string;
	//	BYTE	null = 0;
	UWORD	total_rec;
	
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		//KeyboardSetKeyboardVisible();
		//TextboxSetText(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE, &null);
		// ---------------------------------------------------------------------------------
		// -------------------- add 22052000 -----------------------------------------------
		FormSetFormActiveObject(FORM_EXPENSE_DIALOG_INPUT_TYPE, TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE);
		// ---------------------------------------------------------------------------------
		FormDrawForm(FORM_EXPENSE_DIALOG_INPUT_TYPE);
		return TRUE;
		
	case EVT_BITMAP_SELECT:
		switch(Event->eventID)
		{	
		case BITMAP_EXPENSE_DIALOG_INPUT_TYPE_X:
			//KeyboardSetKeyboardInvisible();
			if (G_add_expense_type != NO_SELECT || G_rename_expense_type != NO_SELECT )
			{
				G_add_expense_type = NO_SELECT;
				G_rename_expense_type = NO_SELECT;
				FormPopupForm(FORM_EXPENSE_LIST);
			}
			else
				FormPopupForm(FORM_EXPENSE_TYPE);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_KEY:
			if (Event->para2 & 0x00000300)
				return TRUE;
			if (Event->eventID == SOFT_KEY)
			{
				if (Event->para1 == '\r' || Event->para1 == '\n')
				{
					EvtAppendEvt(EVT_INLAY_SELECT, 0, INLAY_OK, 0, NULL);
					return TRUE;
				}
				
				TextboxAddKeyInChar(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE, (BYTE)(Event->para1));
				return TRUE;
			}
			break;
			
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				//KeyboardSetKeyboardInvisible();
				TextboxGetTextPointer(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE, &textbox_string);
#ifdef DEBUG_MICH
				printf("\n In ExpenseDialogInputType()");
				printf("\n G_rename_expense_type = %ld", G_rename_expense_type);
				printf("\n G_add_expense_type = %ld", G_add_expense_type);
#endif
				
				if (G_rename_expense_type != NO_SELECT)
				{
					//L==================================================================
					
					if (textbox_string[0] != 0)
						if(ExpenseRenameExpenseType(textbox_string) != TRUE)
						{
							ExpenseSetCatPopupEnable();
							FormPopupForm(FORM_EXPENSE_DIALOG_TYPE_EXIST);
							return TRUE;
						}
						//L==================================================================
						ExpenseSetCatPopupEnable();
						FormPopupForm(FORM_EXPENSE_LIST);
				}
				else
				{
					//L==================================================================
					
					if (textbox_string[0] == 0)
					{
#ifdef DEBUG_MICH
						printf("\n textbox_string[0] == 0");
						printf("\n then popup form_expense_list");
#endif
						if (G_add_expense_type == NO_SELECT)
							ExpenseSetType((UBYTE)OTHER);
						G_del_expense_type = NO_SELECT;
						G_add_expense_type = NO_SELECT;
						G_rename_expense_type = NO_SELECT;
						ExpenseSetCatPopupEnable();
						FormPopupForm(FORM_EXPENSE_LIST);
					}
					//L==================================================================
					else if(ExpenseNewExpenseType(textbox_string, &total_rec))
					{
						if (G_add_expense_type == NO_SELECT)
						{
							ListHighlightStatus = EXPENSE_TYPE_HIGHLIGHT;
							ExpenseSetType((UBYTE)total_rec);
						}
						else
							G_add_expense_type = NO_SELECT;
						
						ExpenseSetCatPopupEnable();
						FormPopupForm(FORM_EXPENSE_LIST);
					}
					else
					{
						FormPopupForm(FORM_EXPENSE_DIALOG_TYPE_EXIST);
					}
					
				}
				return TRUE;
				
			case INLAY_EXIT:
				//L==================================================================
				//KeyboardSetKeyboardInvisible();
				if (G_add_expense_type == NO_SELECT && G_add_expense_type == NO_SELECT 
					&& G_rename_expense_type == NO_SELECT)
				{
					ExpenseSetType((UBYTE)OTHER);
				}
				//L==================================================================
				G_del_expense_type = NO_SELECT;
				G_add_expense_type = NO_SELECT;
				G_rename_expense_type = NO_SELECT;
				FormPopupForm(FORM_EXPENSE_LIST);
				return TRUE;
				
			default:	return FALSE;
			}
			
	}
	
	return FALSE;
}



/*****************************************************************
* Function:	ExpenseDialogDelType
* Purpose: 	This function is the event handler for deletting expense type
*				dialog box of the expense application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseDialogDelType(EvtType *Event)
{
	
	SHORT	item_num;
	
#ifdef DEBUG_MICH
	printf("\n Event = %ld", Event->eventType);
#endif
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_EXPENSE_DIALOG_DEL_TYPE);
		ControlPopupSetSelectedItem(POPUP_EXPENSE_TYPE, 0);
		return TRUE;
		
		//L=====================================================
	case EVT_CONTROL_POPUP_SELECT:
#ifdef DEBUG_MICH
		printf("\n EVT_CONTROL_POPUP_SELECT");
		printf("\n Point 1");
#endif
		ControlPopupGetSelectedItem((ObjectID)Event->eventID, &item_num);
		
#ifdef DEBUG_MICH
		printf("\n Point 2");
#endif
		
		ExpenseDeleteExpenseType(item_num);
		
#ifdef DEBUG_MICH
		printf("\n Point 3");
#endif
		//ExpenseSetCatPopupEnable();
		//ExpenseLoadExpenseType();
		ControlPopupSetSelectedItem(POPUP_EXPENSE_TYPE, 0);
		
#ifdef DEBUG_MICH
		printf("\n Point 4");
#endif
		
		FormPopupForm(FORM_EXPENSE_LIST);
#ifdef DEBUG_MICH
		printf("\n Point 5");
#endif
		return TRUE;
		/*
		case EVT_LIST_SELECT:
		ListGetSelectedItem((ObjectID)Event->eventID, &item_num);
		ExpenseDeleteExpenseType(item_num);
		ExpenseSetCatPopupEnable();
		FormPopupForm(FORM_EXPENSE_LIST);
		*/
		//L=====================================================
		
		
	case EVT_INLAY_SELECT:
		switch(Event->para1)
		{	
		case INLAY_OK:
		case INLAY_EXIT:
			ExpenseDeleteExpenseType(0);
			ControlPopupSetSelectedItem(POPUP_EXPENSE_TYPE, 0);
			G_del_expense_type = NO_SELECT;
			G_add_expense_type = NO_SELECT;
			G_rename_expense_type = NO_SELECT;
			FormPopupForm(FORM_EXPENSE_LIST);
			return TRUE;
			
		default:	return FALSE;
		}
		
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	ExpenseDialogTypeExist
* Purpose: 	This function is the event handler for the exist
*				confirmation dialog box of the expense application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN ExpenseDialogTypeExist(EvtType *Event)
{
	BYTE	null = 0;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_EXPENSE_DIALOG_TYPE_EXIST);
		return TRUE;
		
	case EVT_INLAY_SELECT:
		switch(Event->para1)
		{	
		case INLAY_OK:
		case INLAY_EXIT:
			if (G_add_expense_type != NO_SELECT || G_rename_expense_type != NO_SELECT )
			{
				TextboxSetInsertPointOn(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE);
				TextboxSetText(TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE, &null);
				FormPopupForm(FORM_EXPENSE_DIALOG_INPUT_TYPE);
			}
			else
				FormPopupForm(FORM_EXPENSE_TYPE);
			return TRUE;
			
			
		default:	return FALSE;
		}
		
	}
	
	return FALSE;
}

