/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   expdef.h
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef _EXPDEF_H_
#define _EXPDEF_H_

#include "uifunc.h"
#include "uidef.h"
#include "ui.h"
#include "mmu.h"
#include "expense.h"

/******************************************************************
***************** EXPENSE TYPE DEFINES ****************************
******************************************************************/
/*
#define		AIRFARE					0
#define		BREAKFAST				1
#define		BUS						2
#define		BUSINESS_MEALS			3
#define		CAR_RENTAL				4
#define		DINNER					5
#define		ENTRETAINMENT			6
#define		FAX						7
#define		GAS						8
#define		GIFTS					9
#define		HOTEL					10
#define		INCIDENTALS				11
#define		LAUNDRY					12
#define		LIMO					13
#define		LODIGING				14
#define		LUNCH					15
#define		MILEAGE					16
#define		PARKING					17
#define		POSTAGE					18
#define		SNACK					19
#define		SUBWAY					20
#define		SUPPLIES				21
#define		TAXI					22
#define		TELEPHONE				23
#define		TIPS					24
#define		TOLLS					25
#define		TRAIN					26
#define		OTHER					27
#define		EXPENSE_TYPE			100
*/

//L=====================================================
//#define		EXPENSE_TYPE			1000
#define		EXPENSE_TYPE			254
//L=====================================================
#define		AIRFARE					1
#define		BREAKFAST				2
#define		BUS						3
#define		BUSINESS_MEALS			4
#define		CAR_RENTAL				5
#define		DINNER					6
#define		ENTRETAINMENT			7
#define		FAX						8
#define		GAS						9
#define		GIFTS					10
#define		HOTEL					11
#define		INCIDENTALS				12
#define		LAUNDRY					13
#define		LIMO					14
#define		LODIGING				15
#define		LUNCH					16
#define		MILEAGE					17
#define		PARKING					18
#define		POSTAGE					19
#define		SNACK					20
#define		SUBWAY					21
#define		SUPPLIES				22
#define		TAXI					23
#define		TELEPHONE				24
#define		TIPS					25
#define		TOLLS					26
#define		TRAIN					27
//L==================================================================
//#define		OTHER					28
#define		USER_DEFINE				254
#define		OTHER					255
#define		NO_SELECT				0xffffffff
//L==================================================================

//t======================================================


/******************************************************************
***************** EXPENSE CURRENICES DEFINES ****************************
******************************************************************/
#define		AUSTRALIA_CURR			0
#define		AUSTRIA_CURR			1
#define		BELGIUM_CURR			2
#define		BRAZIL_CURR				3
#define		CANADA_CURR				4
#define		DENMARK_CURR			5
#define		EURO_CURR				6
#define		FINLAND_CURR			7
#define		FRANCE_CURR				8
#define		GERMANY_CURR			9
#define		HONG_KONG_CURR			10
#define		ICELAND_CURR			11
#define		IRELAND_CURR			12
#define		ITALY_CURR				13
#define		JAPAN_CURR				14
#define		LUXEMBOURG_CURR			15
#define		MEXICO_CURR				16
#define		NETHERLANDS_CURR		17
#define		NEW_ZEALAND_CURR		18
#define		NORWAY_CURR				19
#define		SPAIN_CURR				20
#define		SWEDEN_CURR				21
#define		SWITZERLAND_CURR		22
#define		UNITED_KINGDOM_CURR		23
#define		UNITED_STATES_CURR		24
#define		NONE_CURR				25
/******************************************************************
******************************************************************/
#define		NUM_FLODERS				50
#define		EXPENSE_NUM_FIELD	3
#define		F_DATE				0
#define		F_TYPE				1
#define		F_AMT				2


/******************************************************************
******************************************************************/
#define		EXPENSE_NO_HIGHLIGHT		0
#define		EXPENSE_DATE_HIGHLIGHT		1
#define		EXPENSE_TYPE_HIGHLIGHT		2
#define		EXPENSE_CURR_HIGHLIGHT		3
#define		EXPENSE_AMT_HIGHLIGHT		4
#define		EXPENSE_OLD_AMT_HIGHLIGHT	5

#define		EXPENSE_INVALID_REC_NUM		65534

#define		EXPENSE_CURR_REC_ID			0x80001000

#define		EXPENSE_MAIN_APP_SAVE		0x80001001
#define		F_PopupItemNum				0
#define		F_CatText					1
#define		F_CatHighlightInList		2
#define		F_prev_row_num				3
#define		F_prev_col_num				4
#define		F_NewItemNumInList			5
#define		F_DelItemNum				6
#define		F_dialogX_selected			7
#define		F_RenameCat					8
#define		F_ActiveTextboxID			9
#define		F_ActiveFormID				10
#define		F_ExpTextboxString			11
#define		F_ExpTextboxCharPos			12
#define		F_ExpKeypadInvisible		13
#define		F_LargeFontInEdcat			14
#define		F_G_del_expense_type		15
#define		F_G_rename_expense_type		16
#define		F_G_add_expense_type		17


#define		EXPENSE_MDB_APP_SAVE		0x80001002
#define		F_ListHighlightStatus		0
#define		F_CatNum					1
#define		F_HighlightRecNumInList		2
#define		F_TotalRecordInCat			3
#define		F_NewItemNum				4
#define		F_RecIDInList_0				5
#define		F_NewExpense_rec_id			6
#define		F_Highlighted_rec_id		7
#define		F_UnDelete_rec_id			8

//t===============================================================================
#define		F_TypeID					0
#define		F_TypeName					1
//t===============================================================================

/******************************************************************
***************** EXPENSE OBJECT ID DEFINES ***********************
******************************************************************/

/*===============================================================*/
/*============== FORM_EXPENSE_DATE ==============================*/
#define		FORM_EXPENSE_DATE						0
#define		STRING_EXPENSE_DATE_DATE				1
#define		PUSH_EXPENSE_DATE_JAN					2
#define		PUSH_EXPENSE_DATE_FEB					3
#define		PUSH_EXPENSE_DATE_MAR					4
#define		PUSH_EXPENSE_DATE_APR					5
#define		PUSH_EXPENSE_DATE_MAY					6
#define		PUSH_EXPENSE_DATE_JUN					7
#define		PUSH_EXPENSE_DATE_JUL					8
#define		PUSH_EXPENSE_DATE_AUG					9
#define		PUSH_EXPENSE_DATE_SEP					10
#define		PUSH_EXPENSE_DATE_OCT					11
#define		PUSH_EXPENSE_DATE_NOV					12
#define		PUSH_EXPENSE_DATE_DEC					13
#define		STRING_EXPENSE_DATE_WDAY				14
#define		TABLE_EXPENSE_DATE						15
#define		BITMAP_EXPENSE_DATE_LEFT				16
#define		BITMAP_EXPENSE_DATE_RIGHT				17
#define		BUTTON_EXPENSE_DATE_DISABLE_BKGRD		18
#define		PUSH_EXPENSE_DATE_Y1					19
#define		PUSH_EXPENSE_DATE_Y2					20
#define		PUSH_EXPENSE_DATE_Y3					21
#define		PUSH_EXPENSE_DATE_Y4					22
#define		PUSH_EXPENSE_DATE_Y5					23
#define		LINE_EXPENSE_DATE_YUP					24
#define		LINE_EXPENSE_DATE_YDWN					25
#define		BUTTON_EXPENSE_DATE_TODAY				26
#define		GROUP_ID_EXPENSE_DATE_MONTH				0
#define		GROUP_ID_EXPENSE_DATE_YEAR				2

/*===============================================================*/
/*============== FORM_EXPENSE_LIST ==============================*/
#define		FORM_EXPENSE_LIST						27
#define		POPUP_EXPENSE_LIST						28
#define		BUTTON_EXPENSE_LIST_NEW					29
//#define		BUTTON_EXPENSE_LIST_DEL					30
#define		SCROLLBAR_EXPENSE_LIST					31
#define		STRING_EXPENSE_LIST_TOTAL				32
#define		STRING_EXPENSE_LIST_TOTAL_CURR			33
#define		STRING_EXPENSE_LIST_TOTAL_AMT			34
#define		TEXTBOX_EXPENSE_LIST_AMT1				35
#define		TEXTBOX_EXPENSE_LIST_AMT2				36
#define		TEXTBOX_EXPENSE_LIST_AMT3				37
#define		TEXTBOX_EXPENSE_LIST_AMT4				38
#define		TEXTBOX_EXPENSE_LIST_AMT5				39
#define		TEXTBOX_EXPENSE_LIST_AMT6				40
#define		TEXTBOX_EXPENSE_LIST_AMT7				41
#define		TEXTBOX_EXPENSE_LIST_AMT8				42
#define		TEXTBOX_EXPENSE_LIST_AMT9				43
#define		TEXTBOX_EXPENSE_LIST_AMT10				44
#define		TEXTBOX_EXPENSE_LIST_AMT11				45
#define		LIST_EXPENSE_LIST_DATE					46
#define		LIST_EXPENSE_LIST_TYPE					47
#define		LIST_EXPENSE_LIST_CURR					48
#define		BITMAP_EXPENSE_LIST_KEYPAD				49
#define		BITMAP_EXPENSE_LIST_KEYB				50
#define		BITMAP_EXPENSE_LIST_KEYC				51
#define		BITMAP_EXPENSE_LIST_KEYF				52
#define		BITMAP_EXPENSE_LIST_KEY7				53
#define		BITMAP_EXPENSE_LIST_KEY8				54
#define		BITMAP_EXPENSE_LIST_KEY9				55
#define		BITMAP_EXPENSE_LIST_KEY4				56
#define		BITMAP_EXPENSE_LIST_KEY5				57
#define		BITMAP_EXPENSE_LIST_KEY6				58
#define		BITMAP_EXPENSE_LIST_KEY1				59
#define		BITMAP_EXPENSE_LIST_KEY2				60
#define		BITMAP_EXPENSE_LIST_KEY3				61
#define		BITMAP_EXPENSE_LIST_KEYD				62
#define		BITMAP_EXPENSE_LIST_KEY0				63
#define		BITMAP_EXPENSE_LIST_KEYA				64
#define		BITMAP_EXPENSE_LIST_KEYEN				65
//#define		BUTTON_EXPENSE_LIST_DELALL				107
#define		STRING_EXPENSE_LIST_HEADER				114

/*===============================================================*/
/*============== FORM_EXPENSE_TYPE ==============================*/
#define		FORM_EXPENSE_TYPE						66
#define		BUTTON_EXPENSE_TYPE						67
#define		LIST_EXPENSE_TYPE_LIST1					68
//#define		LIST_EXPENSE_TYPE_LIST2					69
#define		POPUP_EXPENSE_TYPE						69
#define		STRING_EXPENSE_TYPE_HEADER				108

/*===============================================================*/
/*============== FORM_EXPENSE_CURR ==============================*/
#define		FORM_EXPENSE_CURR						70
#define		BUTTON_EXPENSE_CURR						71
#define		LIST_EXPENSE_CURR_LIST1					72
#define		LIST_EXPENSE_CURR_LIST2					73
#define		STRING_EXPENSE_CURR_HEADER				109

/*===============================================================*/
/*============== FORM_EXPENSE_DIALOG_SAVE =======================*/
#define		FORM_EXPENSE_DIALOG_SAVE				74
#define		STRING_EXPENSE_DIALOG_SAVE				75
#define		BITMAP_EXPENSE_DIALOG_SAVE_X			76
#define		BUTTON_EXPENSE_DIALOG_SAVE_YES			77
#define		BUTTON_EXPENSE_DIALOG_SAVE_NO			78

/*===============================================================*/
/*============== FORM_EXPENSE_EDCAT =============================*/
#define		FORM_EXPENSE_EDCAT						79
#define		STRING_EXPENSE_EDCAT_EDCAT				80
#define		BUTTON_EXPENSE_EDCAT_NEW				81
#define		BUTTON_EXPENSE_EDCAT_DEL				82
#define		BUTTON_EXPENSE_EDCAT_RENAME				83
#define		SCROLLBAR_EXPENSE_EDCAT					84
#define		LIST_EXPENSE_EDCAT						85
#define		BUTTON_EXPENSE_EDCAT_LARGE_FONT			115
#define		BUTTON_EXPENSE_EDCAT_SMALL_FONT			116

/*===============================================================*/
/*============== FORM_EXPENSE_DIALOG_EDCAT ======================*/
#define		FORM_EXPENSE_DIALOG_EDCAT				86
#define		STRING_EXPENSE_DIALOG_EDCAT				87
#define		BITMAP_EXPENSE_DIALOG_EDCAT_X			88
#define		TEXTBOX_EXPENSE_DIALOG_EDCAT			89

/*===============================================================*/
/*============== FORM_EXPENSE_DIALOG_SELCAT =====================*/
#define		FORM_EXPENSE_DIALOG_SELCAT				90
#define		STRING_EXPENSE_DIALOG_SELCAT			91
#define		BITMAP_EXPENSE_DIALOG_SELCAT_X			92

/*===============================================================*/
/*============== FORM_EXPENSE_DIALOG_EXIST ======================*/
#define		FORM_EXPENSE_DIALOG_EXIST				93
#define		STRING_EXPENSE_DIALOG_EXIST1			94
#define		STRING_EXPENSE_DIALOG_EXIST2			95
#define		STRING_EXPENSE_DIALOG_EXIST3			96

/*===============================================================*/
/*============== FORM_EXPENSE_DIALOG_ERASE ======================*/
#define		FORM_EXPENSE_DIALOG_ERASE				97
#define		STRING_EXPENSE_DIALOG_ERASE				98
#define		BUTTON_EXPENSE_DIALOG_ERASE_YES			99
#define		BUTTON_EXPENSE_DIALOG_ERASE_NO			100

/*===============================================================*/
/*============== FORM_EXPENSE_DIALOG_REMOVE =====================*/
#define		FORM_EXPENSE_DIALOG_REMOVE				101
#define		STRING_EXPENSE_DIALOG_REMOVE1			102
#define		STRING_EXPENSE_DIALOG_REMOVE2			103
#define		STRING_EXPENSE_DIALOG_REMOVE3			104
#define		BUTTON_EXPENSE_DIALOG_REMOVE_YES		105
#define		BUTTON_EXPENSE_DIALOG_REMOVE_NO			106

/*===============================================================*/
/*============== FORM_EXPENSE_DIALOG_SELTYPE =====================*/
#define		FORM_EXPENSE_DIALOG_SELTYPE				110
#define		STRING_EXPENSE_DIALOG_SELTYPE			111
#define		BITMAP_EXPENSE_DIALOG_SELTYPE_X			112

/*===============================================================*/
/*============== FORM_EXPENSE_DIALOG_LOW_MEMORY =================*/
#define 	FORM_EXPENSE_DIALOG_LOW_MEMORY			118
#define 	BITMAP_EXPENSE_DIALOG_LOW_MEMORY_X		119
#define 	STRING_EXPENSE_DIALOG_LOW_MEMORY		120
#define 	STRING_EXPENSE_DIALOG_LOW_MEMORY2		121

//t===============================================================================
/*===============================================================*/
/*============== FORM_EXPENSE_DIALOG_INPUT_TYPE =================*/
#define		FORM_EXPENSE_DIALOG_INPUT_TYPE			122
#define		BITMAP_EXPENSE_DIALOG_INPUT_TYPE_X		123
#define		TEXTBOX_EXPENSE_DIALOG_INPUT_TYPE		124

/*===============================================================*/
/*============== FORM_EXPENSE_DIALOG_DEL_TYPE =================*/
#define		FORM_EXPENSE_DIALOG_DEL_TYPE			125
#define		STRING_EXPENSE_DIALOG_DEL_TYPE			126
#define		STRING_EXPENSE_DIALOG_DEL_TYPE2			127
#define		POPUP_EXPENSE_DIALOG_DEL_TYPE			128

/*===============================================================*/
/*============== FORM_EXPENSE_DIALOG_TYPE_EXIST =================*/
#define		FORM_EXPENSE_DIALOG_TYPE_EXIST			129
#define		STRING_EXPENSE_DIALOG_TYPE_EXIST1		130
#define		STRING_EXPENSE_DIALOG_TYPE_EXIST2		131
#define		STRING_EXPENSE_DIALOG_TYPE_EXIST3		132

//t===============================================================================

/*===============================================================*/
/*============== MENU_EXPENSE ===================================*/
#define		MENU_EXPENSE							113

/*==================== Menu Item ===========================*/
#define		MENU_ITEM_DELETE						0
#define 	MENU_ITEM_UNDELETE						1
#define 	MENU_ITEM_DELALL						2
#define 	MENU_ITEM_ADD_TYPE						3
#define 	MENU_ITEM_DEL_TYPE						4
#define 	MENU_ITEM_RENAME_TYPE					5

/*===============================================================*/

/*===============================================================*/
/*============== MENU_EXPENSE_EDCAT =============================*/
#define		MENU_EXPENSE_EDCAT						117

/*==================== Menu Item ===========================*/
#define		MENU_ITEM_FONT							0

/*===============================================================*/

typedef struct
{
	BYTE	year;
	BYTE	mon;
	BYTE	day;
	BYTE	hr;
	BYTE	min;
	BYTE	sec;
} EXPENSE_DATE;


/*===============================================================*/
/* Expense function in main */
BOOLEAN		ExpenseCurr(EvtType*);
BOOLEAN		ExpenseDialogEditCat(EvtType*);
//t===============================================================================
BOOLEAN		ExpenseDialogInputType(EvtType*);
BOOLEAN		ExpenseDialogDelType(EvtType*);
//t==============================================================================
BOOLEAN		ExpenseDialogSave(EvtType*);
BOOLEAN		ExpenseDialogSelectCat(EvtType*);
BOOLEAN		ExpenseDialogSelectType(EvtType*);
BOOLEAN		ExpenseDialogErase(EvtType*);
BOOLEAN		ExpenseDialogExist(EvtType*);
//t==============================================================================
BOOLEAN		ExpenseDialogTypeExist(EvtType*);
//t==============================================================================
BOOLEAN		ExpenseDialogRemove(EvtType*);
BOOLEAN		ExpenseDialogLowMemory(EvtType*);
BOOLEAN		ExpenseDate(EvtType*);
BOOLEAN		ExpenseEditCate(EvtType*);
BOOLEAN		ExpenseList(EvtType*);
BOOLEAN		ExpenseType(EvtType*);
BOOLEAN		ExpenseHandleKeyInStatus(EvtType *Event);



UBYTE	ExpenseCatSelectedNameToNum(BYTE *in_cat_string);
BOOLEAN ExpenseCatSetScrollbar(SHORT new_cat_num);
BOOLEAN ExpenseCatToList(BYTE *new_cat_string, BOOLEAN add_new_cat);
BOOLEAN ExpenseCheckMemoryEmpty();
BYTE	ExpenseCheckTextboxDigitOver(ObjectID textbox_id, BYTE *input_string, WORD insert_ptr_pos, SHORT sig_fig);
BOOLEAN ExpenseDatabaseClose(void);
BOOLEAN ExpenseDatabaseInit(BOOLEAN is_restart);
BOOLEAN ExpenseDeleteAllExpense(void);
BOOLEAN	ExpenseDeleteCat(void);
BOOLEAN ExpenseDeleteExpense(USHORT item_num);
UWORD	ExpenseGetNewExpenseType(void);
void	ExpenseInitTypeCurr(void);
BOOLEAN ExpenseIsKeypadVisible(void);
void	ExpenseKeypadInvisible(void);
void	ExpenseKeypadVisible(void);
BOOLEAN ExpenseListSetScrollbar(void);
BOOLEAN	ExpenseCheckNewRecord(void);
// -------------------- modified at 22052000 --------------------------------
BOOLEAN ExpenseLoadRecord(BYTE *incat_name, BOOLEAN reset_undelete);
// --------------------------------------------------------------------------
BOOLEAN ExpenseNewCat(BOOLEAN rename_cat);
BOOLEAN ExpenseNewExpense(void);
//t===============================================================================
BOOLEAN	ExpenseNewExpenseType(BYTE *expense_type_string, UWORD *total_rec);
BOOLEAN ExpenseUpdateExpenseType(void);
BOOLEAN ExpenseLoadExpenseType(void);
BOOLEAN ExpenseDeleteExpenseType(UWORD replaced_expense_type);
RecordID ExpenseTypeDBNumToDBRecID(UWORD db_type_num);
BOOLEAN ExpenseRenameExpenseType(BYTE *rename_expense_type_string);
//t===============================================================================
BOOLEAN ExpenseNumStyleConvert(BYTE *sbuf);
BOOLEAN ExpenseRecordToList(USHORT *new_item_num);
BOOLEAN ExpenseSetAmount(SHORT item_num, double amount);
void	ExpenseSetCatPopupEnable(void);
BOOLEAN ExpenseSetCurr(BYTE curr);
BOOLEAN ExpenseSetDate(EXPENSE_DATE date);
void 	ExpenseSetEdcatListFont(ObjectID list_id, BYTE font);
BOOLEAN ExpenseSetType(UBYTE type);
BOOLEAN ExpenseScrollbarSetCat(USHORT new_value);
void	ExpenseScrollbarSetList(USHORT new_value);
void	ExpenseStoreDate(EXPENSE_DATE date);

/* API functions in System Setup */
/*===============================================================*/
void	ExpenseInitMainGlobal(BOOLEAN is_restart);
void	ExpenseInitMDBGlobal(BOOLEAN is_restart);


#endif
