/* CDPEDITO.H  		CIC proprietary
 *----------------------------------------------------------------------------
 * SCCS Version 1.1, 17:24:06 3/5/96
 *----------------------------------------------------------------------------
 * S. Tien		Aug-15-1990	initial version
 * S. Tien		Nov-28-1990	added MAX(string, wordlist, charinword)
 *					      MAX(rawword)
 * S. Tien		Jan-15-1992	change MAXSTROKES from 200 to 500
 * S. Tien		Jun-19-1992	add SDELAY define to be 11
 * S. Tien		Dec-15-1992	added PRINTEDGRIDLESS datafmt type
 * S. Tien		Jan-18-1993	added CNONSTD and WNONSTD markings
 * JP Shipherd		Mar-05-1993	added ifndef CDPEDITOR_H
 * S. Tien              Apr-02-1993	added delay marking constants
 * K. Rolle             Apr-29-1993	Added types CDP_MARKING, CDP_STK_STATUS,
 *                                        and CDP_CHAR_STATUS (used by 
 *                                        bw_gdstk()).
 * E. Huang             Sep-28-1993     Added CDELAY1 for char dealy function.
 * K. Rolle             0ct-25-1993	Removed trailing commas from enum
 *                                        definitions.
 * K. Rolle             28-Feb-94  	Added type CDP_CONN_STATUS.
 * JP Shipherd		24-May-94	Renamed cdpedito.h for pc 
 *					 compatibility
 * Erica H.             09/27/94        Merge cdp_china.h -> cdpedito.h for 
 *                                      Chinese stuff
 *----------------------------------------------------------------------------
 */
#ifndef CDPEDITO_H
#define CDPEDITO_H

/* parameter constants */

#define ASCIISET	0x0000007F

#define BLACK   15
#define WHITE   0

#define FORWARD_STROKE   1
#define BACKWARD_STROKE  0

#define MAXNUM          32000
#define MAXSTROKES	1000  /* orig 500; extend for Japan and Chinese */
#define MAXCHARS	200
#define MAXWORDS	100

#define MAXCHR		2
#define MAXCHRS		50

#define MAXSTRING	256
#define MAXWORDLIST	50
#define MAXCHARINWORD	30
#define MAXRAWWORD	3000

#define SORDINARY	0	/* STROKE */
#define SIDOT 		1
#define STCROSS		2
#define SXCROSS		3
#define SPERIOD		4
#define SCOMMA		5
#define SAPOSTROPHY	6
#define SDQUOTE		7
#define SQUESMARK	8
#define SDELETE		9
#define SQUESTION	10
#define SDELAY		11
#define SDELAY1		12

#define SETC            11      /* for Chinesei "..." usage only  */

#define SPUNCH		19      /* all the punchuations */

#define	SMOUTH		20	/* Japanese protocol */
#define	SGATE		21
#define	SWOOD		22
#define	SPICK		23
#define	SMAN		24
#define	SMEN		25
#define	SDIRT		26
#define	SWATER		27
#define	STRIAN		28
#define	SSILK		29
#define	STALK		30
#define	SMONT		31
#define	SINSECT		32
#define	SGRASS		33
#define	SBAMBOO		34
#define	SSUN		35
#define	SMOON		36
#define	SWALK		37
#define	SHEART		38
#define	SZIGZAG		39

/* for Chinese radical  */
#define CONNRAD         99
#define NSTDRAD         100

#define CGOOD		20	/* CHARACTER */
#define CBAD 		21
#define CINSERT		22
#define CUNDO 		23
#define CDELETE		24
#define CQUESTION	25
#define CNONSTD		26
#define CNONGB		27
#define CCONN2	        0x1000
#define CCONN3	        0x2000
#define CCONN4	        0x4000
#define CDELAY		28      /* ending of char delay */
#define CDELAY1         29      /* beginning of char delay */

#define WGOOD		30	/* WORD */
#define WBAD 		31
#define WINSERT		32
#define WUNDO 		33
#define WDELETE		34
#define WQUESTION	35
#define WCONN	        36
#define WNONSTD	        37
#define WDELAY	        38

#define MARK 		1
#define UNMARK		0

#define PRINTEDLINE	0       /* data format */
#define CURSIVELINE	1
#define PRINTEDBOX	2
#define PRINTEDGRIDLESS	3

/* structure for stroke/char/word editing    */
#define EDITORREC struct editorrec
EDITORREC 
    {
    COUNT index;
    COUNT info;
    COUNT sortval;  /* just for sorting purpose, due to qsort() will
                       rearrange the same index key                  */ 
    };

/*
 *-----------------------------------------------------------------------------
 * For stroke status: normal, delayed stroke and pairwise connection 
 *-----------------------------------------------------------------------------
 */
typedef enum
     {
     SNORMAL,			/* a regular stroke			     */
     SDELAY_BEGIN,      	/* 1st stk of a char expecting a delayed stk */
     SDELAY_END,        	/* a delayed stroke                          */
     SCONN2_NORMAL,  		/* a stroke connected by 2 strokes           */ 
     SCONN2_DELAY_BEGIN 	/* a stroke connected by 2 strokes and also  */
				/* expects a delayed stroke		     */ 
     } CDP_STK_STATUS;

/*
 *-----------------------------------------------------------------------------
 * For char status: does it begin a word?
 *-----------------------------------------------------------------------------
 */
typedef enum
    {
    CDP_BEGIN_WORD,             /* Character begins a word                   */
    CDP_NOT_BEGIN_WORD          /* Character does not begin a word           */
     } CDP_CHAR_STATUS;

/*
 *-----------------------------------------------------------------------------
 * For char connected status: Specifies type of connected group and position
 * within connected group.  A connected group is a string of consecutive
 * characters in which each consecutive pair shares a stroke.
 *-----------------------------------------------------------------------------
 */
typedef enum
    {
    CDP_NO_CONN,                /* Character does not share any stroke with  */
                                /*   with any other character.               */
    CDP_CONN2_1,                /* First of two connected characters         */
    CDP_CONN2_2,                /* Second of two connected characters        */
    CDP_CONN3_1,                /* First of three connected characters       */
    CDP_CONN3_2,                /* Second of three connected characters      */
    CDP_CONN3_3,                /* Third of three connected characters       */
    CDP_CONN4_1,                /* First of four connected characters        */
    CDP_CONN4_2,                /* Second of four connected characters       */
    CDP_CONN4_3,                /* Third of four connected characters        */
    CDP_CONN4_4                 /* Fourth of four connected characters       */
     } CDP_CONN_STATUS;

/*
 *-----------------------------------------------------------------------------
 * For return type of function bw_gdstk().
 *-----------------------------------------------------------------------------
 */
typedef enum
    {
    CDP_MARKING_OK,             /* Sentence contains no problematic marking  */
    CDP_WRONG_WORD,             /* Sentence contains a word that has         */
                                /*   inconsistent marking                    */
    CDP_WRONG_MARKING,          /* Sentence contains suspect stroke markings */
    CDP_DELAY_MARKING           /* Sentence contains delayed stroke          */
    } CDP_MARKING;

/*  for Chinese charactor radical marking */
#define MAX_PMT  128          /*  max prompt string chars */
#define VER_MAX  20           /*  max version no */

#endif	/* #ifndef CDPEDITO_H	*/
/*----------------------------- end of CDPEDITOR.H --------------------------*/
