/* DATCOL.H			CIC proprietary
 *----------------------------------------------------------------------------
 * SCCS 1.2, 09:58:47 3/11/96
 *----------------------------------------------------------------------------
 * Header file for datcol program (modified to suit CDPEDITOR).
 *-----------------------------------------------------------------------------
 * David Hwang		March 1990
 * Simon S. Tien	08/14/1990
 * Simon S. Tien	12/14/1992	added GRIDLESS mode
 * Erica H.             01/19/1994      added MIXED for printing writing style
 *-----------------------------------------------------------------------------
 */
#ifndef DATCOL_H
#define DATCOL_H

/* Sampling rate (rateC) */
#define SLOW	        0	/* 100 pts/sec */
#define QUICK	        1	/* 200 pts/sec */

/* Spatial resolution (sparou) */
#define LOW	        0	/* 254 lines/inch */
#define HIGH	        1	/* 1016 lines/inch */

/* Entry mode (entmodC) */
#define SEQUENTIAL	0
#define RANDOM		1

/* Subject type (subtypC) */
#define SINGLE		0
#define _WORD		1
#define PHRASE		2
#define SENTENCE	3

/* Data type (dattypC) */
#define SUBJECT		0
#define VARIATION	1

/* Box mode or Line mode (boxmodC) */
#define LINE		0
#define BOX		1
#define GRIDLESS	2

/* Left or Right hander */
#define LEFT_HAND	0
#define RIGHT_HAND	1

/* Cursive or Printing writing style */
#define CURSIVE		0
#define PRINTING	1
#define MIXED           2

/* Status of the sample just collected */
#define GOOD		0
#define BAD		1
#define UNKNOWN		2

#define XDFILESTR      13	/* Max length of the filename string	     */
#define XPLACESTR      80	/* Max length of the place string	     */
#define XPROMTSTR     256	/* Max length of the prompted string	     */
#define HEADSIZE     1024	/* Main header size of the data file	     */

#define DT3103	        0
#define DT3203	        0
#define DT3503	        1
#define SUMAMM	        2

#define MAXALATT        2
#define MAXFDESC       13	/* Max. allowable length for a file desc.    */

#define SYSCOL	       58	/* Starting col. (0-79) for system-line msgs */
#define SYSROW	        0

#define MAXRAW     0x5000	/* Maximum length of the raw data buffer     */
#define MAXBOX        128	/* Maximum text box in one data sample	     */
#define MAXSEG       1024	/* Maximum stroke number in one data sample  */

#endif	/* #ifndef DATCOL_H	*/
