/* disampub.h			CIC Proprietary
 *------------------------------------------------------------------------------
 * SCCS Version %I%, %U% %G%
 *----------------------------------------------------------------------------
 * This file contains function prototypes for those functions that are
 * used outside the disamlib library.
 *----------------------------------------------------------------------------
 * S. Sanders        8 July 1992
 * K. Rolle         31-Aug-92   Added non-ANSI C prototypes.
 * JP Shipherd      04-Nov-92   Backport from PC.
 * D. Hwang         07-Dec-92   Added CIC_ATAN2_MACRO macro
 * JP Shipherd      23-Jan-93   Added ifndef DISAMPUB_H
 * V. Wilburn        3-Feb-93   Merged with Japanese
 * JP Shipherd      25-Mar-93   Removed NEARFUNC from far_xing()
 * D. Hwang         29-Sep-93   Removed ifind()
 * JP Shipherd      16-Feb-94   Added Dan Illowski's CIC_INT ipls3nc()
 * J. Wang          30-May-95   Changed CIC_ATAN2_MACRO according to John's
 *                                new code.
 *----------------------------------------------------------------------------
 */
#ifndef DISAMPUB_H
#define DISAMPUB_H

/*
 *------------------------------------------------------------------------------
 * include necessary headers
 *------------------------------------------------------------------------------
 */
#include <params.h> 	    	/* STROKE needed by disampub.h	    	     */
#include <zorroapi.h>
#include <modpub.h>
#include <zohmmpub.h>


COUNT cic_atan2
    (
    COUNT x,
    COUNT y
    );

ULONG eucdis
    (
    LONG deltaxL,			/* x difference = x0 - x1	      */
    LONG deltayL			/* y difference = y0 - y1	      */
    );

BOOL cmp4
    (
    ZO_DATA	*zo_dataP,
    TINY *dpt
    );

BOOL rat2
    (
    ZO_DATA	*zo_dataP,
    TINY *input_dpt
    );

BOOL rat3
    (
    ZO_DATA	*zo_dataP,
    TINY *input_dpt
    );

BOOL  ixing
    (
    STROKE *ps,
    COUNT p3,
    COUNT p4,
    COUNT sx,
    COUNT sy,
    COUNT x1,
    COUNT x2,
    COUNT y1,
    COUNT y2
    );

BOOL xing12
    (
    ZO_DATA	*zo_dataP,
    TINY *dpt
    );

BOOL ccdthr
    (
    ZO_DATA	*zo_dataP,
    TINY *dpt
    );

BOOL dist
    (
    ZO_DATA	*zo_dataP,
    TINY *input_dpt
    );

INT  ifin2
    (
    STROKE *ps,
    COUNT p1,
    COUNT p2,
    COUNT type
    );

BOOL fin2
    (
    ZO_DATA	*zo_dataP,
    TINY *input_dpt
    );

BOOL find
    (
    ZO_DATA	*zo_dataP,
    TINY *input_dpt
    );

BOOL hocvrc
    (
    ZO_DATA	*zo_dataP,
    TINY *dpt
    );

BOOL hrivrtp
    (
    ZO_DATA	*zo_dataP,
    TINY *dpt
    );

BOOL leng12
    (
    ZO_DATA	*zo_dataP,
    TINY *input_dpt
    );

BOOL angl
    (
    ZO_DATA	*zo_dataP,
    TINY *dpt
    );

BOOL avac
    (
    ZO_DATA	*zo_dataP,
    TINY *dpt
    );

BOOL avag
    (
    ZO_DATA	*zo_dataP,
    TINY *dpt
    );

BOOL avan
    (
    ZO_DATA	*zo_dataP,
    TINY *dpt
    );

BOOL pls3(
    ZO_DATA	*zo_dataP,
    TINY *dpt
    );

BOOL rtlt
    (
    ZO_DATA	*zo_dataP,
    TINY *dpt
    );

INT pindex
    (
    ZO_DATA	*zo_dataP,
    STROKE *ps,
    COUNT  pt
    );

VOID p2index
    (
    ZO_DATA	*zo_dataP,
    STROKE *ps,
    COUNT  pt1,
    COUNT  pt2,
    COUNT *ibegP,
    COUNT *iendP
    );

BOOL hrivrt
    (
    ZO_DATA	*zo_dataP,
    TINY *dP
    );

BOOL cccw
    (
    ZO_DATA	*zo_dataP,
    TINY *dpt
    );

/* CIC_ATAN2_MACRO			CIC Proprietary
 *-----------------------------------------------------------------------------
 * Macro to calculate the angle between two points, (xo, yo) and (x1, y1).
 * That is, calculation of arctan(x1 - xo, y1 - yo).
 *
 * NOTE:  Must include the following in the calling program
 *
 *	  1. IMPORT COUNT angle_table[];
 *
 * inputs:	dx = (x1 - xo)	  --    the x difference value
 * 		dy = (x1 - xo)	  --    the y difference value
 *
 * output:	angle		  --    the calculated angle [arctan(dx, dy)]
 *
 * j. s. ostrem	    Nov 23, 1992	Macro version of cic_atan2 (taken
 *					from ~ostrem/lib/jsolib/cic_atan2.c)
 *-----------------------------------------------------------------------------
 */

#define CIC_ATAN2_MACRO(dx, dy, angle) \
    { \
    LONG absdxL; \
    LONG absdyL; \
    IMPORT COUNT angle_table[]; \
    absdxL = (LONG) abs(dx); \
    absdyL = (LONG) abs(dy); \
    if (absdxL >= absdyL) \
	{ \
	if (absdxL != 0L) \
	    angle = angle_table[((absdyL << 7) + (absdxL >> 1)) / absdxL]; \
	else \
	    angle = 0; \
	} \
    else \
	angle = 900 - angle_table[((absdxL << 7) + (absdyL >> 1)) / absdyL]; \
    if (dx < 0) \
        angle = 1800 - angle; \
    if (dy < 0) \
        angle = -angle; \
    }
/*-------------------------- end of CIC_ATAN2_MACRO -------------------------*/


/* DIST_512_4_MACRO			CIC Proprietary
 *-----------------------------------------------------------------------------
 * Macro to calculate the distance (x512) between two points.  It is assumed
 * that the arguments dxL, dyL, distL, are LONG integers.  After the macro
 * is called, distL contains an approximation to the true euclidean distance.
 * The calculation has a MAXIMUM error of 4% (except for very small input
 * values), based on the following formulae:
 *
 * If (x0, y0) and (x1, y1) are the two points to calculate the distance
 * between, then define
 *
 *		dx  =  x0 - x1
 *		dy  =  y0 - y1
 *
 * Note that both dx and dy can be positive or negative, so calculate
 *
 *		abs_dx  =  |x0 - x1|
 *		abs_dy  =  |y0 - y1|
 *
 * The calculation is based on an approximation to the hypotenuse C
 * of a right triangle with sides A = max(abs_dx, abs_dy) and
 * B = min(abs_dx, abs_dy)
 *
 * If A >= 2B, the function returns:
 *
 *              512 * (A + B/4) = 128 * (4A  + B)
 *                              = ((A << 2) + B) << 7
 *
 * If A < 2B, the function returns:
 *
 *              512 * (7A/8 + B/2)  =  64 * (7A + 4B)
 *                                  =  ((A << 3) - A + (B << 2)) << 6
 *
 *
 * NOTE: For efficiency there is no checking done to determine if the
 *	 calculated distance will be too large to fit in an LONG
 *	 integer (i.e., there is no OVERFLOW protection).  Hence it is the
 *	 programmer's responsibility to check for this condition before
 *	 calling the program if it is possible, given the problem, for
 *	 the overflow to occur.  See below for definitions of the size
 *	 of LONG and UNSIGNED LONG integers.
 *
 * NOTE: a LONG integer is in the range  -(2 to the power of 31) to
 *	 (2 to the power of 31 - 1), or from slightly less than minus 2
 *       to slightly more than plus 2 billion.
 * NOTE: an UNSIGNED LONG integer is a POSITIVE integer in the range 0 to
 *	 (2 to the power of 32), or 0 to something more than 4 billion
 *
 *
 * inputs:	dxL = (x1 - xo)	  --    the x difference value
 * 		dyL = (x1 - xo)	  --    the y difference value
 *
 * output:	distL		  --    the calculated Euclidean Distance (x512)
 *
 * j. s. ostrem	    Nov 24, 1992	Macro version of  dist_512_4.c
 *-----------------------------------------------------------------------------
 */

#define DIST_512_4_MACRO(dxL, dyL, distL) \
    { \
    if (dxL < 0) \
	dxL = -dxL; \
    if (dyL < 0) \
	dyL = -dyL; \
    if (dxL <= dyL) \
	{ \
	distL = dxL; \
	dxL   = dyL; \
	dyL   = distL; \
	} \
    if (dxL > (dyL << 1)) \
	distL = ((dxL << 2) + dyL) << 7; \
    else \
	distL = ((dxL << 3) - dxL + (dyL << 2)) << 6; \
    }
/*-------------------------- end of DIST_512_4_MACRO ------------------------*/


#endif	/* ifndef DISAMPUB_H */
