/* DYNAMIC.H                                                   CIC Proprietary
 *----------------------------------------------------------------------------
 * SCCS version 1.1, 17:24:07 3/5/96
 *----------------------------------------------------------------------------
 * Definition of parameters and structures for program REALSIG
 *
 * JP Shipherd	 04-Nov-92    Backport from PC.
 *----------------------------------------------------------------------------
 */

#define MMAX 256
#define MAXWRD 20               /* max length of a word in connected script */
#define NUMFEAT 44              /* number of features (length of oldvalL))  */
#define INPUTSEGS 200           /* max number of allowed segments in signtr.*/
#define MAXSIG 1024             /* max length for arrays used in sign. ver. */
#define SAVESEGS 20             /* max number of segments saved in template */
#define MAXTEMP 6               /* maximum number of signatures in a        */
                                /* subject's signature template             */
#define DPTHRES 25000L          /* stopping distance for DP calculation     */
#define TEMPPTS 256             /* number of points in signature templates  */

#ifdef sun
#define TEMPDAT struct tempdat
TEMPDAT				/* structure for signatures templates	    */
    {
    COUNT timedown;		/* total time that pen is down 		    */
    COUNT nsegments;		/* number of down segments (i.e. pen-downs) */
    COUNT x_energy;		/* standard deviation of X-signal 	    */
    COUNT y_energy;		/* standard deviation of Y-signal 	    */
    COUNT xtemp[TEMPPTS];	/* data for X-signal template     	    */
    COUNT ytemp[TEMPPTS];	/* data for Y-signal template    	    */
    };

#else /* ifdef sun */

#define TEMPDAT struct tempdat
TEMPDAT                         /* structure for signatures templates       */
    {
    COUNT timedown;             /* total time that pen is down              */
    COUNT nsegments;            /* number of down segments (i.e. pen-downs) */
    COUNT x_energy;             /* standard deviation of X-signal           */
    COUNT y_energy;             /* standard deviation of Y-signal           */
    COUNT xtemp[TEMPPTS];       /* data for X-signal template               */
    COUNT ytemp[TEMPPTS];       /* data for Y-signal template               */
    COUNT segptrs[SAVESEGS];    /* indices to beginnings of segments        */
    COUNT endptrs[SAVESEGS];    /* indices to ends of segments (except last)*/
    LONG  xacoefL;              /* linear x trend a coefficient (from a+bt) */
    LONG  xbcoefL;              /* linear x trend b coefficient (from a+bt) */
    LONG  yacoefL;              /* linear y trend a coefficient (from a+bt) */
    LONG  ybcoefL;              /* linear y trend b coefficient (from a+bt) */
    COUNT xave;                 /* x average after detrending               */
    COUNT yave;                 /* y average after detrending               */
    };

#endif /* ifdef sun */

#define TEMP2 struct temp2
TEMP2                       	/* structure for signatures templates       */
    {
    COUNT time;                 /* total time that pen is down              */
    COUNT nseg;                 /* number of down segments (i.e. pen-downs) */
    COUNT x_ener;               /* standard deviation of X-signal           */
    COUNT y_ener;               /* standard deviation of Y-signal           */
    COUNT xxx[TEMPPTS];         /* data for X-signal template               */
    COUNT yyy[TEMPPTS];         /* data for Y-signal template               */
    };
