// jotcedbg.h

#ifndef JOTCEDBG_H
#define JOTCEDBG_H

// The following part is for debug
#if JOT_DEBUG

#define _Debug_Printf Debug_Printf

#define  SZ_CHARTYPE    TCHAR
#define  LP_STRINGTYPE  LPTSTR

_inline VOID
CDECL
_Debug_Printf(
    LP_STRINGTYPE pFormatString,
    ...
    )
{
     va_list arglist;
     SZ_CHARTYPE DebugBuffer[2048];
	 SZ_CHARTYPE *lpBuf = DebugBuffer;
	 TCHAR dbfile[] = TEXT("\\windows\\desktop\\debug.txt");
	 HANDLE hdbfile;
	 DWORD	nwritten;
	 DWORD	nwrite;

     va_start(arglist, pFormatString);
     nwrite = wvsprintf(DebugBuffer, pFormatString, arglist);
	 hdbfile = CreateFile(dbfile, GENERIC_WRITE, FILE_SHARE_READ, NULL,
		OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	 if (hdbfile != INVALID_HANDLE_VALUE)
		{
		SetFilePointer(hdbfile, -1, NULL, FILE_END);
		SetFilePointer(hdbfile, 1, NULL, FILE_CURRENT);
		WriteFile(hdbfile, DebugBuffer, nwrite * 2, &nwritten, NULL);
		CloseHandle(hdbfile);
		}
}


_inline VOID
CDECL
_Debug_Printf_Cond(
	BOOL fCond,
    LP_STRINGTYPE pFormatString,
    ...
    )
{
	if ( fCond )
	{
        va_list arglist;
        SZ_CHARTYPE DebugBuffer[2048];
		SZ_CHARTYPE *lpBuf = DebugBuffer;
		 TCHAR dbfile[] = TEXT("\\windows\\desktop\\debug.txt");
		 HANDLE hdbfile;
		DWORD	nwritten;
		DWORD	nwrite;

        va_start(arglist, pFormatString);
        nwrite = wvsprintf(DebugBuffer, pFormatString, arglist);
		hdbfile = CreateFile(dbfile, GENERIC_WRITE, FILE_SHARE_READ, NULL,
			OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hdbfile != INVALID_HANDLE_VALUE)
			{
			SetFilePointer(hdbfile, -1, NULL, FILE_END);
			SetFilePointer(hdbfile, 1, NULL, FILE_CURRENT);
			WriteFile(hdbfile, DebugBuffer, nwrite * 2, &nwritten, NULL);
			CloseHandle(hdbfile);
			}
	}
}

#define DBG_PRINTF_COND _Debug_Printf_Cond
#define DBG_PRINTF 		_Debug_Printf
#define DBGNEWLINE 	DBG_PRINTF( TEXT( "\r\n"));

#else	// dont want debug msgs

// NOTE: the below warning will only be disabled in straight 'retail' builds,
//  not in either 'debug' builds or 'WANT_DEBUG_MSGS retail' builds
#pragma warning( disable:4002 )	// wrong number of parms warning
#define DBG_PRINTF_COND()
#define DBG_PRINTF()
#define DBGNEWLINE 	

#endif	/* #if JOT_DEBUG	*/

#endif	/* #if JOTCEDBG_H	*/
