// jotmepub.h

#ifndef JOTMEPUB_H
#define JOTMEPUB_H

#ifdef _WIN32_WCE

#define DllExport	__declspec( dllexport )

#define JOT_MACRO_DLL	TEXT("jotmedll.dll")
#define JOT_MACRO_DLL_SPELLER	TEXT("cicmedll.dll")

#define JOT_ME_DATABASE	TEXT("Jot Macro Database")

#define JOT_MAX_MACRO_OUTPUT_LEN 1024
#define JOT_MAX_MACRO_LEN		 7
	
#define JOT_MACRO_TEXT		0
#define JOT_MACRO_ACTION	1

#if 0 // ( _WIN32_WCE < 101 )
#define CEOID PEGOID
#endif

typedef struct tagJOT_MACRO
	{
	TCHAR	macroS[JOT_MAX_MACRO_LEN + 1];		// Macro name
	int		type;								// Text
	union 
		{
		int		action;						// Action index
		TCHAR	textS[JOT_MAX_MACRO_OUTPUT_LEN + 1];		// Text string
		}	output;
	}	JOT_MACRO;

BOOL DllExport JotMeWrite
	(
	JOT_MACRO	*macroP,
	CEOID		pegoid
	);
typedef BOOL (*PFN_JOTMEWRITE)
	(
	JOT_MACRO	*macroP,
	CEOID		pegoid
	);

CEOID DllExport JotMeSeek
	(
	TCHAR		*macroS,
	DWORD		*dwIndexP
	);
typedef CEOID (*PFN_JOTMESEEK)
	(
	TCHAR		*macroS,
	DWORD		*dwIndexP
	);

BOOL DllExport JotMeRead
	(
	JOT_MACRO	*macroP
	);
typedef BOOL (*PFN_JOTMEREAD)
	(
	JOT_MACRO	*macroP
	);

BOOL DllExport JotMeFind
	(
	DWORD	index
	);
typedef BOOL (*PFN_JOTMEFIND)
	(
	DWORD	index
	);

BOOL DllExport JotMeDelete
	(
	DWORD	index
	);
typedef BOOL (*PFN_JOTMEDELETE)
	(
	DWORD	index
	);

typedef struct tagJOTME_FUNC
	{
	PFN_JOTMEWRITE	JotMeWriteP;
	PFN_JOTMESEEK	JotMeSeekP;
	PFN_JOTMEREAD	JotMeReadP;
	PFN_JOTMEFIND	JotMeFindP;
	PFN_JOTMEDELETE	JotMeDeleteP;
	} JOTME_FUNC;

#else
#define JOT_MACRO_DLL	NULL
#endif	/* #ifdef _WIN32_WCE	*/
#endif
