/* LOWPUB.H	@(#)lowpub.h	1.56   10/29/96   19:59:32
 *----------------------------------------------------------------------------
 * Definition of constants and structures for low end recognizer.
 *
 * CIC Proprietary      Copyright (C) 1995 CIC Inc.
 *
 * Gordon Sun 	05/17/95
 *----------------------------------------------------------------------------
 */

#ifndef LOWPUB_H
#define LOWPUB_H

/*
 *-----------------------------------------------------------------------------
 * Constants for tablet input
 *-----------------------------------------------------------------------------
 */
#define CHARSEGS 256            /* number of points in angle templates      */
#define CHARPTS (CHARSEGS + 1)  /* number of points in  X, Y templates      */
#define MMAX    (CHARSEGS + 1)  /* length of column arrays for DYNANG       */
#define MAX_DATA_FILES	200     /* Max number of data files. */
 


/*
 *-----------------------------------------------------------------------------
 * Constants for preprocessing.
 *-----------------------------------------------------------------------------
 */

 #define	SIZE_OFFSET	24	/* Used in size normalization.*/
 #define	RS_SHIFT	9	/* Resampling shift constant.	*/
 #define	END_SHIFT	2	/* Down shift for end point features.*/

 #define	MAX_SEGMENTS	16	/* Max number of segments.	*/
 #define	MAX_STROKES	2	/* Max number of strokes.	*/
 #define	ANGLE_RANGE	32	/* Angle range.			*/
 #define	ANGLE_HALF	16	/* Half angle range.		*/
 #define	ZERO_CURV	48	/* Curvature origin.		*/
 #define	ANGLE_SEG1	6	/* Angle change for segmentation.*/
 #define	ANGLE_SEG2	7	/* Angle change for segmentation.*/
 #define	ANGLE_SEG3	11	/* Angle change for segmentation.*/
 #define	ANGLE_SEG4	5	/* Angle change for segmentation.*/
 #define	ANGLE_SEG5	2	/* Angle change for segmentation.*/
 #define	MAX_DOT_SIZE	12	/* If size < this value, it is a dot.*/
 #define	MAX_DOT_SIZE1	16	/* If size < this value, it is a dot.*/
 #define	FEATURE_SIZE	80	/* Max feature points.*/

 #define	NUM_POS_CENTR	2	/* Number of position centers.*/

/*
 *-----------------------------------------------------------------------------
 * Constant for classification of strokeds and characters.
 *-----------------------------------------------------------------------------
 */
 #define	TOT_REJECT_THRES 20	/* Thresheld for rejection.    	    */
 #define	ANG_REJECT	8	/* Reject value for posision score. */
 #define	LEN_REJECT	8	/* Reject value for posision score. */
 #define	CUR_REJECT	24	/* Reject value for posision score. */
 #define	POS_REJECT	50	/* Reject value for posision score. */
 #define	SHAPE_DISAMB	30	/* Threshold for shape disambiguation.*/
 #define        HOOK_DIS        30      /* Threshold for rec without hooks.*/

/*
 *-----------------------------------------------------------------------------
 * Property flag for recognition (in field of recP). 
 *-----------------------------------------------------------------------------
 */
 #define	FL_USCHAR	0x0001	/* Do recognition of U.S. Characters.*/
 #define	FL_DIGIT	0x0002	/* Do recognition of digits.	*/
 #define        FL_EQUAT        0x0002  /* Do recognition of digits.    */
 #define	FL_SYMBOL	0x0004	/* Do recognition of digits.	*/
 #define	FL_EXTEND	0x0008	/* Do recognition for extended chars.*/
 #define        FL_USEMODEL     0x0010  /* Use model for recognition.   */
 #define        FL_DISAMB       0x0020  /* Use model for recognition.   */
 #define        FL_HOOK       	0x0040  /* Use model for recognition.   */
 #define	FL_PENALTY	0x0080  /* Add extra penalty for recognition.*/
/*
 *-----------------------------------------------------------------------------
 * Constant for labeling of the recognition models of characters and 
 * symbols (and their versions).
 * When you change the mapping table in lowlib/table.c, you need to change
 * the following constants.
 *-----------------------------------------------------------------------------
 */
 #define	TOT_MODELS	78	/* Total number of models.*/
 #define	BAS_NUM_MOD	18	/* Base models used in number mode.*/
 #define	TOT_NUM_MOD	37	/* # of models used in number mode.*/
 #define	BAS_CHA_MOD	46	/* base models used in character mode.*/
 #define	TOT_CHA_MOD	59	/* # of models used in character mode.*/
 #define	TOT_SYM_MOD	26	/* # of models used in symbol mode.*/
 #define	TOT_EXT_MOD	56	/* # of models in extended characters.*/
 
 #define 	MOD_WAIT_FOUR	3	/* Model index of first stk of '4'  */
 #define 	MOD_WAIT_X	56	/* Model index of first stroke of 'x' */
 #define 	MOD_MODE_TO_EXTENDED_FIRST	67
 #define	MOD_MODE_TO_EXTENDED_SECOND	68
 					/* Model index for EXTENDED mode switch */

 #define	REC_REJECTED	255	/* It is rejected.	    	    */
 #define	REC_WAIT	254	/* It is not finished.	    	    */

 #define	X_SECOND	4	/* # of models for second stk of X. */

/*
 *-----------------------------------------------------------------------------
 * Labels of data files.
 *-----------------------------------------------------------------------------
 */
 #define	TOT_DATA_MODELS	102	/* Total number of models.*/
/* Number models (total 16). */
 #define	NUM_ONE		0	/* It is number '1'. */
 #define	NUM_TWO_1	1	/* It is version 1 of number '2'. */
 #define	NUM_TWO_2	1	/* It is version 2 of number '2'. */
 #define	NUM_THREE	2	/* It is number '3'. */
 #define	NUM_FOUR_1	3	/* It is version 1 of number '4'. */
 #define	NUM_FOUR_2	4	/* It is version 2 of number '4'. */
 #define	NUM_FOUR_3	5	/* It is version 3 of number '4'. */
 #define	NUM_FIVE_1	6	/* It is version 1 of number '5'. */
 					/* It is also character 'S'. */
 #define	NUM_FIVE_2	7	/* It is version 2 of number '5'. */
 #define	NUM_SIX		8	/* It is number '6'. */
 #define	NUM_SEVEN	9	/* It is number '7'. */
 #define	NUM_EIGHT_1	10	/* It is version 1 of number '8'. */
 #define	NUM_EIGHT_2	11	/* It is version 2 of number '8'. */
 #define	NUM_NINE	12	/* It is number '9'. */
 #define	NUM_ZERO_1	13	/* It is verion 1 of '0' or 'O'. */
 #define	NUM_ZERO_2	14	/* It is verion 2 of '0' or 'O'. */

/* editing models (total 4) shared in number and character mode. */
 #define	SYM_BAC		15	/* It is back space. */
 #define	SYM_SPA		16	/* It is dash '_' or space. */
 #define	SYM_NEW_1	17	/* It is comma ',' or new line. */

/* Character models (total 58). */
 #define	CHAR_A_1	18	/* It is the version 1 of letter 'A'.*/
 #define	CHAR_A_2	19	/* It is the version 2 of letter 'A'.*/
 #define	CHAR_A_3	19	/* It is the version 3 of letter 'A'.*/
 #define	CHAR_B_1	20	/* It is the version 1 of letter 'B'.*/
 #define	CHAR_B_2	21	/* It is the version 2 of letter 'B'.*/
 #define	CHAR_C		22	/* It is the letter C. */
 #define	CHAR_D_1	23	/* It is the version 1 of letter 'D'.*/
 #define	CHAR_D_2	24	/* It is the version 2 of letter 'D'.*/
 #define	CHAR_E		25	/* It is the letter E. */
 #define	CHAR_F_1	26	/* It is the version 1 of letter 'F'.*/
 #define	CHAR_F_2	27	/* It is the version 2 of letter 'F'.*/
 #define	CHAR_F_3	28	/* It is the version 3 of letter 'F'.*/
 #define	CHAR_G_1	29	/* It is the version 1 of letter 'G'.*/
 #define	CHAR_G_2	30	/* It is the version 2 of letter 'G'.*/
 #define	CHAR_G_3	30	/* It is the version 3 of letter 'G'.*/
 #define	CHAR_H_1	31	/* It is the version 1 of letter 'H'.*/
 #define	CHAR_H_2	-1	/* It is the version 2 of letter 'H'.*/
 #define	CHAR_H_3	32	/* It is the version 3 of letter 'H'.*/
 #define	CHAR_I_1	0	/* It is the version 1 of letter 'I'.*/
 					/* It is  also an apostrophe '''. */
 #define	CHAR_I_2	-1	/* It is the version 2 of letter 'I'.*/
 #define	CHAR_J_1	33	/* It is the version 1 of letter 'J'.*/
 #define	CHAR_J_2	33	/* It is the version 2 of letter 'J'.*/
 #define	CHAR_J_3	-1	/* It is the version 3 of letter 'J'.*/
 #define	CHAR_K_1	34	/* It is the version 1 of letter 'K'.*/
 #define	CHAR_K_2	35	/* It is the version 2 of letter 'K'.*/
 #define	CHAR_L_1	36	/* It is the version 1 of letter 'L'.*/
 #define	CHAR_L_2	37	/* It is the version 2 of letter 'L'.*/
 #define	CHAR_M_1	38	/* It is the version 1 of letter 'M'.*/
 #define	CHAR_M_2	39	/* It is the version 2 of letter 'M'.*/
 #define	CHAR_N		40	/* It is the letter N. */
 #define	CHAR_O_1	13	/* It is verion 1 of '0' or 'O'. */
 #define	CHAR_O_2	14	/* It is verion 2 of '0' or 'O'. */
 #define	CHAR_P_1	41	/* It is the version 1 of letter 'P'.*/
 #define	CHAR_P_2	42	/* It is the version 2 of letter 'P'.*/
 #define	CHAR_Q_1	43	/* It is the version 1 of letter 'Q'.*/
 #define	CHAR_Q_2	-1	/* It is the version 2 of letter 'Q'.*/
 #define	CHAR_Q_3	44	/* It is the version 3 of letter 'Q'.*/
 #define	CHAR_R_1	45	/* It is the version 1 of letter 'R'.*/
 #define	CHAR_R_2	46	/* It is the version 2 of letter 'R'.*/
 #define	CHAR_S		47	/* It is the letter 'S' or '5'. */
 #define	CHAR_T_1	48	/* It is the version 1 of letter 'T'.*/
 #define	CHAR_T_2	49	/* It is the version 2 of letter 'T'.*/
 #define	CHAR_T_3	50	/* It is the version 3 of letter 'T'.*/
 #define	CHAR_T_4	-1	/* It is the version 4 of letter 'T'.*/
 #define	CHAR_U_1	51	/* It is the version 1 of letter 'U'.*/
 #define	CHAR_U_2	52	/* It is the version 2 of letter 'U'.*/
 #define	CHAR_V_1	53	/* It is the version 1 of letter 'V'.*/
 #define	CHAR_V_2	54	/* It is the version 2 of letter 'V'.*/
 #define	CHAR_V_3	53	/* It is the version 3 of letter 'V'.*/
 #define	CHAR_V_4	53	/* It is the version 4 of letter 'V'.*/
 #define	CHAR_W		55	/* It is the letter W. */
 #define	CHAR_X_1	56	/* It is the version 1 of letter 'X'.*/
 #define	CHAR_X_2	57	/* It is the version 2 of letter 'X'.*/
 #define	CHAR_X_3	-1	/* It is the version 3 of letter 'X'.*/
 #define	CHAR_X_4	-1	/* It is the version 4 of letter 'X'.*/
 #define	CHAR_Y_1	58	/* It is the version 1 of letter 'Y'.*/
 #define	CHAR_Y_2	59	/* It is the version 2 of letter 'Y'.*/
 #define	CHAR_Y_3	-1	/* It is the version 3 of letter 'Y'.*/
 #define	CHAR_Z		60	/* It is the letter Z. */


/* Symbol and gesture models. */
 #define	SYM_APS		0	/* It is apostrophe "'" or "I". */
 #define	SYM_DAS		16	/* It is dash '_' or space. */
 #define	SYM_COM		17	/* It is comma ',' or new line. */
 #define	SYM_DOL		CHAR_S	/* It is '$' (or 'S' and '5'). */
 #define	SYM_EXC		61	/* It is exclamation '!'. */
 #define	SYM_QUE		62	/* It is question mark '?'. */
 #define	SYM_RBR		63	/* It is rigth bracket ')'. */
 #define	SYM_LBR		64	/* It is left bracket '('. */
 #define	SYM_SLA		65	/* It is slash '/'. */
 #define	RESET		66	/* It is a upper-left stroke. */
 #define	SYM_RLT		67	/* It is retraced left stroke. */
 #define	SYM_RRT		68	/* It is retraced right stroke. */
 #define	SYM_RUP		-1	/* It is retraced up stroke. */
 #define	SYM_RDN		-1	/* It is retraced down stroke. */
 #define	SYM_RUL		-1	/* It is retraced Upper-left stroke. */
 #define	SYM_RUR		-1	/* It is retraced Upper-right stk. */
 #define	SYM_RLL		-1	/* It is retraced lower-left stroke. */
 #define	SYM_RLR		-1	/* It is retraced lower-right stk. */
 #define	SYM_CUT		69	/* CUT gesture. */
 #define	SYM_PAS		70	/* PASTE gesture. */
 #define	SYM_DEL		71	/* DELETE gesture. */
 #define	SYM_COP		72	/* COPY gesture. */
 #define	SYM_PER		73	/* Percent '%' symbol. */
 #define	CHAR_R_A	74	/* Reversed 'A'. */
 #define	CHAR_R_C	75	/* Reversed 'C'. */
 #define	CHAR_R_E	76	/* Reversed 'E'. */
 #define	CHAR_R_N	-1	/* Reversed 'N'. */
 #define	CHAR_R_O	77	/* Reversed 'O'. */
/* #define	SYM_UNDO	78	 New "undo" gesture. */
/*  #define	SYM_RETURN	79	 New "catraige return" gesture. */
/* #define	CHAR_C_2	85	 Shape  '<'. */
/* #define	CHAR_R_S	85	 Reversed 'S'. */
/* #define	SYM_SHC		86	 Short cut gesture. */
 #define	SYM_DOT		-1	/* It is dot '.'. */

/*
 *-----------------------------------------------------------------------------
 * Macros
 *-----------------------------------------------------------------------------
 */
 #define	CURV(x)		{ if (x > ANGLE_HALF) x -= ANGLE_RANGE; \
				  else if (x < -ANGLE_HALF) x += ANGLE_RANGE;}

/*
 *-----------------------------------------------------------------------------
 * Structures
 *-----------------------------------------------------------------------------
 */

typedef struct databox        	DATABOX;
typedef struct stkdata        	STKDATA;
typedef struct chdata         	CHDATA;
typedef struct lowrec         	LOWREC;
typedef struct charmod        	CHARMOD;
typedef struct charver        	CHARVER;
typedef struct charverF        	CHARVERF;
typedef struct model        	MODEL;
typedef struct recmod        	RECMOD;
typedef struct recchar        	RECCHAR;
typedef struct recver        	RECVER;
typedef struct datamap        	DATAMAP;

struct datamap          /* A map between data file and model number. */
    {
    CIC_TEXT        *labelS;
    CIC_INT16       indexW;
    };

struct databox          /* A box to hold the current data. */
    {			/* We use (minx, miny) as the origin.*/
    CIC_INT16       maxxW;
    CIC_INT16       maxyW;
    };

/*
 *  This is the structure to hold the stroke raw data. 
 */
struct stkdata
    {
    CIC_INT16   *xWP;        /* X data array                 */
    CIC_INT16   *yWP;        /* Y data array                 */
    CIC_INT16   lenW;        /* Number of raw data points    */
    CIC_INT16   *fxWP;       /* X feature array              */
    CIC_INT16   *fyWP;       /* Y feature array              */
    CIC_INT16   *angleWP;    /* Angle feature array          */
    CIC_INT16   ftlenW;      /* Number of feature points.    */
    CIC_INT16   segnoW;      /* Number of segments.          */
    CIC_INT16   sizeW;       /* Size of the stroke.          */
    CIC_INT16   *segbegWP;   /* Start point of each segment. */
    CIC_INT16   *segangWP;   /* Angle of each segment.       */
    CIC_INT16   *segcurWP;   /* Curvature of each segment.   */
    CIC_UINT8	xbegUC;		/* x coordinate of start point.	*/
    CIC_UINT8	ybegUC;		/* y coordinate of start point.	*/
    CIC_UINT8	xendUC;		/* x coordinate of end point.	*/
    CIC_UINT8	yendUC;		/* y coordinate of end point.	*/
    DATABOX	box;
    STKDATA     *nextP;     /* ptr to next                  */
    };
 
/*
 *  This is the structure to hold the data for one character. 
 */
struct chdata
    {
    STKDATA     *stkP;      /* raw data.        */
    CIC_INT16	nstkW;	    /* number of strokes.	*/
    CIC_INT16	lenW;	    /* number of data points.	*/
    CIC_INT16	indexW;	    /* character label.	*/
    };


/*
 *  This is the structure to hold a model for one character version. 
 */
struct charver
    {
    CIC_INT32	countL;		/* Number of samples for this version.*/
    CIC_UINT8	penalUC;   	/* Penalty distance.	*/
    CIC_UINT8	segnoUC;   	/* Number of segments.	*/
    CIC_UINT8	*angUCP;   	/* Angle of each segment.	*/
    CIC_UINT8	*curUCP;   	/* Curvature of each segment.*/
    CIC_UINT8	*lenUCP;	/* Length of each segment.*/
    };

/*
 *  This is the structure to hold a model for a character. 
 */
struct charmod
    {
    CIC_UINT8	vernoUC;	/* Number of versions.	*/
    CIC_UINT8   segno_minUC;    /* Min segment number.  */
    CIC_UINT8   segno_maxUC;    /* Max segment number.  */
    CIC_UINT8	xbegUC[NUM_POS_CENTR];	/* x coordinate of start point.	*/
    CIC_UINT8	ybegUC[NUM_POS_CENTR];	/* y coordinate of start point.	*/
    CIC_UINT8	xendUC[NUM_POS_CENTR];	/* x coordinate of end point.	*/
    CIC_UINT8	yendUC[NUM_POS_CENTR];	/* y coordinate of end point.	*/
    CHARVER	*chverP;   	/* Character model.		*/
    };

/*
 *  This is the structure to hold the recognizer model. 
 */
struct model
    {
    CIC_UINT8	charnoUC;   		/* Number of characters.	*/
    CHARMOD	*chmodP;   		/* Character or symbol models.	*/
    CIC_UINT8	numberUC[TOT_NUM_MOD]; 	/* A set of model index for numbers.*/
    CIC_UINT8	letterUC[TOT_CHA_MOD]; 	/* A set of model index for letters.*/
    CIC_UINT8	symbolUC[TOT_SYM_MOD]; 	/* A set of model index for symbols.*/
    CIC_UINT8	extendUC[TOT_EXT_MOD]; 	/* model index of extended characters.*/
    };

/*
 *  This is the structure to hold a model for one character version. 
 */
struct recver
    {
    CIC_UINT8	penalUC;   	/* Penalty.				*/
    CIC_UINT8	segnoUC;   	/* Number of segments.			*/
    CIC_UINT16	segposW;   	/* start position of segments.		*/
    };
/*
 *  This is the structure to hold a model for a character. 
 */
struct recchar
    {
    CIC_UINT8	vernoUC;   	/* Number of versions.	*/
    CIC_UINT8   segno_minUC;    /* Min segment number.  */
    CIC_UINT8   segno_maxUC;    /* Max segment number.  */
    CIC_UINT8	xbegUC[NUM_POS_CENTR];	/* x coordinate of start point.	*/
    CIC_UINT8	ybegUC[NUM_POS_CENTR];	/* y coordinate of start point.	*/
    CIC_UINT8	xendUC[NUM_POS_CENTR];	/* x coordinate of end point.	*/
    CIC_UINT8	yendUC[NUM_POS_CENTR];	/* y coordinate of end point.	*/
    RECVER	*recverP;   	/* Character model.		*/
    };

/*
 *  This is the structure to hold the recognizer model. 
 */
struct recmod
    {
    CIC_UINT8	charnoUC;   		/* Number of characters.	*/
    RECCHAR	*chmodP;   		/* Character or symbol models.	*/
    RECVER	*vbufP;   		/* Version buffer.	*/
    CIC_UINT8	*angUCP;   		/* Angle buffer.	*/
    CIC_UINT8	*curUCP;   		/* Curvature buffer.	*/
    CIC_UINT8	*lenUCP;   		/* length buffer.	*/
    CIC_UINT16	nverW;   		/* Number of versions.	*/
    CIC_UINT16	nsegW;   		/* Number of segments.	*/
    CIC_UINT8	numberUC[TOT_NUM_MOD]; 	/* A set of model index for numbers.*/
    CIC_UINT8	letterUC[TOT_CHA_MOD]; 	/* A set of model index for letters.*/
    CIC_UINT8	symbolUC[TOT_SYM_MOD]; 	/* A set of model index for symbols.*/
    CIC_UINT8	extendUC[TOT_EXT_MOD]; 	/* model index of extended characters.*/
    };
/*
 *  This is the structure to hold the recognizer information. 
 */

 #define	LO_NBEST	2	/* # of top recognition candidates.*/

struct lowrec
    {
    MODEL     	*modelP;   	/* model data.        		*/
    RECMOD     	*recmodP;  	/* compressed model data.        	*/
    CHDATA	*chP;	   	/* input character data.		*/
    CIC_UINT8	*recmodsUCP; 	/* Model indices to be recognized.	*/
    CIC_TEXT	*labelS;   	/* ASCII labels of Models to be recognized.*/
    CIC_UINT8	nmodsUC;    	/* Number of Models to be recognized.*/
    CIC_UINT8	indexUC;    	/* Input characer index (if any).*/
    CIC_UINT8	recogUC[LO_NBEST];/* Recognized index in current mode.	*/
    CIC_UINT8	verUC[LO_NBEST]; /* Recognized versions.	*/
    CIC_INT16	posW[LO_NBEST];	/* End point position distance.	*/
    CIC_INT16	shapeW[LO_NBEST]; /* Shape match distance.	*/
    CIC_INT16	disW[LO_NBEST]; /* Total distance.	*/
    CIC_INT16	rejectW[4];/* Rejection threshold.		*/
    CIC_INT16	flagW;	   /* Property flag of the recognizer.	*/
    };

#endif          /* closes the ifndef LOWPUB_H at the top of the file */ 
/*---------------------------------------------------------------------------*/
