/* mempub.h
 *-----------------------------------------------------------------------------
 * SCCS VERSION 1.1, 15:16:49 3/5/96
 *-----------------------------------------------------------------------------
 * Defines Macros for memory allocation accross platforms
 *
 * JP Shipherd	    20-Jan-94	Initial
 * PL Spoltore      27-Jul-94   Updated for OS/2 and PenPM Project.
 * PL Spoltore      01-Sep-94   Memory manager types defined within concept
 *                              features rather than operating systems.
 * P.L. Spoltore    21-Feb-95   Added CIC_MINIT and CIC_MTERMINATE macros.
 * P.L. Spoltore    13-Mar-95   Removed quick patch for sun only systems now
 *                                that OPTIONS2.H is being inclued on all
 *                                platforms.
 *-----------------------------------------------------------------------------
 */

#ifndef MEMPUB_H
#define MEMPUB_H

/*
 *-----------------------------------------------------------------------------
 * Windows Specific Memory Manager Macros
 *
 * The Windows specific memory manager macros will expand two ways
 * depending on whether or not we have a debugging version of the
 * recognizer under construction. If we are debugging the recognizer
 * then they expand to make a function call which will still use the
 * windows memory managment library but will also do some tracking of
 * allocations and deallocations so that we can have some debugging
 * checks for poor memory handling.
 *-----------------------------------------------------------------------------
 */

#if MEM_MANAGER_WINDOWS

#include <stdtyp.h>
#include <windows.h>

#define CIC_MINIT()
#define CIC_MTERMINATE()

#define CIC_MALLOC(size, pointer) \
    { \
    HANDLE  tempH; \
    tempH = (HANDLE) GlobalAlloc(GMEM_SHARE, \
        size + sizeof(long)); \
    if (tempH) \
    	pointer = GlobalLock(tempH); \
    if (pointer) \
    	{ \
        *((long FARPTR) pointer) = (long)(COUNT) tempH; \
        ((char FARPTR) pointer) += sizeof(long); \
	} \
    };

#define CIC_REALLOC(new_size, pointer) \
    { \
    HANDLE tempH; \
    ((char FARPTR)(pointer)) -= sizeof(LONG); \
    tempH = (HANDLE) (*((LONG FARPTR) (pointer))); \
    if (tempH) \
        { \
	tempH = GlobalReAlloc(tempH, new_size + sizeof(long), GMEM_MOVEABLE); \
	if (tempH) \
	    { \
	    pointer = GlobalLock(tempH); \
	    if (pointer) \
	        { \
		*((long FARPTR) pointer) = (long)(COUNT) tempH; \
		((char FARPTR) pointer) += sizeof(long); \
		} \
	    } \
	} \
    }

#define CIC_FREE(pointer) \
    { \
    HANDLE  tempH; \
    if (pointer) \
    	{ \
        ((char FARPTR)(pointer)) -= sizeof(LONG); \
        tempH = (HANDLE) (*((LONG FARPTR) (pointer))); \
	if (tempH) \
	    { \
            GlobalUnlock(tempH); \
	    GlobalFree(tempH); \
            (char FARPTR)(pointer) = (char FARPTR) NULL; \
	    } \
	} \
    };

/*
 *-----------------------------------------------------------------------------
 * Standard 'C' Runtime Malloc/Free Memory Allocation Scheme Macros
 *-----------------------------------------------------------------------------
 */

#else 

#define CIC_MINIT()
#define CIC_MTERMINATE()
#define CIC_MALLOC(size, pointer)   (pointer) = (void *) (malloc(size))
#define CIC_FREE(pointer)           free(pointer);

#endif /* EndIf MEM_MANAGER_MALLOC */


/*-------------------------------------------------------------------------*/
/* End of Include - Do not place any line below this                       */
/* End of Include - Do not place any line below this                       */
/* End of Include - Do not place any line below this                       */
/*-------------------------------------------------------------------------*/

#endif /* EndIf MEMPUB_H */

/*-------------------------------------------------------------------------*/
/* End of File                                                             */
/* End of File                                                             */
/* End of File                                                             */
/*-------------------------------------------------------------------------*/
