/* options2.h
 *------------------------------------------------------------------------------
 * SCCS VERSION 1.1, 11:53:10 3/5/96
 *------------------------------------------------------------------------------
 * Defines platform-specific constants that are composites of other, more
 * fundamental such constants.  Should be included LAST in all options.h files.
 *
 * D. C. Foyt      19-Aug-92
 * JP Shipherd     02-Feb-93    Added ifndef OPTIONS2_H
 * P.L. Spoltore   21-Jul-94    Updated for OS/2 options that are required.
 * P.L. Spoltore   21-Oct-94    Added features so that the core conditionally
 *                                builds different sections based on a feature
 *                                defined as being required - rather than a
 *                                particular operating system that it is being
 *                                built for.
 * P.L. Spoltore   26-Oct-94    Added GESTURE_DWN_RT_SPACE to force the "L"
 *                                shape PenWindows space gesture into a
 *                                feature (since it is coded as pwspace.c)
 * P.L. Spoltore   7-Nov-94     Added changes to support new operating system
 *                                Windows-95.
 * P.L. Spoltore   21-Nov-94    Added feature STACK_IS_PRIVATE to control the
 *                                inclusion or not of the call to the function
 *                                BeginPrivateStack() and EndPrivateStack().
 * P.L. Spoltore   4-Jan-95     Removed PP_DIAG from default defines since it
 *                                is now used as a structure in the PPLib.
 * P.L. Spoltore   02-Feb-95    Updated for Windows-95. Removed references
 *                                to WINPAD.
 * P.L. Spoltore   02-Feb-95    Removed definition of WL_INCLUDE_DAWG from
 *                                this file. This is only used within the
 *                                WLLIB directory so it has been moved to the
 *                                WLLOC.H file.
 * P.L. Spoltore   27-Mar-95    Added GESTURES_STROKE_DICS to allow the
 *                                seperate inclusion or exclusion of stroke
 *                                dictionary gesture recognition.
 *------------------------------------------------------------------------------
 */

#ifndef OPTIONS2_H
#define OPTIONS2_H

/*
 *-----------------------------------------------------------------------------
 * Define what type of recognizer this is going to be
 *
 * For this section to work correctly, it is assumed that the following
 * definitions have been properly set-up in the "options.h" file that
 * has already been included:
 *
 * USSUN            US recognizer running under Sun Unix
 * USDOS            US recognizer running under dos
 * USWIN            US recongizer running under windows 3.1
 * USWIN95          US recognizer running under windows-95
 * USOS2            US recognizer running under OS/2
 *
 * JSUN             Japanese recognizer running under Sun Unix
 * JDOS             Japanese recognizer running under dos
 * JWIN             Japanese recognizer running under windows 3.1
 * JWIN95           Japanese recognizer running under windows-95
 * JOS2             Japanese recognizer running under OS/2
 *
 *-----------------------------------------------------------------------------
 */

/*
 * Some defines that need to be integrated a little better into the system
 * of features that we are migrating too. Someday!
 */
#define JPNREC        (JDOS || JWIN || JWIN95)
#define USREC         (USDOS || USWIN || USWIN95 || USOS2)
#define CICDOS        (JDOS || USDOS)
#define PEN_DOS       (JDOS || USDOS)
#define PEN_WINDOWS_1 ((JWIN || USWIN))
#define PEN_WINDOWS_2 (USWIN95 || WINCE)
#define PEN_WINDOWS   (PEN_WINDOWS_1 || PEN_WINDOWS_2)
#define DOS           (JDOS || USDOS)
#define OS2           (USOS2 || JOS2)
#define WIN95         (USWIN95 || JWIN95)
#define SUN           (USSUN || JSUN || defined(sun))
#define REPI          (OS2)

/*
 * Start Declaring some of the other recognizer type codes. These really should
 * be adjusted to use the set defined above, or this set defined below. I dunno
 * which one yet -- only time will tell.
 */

#ifndef CIC_EUR_RECOG
#define CIC_EUR_RECOG W_EUROPE
#endif

#ifndef CIC_JPN_RECOG
#define CIC_JPN_RECOG JPNREC
#endif

#ifndef CIC_US_RECOG
#define CIC_US_RECOG USREC
#endif

#ifndef MAC
#define MAC            0
#endif

/*
 *-----------------------------------------------------------------------------
 * Define Operating System Default Features
 *
 * Define some default features that each of the operating systems are going
 * to have. This "feature" method of defining operating systems is being done
 * to make the core code more portable and the recognizer "feature" defined
 * rather than special sets of code that include different features based on
 * the recognizer defined. This is a subtle difference - but is important
 * to rapid porting efforts.
 *-----------------------------------------------------------------------------
 */

/*
 * Define the features required for a 16-bit Windows-95 Recognizer
 */

#if WIN95 && CORE16

#define STATIC_DICTIONARIES     0       /* Statically link to stroke dics    */
#define STACK_IS_PRIVATE        1       /* Switch to Private Stack in Core   */
#define VITERBI_IS_ASM          0       /* Use the assembly language viterbi */
#define MEM_MANAGER_STATIC      0       /* Use the CIC Static Memory Manager */
#define MEM_MANAGER_MALLOC      0       /* Use 'C' Malloc Memory Manager     */
#define MEM_MANAGER_WINDOWS     1       /* Use the Windows Specific Mem Mgr  */
#define FILE_MANAGER_ANSI       1       /* Use ANSI file managment functions */
#define FILE_MANAGER_CIC        0       /* Use CIC file managment functions  */
#define SUPPLEMENTAL_WORDLIST   0       /* Use a supplemental ASCII wordlist */
#define GESTURES_ADD_STROKE     1       /* Recognizes gests on first stroke  */
#define GESTURES_REC_COMPLETE   1       /* Recognizes gests at completion    */
#define GESTURES_CHAR_CIRCLE    1       /* Allow for letter/circle gestures  */
#define GESTURES_CHAR_DOT       0       /* Allow for letter/dot gestures     */
#define GESTURES_CIRCLE_DOT     1       /* Allow for circle dot gestures     */
#define GESTURES_DWN_RT_SPACE   1       /* Allow the down/right (L) space    */
#define TRAINABLE               0       /* YES training should be included   */
#define PRIVATE_API             1       /* Enable Private Training API       */

#endif

/*
 * Define the features required for a 32-bit Windows-95 Recognizer
 */

#if WIN95 && CORE32

#define STATIC_DICTIONARIES     0       /* Statically link to stroke dics    */
#define STACK_IS_PRIVATE        1       /* Switch to Private Stack in Core   */
#define VITERBI_IS_ASM          0       /* Use the assembly language viterbi */
#define MEM_MANAGER_STATIC      0       /* Use the CIC Static Memory Manager */
#define MEM_MANAGER_MALLOC      1       /* Use 'C' Malloc Memory Manager     */
#define MEM_MANAGER_WINDOWS     0       /* Use the Windows Specific Mem Mgr  */
#define FILE_MANAGER_ANSI       1       /* Use ANSI file managment functions */
#define FILE_MANAGER_CIC        0       /* Use CIC file managment functions  */
#define SUPPLEMENTAL_WORDLIST   0       /* Use a supplemental ASCII wordlist */
#define GESTURES_ADD_STROKE     1       /* Recognizes gests on first stroke  */
#define GESTURES_REC_COMPLETE   1       /* Recognizes gests at completion    */
#define GESTURES_CHAR_CIRCLE    1       /* Allow for circle letter gestures  */
#define GESTURES_CHAR_DOT       0       /* Allow for letter/dot gestures     */
#define GESTURES_CIRCLE_DOT     1       /* Allow for circle dot gestures     */
#define GESTURES_DWN_RT_SPACE   1       /* Allow the down/right (L) space    */
#define TRAINABLE               0       /* YES training should be included   */
#define PRIVATE_API             1       /* Enable Private Training API       */

#endif

/*
 * Define the features required for a 32-bit Pen Windows Recognizer
 */

#if WIN && CORE32

#define STATIC_DICTIONARIES     0       /* Statically link to stroke dics    */
#define STACK_IS_PRIVATE        0       /* Switch to Private Stack in Core   */
#define VITERBI_IS_ASM          1       /* Use the assembly language viterbi */
#define MEM_MANAGER_STATIC      0       /* Use the CIC Static Memory Manager */
#define MEM_MANAGER_MALLOC      0       /* Use 'C' Malloc Memory Manager     */
#define MEM_MANAGER_WINDOWS     1       /* Use the Windows Specific Mem Mgr  */
#define FILE_MANAGER_ANSI       1       /* Use ANSI file managment functions */
#define FILE_MANAGER_CIC        0       /* Use CIC file managment functions  */
#define SUPPLEMENTAL_WORDLIST   1       /* Use a supplemental ASCII wordlist */
#define GESTURES_ADD_STROKE     1       /* Recognizes gests on first stroke  */
#define GESTURES_REC_COMPLETE   0       /* Recognizes gests at completion    */
#define GESTURES_CHAR_CIRCLE    1       /* Allow for circle letter gestures  */
#define GESTURES_CHAR_DOT       0       /* Allow for letter/dot gestures     */
#define GESTURES_CIRCLE_DOT     0       /* Allow for circle dot gestures     */
#define GESTURES_DWN_RT_SPACE   1       /* Allow the down/right (L) space    */
#define TRAINABLE               1       /* YES training should be included   */
#define PRIVATE_API             1       /* Enable Private Training API       */

#endif

/*
 * Define the features required for a 16-bit Pen Windows Recognizer
 */

#if WIN && CORE16

#define STATIC_DICTIONARIES     0       /* Statically link to stroke dics    */
#define STACK_IS_PRIVATE        0       /* Switch to Private Stack in Core   */
#define VITERBI_IS_ASM          0       /* Use the assembly language viterbi */
#define MEM_MANAGER_STATIC      0       /* Use the CIC Static Memory Manager */
#define MEM_MANAGER_MALLOC      0       /* Use 'C' Malloc Memory Manager     */
#define MEM_MANAGER_WINDOWS     1       /* Use the Windows Specific Mem Mgr  */
#define FILE_MANAGER_ANSI       1       /* Use ANSI file managment functions */
#define FILE_MANAGER_CIC        0       /* Use CIC file managment functions  */
#define SUPPLEMENTAL_WORDLIST   1       /* Use a supplemental ASCII wordlist */
#define GESTURES_ADD_STROKE     1       /* Recognizes gests on first stroke  */
#define GESTURES_REC_COMPLETE   0       /* Recognizes gests at completion    */
#define GESTURES_CHAR_CIRCLE    1       /* Allow for circle letter gestures  */
#define GESTURES_CHAR_DOT       0       /* Allow for letter/dot gestures     */
#define GESTURES_CIRCLE_DOT     0       /* Allow for circle dot gestures     */
#define GESTURES_DWN_RT_SPACE   1       /* Allow the down/right (L) space    */
#define TRAINABLE               1       /* YES training should be included   */
#define PRIVATE_API             1       /* Enable Private Training API       */

#endif

/*
 * Define the features required for a Sun Recognizer
 */

#if SUN

#define STATIC_DICTIONARIES     1       /* Statically link to stroke dics    */
#define STACK_IS_PRIVATE        0       /* Switch to Private Stack in Core   */
#define VITERBI_IS_ASM          0       /* Use the assembly language viterbi */
#define MEM_MANAGER_STATIC      0       /* Use the CIC Static Memory Manager */
#define MEM_MANAGER_MALLOC      1       /* Use 'C' Malloc Memory Manager     */
#define MEM_MANAGER_WINDOWS     0       /* Use the Windows Specific Mem Mgr  */
#define FILE_MANAGER_ANSI       0       /* Use ANSI file managment functions */
#define FILE_MANAGER_CIC        1       /* Use CIC file managment functions  */
#define SUPPLEMENTAL_WORDLIST   0       /* Use a supplemental ASCII wordlist */
#define GESTURES_ADD_STROKE     0       /* Recognizes gests on first stroke  */
#define GESTURES_REC_COMPLETE   0       /* Recognizes gests at completion    */
#define GESTURES_CHAR_CIRCLE    0       /* Allow for circle letter gestures  */
#define GESTURES_CIRCLE_DOT     0       /* Allow for circle dot gestures     */
#define GESTURES_DWN_RT_SPACE   0       /* Allow the down/right (L) space    */
#define TRAINABLE               0       /* YES training should be included   */
#define PRIVATE_API             0       /* Enable Private Training API       */

#endif

/*
 * Define the features required for an OS/2 Recognizer
 */

#if OS2

#define STATIC_DICTIONARIES     0       /* Statically link to stroke dics    */
#define VITERBI_IS_ASM          0       /* Use the assembly language viterbi */
#define MEM_MANAGER_STATIC      1       /* Use the CIC Static Memory Manager */
#define MEM_MANAGER_MALLOC      0       /* Use 'C' Malloc Memory Manager     */
#define MEM_MANAGER_WINDOWS     0       /* Use the Windows Specific Mem Mgr  */
#define FILE_MANAGER_ANSI       1       /* Use ANSI file managment functions */
#define FILE_MANAGER_CIC        0       /* Use CIC file managment functions  */
#define SUPPLEMENTAL_WORDLIST   0       /* Use a supplemental ASCII wordlist */
#define GESTURES_ADD_STROKE     0       /* Recognizes gests on first stroke  */
#define GESTURES_REC_COMPLETE   1       /* Recognizes gests at completion    */
#define GESTURES_CHAR_CIRCLE    0       /* Allow for circle letter gestures  */
#define GESTURES_CIRCLE_DOT     0       /* Allow for circle dot gestures     */
#define GESTURES_DWN_RT_SPACE   0       /* Allow the down/right (L) space    */
#define TRAINABLE               1       /* YES training should be included   */
#define PRIVATE_API             1       /* Enable Private Training API       */

#endif

/*
 * Define the features required for a DOS Recognizer
 */

#if DOS

#define STATIC_DICTIONARIES     1       /* Statically link to stroke dics    */
#define STACK_IS_PRIVATE        0       /* Switch to Private Stack in Core   */
#define VITERBI_IS_ASM          1       /* Use the assembly language viterbi */
#define MEM_MANAGER_STATIC      1       /* Use the CIC Static Memory Manager */
#define MEM_MANAGER_MALLOC      0       /* Use 'C' Malloc Memory Manager     */
#define MEM_MANAGER_WINDOWS     0       /* Use the Windows Specific Mem Mgr  */
#define FILE_MANAGER_ANSI       1       /* Use ANSI file managment functions */
#define FILE_MANAGER_CIC        0       /* Use CIC file managment functions  */
#define SUPPLEMENTAL_WORDLIST   0       /* Use a supplemental ASCII wordlist */
#define GESTURES_ADD_STROKE     0       /* Recognizes gests on first stroke  */
#define GESTURES_REC_COMPLETE   0       /* Recognizes gests at completion    */
#define GESTURES_CHAR_CIRCLE    0       /* Allow for circle letter gestures  */
#define GESTURES_CHAR_DOT       0       /* Allow for letter/dot gestures     */
#define GESTURES_CIRCLE_DOT     0       /* Allow for circle dot gestures     */
#define GESTURES_DWN_RT_SPACE   0       /* Allow the down/right (L) space    */
#define TRAINABLE               0       /* YES training should be included   */
#define PRIVATE_API             0       /* Enable Private Training API       */

#endif

/*
 *-----------------------------------------------------------------------------
 * feature: GESTURES_ALLOWED
 *
 * This is really a combined feature of any of the gesture sets above. It
 * should probably be removed and changed with the feature check themselves
 * whereever appropriate.
 *-----------------------------------------------------------------------------
 */
#ifndef GESTURES_ALLOWED
#define GESTURES_ALLOWED    (GESTURES_ADD_STROKE   || \
                            GESTURES_REC_COMPLETE || \
                            GESTURES_CHAR_CIRCLE  || \
                            GESTURES_CHAR_DOT     || \
                            GESTURES_CIRCLE_DOT   || \
                            GESTURES_DWN_RT_SPACE)
#endif

/*
 *-----------------------------------------------------------------------------
 * feature: STATIC_DICTIONARIES
 *
 * This is defined when we include staticly link stroke dictionaries (such
 * as under DOS or other restrive platforms). When this is false, we dynamically
 * load and allocate the stroke dictionaries.
 *-----------------------------------------------------------------------------
 */
#ifndef STATIC_DICTIONARIES
#define STATIC_DICTIONARIES 0
#endif

/*
 *-----------------------------------------------------------------------------
 * feature: SUPPLEMENTAL_WORDLIST
 *
 * This is defined when we wish the core to include a supplemental ASCII word
 * list as part of its word list dictionary search.
 *-----------------------------------------------------------------------------
 */
#ifndef SUPPLEMENTAL_WORDLIST
#define SUPPLEMENTAL_WORDLIST   0
#endif

/*
 *-----------------------------------------------------------------------------
 * feature: WATCOM_API
 *
 * WATCOM_API is defined when compiling the 16 bit platform version of a 32
 * bit windows recognizer
 *-----------------------------------------------------------------------------
 */
#ifndef _WATCOM_API_
#define _WATCOM_API_ 0
#endif

/*
 *-----------------------------------------------------------------------------
 * feature: PRIVATE_API
 *
 * PRIVATE_API is defined when we need to build private API functions that
 * are called from outside the normal Pen Windows API. This is used to include
 * all the specialized training functions required by the CIC Advanced Trainer.
 *-----------------------------------------------------------------------------
 */
#ifndef PRIVATE_API
#define PRIVATE_API 0
#endif

/*
 *-----------------------------------------------------------------------------
 * feature: RT_DIAG
 *
 * This is a special feature that enables an super-dupper enabled debugging
 * recognizer version that spits out so much information that a government
 * worker would be satisfied.
 *-----------------------------------------------------------------------------
 */

#ifndef RT_DIAG
#define RT_DIAG        0
#endif

/*
 *-----------------------------------------------------------------------------
 * feature: TRAINABLE
 *
 * Tell if training will be enabled or not in the recognizer. This not
 * only removes the training sections of code, but also the user dependent
 * recognizer components.
 *-----------------------------------------------------------------------------
 */

#ifndef TRAINABLE
#define TRAINABLE 0
#endif

/*
 *------------------------------------------------------------------------------
 * The following prevented unwanted warning messages from the Watcom compiler.
 *   -- Foyt, 20-Jan-92
 *------------------------------------------------------------------------------
 */

#ifndef ANSI_C
#if (PEN_WINDOWS || CICDOS || OS2)
#define ANSI_C         1
#else
#define ANSI_C         0
#endif
#endif

#ifndef W_EUROPE
#define W_EUROPE        0
#endif

#ifndef CV_MASK_ENABLED
#define CV_MASK_ENABLED    0
#endif

#ifndef DEBUG
#define DEBUG          0
#endif

#ifndef IO_OK
#define IO_OK          0
#endif

#ifndef OFF_LINE
#define OFF_LINE       0
#endif

#ifndef PENPOINT
#define PENPOINT       0
#endif

#ifndef MINIMAL_REC
#define MINIMAL_REC    0
#endif

#ifndef NOSHIFT
#define NOSHIFT        0
#endif

#ifndef RD_BMOS_DIAG
#define RD_BMOS_DIAG   0
#endif

#ifndef RD_BMOS_TRAIN
#define RD_BMOS_TRAIN  0
#endif

#ifndef RD_PP_DIAG
#define RD_PP_DIAG     0
#endif

#ifndef RD_PP_ERR
#define RD_PP_ERR     0
#endif

#ifndef REALSIG
#define REALSIG        0
#endif

#ifndef SIG_ONLY
#define SIG_ONLY       0
#endif

#ifndef SIGVER_REC
#define SIGVER_REC     0
#endif

#ifndef SMALL_RECOGNIZER
#define SMALL_RECOGNIZER 0
#endif

#ifndef VITERBI_TEST
#define VITERBI_TEST   0
#endif

#ifndef DB_PRINT_RESULTS
#define DB_PRINT_RESULTS 0
#endif

/*
 *-----------------------------------------------------------------------------
 * End of Include - Do not place any line below this
 * End of Include - Do not place any line below this
 * End of Include - Do not place any line below this
 *-----------------------------------------------------------------------------
 */

#endif      /* ifndef OPTIONS2_H */

/*
 *-----------------------------------------------------------------------------
 * End of File
 * End of File
 * End of File
 *-----------------------------------------------------------------------------
 */
