#ifndef _TOOLS_H
#define _TOOLS_H
/* tools.h	$W$   $G$
 *----------------------------------------------------------------------------
 * This file contains definitions used in the configuration tools (as in
 * the files conf.c and conftool.c).
 *
 * Gordon Sun	06/19/95
 *----------------------------------------------------------------------------
 */

#define MAXFNAME        80     /* Max size of a file name. */
#define	MAXARGLEN	80

typedef struct dataitem DATAITEM;
typedef struct rc_conf_lst RC_CONF_LST;
typedef CIC_BOOL (*CONFFUNCP)(CIC_COUNT, CIC_TEXT **, VOID *);

struct dataitem
    {
    DATAITEM    *nextP; /* This is a linked list.               */
    CIC_TEXT    fileS[MAXFNAME];
    CIC_INT16   indexW; /* Additional type-dependent info       */
    };

/*
 * This structure just represents a list of data items, such as for a
 * training or recognition run.
 */ 
typedef struct
    {
    CIC_INT16   nitems;         /* An item count.               */
    DATAITEM    *itemP;
    DATAITEM    *tailP;
    } DATALIST;

typedef struct rc_conf
    {
    CIC_TEXT    keyS[MAXARGLEN];        /* "keyword" from line or argv  */
    CIC_TEXT    argS[MAXARGLEN];        /* arguments from line or argv  */
    } RC_CONF;
 

struct rc_conf_lst
    {
    RC_CONF_LST *nextP;             /* ptr to next RC_CONF in list          */
    RC_CONF     confrec;            /* data from the .ri file               */
    };



/*
 *----------------------------------------------------------------------------
 * This structure is used to store a table of names and handling routines.
 * It is used to handle configuration files and such.
 *----------------------------------------------------------------------------
 */
typedef struct
    {
    CIC_TEXT	*nameS;		/* The option name	*/
    CONFFUNCP	handler;	/* The handler function	*/
    BOOL	argposB;	/* Found in arg list?	*/
    } CONFTAB;

#endif	/* _TOOLS_H	*/
