/* zdllapi.h
 *----------------------------------------------------------------------------
 * SCCS Version %I%, %U% %G%
 *----------------------------------------------------------------------------
 * DLL API for ZORRO
 *
 * J. Wang          17-Mar-96   Initial.
 *----------------------------------------------------------------------------
 */
#ifndef ZDLLAPI_H 
#define ZDLLAPI_H

#define DllExport	__declspec( dllexport )

BOOL  WINAPI    DllMain 
	(
	HANDLE hInst, 
    ULONG ul_reason_for_call,
    LPVOID lpReserved
	);

ZO_RET DllExport  ZorroOpen
    (             
    long        *handleP
    );
typedef ZO_RET (*PFN_ZORROOPEN)
	(
	long	*handleP
	);

ZO_RET DllExport  ZorroClose
    (             
    long        handle
    );
typedef ZO_RET (*PFN_ZORROCLOSE)
	(
	long	handle
	);

ZO_RET DllExport  ZorroMode
    (              
    long        handle,
    int input_method,
    ZO_CHAR     mode
    );
typedef ZO_RET (*PFN_ZORROMODE)
    (              
    long        handle,
    int input_method,
    ZO_CHAR     mode
    );

ZO_RET DllExport  ZorroTrain
    (              
    long        handle,
	unsigned long trainUL
    );
typedef ZO_RET (*PFN_ZORROTRAIN)
    (              
    long        handle,
	unsigned long trainUL
    );     
   
ZO_RET DllExport  ZorroStroke
    (                      
    long        handle,
    int         input_method,           /* Current input method         */
    ZO_MODELINE *mode_lineP,            /* Modeline if using MODELINE   */
    ZO_STROKE   *strokeP,               /* Input stroke                 */
    ZO_RESULT   *resultP                /* Returned result              */
    );
typedef ZO_RET (*PFN_ZORROSTROKE)
    (                      
    long        handle,
    int         input_method,           /* Current input method         */
    ZO_MODELINE *mode_lineP,            /* Modeline if using MODELINE   */
    ZO_STROKE   *strokeP,               /* Input stroke                 */
    ZO_RESULT   *resultP                /* Returned result              */
    );

ZO_RET DllExport  ZorroFlush
    (                        
    long        handle,
    ZO_RESULT   *resultP                /* Returned result              */
    );
typedef ZO_RET (*PFN_ZORROFLUSH)
    (                        
    long        handle,
    ZO_RESULT   *resultP                /* Returned result              */
    );
        
#if ZORRO_TRAINABLE
ZO_RET DllExport  ZorroLoadTrain
    (           
    long        handle,
    char        *train_fileS
    );
typedef ZO_RET (*PFN_ZORROLOADTRAIN)
    (           
    long        handle,
    char        *train_fileS
    );

ZO_RET DllExport  ZorroUnloadTrain
    (
    long        handle
    );
typedef ZO_RET (*PFN_ZORROUNLOADTRAIN)
    (
    long        handle
    ); 
    
#endif /* #if ZORRO_TRAINABLE   */

#if ZORRO_TRAINABLE || ZORRO_EXTERNAL_TRAINER

ZO_RET DllExport  ZorroRecExtendedChar
    (
    long        handle,
    ZO_CHAR     *compositionS,          /* Array contained compositions */
    int         num_composition,        /* Number of compositions       */
    ZO_RESULT   *resultP                /* Recognized result            */
    );
typedef ZO_RET (*PFN_ZORRORECEXTENDEDCHAR)
    (
    long        handle,
    ZO_CHAR     *compositionS,          /* Array contained compositions */
    int         num_composition,        /* Number of compositions       */
    ZO_RESULT   *resultP                /* Recognized result            */
    );

#endif

#if ZO_DEBUG
ZO_RET DllExport  ZorroShapeToResult
    ( 
    unsigned int shape_index,
    ZO_CHAR     mode,
    ZO_CHAR     *charP
    );      
typedef ZO_RET (*PFN_ZORROSHAPETORESULT)
    ( 
    unsigned int shape_index,
    ZO_CHAR     mode,
    ZO_CHAR     *charP
    ); 

#endif /* #if ZO_DEBUG */    

typedef struct tagJOT_RECO
	{
	PFN_ZORROOPEN	ZorroOpenP;
	PFN_ZORROCLOSE	ZorroCloseP;
	PFN_ZORROMODE	ZorroModeP;
	PFN_ZORROTRAIN	ZorroTrainP;
	PFN_ZORROSTROKE ZorroStrokeP;
	PFN_ZORROFLUSH	ZorroFlushP;
#if ZORRO_TRAINABLE
	PFN_ZORROLOADTRAIN		ZorroLoadTrainP;
	PFN_ZORROUNLOADTRAIN	ZorroUnloadTrainP;
#endif
#if ZORRO_TRAINABLE || ZORRO_EXTERNAL_TRAINER
	PFN_ZORRORECEXTENDEDCHAR	ZorroRecExtendedCharP;
#endif
	}	JOT_RECO;
           
#endif /* #ifndef ZDLLAPI_H */
