/* zopub.h              CIC Proprietary
 *----------------------------------------------------------------------------
 * SCCS Version %I%, %U% %G%
 *----------------------------------------------------------------------------
 * Public header file for ZORRO app in Window 95
 *
 * J. Wang           18-Apr-96   Initial.
 *----------------------------------------------------------------------------
 */
#ifndef ZOPUB_H
#define ZOPUB_H

// This macro is for demo and data collection purpose
#define ZORRO_NEED_HPENDATA     1

      
#define TRAIN_DATA_FILE "train.dat"

#define szZorroStartClass "ZorroStartClass"
#define szZorroInputClass "ZorroInputClass"      
#define szZorroVArrowClass   "PAVArrowClass"

// INPUT mode
#define INPUT_BOX       0
#define INPUT_MODELINE  1

// ID of configurable values in HOOK DLL
#define CONFIG_USE_ZORRO        0
#define CONFIG_TIMEOUT          1
#define CONFIG_OUTMODE          2
#define CONFIG_MODELINE         3 
#define CONFIG_INKMODE          4

// ID of query values in UI
#define QUERY_INPUT             0

// KEY up and down flags
#define ZO_KEY_DOWN             0x01
#define ZO_KEY_UP               0x02
#define ZO_KEY                  (ZO_KEY_DOWN | ZO_KEY_UP)

// Messages
#define WM_ZO_GETMODELINE               0x6000        
#define WM_ZO_SETMODELINE               0x6001
#define WM_ZO_SETHWNDINPUTBOX   0x6002
#define WM_ZO_SETHWNDBOX                0x6003   
#define WM_ZO_CHAR                              0x6004 
#define WM_ZO_SWITCHMODE        0x6005
#define WM_ZO_CLOSE                             0x6006
#define WM_ZO_SETFOCUS                  0x6007 
#define WM_ZO_KILLFOCUS                 0x6008
#define WM_ZO_READY                     0x6009 
#define WM_ZO_QUERY                     0x600A
#define WM_ZO_DISABLEMACRO              0x600B 
#define WM_ZO_UPDATEMACRO               0x600C
#define WM_ZO_CONFIGURE                 0x600D 
#define WM_ZO_TRAYNOTIFY                0x600E

#if ZORRO_NEED_HPENDATA
#define WM_ZO_HPENDATA          0x6100
#endif

// Modeline packed to a LONG and vs versa
#define MAKEMODELINE(dir, pos)  (((LONG)(dir) << 30) | MAKELONG((pos).x, (pos).y))
#define GETDIR(l)               ((LONG)(l) >> 30)
#define GETPOSX(l)              LOWORD(((l) & 0x3FFFFFFF))
#define GETPOSY(l)              HIWORD(((l) & 0x3FFFFFFF))

// Modeline dimension
#define ML_DIM          6
#define ML_RADIUS       4

// Output mode
#define OUTPUT_AFTER_STROKE          0
#define OUTPUT_AFTER_CHARACTER       1

// Ink clearing mode
#define CLEAR_INK_AFTER_STROKE          0
#define CLEAR_INK_AFTER_CHARACTER       1
#define CLEAR_INK_AFTER_PHRASE          2

// Old definitions
#define OUT_WHEN_PENUP		0
#define OUT_WHEN_TIMEOUT	1
#define OUT_WHEN_SPACE		2

// Vitual key masks for SHIFT, CONTROL and ALT
#define VM_SHIFT        0x01
#define VM_CONTROL      0x02
#define VM_ALT          0x04
#define VM_AC           VM_ALT | VM_CONTROL
#define VM_CS           VM_CONTROL | VM_SHIFT

// Functions from zohook.dll
/*
int __export CALLBACK InitZorroHookDll
    (
    HWND hwndMainWindow,
    HWND hwndBox,
    HWND hwndDemo
    );
    
BOOL __export CALLBACK ConfigZorroHookDll
    (                       
    int         idConfig,               // What to config
    LONG        value                   // New value 
    );
        
BOOL __export CALLBACK InstallFilter 
    (
    BOOL nCode          // TRUE to install HOOK, FALSE to remove it
    );
*/          
#endif 
