/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   jottime.c
Author(s)   :   J. Wang
Company     :   Communication Intelligence Corporation
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include <stdafx.h>
#include "mmu.h"
#include "ui.h"
#include "uifunc.h"
#include "app.h"
#include "jot.h"
#include "jotui.h"
#include "iocon.h"

extern int g_timeout;
extern int g_timeoutMultiStroke;

BOOLEAN TimeoutsHandleEvent(EvtType *Event)
{
	BOOLEAN handled = FALSE;
	BYTE    time[32];
	
	switch (Event->eventType)
	{
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_TIMEOUT, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_TIMEOUT, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		break;
	case EVT_SCROLLBAR_REPEAT:
		g_timeout = Event->para2 * 100 + JOT_MIN_SYMBOL_TIMEOUT;
		ScrollbarDrawScrollbar(SCROLLBAR_TIMEOUT);
		strcpy(time, JOTSTR13);
		time[1] = g_timeout / 1000 + '0';
		time[3] = (g_timeout % 1000) / 100 + '0';
		/* sprintf((char *)time, "(%d.%d seconds)", g_timeout / 10, g_timeout - (g_timeout / 10) * 10); */
		StringSetText(STRING_TIME, time);
		StringDrawString(STRING_TIME);
		break;
	case EVT_FORM_OPEN:
		UpdateJotTrainerDB(JOT_READ_DB);
		ScrollbarInitScrollbar(SCROLLBAR_TIMEOUT);
		ScrollbarSetScrollbar
			(
			SCROLLBAR_TIMEOUT, 
			(g_timeout - JOT_MIN_SYMBOL_TIMEOUT) / 100,
			34, 0,
			2, 
			34);
		
		strcpy(time, JOTSTR13);
		time[1] = g_timeout / 1000 + '0';
		time[3] = (g_timeout % 1000) / 100 + '0';
		/* sprintf((char *)time, "(%d.%d seconds)", g_timeout / 10, g_timeout - (g_timeout / 10) * 10); */
		StringSetText(STRING_TIME, time);
		FormDrawForm(FORM_JOT);
		ScrollbarDrawScrollbar(SCROLLBAR_TIMEOUT);
		handled = TRUE;
		break;
	case EVT_FORM_CLOSE:
		UpdateJotTrainerDB(JOT_WRITE_DB);
		JotUpdate();
		break;
	}
	return handled;
}
