/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   jottrain.c
Author(s)   :   J. Wang
Company     :   Communication Intelligence Corporation
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              

#include <stdafx.h>
#include "mmu.h"
#include "ui.h"
#include "uifunc.h"
#include "app.h"
#include "jotui.h"
#include <zorroapi.h>
#include <jot.h>

#define MAX_PAGE 9

extern JOT_STATUS jot_status;
extern unsigned int g_train;

int		g_page = 0;

/* Globals used by OKCANCEL dialog */
extern BYTE		*g_okcancelString1;
extern BYTE		*g_okcancelString2;
extern BOOLEAN     g_okcancel;
extern BYTE		*g_okcancelTitle;
extern USHORT		g_okForm;
extern USHORT		g_cancelForm;
extern BOOLEAN		g_fromOkCancel;
extern ObjectID     g_prevForm;

BYTE *g_pageString[] = 
{
	NULL, 
		JOT_FORM_J,
		JOT_FORM_K,
		JOT_FORM_P,
		JOT_FORM_Q,
		JOT_FORM_T,
		JOT_FORM_T,
		JOT_FORM_I,
		JOT_FORM_$,
};

ObjectID g_pageBitmap[] =
{
	0,
		BITMAP_J,
		BITMAP_K,
		BITMAP_P,
		BITMAP_Q,
		BITMAP_T1,
		BITMAP_T2,
		BITMAP_I,
		BITMAP_DOLLAR,
};

int g_pageFlag[] = 
{
	0,
		JOT_J_UC_TWO_STROKE,
		JOT_K_LU_TWO_STROKE,
		JOT_P_LU_TWO_STROKE,
		JOT_Q_UC_TWO_STROKE,
		JOT_T_LC_VH,
		JOT_T_LC_HV,
		JOT_I_LC,
		JOT_DOLLAR_TWO_STROKE,
};

ObjectID g_pagePushbuttons[] = 
{
	PUSHBUTTON_INTRO,
		PUSHBUTTON_J,
		PUSHBUTTON_k,
		PUSHBUTTON_p,
		PUSHBUTTON_Q,
		PUSHBUTTON_t1,
		PUSHBUTTON_t2,
		PUSHBUTTON_i,
		PUSHBUTTON_DOLLAR,
};

Err ControlSetCheckboxValue(ObjectID objID, BOOLEAN value)
{
	Control *checkbox;
	BYTE object_type;
	ControlTemplateCheckBox *checkboxTemplate;
	
	if (UISearchForAddress(objID,&object_type,(void**)&checkbox) != TRUE)
		return ERR_UI_RES_NOT_FOUND;
	
	checkboxTemplate = (ControlTemplateCheckBox *)checkbox->control_template;
	checkboxTemplate->control_value = (value != 0);
	return TRUE;
}

Err ControlGetCheckboxValue(ObjectID objID, BOOLEAN *value)
{
	Control *checkbox;
	BYTE object_type;
	ControlTemplateCheckBox *checkboxTemplate;
	
	if (UISearchForAddress(objID,&object_type,(void**)&checkbox) != TRUE)
		return ERR_UI_RES_NOT_FOUND;
	
	checkboxTemplate = (ControlTemplateCheckBox *)checkbox->control_template;
	*value = checkboxTemplate->control_value;
	return TRUE;
}

void CheckboxClicked(unsigned int train)
{
	BOOLEAN checked;
	
	ControlGetCheckboxValue(CHECKBOX_YES, &checked);
	if (checked)
		g_train |= train;
	else
		g_train &= ~train;
	/* zo_train(0, g_train); */
}

void GotoTrainerPage(int page)
{
	int i;
	
	if (page < 0 || page >= MAX_PAGE)
		return;
	
	if (page > 0)
	{
		ControlSetAttributes(BUTTON_RESET,
			FALSE,	// enable
			FALSE,	// drawn
			FALSE,	// save behind
			FALSE,	// active
			FALSE);	// visible
		StringSetAttribute(STRING_TRAINER1, FALSE, FALSE);
		StringSetAttribute(STRING_TRAINER2, FALSE, FALSE);
		StringSetAttribute(STRING_TRAINER3, FALSE, FALSE);
		StringSetAttribute(STRING_TRAINER4, FALSE, FALSE);
		StringSetAttribute(STRING_QUESTION1, FALSE, TRUE);
		StringSetAttribute(STRING_QUESTION2, FALSE, TRUE);
		StringSetAttribute(STRING_YES, FALSE, TRUE);
		StringSetAttribute(STRING_NO, FALSE, TRUE);
		ControlSetAttributes(CHECKBOX_YES,
			TRUE,	// enable
			FALSE,	// drawn
			FALSE,	// save behind
			FALSE,	// active
			TRUE);	// visible
		ControlSetAttributes(CHECKBOX_NO,
			TRUE,	// enable
			FALSE,	// drawn
			FALSE,	// save behind
			FALSE,	// active
			TRUE);	// visible		
		for (i = 1; i < MAX_PAGE; i++)
			BitmapSetAttribute(g_pageBitmap[i], FALSE, FALSE, FALSE, FALSE);
		BitmapSetAttribute(g_pageBitmap[page], FALSE, FALSE, FALSE, TRUE);
		StringSetText(STRING_QUESTION2, g_pageString[page]);
		if (g_pageFlag[page] & g_train)
		{
			ControlSetCheckboxValue(CHECKBOX_YES, TRUE);
			ControlSetCheckboxValue(CHECKBOX_NO, FALSE);
		}
		else
		{
			ControlSetCheckboxValue(CHECKBOX_YES, FALSE);
			ControlSetCheckboxValue(CHECKBOX_NO, TRUE);
		}
	}
	else
	{
		ControlSetAttributes(BUTTON_RESET,
			TRUE,	// enable
			FALSE,	// drawn
			FALSE,	// save behind
			TRUE,	// active
			TRUE);	// visible
		StringSetAttribute(STRING_TRAINER1, FALSE, TRUE);
		StringSetAttribute(STRING_TRAINER2, FALSE, TRUE);
		StringSetAttribute(STRING_TRAINER3, FALSE, TRUE);
		StringSetAttribute(STRING_TRAINER4, FALSE, TRUE);
		StringSetAttribute(STRING_QUESTION1, FALSE, FALSE);
		StringSetAttribute(STRING_QUESTION2, FALSE, FALSE);
		StringSetAttribute(STRING_YES, FALSE, FALSE);
		StringSetAttribute(STRING_NO, FALSE, FALSE);
		ControlSetAttributes(CHECKBOX_YES,
			FALSE,	// enable
			FALSE,	// drawn
			FALSE,	// save behind
			FALSE,	// active
			FALSE);	// visible
		ControlSetAttributes(CHECKBOX_NO,
			FALSE,	// enable
			FALSE,	// drawn
			FALSE,	// save behind
			FALSE,	// active
			FALSE);	// visible		
		for (i = 1; i < MAX_PAGE; i++)
			BitmapSetAttribute(g_pageBitmap[i], FALSE, FALSE, FALSE, FALSE);
	}
	
	//	FormEraseForm(FORM_TRAINER);
	FormDrawForm(FORM_TRAINER);
	g_page = page;
}

/********************************************************
* Function:	TrainerHandleEvent
* Purpose: 	This function is the event handler for the 
*				Jot Trainer
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN TrainerHandleEvent(EvtType *Event)
{
	Control *control;
	ControlTemplatePushButton *pushbutton;
	BYTE obj_type;
	int i;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if (Event->para2 & 0x00000200)
		{
			if (Event->para1 == LLETTER_RESET || Event->para1 == SLETTER_RESET)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_RESET;
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK)
			UpdateJotTrainerDB(JOT_WRITE_DB);
		FormPopupForm(FORM_JOT);
		break;
	case EVT_CONTROL_SELECT:
		{
			switch (Event->eventID)
			{
			case PUSHBUTTON_INTRO:
				GotoTrainerPage(0);
				break;
			case PUSHBUTTON_J:
				GotoTrainerPage(1);
				break;
			case PUSHBUTTON_k:
				GotoTrainerPage(2);
				break;
			case PUSHBUTTON_p:
				GotoTrainerPage(3);
				break;
			case PUSHBUTTON_Q:
				GotoTrainerPage(4);
				break;
			case PUSHBUTTON_t1:
				GotoTrainerPage(5);
				break;
			case PUSHBUTTON_t2:
				GotoTrainerPage(6);
				break;
			case PUSHBUTTON_i:
				GotoTrainerPage(7);
				break;
			case PUSHBUTTON_DOLLAR:
				GotoTrainerPage(8);
				break;
			case CHECKBOX_YES:
			case CHECKBOX_NO:
				CheckboxClicked(g_pageFlag[g_page]);
				break;
			case BUTTON_RESET:
				g_okForm = FORM_TRAINER;
				g_cancelForm = FORM_TRAINER;
				g_okcancelTitle = JOTSTR14;
				g_okcancelString1 = JOTSTR15;
				g_okcancelString2 = JOTSTR16;
				g_okcancel = FALSE;
				g_fromOkCancel = FALSE;
				FormPopupForm(FORM_OKCANCEL);
				break;
			}
			break;
		}
	case EVT_FORM_OPEN:
		g_prevForm = FORM_TRAINER;
		//UpdateJotTrainerDB(JOT_READ_DB);
		if (g_fromOkCancel && g_okcancel)
		{
			g_train = JOT_TRAIN_DEFAULT;
			UpdateJotTrainerDB(JOT_WRITE_DB);
			g_fromOkCancel = FALSE;
			g_okcancel = FALSE;
		}			
		else if (!g_fromOkCancel)
			UpdateJotTrainerDB(JOT_READ_DB);
		for (i = 0; i < MAX_PAGE; i++)
		{
			ControlInitControl(g_pagePushbuttons[i]);
			FormGetObjectPointer(g_pagePushbuttons[i], &obj_type, (void**)&control);
			if (control)
			{
				pushbutton = control->control_template;
				if (i == g_page)
					pushbutton->control_value = TRUE;
				else
					pushbutton->control_value = FALSE;
			}
		}
		GotoTrainerPage(g_page);
		FormDrawForm(FORM_TRAINER);
		break;
	case EVT_FORM_CLOSE:
		UpdateJotTrainerDB(JOT_WRITE_DB);
		JotUpdate();
		break;
	}
	return TRUE;
	}
	
	void SaveFormTrainer()
	{
        jot_status.form_trainer_page = g_page;
	}
	
	void RestoreFormTrainer()
	{
        g_page = jot_status.form_trainer_page;
	}
