/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   jottrdb.c
Author(s)   :   J. Wang
Company     :   Communication Intelligence Corporation
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "mmu.h"
#include "ui.h"
#include "uifunc.h"
#include <jot.h>
#include <zorroapi.h>
#include "jotui.h"
#include "app.h"

extern JOT_STATUS jot_status;
extern ObjectID g_prevForm;

unsigned int g_train = JOT_TRAIN_DEFAULT;
int g_timeout = JOT_SYMBOL_TIMEOUT;
int g_timeoutMultiStroke = JOT_STROKE_TIMEOUT;

DatabaseID	g_trdbID = (DatabaseID)NULL;
DatabaseID	g_stdbID = (DatabaseID)NULL;

BOOLEAN WriteJotTrainerDB()
{
	RecordID recID;
	
	if (DataOpenRecord(g_trdbID, 0, &recID, NULL) != TRUE)
	{
		if (DataNewRecord(g_trdbID, 0, 3, &recID) != TRUE)
			return FALSE;
	}
	
	if (DataWriteField(g_trdbID, recID, 0, sizeof(unsigned int), (BYTE *)&g_train) != TRUE)
		return FALSE;
	
	if (DataWriteField(g_trdbID, recID, 1, sizeof(int), (BYTE *)&g_timeout) != TRUE)
		return FALSE;
	
	if (DataWriteField(g_trdbID, recID, 2, sizeof(int), (BYTE *)&g_timeoutMultiStroke) != TRUE)
		return FALSE;
	
	DataCloseRecord(g_trdbID, recID);
	return TRUE;
}

BOOLEAN ReadJotTrainerDB()
{
	RecordID recID;
	UWORD trainLen;
	unsigned int *train;
	UWORD timeoutLen;
	int *timeout;
	UWORD timeoutStrokeLen;
	int *timeoutStroke;
	
	if (DataOpenRecord(g_trdbID, 0, &recID, NULL) != TRUE)
		return FALSE;
	
	if (DataGetField(g_trdbID, recID, 0, (BYTE **)&train, &trainLen) != TRUE)
		goto ERROR_RETURN;
	
	if (DataGetField(g_trdbID, recID, 1, (BYTE **)&timeout, &timeoutLen) != TRUE)
		goto ERROR_RETURN;
	
	if (DataGetField(g_trdbID, recID, 2, (BYTE **)&timeoutStroke, &timeoutStrokeLen) != TRUE)
		goto ERROR_RETURN;
	
	g_timeout = *timeout;
	g_timeoutMultiStroke = *timeoutStroke;
	g_train = *train;
	qfree((void *)train);
	qfree((void *)timeout);
	qfree((void *)timeoutStroke);
	DataCloseRecord(g_trdbID, recID);
	return TRUE;
	
ERROR_RETURN:
	DataCloseRecord(g_trdbID, recID);
	if (train)
		qfree((void *)train);
	if (timeout)
		qfree((void *)timeout);
	if (timeoutStroke)
		qfree((void *)timeoutStroke);
	
	return FALSE;
}

BOOLEAN UpdateJotTrainerDB(int read_or_write)
{
	BOOLEAN newDB = FALSE;
	
	if (DataFindDB(JOT_TRAINER_DB_NAME, &g_trdbID) != TRUE)
	{
		//		printf("Cannot find trainer DB\n");
		newDB = TRUE;
		if (DataNewDB(JOT_TRAINER_DB_NAME, JOT_TRAINER_DB_VERSION,
			JOT_TRAINER_DB_INFO, &g_trdbID) != TRUE)
		{
			//			printf("Cannot create trainer DB\n");
			return FALSE;
		}
	}
	
	if (DataOpenDB(g_trdbID, 0, OPEN_RW) != TRUE)
	{
		//		printf("Cannot open trainer DB\n");
		return FALSE; 
	}
	
	/* Add default trainer values if it's a new database */
	if (newDB)
	{
		//		printf("New DB!\n");
		g_train = JOT_TRAIN_DEFAULT;
		g_timeout = JOT_SYMBOL_TIMEOUT;
		g_timeoutMultiStroke = JOT_STROKE_TIMEOUT;
		WriteJotTrainerDB();
	}
	else if (read_or_write == JOT_READ_DB)
	{
		ReadJotTrainerDB();
	}
	else
	{
		WriteJotTrainerDB();
	}
	
	DataCloseDB(g_trdbID);
	
	return TRUE;
}

BOOLEAN SaveStatus()
{
	RecordID recID;
	
	FormGetActiveFormID(&jot_status.formID);
	if (jot_status.formID != FORM_JOT &&
		jot_status.formID != FORM_MACRO_EDITOR &&
		jot_status.formID != FORM_TRAINER &&
		jot_status.formID != FORM_JOT_NEWMACRO)
		jot_status.formID = g_prevForm;
	
	if (jot_status.formID != FORM_JOT &&
		jot_status.formID != FORM_MACRO_EDITOR &&
		jot_status.formID != FORM_TRAINER &&
		jot_status.formID != FORM_JOT_NEWMACRO)
		jot_status.formID = FORM_JOT;
	
	//	if (jot_status.formID == FORM_JOT)
	SaveFormJot();
    if (jot_status.formID == FORM_JOT_NEWMACRO)
		SaveFormNewMacro();
	//	else if (jot_status.formID == FORM_TRAINER)
	SaveFormTrainer();
	
	if (DataOpenRecord(g_stdbID, 1, &recID, NULL) != TRUE)
	{
		if (DataNewRecord(g_stdbID, 1, 1, &recID) != TRUE)
			return FALSE;
	}
	
	if (DataWriteField(g_stdbID, recID, 0, sizeof(JOT_STATUS), (BYTE *)&jot_status) != TRUE)
		return FALSE;
	
	DataCloseRecord(g_stdbID, recID);
	return TRUE;
}

BOOLEAN LoadStatus()
{
	UWORD statusLen;
	JOT_STATUS *status;
	RecordID recID;
	
	if (DataOpenRecord(g_stdbID, 1, &recID, NULL) != TRUE)
		return FALSE;
	
	if (DataGetField(g_stdbID, recID, 0, (BYTE **)&status, &statusLen) != TRUE)
		goto ERROR_RETURN;
	
	jot_status = *status;
	qfree((void *)status);
	DataCloseRecord(g_stdbID, recID);
	
	RestoreFormJot();
	ListInitList(LIST_MACRO_NAME1);	
	ListInitList(LIST_MACRO_TEXT1);	
	SetMacrosInList(LIST_MACRO_NAME1, LIST_MACRO_TEXT1);	
	
	if (jot_status.formID == FORM_JOT_NEWMACRO)
		RestoreFormNewMacro();
	RestoreFormTrainer();
	return TRUE;
	
ERROR_RETURN:
	if (status)
		qfree((void *)status);
	return FALSE;
}

BOOLEAN UpdateJotStatusDB(int read_or_write)
{
	BOOLEAN newDB = FALSE;
	
	jot_status.formID = FORM_JOT;
	jot_status.form_jot_page = PUSHBUTTON_TIMEOUTS;
	
	if (DataFindDB(JOT_STATUS_DB_NAME, &g_stdbID) != TRUE)
	{
		//		printf("Cannot find status db\n");
		newDB = TRUE;
		if (DataNewDB(JOT_STATUS_DB_NAME, JOT_STATUS_DB_VERSION,
			JOT_STATUS_DB_INFO, &g_stdbID) != TRUE)
		{
			//			printf("Cannot create status DB\n");
			return FALSE;
		}
	}
	
	if (DataOpenDB(g_stdbID, 0, OPEN_RW) != TRUE)
	{
		//		printf("Cannot open status DB\n");
		return FALSE; 
	}
	
	/* Add default trainer values if it's a new database */
	if (newDB)
	{
		//		printf("New DB!\n");
		jot_status.formID = FORM_JOT;
		jot_status.form_jot_page = PUSHBUTTON_TIMEOUTS;
		SaveStatus();
	}
	else if (read_or_write == JOT_READ_DB)
	{
		LoadStatus();
	}
	else
	{
		SaveStatus();
	}
	
	DataCloseDB(g_stdbID);
	
	return TRUE;
}
