/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   jotui.h
Author(s)   :   J. Wang
Company     :   Communication intelligence Corporation
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


/* Jotui.h
 *
 * Header file for Jot user interface
 *
 * Jiping Wang           04-Jan-99   Initial.
 */
#ifndef JOTUI_H
#define JOTUI_H

#define JOT_STATUS_DB_NAME JOT_STATUSDB
#define JOT_STATUS_DB_VERSION 0x0100
#define JOT_STATUS_DB_INFO JOT_DEVELOPER

#define MAX_MACRO_NAME_LEN 7
#define MAX_MACRO_TEXT_LEN 255
typedef struct
	{
	ObjectID	formID;
	SHORT		form_jot_page;
	SHORT		form_trainer_page;
	SHORT		form_newmacro_editMacro;
	BYTE        g_macroName[MAX_MACRO_NAME_LEN+1];
	BYTE		g_macroText[MAX_MACRO_TEXT_LEN+1];
	BOOLEAN		g_macroEditted;
	BOOLEAN		g_modified;
	} JOT_STATUS;

BOOLEAN MacroEditorHandleEvent(EvtType *Event);
BOOLEAN NewMacroFormEventHandler(EvtType *Event);
BOOLEAN WarningFormEventHandler(EvtType *Event);
BOOLEAN OkCancelFormEventHandler(EvtType *Event);

BOOLEAN TrainerHandleEvent(EvtType *Event);

BOOLEAN TimeoutsHandleEvent(EvtType *Event);
BOOLEAN UpdateJotStatusDB(int read_or_write);
void SaveFormNewMacro();
void RestoreFormNewMacro();
void SaveFormJot();
void RestoreFormJot();
void SaveFormTrainer();
void RestoreFormTrainer();


void MenuItemSelectedAction(USHORT item_num);

#endif
