/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   menufunc.c
Author(s)   :   J. Wang
Company     :   Communication Intelligence Corporation
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"

/********************************************************
* Function:	MenuItemSelectedAction
* Purpose: 	This fucntion is to do an action when 
an item in a menu is selected
* Scope:		application/internal
* Input:		menu_item		The item number of the selectd menu item
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void MenuItemSelectedAction(USHORT item_num)
{
    ObjectID active_form_id = 0;
    ObjectID active_object_id = 0;
	BOOLEAN highlighted = FALSE, insert_pt = FALSE;
	BYTE object_type;
	void *addr;
	Field *field_ptr;
	Textbox *textbox_ptr;
	
	
	FormGetActiveFormID(&active_form_id);
    FormGetActiveObject(active_form_id, &active_object_id);
	
	if (FormGetObjectPointer(active_object_id, &object_type, (void**)&addr) == FALSE)
		return;
    if (object_type != FIELD && object_type != TEXTBOX/* && item_num != MENU_ITEM_ZOOM*/)
		return;
    else if (object_type == FIELD)
	{
		field_ptr = (Field*)addr;
		highlighted = field_ptr->field_attr.field_highlight;
		insert_pt = field_ptr->field_attr.field_insert_pt_visible;
	}
	else if (object_type == TEXTBOX)
	{
		textbox_ptr = (Textbox*)addr;
		highlighted = textbox_ptr->textbox_attr.textbox_highlight;
		insert_pt = textbox_ptr->textbox_attr.textbox_insert_pt_visible;
	}
	
	switch(item_num)
	{
	case MENU_ITEM_COPY:
		KeyboardSendEvent(KEY_COPY, FALSE, FALSE, FALSE);
		break;
	case MENU_ITEM_CUT:
		KeyboardSendEvent(KEY_CUT, FALSE, FALSE, FALSE);
		break;
	case MENU_ITEM_PASTE:
		KeyboardSendEvent(KEY_PASTE, FALSE, FALSE, FALSE);
		break;
	case MENU_ITEM_UNDO:
		if (UIGetUndoStatus() != UNDO_EMPTY)
			KeyboardSendEvent(KEY_UNDO, FALSE, FALSE, FALSE);
		break;
	default: break;
	}
}
