/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   mainmenu.c
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"
#include "system.h"
#include "sysetup.h"
#include "msg.h"
#include "dev_pwr.h"

#define     DEFAULT_NUM_APPS    12

void            *cmd_ptr;
DatabaseID      dbid;
ObjectID        active_form;
UWORD           main_no_of_apps;
ObjectID		*object_array = NULL;

void SketchTableUpdateTable(UWORD row_no)
{
    UWORD           i, j, k = 3 * row_no;
    BYTE            object_type;
    Table           *table_ptr;
    Bitmap          *bmp_ptr;
    InstallAppInf   *insAppInf;
	
	SysGetInstallAppHandle(&insAppInf);
	
	FormGetObjectPointer(TABLE_MAIN_MENU, &object_type, (void**)&table_ptr);
	
    /* set all default bitmaps of applications invisible and disable */
    for (i=0; i < DEFAULT_NUM_APPS; i++)
	{
		FormGetObjectPointer(i+2, &object_type, (void**)&bmp_ptr);
		bmp_ptr->bitmap_attr.bitmap_visible = FALSE;
		bmp_ptr->bitmap_attr.bitmap_enable = FALSE;
	}
	
	
	/* set all default bitmaps of install applications invisible and disable */
	for (i=0; i < (main_no_of_apps - DEFAULT_NUM_APPS); i++)
	{
		FormGetObjectPointer(INSTALL_RES_ID + insAppInf[i].icon_index, &object_type, (void**)&bmp_ptr);
		bmp_ptr->bitmap_attr.bitmap_visible = FALSE;
		bmp_ptr->bitmap_attr.bitmap_enable = FALSE;
	}
	
	
	for (i = 0; i < 4; i++)
	{
		for (j = 0; j < 3; j++)
		{
            if (k >= main_no_of_apps)
                (table_ptr->table_item_ptr[3*i+j])->table_item_ui_id = TABLE_MAIN_MENU;
            else
            {
                (table_ptr->table_item_ptr[3*i+j])->table_item_ui_id = object_array[k];
                FormGetObjectPointer(object_array[k], &object_type, (void**)&bmp_ptr);
                bmp_ptr->bitmap_attr.bitmap_visible = TRUE;
                bmp_ptr->bitmap_attr.bitmap_enable = TRUE;
            }
			k++;
		}			
	}					
}

void MainMenuSetScrollbar(EvtType *Event)
{
	WORD		max,min,value,pagesize;
	WORD		scroll_total_lines;
	BYTE		object_type;
	Scrollbar*	scroll_ptr;
	
	ScrollbarGetScrollbar(SCROLLBAR_MAIN_MENU, &value, &max, &min, &pagesize, &scroll_total_lines);
	
	if ((Event->para2 - Event->para1) >= pagesize)
	{
		ScrollbarSetScrollbar(SCROLLBAR_MAIN_MENU, (Event->para2 - 1), max, min, pagesize, scroll_total_lines);
		SketchTableUpdateTable((USHORT)(Event->para2) - 1);
	}
	else if ((Event->para1 - Event->para2) >= pagesize)
	{
		ScrollbarSetScrollbar(SCROLLBAR_MAIN_MENU, (Event->para2 + 1), max, min, pagesize, scroll_total_lines);
		SketchTableUpdateTable((USHORT)(Event->para2) + 1);
	}
	else
	{
		ScrollbarSetScrollbar(SCROLLBAR_MAIN_MENU, Event->para2, max, min, pagesize, scroll_total_lines);
		SketchTableUpdateTable((USHORT)(Event->para2));
	}
	
	if (Event->para2 != Event->para1)
	{
		TableDrawTable(TABLE_MAIN_MENU);
	}
	
    FormGetObjectPointer(SCROLLBAR_MAIN_MENU, &object_type, (void**)&scroll_ptr);
    scroll_ptr->scrollbar_draw_pagesize = pagesize;
    ScrollbarDrawScrollbar(SCROLLBAR_MAIN_MENU);
}

void TableInit()
{
	BYTE i, j;
	BYTE object_type;
	Table *table_ptr;
	InstallAppInf *insAppInf;
	Scrollbar*	scroll_ptr;
	
	TableInitTable(TABLE_MAIN_MENU);
	FormGetObjectPointer(TABLE_MAIN_MENU, &object_type, (void**)&table_ptr);
	
	
	SysGetInstallAppHandle(&insAppInf);
	main_no_of_apps = DEFAULT_NUM_APPS;
	
	
	i = 0;			
	while (insAppInf[i].reg_entry_index != 0xFF)
	{
		FormAddOneObject(FORM_MAIN_MENU, (INSTALL_RES_ID + insAppInf[i].icon_index), BITMAP);
		BitmapInitBitmap(INSTALL_RES_ID + insAppInf[i].icon_index);
		i++;
		main_no_of_apps++;
	}
	
	object_array = (ObjectID *)qmalloc(main_no_of_apps * sizeof(ObjectID));
	i = 0;			
	while (i < DEFAULT_NUM_APPS)
	{
		object_array[i] = 2 + i;
		i++;
	}				
	
	i = 0;
	while (insAppInf[i].reg_entry_index != 0xFF)
	{
		object_array[DEFAULT_NUM_APPS + i] = INSTALL_RES_ID + insAppInf[i].icon_index;
		i++;
	}
	
	
	ScrollbarInitScrollbar(SCROLLBAR_MAIN_MENU);
	if (main_no_of_apps > 12)
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_MAIN_MENU, TRUE);
		ScrollbarSetScrollbar(SCROLLBAR_MAIN_MENU, 0, (main_no_of_apps-1)/3+1-4, 0, 4, (main_no_of_apps-1)/3+1);
		
		FormGetObjectPointer(SCROLLBAR_MAIN_MENU, &object_type, (void**)&scroll_ptr);
		scroll_ptr->scrollbar_draw_pagesize = 4;
		
		ScrollbarDrawScrollbar(SCROLLBAR_MAIN_MENU);
	}
	else
		ScrollbarSetScrollbarVisible(SCROLLBAR_MAIN_MENU, FALSE);
				
}

BOOLEAN MainMenuForm1(EvtType *Event)
{
	//#if 0
	UWORD i;
	InstallAppInf *insAppInf;
	
    AppID appid = 0xffff;
    REGISTRY app_reg;
	
    BYTE        obj_type;
    Bitmap      *bmp;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if (Event->para2 & 0x00000200)
		{
            if (Event->para2 == 0x215 || Event->para2 == 0x21c)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_MAIN_MENU, SCROLLBAR_UP_ARROW);
                return TRUE;            
            }
            else if (Event->para2 == 0x216 || Event->para2 == 0x21d)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_MAIN_MENU, SCROLLBAR_DOWN_ARROW);
                return TRUE;            
            }                    
		}
	}
	
    switch (Event->eventType)
	{
	case EVT_FORM_OPEN:
		StringInitString(STRING_TIME);
		BitmapInitBitmap(BITMAP_BAT0);
		BitmapInitBitmap(BITMAP_BAT1);
		BitmapInitBitmap(BITMAP_BAT2);
		BitmapInitBitmap(BITMAP_BAT3);
		
#ifdef	CLOCK_TESTING            
		tmr = TmrIntEnable(5000, MainMenuUpdate);
#else
		tmr = TmrIntEnable(30000, MainMenuUpdate);
#endif			
		
		MainMenuUpdate();
		
		TableInit();
		
		FormGetObjectPointer(BITMAP_BAT3, &obj_type, (void **)&bmp);
		(bmp->bitmap_attr).bitmap_visible = TRUE;
		
		FormDrawForm(FORM_MAIN_MENU);
		FormGetActiveFormID(&active_form);
		return TRUE;
		
#ifdef PR31700
	case 	EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_MAIN_MENU, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_MAIN_MENU, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
#endif
		
	case	EVT_SCROLLBAR_REPEAT:
	case	EVT_SCROLLBAR_SELECT:
		MainMenuSetScrollbar(Event);
		return TRUE;
		
	case EVT_BITMAP_SELECT:
		switch(Event->eventID)
		{
		case APP_JOT:
			SysGetAppID(JOT, &appid);
			break;
		case APP_SCHEDULER :
			SysGetAppID(SCHEDULER, &appid);
			break;
		case APP_CALCULATOR :
			SysGetAppID(CALCULATOR, &appid);
			break;
		case APP_PHONEBOOK :
			SysGetAppID(PHONEBOOK, &appid);
			break;
		case APP_EMAIL :
			SysGetAppID(EMAIL, &appid);
			break;
		case APP_EXPENSE :
			SysGetAppID(EXPENSE, &appid);
			break;
		case APP_SYSETUP:
			SysGetAppID(SYSETUP, &appid);
			break;
		case APP_TO_DO_LIST:
			SysGetAppID(TODOLIST, &appid);
			break;
		case APP_MEMO:
			SysGetAppID(MEMO, &appid);
			break;
		case APP_VOICE_MEMO:
			SysGetAppID(VOX_MEMO, &appid);
			break;
		case APP_SKETCH:
			SysGetAppID(SKETCH, &appid);
			break;
		case APP_PC_SYNC:
			SysGetAppID(PC_SYNC, &appid);
			break;
		default:
			i = 0;
			SysGetInstallAppHandle(&insAppInf);
			while (insAppInf[i].reg_entry_index != 0xFF)
			{
				if (Event->eventID == INSTALL_RES_ID + insAppInf[i].icon_index)
					break;
				i++;
			}
			if (insAppInf[i].reg_entry_index != 0xFF)
			{
				SysGetRegistryData(insAppInf[i].reg_entry_index, &app_reg);
				appid = app_reg.app_id;
			}
			break;
		}
		break;
		case RTC_EVENT:
			if (Event->eventID == RTC_GETTIME)
			{
				MainMenuUpdateTime(Event);
#ifdef	CLOCK_TESTING            
				tmr = TmrIntEnable(5000, MainMenuUpdate);
#else
				tmr = TmrIntEnable(30000, MainMenuUpdate);
#endif			
				
				return TRUE;
			}
			return FALSE;
		case POWER_EVENT:
			if (Event->eventID == BAT_MAIN_LEVEL)
			{
				MainMenuUpdateBat(Event);
				return TRUE;
			}
			return FALSE;
        default:
			return FALSE;
	}
	
	
	
	if(appid != (AppID) 0xffff)
	{
		EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
		EvtAppendEvt(EVT_APP_LAUNCH, appid, LAUNCH_CMD_NORMAL_LAUNCH, 0, NULL);
		return TRUE;
	}
#ifdef DEBUG
	printf("\nCannot find application ");
#endif
	return FALSE;
}

void MainMenuUpdate()
{
	RtcGetTimeEvt();
	if (!BatChkMainLevel())
		EvtAppendEvt(POWER_EVENT, BAT_MAIN_LEVEL, BatChkMainLevelBakup(), 0, NULL);
    TmrIntDisable(tmr);
}

BOOLEAN MainMenuUpdateTime(EvtType *Event)
{
	RTM				*timer;
	SHORT			byte_write = 0;
    BYTE    		date[30];
	CountrySettings	country;
    ObjectID    	active_form_id;
	
	
    FormGetActiveFormID(&active_form_id);
    if (active_form_id != FORM_MAIN_MENU)
        return FALSE;
	
	/* get time & date from timer */
	//	RtcGetTime(&timer);
	timer = Event->evtPBP;
	
	/* get time & date format from country settings */
	if (!SySetupGetCountrySettings(&country))
		return FALSE;
	
	timer->mon += 1;
	
#ifndef	CLOCK_TESTING
	/* display month, day & year */
	switch(country.date_fmt)
	{
	case SYSETUP_YMD:
		if ((timer->year)%100 < 10)
			byte_write = sprintf((char*)date, "0%d/", timer->year%100);
		else
			byte_write = sprintf((char*)date, "%d/", timer->year%100);
		
		byte_write += sprintf((char*)date + byte_write, "%d/", timer->mon);
		
		if (timer->mday < 10)
			byte_write += sprintf((char*)date + byte_write, "0%d", timer->mday);
		else
			byte_write += sprintf((char*)date + byte_write, "%d", timer->mday);
		break;
		
	case SYSETUP_DMY:
		if (timer->mday < 10)
			byte_write  = sprintf((char*)date,     "0%d/", timer->mday);
		else
			byte_write  = sprintf((char*)date,     "%d/", timer->mday);
		
		byte_write += sprintf((char*)date + byte_write, "%d/", timer->mon);
		
		if (timer->year%100 < 10)
			byte_write += sprintf((char*)date + byte_write, "0%d", timer->year%100);
		else
			byte_write += sprintf((char*)date + byte_write, "%d", timer->year%100);
		break;
		
	case SYSETUP_MDY:
		byte_write  = sprintf((char*)date,     "%d/", timer->mon);
		if (timer->mday < 10)
			byte_write += sprintf((char*)date + byte_write, "0%d/", timer->mday);
		else
			byte_write += sprintf((char*)date + byte_write, "%d/", timer->mday);
		if ((timer->year)%100 < 10)
			byte_write += sprintf((char*)date + byte_write, "0%d", timer->year%100);
		else
			byte_write += sprintf((char*)date + byte_write, "%d", timer->year%100);
		break;
		
	default:	return FALSE;
	}
	
	byte_write += sprintf((char*)date + byte_write, "  ");
#endif
	
	
	switch(country.time_fmt)
	{
	case SYSETUP_12HR_DISPLAY:
		if (timer->hour < 10)
			if (timer->hour == 0)
				byte_write += sprintf((char*)date + byte_write, "%d:", 12);
			else
				byte_write += sprintf((char*)date + byte_write, "%d:", timer->hour);
			else
				if (timer->hour < 13)
					byte_write += sprintf((char*)date + byte_write, "%d:", timer->hour);
				else
					byte_write += sprintf((char*)date + byte_write, "%d:", timer->hour - 12);
				
				
#ifdef CLOCK_TESTING
				if (timer->min < 10)
					byte_write += sprintf((char*)date + byte_write, "0%d:", timer->min);
				else
					byte_write += sprintf((char*)date + byte_write, "%d:", timer->min);
				
				if (timer->sec < 10)
					byte_write += sprintf((char*)date + byte_write, "0%d", timer->sec);
				else
					byte_write += sprintf((char*)date + byte_write, "%d", timer->sec);
#else
				if (timer->min < 10)
					byte_write += sprintf((char*)date + byte_write, "0%d", timer->min);
				else
					byte_write += sprintf((char*)date + byte_write, "%d", timer->min);
#endif							
				
				
				
				if (timer->hour < 12)
					byte_write += sprintf((char*)date + byte_write, MAINAM);
				else
					byte_write += sprintf((char*)date + byte_write, MAINPM);
				
				
				
				break;
				
	case SYSETUP_24HR_DISPLAY:
		if (timer->hour < 10)
			byte_write += sprintf((char*)date + byte_write, "0%d:", timer->hour);
		else
			byte_write += sprintf((char*)date + byte_write, "%d:", timer->hour);
		
#ifdef 	CLOCK_TESTING
		if (timer->min < 10)
			byte_write += sprintf((char*)date + byte_write, "0%d:", timer->min);
		else
			byte_write += sprintf((char*)date + byte_write, "%d:", timer->min);
		
		if (timer->sec < 10)
			byte_write += sprintf((char*)date + byte_write, "0%d", timer->sec);
		else
			byte_write += sprintf((char*)date + byte_write, "%d", timer->sec);				
#else				
		if (timer->min < 10)
			byte_write += sprintf((char*)date + byte_write, "0%d", timer->min);
		else
			byte_write += sprintf((char*)date + byte_write, "%d", timer->min);
#endif				
		break;
		
	default:	return FALSE;
	}
	
	qfree(timer);
	
	StringSetText(STRING_TIME, date);
	StringDrawString(STRING_TIME);
	return TRUE;
}

BOOLEAN MainMenuUpdateBat(EvtType *Event)
{
    BYTE        obj_type;
    Bitmap      *bmp;
    ObjectID    active_form_id;
	
	
    FormGetActiveFormID(&active_form_id);
    if (active_form_id != FORM_MAIN_MENU)
        return FALSE;
	
	
	FormGetObjectPointer(BITMAP_BAT0, &obj_type, (void **)&bmp);
    (bmp->bitmap_attr).bitmap_visible = FALSE;
	FormGetObjectPointer(BITMAP_BAT1, &obj_type, (void **)&bmp);
    (bmp->bitmap_attr).bitmap_visible = FALSE;
	FormGetObjectPointer(BITMAP_BAT2, &obj_type, (void **)&bmp);
    (bmp->bitmap_attr).bitmap_visible = FALSE;
	FormGetObjectPointer(BITMAP_BAT3, &obj_type, (void **)&bmp);
    (bmp->bitmap_attr).bitmap_visible = FALSE;
	
	if (Event->para1 >= 9)
	{
		FormGetObjectPointer(BITMAP_BAT3, &obj_type, (void **)&bmp);
		(bmp->bitmap_attr).bitmap_visible = TRUE;
	}     	
	else if (Event->para1 >= 6)
	{
		FormGetObjectPointer(BITMAP_BAT2, &obj_type, (void **)&bmp);
		(bmp->bitmap_attr).bitmap_visible = TRUE;
	}     	
	else if (Event->para1 >= 3)
	{
		FormGetObjectPointer(BITMAP_BAT1, &obj_type, (void **)&bmp);
		(bmp->bitmap_attr).bitmap_visible = TRUE;
	}     	
	else
	{
		FormGetObjectPointer(BITMAP_BAT0, &obj_type, (void **)&bmp);
		(bmp->bitmap_attr).bitmap_visible = TRUE;
	}     	
	
	BitmapDrawBitmap(BITMAP_BAT0);
	BitmapDrawBitmap(BITMAP_BAT1);
	BitmapDrawBitmap(BITMAP_BAT2);
	BitmapDrawBitmap(BITMAP_BAT3);
	return TRUE;
	//#endif
}
