/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   memodb.h
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#ifndef __MEMODB_H_
#define __MEMODB_H_

#include "uifunc.h"
#include "ui.h"
#include "mmu.h"
#include "Memo.h"
#include "MemoFunc.h"

/*==================== App Status ===========================*/
typedef struct _AppStatus
{
	RecordID	rec_id;
	BYTE		sketch_status;
	BYTE		new_sort_mode;
	BYTE		edit_mode;
	BOOLEAN		field_change;
	BYTE		create_time[30];
}AppStatus;

/*==================== Memo Records =========================*/
typedef	struct _RecordIDBlock
{
	BYTE		num_records;
	RecordID	record_id[20];
	DatabaseID	dbid[20];
	struct		_RecordIDBlock *next;
}RecordIDBlock;

typedef	struct _TableDisplay
{	
	ObjectID	table_id;
	USHORT		num_rows_displayed;
	USHORT		total_num_rows;
	USHORT		top_row_num;
	RecordIDBlock *record_id_block;
}TableDisplay;

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/

extern ObjectID	pressed_object1;
extern ObjectID	pressed_object2;
extern BOOLEAN	pen_down;
extern BYTE		show_line;
extern BYTE		restart_form;
extern BOOLEAN	restore_status;
extern WORD		memo_top_line, memo_insert_pt_pos;
extern ObjectID		low_memory_form_id;
extern BOOLEAN		entry_low_memory, entry_old_edit;

/*****************************************************************
********************** To Do List Application ********************
*****************************************************************/
BOOLEAN TableDisplayDeleteAllRecordID(TableDisplay *table_display);
BOOLEAN MemoTableDisplayDraw(TableDisplay *table_display);
BOOLEAN MemoFieldUpdateRecord();
BOOLEAN MemoCateNameToNum(BYTE *cate_name, UBYTE *cate_num);
BOOLEAN	MemoRecordToTable(DatabaseID dbid, BYTE sorted_by, BYTE *cate_name);
BOOLEAN MemoGetRecNumWithCateName(UWORD total_num_rec, BYTE *cate_name, UWORD rec_num[], UWORD *num_rec);
BOOLEAN MemoPopupCateActions(SHORT selected_item);
void MemoSetFontPageMonth(RecordID rec_id, Table *table_addr, USHORT cell, USHORT max_rows_on_display);
void MemoSetFontPageDate(RecordID rec_id, Table *table_addr, USHORT cell, USHORT max_rows_on_display);
void MemoAppRestore(BOOLEAN restart);
void MemoAppSave();
void MemoChangeUpdateRecord();
void TableDisplayInsertRecordID(TableDisplay *table_display, RecordID record_id, DatabaseID dbid);
void MemoDatabaseInit();
void MemoDatabaseChecking();
void MemoDateUpdateRecord(SHORT new_year, SHORT new_month, SHORT new_day);
BYTE MemoCompareTwoStrings(BYTE *string1, BYTE *string2);

#endif
