/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   memofunc.h
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#ifndef __MEMOFUNC_H_
#define __MEMOFUNC_H_

#include "uifunc.h"
#include "ui.h"
#include "mmu.h"
#include "SySetup.h"
#include "Memo.h"
#include "MemoDB.h"

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
extern DatabaseID		memo_dbid;
extern BYTE **			memo_field_buffer;
extern BYTE 			memo_text_buffer[5];
extern TableDisplay		memo_list;
extern AppStatus		app_status;
extern BYTE				table_font;
extern ObjectID			pressed_key;
extern WORD				memo_top_line, memo_insert_pt_pos;

/*****************************************************************
********************** To Do List Application ********************
*****************************************************************/
BOOLEAN MemoSetTableTopRowNum(UWORD top_record);
BOOLEAN MemoSetScrollbar();
BOOLEAN MemoDisplayGetRecordID(TableDisplay *table_display, USHORT row_num,RecordID *rec_id, DatabaseID *dbid);
BOOLEAN MemoSetUpFieldScreen(ObjectID form_id);
BOOLEAN MemoEditSetField(ObjectID form_id, ObjectID field_id);
BOOLEAN MemoFieldSetScrollbar(ObjectID field_id, ObjectID scrollbar_id);
BOOLEAN MemoChangeFont();
BOOLEAN MemoEditCateSetScrollbar();
BOOLEAN DeleteCateCheck(SHORT selected_item);
BOOLEAN DeleteCate(SHORT selected_item);
BOOLEAN MemoInputCatCheckCharIn();
BOOLEAN MemoTableSetScrollbar();
BOOLEAN MemoViewingSelectedLargeFontOnly();
void MemoSetTableFont();
void MemoChangeCateListFontSize();
void MemoScrollbarSetTable(EvtType *Event);
void MemoRecordToVariable();
void MemoViewingSetUpScreen();
void MemoInitFieldBuffer();
void MemoFieldToFieldBuffer();
void MemoFieldBufferToField();
void MemoClearFieldBuffer();
void MemoNewSetUpVariable();
void MemoMenuSelectedAction(USHORT item_num);
void MemoScrollbarSetField(ObjectID field_id, ObjectID scrollbar_id, EvtType *Event);
void MemoScrollbarSetEditCate(EvtType *Event);
void MemoCateNameToPopupTrigger(DatabaseID dbid);
Err MemoGetClickedCell(ObjectID table_id,SHORT x_coord,SHORT y_coord,USHORT *row_number,
					   USHORT *col_number,USHORT *cell_number);

#endif
