/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   memo.c
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "uidef.h"
#include "uifunc.h"
#include "Memo.h"
//#define       DEBUG
//#define DEBUG_HENRY


/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
ObjectID	pressed_object1;
ObjectID	pressed_object2;
ObjectID	pressed_key;
BOOLEAN		pen_down, goto_highlight;
BYTE		restart_form, show_line, table_font;
WORD		memo_top_line, memo_insert_pt_pos;
ObjectID	low_memory_form_id;
BOOLEAN		entry_low_memory, entry_old_edit;
BYTE		old_cate[30];

/*****************************************************************
***************** Application Event Handle Function **************
*****************************************************************/
/******************************************************************
* Function:	SchedulerAnnList
* Purpose: 	This function is the event handler for the 
*			ANN LIST of the Anniversaries application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN	MemoList(EvtType* Event)
{
	static	ObjectID old_column0_id, old_column1_id, old_column2_id;
	static	USHORT	old_row_num, highlight_row;
	static	BOOLEAN	not_table_clear = FALSE;
	ObjectID	cell_ui_id;
	RecordID	rec_id;
	BYTE		object_type, text_color, text_bg_color;
	USHORT		row_number, col_number, cell_number, item_num;
	Control		*ctl_addr;
	String		*string1_addr, *string2_addr, *string3_addr, *table_string;
	Table		*table_addr;
#ifdef PR31700
	AppID           appid;
#endif
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_NEW || Event->para1 == SLETTER_NEW)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_MEMO_NEW;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_SORT || Event->para1 == SLETTER_SORT)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_MEMO_SORT;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_CATE || Event->para1 == SLETTER_CATE)
			{
				ControlPopupPopupTrigger(POPUP_TRIGGER_CATEGORY);
				return	FALSE;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		app_status.edit_mode = MEMO_LIST;
		restart_form = RESTART_MEMO;
		
		FormGetObjectPointer(POPUP_TRIGGER_CATEGORY, &object_type, (void **)&ctl_addr);
		ctl_addr->control_attr.control_enable = TRUE;
		ctl_addr->control_attr.control_visible = TRUE;
		
		FormGetObjectPointer(STRING_MEMO_CONTENT_N1, &object_type, (void **)&table_string);
		table_font = table_string->text_font;
		
		ControlPopupFindItemNum(POPUP_TRIGGER_CATEGORY, current_cate, &item_num);
		ControlPopupSetSelectedItem(POPUP_TRIGGER_CATEGORY, item_num);
		FormDrawForm(FORM_MEMO_LIST);				
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{
		case	BUTTON_MEMO_NEW:
#ifdef	PR31700
			if (MemoryCheckMemLow() || (entry_low_memory && entry_old_edit))
			{
				low_memory_form_id = FORM_MEMO_LIST;
				FormPopupForm(FORM_SYSTEM_LOW_MEM);
				return TRUE;
			}											
#endif												
			
			MemoInitFieldBuffer();
			MemoNewSetUpVariable();
			FormPopupForm(FORM_MEMO_NEW);
			return TRUE;
			
		case	BUTTON_MEMO_SORT:
			FormPopupForm(FORM_SORT_BY);
			return TRUE;
			
		default:
			return FALSE;
		}
		return TRUE;
		
		case	EVT_CONTROL_POPUP_SELECT:
			if (MemoPopupCateActions((SHORT)(Event->para1)) == TRUE) 
				return TRUE;
			break;
			
		case	EVT_BITMAP_SELECT:
			row_number = Event->eventID - MEMO_BITMAP_OFFSET + memo_list.top_row_num;
			MemoDisplayGetRecordID(&memo_list, row_number, &app_status.rec_id, &memo_dbid);
			MemoLaunchApplication();
			return TRUE;
			
		case	EVT_SCROLLBAR_REPEAT:
		case	EVT_SCROLLBAR_SELECT:
			MemoScrollbarSetTable(Event);
			return TRUE;
			
		case	PEN_EVENT:
			if (MemoGetClickedCell(TABLE_MEMO_LIST,(SHORT)(Event->para1),(SHORT)(Event->para2),
				&row_number,&col_number,&cell_number) == TRUE)
			{
				FormGetObjectPointer(TABLE_MEMO_LIST, &object_type, (void **)&table_addr);
				cell_ui_id = ((TableItems*)(table_addr->table_item_ptr[cell_number]))->table_item_ui_id;
				not_table_clear = FALSE;
				
				if ((cell_ui_id >= STRING_MEMO_CONTENT_N1 && cell_ui_id < STRING_MEMO_CONTENT_N1 + 13) ||
					(cell_ui_id >= STRING_MEMO_LIST_MONTH && cell_ui_id < STRING_MEMO_LIST_MONTH + 26))
				{
					if (col_number == MEMO_COLUMN_0 )
					{
						FormGetObjectPointer(cell_ui_id, &object_type, (void **)&string1_addr);
						FormGetObjectPointer(cell_ui_id+13, &object_type, (void **)&string2_addr);
						FormGetObjectPointer(cell_ui_id-87, &object_type, (void **)&string3_addr);
					}
					else if (col_number == MEMO_COLUMN_1 )
					{
						FormGetObjectPointer(cell_ui_id-13, &object_type, (void **)&string1_addr);
						FormGetObjectPointer(cell_ui_id, &object_type, (void **)&string2_addr);
						FormGetObjectPointer(cell_ui_id-100, &object_type, (void **)&string3_addr);
					}
					else
					{
						FormGetObjectPointer(cell_ui_id+87, &object_type, (void **)&string1_addr);
						FormGetObjectPointer(cell_ui_id+100, &object_type, (void **)&string2_addr);
						FormGetObjectPointer(cell_ui_id, &object_type, (void **)&string3_addr);
					}
					if (Event->eventID == PEN_DOWN && object_type == STRING)
					{
						text_color = string1_addr->string_color;
						text_bg_color = string1_addr->string_bg_color;
						
						string1_addr->string_color = COLOR_WHITE;
						string1_addr->string_bg_color = COLOR_BLACK;
						string2_addr->string_color = COLOR_WHITE;
						string2_addr->string_bg_color = COLOR_BLACK;
						string3_addr->string_color = COLOR_WHITE;
						string3_addr->string_bg_color = COLOR_BLACK;
						
						StringDrawString(string1_addr->identification.ui_object_id);
						StringDrawString(string2_addr->identification.ui_object_id);
						StringDrawString(string3_addr->identification.ui_object_id);
						
						string1_addr->string_color = text_color;
						string1_addr->string_bg_color = text_bg_color;
						string2_addr->string_color = text_color;
						string2_addr->string_bg_color = text_bg_color;
						string3_addr->string_color = text_color;
						string3_addr->string_bg_color = text_bg_color;
						/* Clear the old highlight cell */
						if ((old_column0_id >= STRING_MEMO_LIST_MONTH && old_column0_id < STRING_MEMO_LIST_MONTH + 13) &&
							(old_row_num != row_number))
						{
							StringDrawString(old_column0_id);
							StringDrawString(old_column1_id);
							StringDrawString(old_column2_id);
						}
						old_column0_id = string1_addr->identification.ui_object_id;
						old_column1_id = string2_addr->identification.ui_object_id;
						old_column2_id = string3_addr->identification.ui_object_id;
						old_row_num = row_number;
						highlight_row = row_number;
						pen_down = TRUE;
					}					
					else if (Event->eventID == PEN_MOVE && old_row_num != row_number && pen_down == TRUE)
					{
						StringDrawString(old_column0_id);
						StringDrawString(old_column1_id);
						StringDrawString(old_column2_id);
						
						text_color = string1_addr->string_color;
						text_bg_color = string1_addr->string_bg_color;
						
						string1_addr->string_color = COLOR_WHITE;
						string1_addr->string_bg_color = COLOR_BLACK;
						string2_addr->string_color = COLOR_WHITE;
						string2_addr->string_bg_color = COLOR_BLACK;
						string3_addr->string_color = COLOR_WHITE;
						string3_addr->string_bg_color = COLOR_BLACK;
						
						old_column0_id = string1_addr->identification.ui_object_id;
						old_column1_id = string2_addr->identification.ui_object_id;
						old_column2_id = string3_addr->identification.ui_object_id;
						
						StringDrawString(old_column0_id);
						StringDrawString(old_column1_id);
						StringDrawString(old_column2_id);
						
						string1_addr->string_color = text_color;
						string1_addr->string_bg_color = text_bg_color;
						string2_addr->string_color = text_color;
						string2_addr->string_bg_color = text_bg_color;
						string3_addr->string_color = text_color;
						string3_addr->string_bg_color = text_bg_color;
						
						old_row_num = row_number;
						highlight_row = row_number;
					}					
					else if (Event->eventID == PEN_UP && pen_down == TRUE)
					{
						row_number += memo_list.top_row_num;
						
						if (MemoDisplayGetRecordID(&memo_list,row_number,&rec_id,&memo_dbid) == FALSE)
							return FALSE; /* Exit if clicked on empty row */
						
						app_status.rec_id = rec_id;
						memo_top_line = 0;
						memo_insert_pt_pos =0;
						
						strcpy(temp_cate, current_cate);
						
						MemoRecordToVariable();
						MemoViewingSetUpScreen();
						//HENRY							strcpy(temp_cate, current_cate);
						strcpy(old_cate, current_cate);
						/* Disable the field object */
						show_line = FALSE;
						goto_highlight = FALSE;
#ifdef	PR31700
						SndPlaySndEffect(SNDRES5_BEEP);
#endif
						FormPopupForm(FORM_MEMO_VIEWING);
						pen_down = FALSE;
						return TRUE;
					}
					}
					else
					{
						/* Clear the old highlight cell */
						if (old_column0_id >= STRING_MEMO_LIST_MONTH && old_column0_id < STRING_MEMO_LIST_MONTH + 13)
						{
							if (row_number == highlight_row)
							{
								StringDrawString(old_column0_id);
								StringDrawString(old_column1_id);
								StringDrawString(old_column2_id);
								highlight_row = -1;
							}
						}
					}
				}
				else
				{
					/* Clear the old highlight cell */
					if ((old_column0_id >= STRING_MEMO_LIST_MONTH && old_column0_id < STRING_MEMO_LIST_MONTH + 13) &&
						(memo_list.total_num_rows != 0))
					{
						if (not_table_clear == FALSE)
						{
							StringDrawString(old_column0_id);
							StringDrawString(old_column1_id);
							StringDrawString(old_column2_id);
							not_table_clear = TRUE;
						}
					}
				}
				return TRUE;
#ifdef PR31700
		case 	EVT_IO_KEY_CTRL:
			if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
			{
				if (Event->para2 == IO_UP_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_MEMO_LIST, SCROLLBAR_UP_ARROW);
				else if (Event->para2 == IO_DOWN_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_MEMO_LIST, SCROLLBAR_DOWN_ARROW);
				return TRUE;
			}
			return FALSE;
			
		case	EVT_INLAY_SELECT:
			if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			{
				SysGetAppID(MAINMENU, &appid);
				EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
				EvtAppendEvt(EVT_APP_LAUNCH, appid, 0, 0, NULL);
			}
			return TRUE;
#endif
		case	EVT_MENU_SELECT_ITEM:
			FormGetObjectPointer(STRING_MEMO_CONTENT_N1, &object_type, (void **)&table_string);
			if (table_string->text_font == SMALL_FONT)
				table_font = MEDIUM_FONT;
			else
				table_font = SMALL_FONT;
			
			MemoSetTableFont();
			MemoTableDisplayDraw(&memo_list);
			MemoTableSetScrollbar();
			TableDrawTable(TABLE_MEMO_LIST);
			return TRUE;
			
		default:
			return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerToDoViewing
* Purpose: 	This function is the event handler for the 
*			TO DO VIEWING screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN MemoViewing(EvtType* Event)
{
	BYTE	object_type, original_font;
	Control	*ctl_addr;
	Field	*fld_addr;
	String	*string_addr;
	USHORT	num_items, count;
	WORD	old_insert_pt_pos;
	
	BYTE	*label;
	USHORT	item_num;
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_SKETCH || Event->para1 == SLETTER_SKETCH)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_MEMO_SKETCH;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_DEL || Event->para1 == SLETTER_DEL)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_MEMO_DEL;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_CATE || Event->para1 == SLETTER_CATE)
			{
				ControlPopupPopupTrigger(POPUP_TRIGGER_CATEGORY);
				return	FALSE;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		app_status.edit_mode = MEMO_VIEWING;
		restart_form = RESTART_MEMO_VIEWING;
		
		FormGetObjectPointer(FIELD_MEMO_VIEWING, &object_type, (void **)&fld_addr);
		if (show_line == FALSE)
		{
			fld_addr->field_attr.field_insert_pt_visible = FALSE;
			fld_addr->field_attr.field_enable = FALSE;
			fld_addr->field_back_line = NO_LINE;
			
			MenuGetNumOfItems(MEMO_MENU, &num_items);
			
			for (count =0; count < num_items; count++)
				MenuDeleteItem(MEMO_MENU, 0);
			
			FieldGetFont(FIELD_MEMO_VIEWING, &original_font);
			
			if (original_font == SMALL_FONT)
				MenuInsertItem(MEMO_MENU, 0, MEMOLFONT);
			else
				MenuInsertItem(MEMO_MENU, 0, MEMOSFONT);
		}
		else
		{
			FormSetFormActiveObject(FORM_MEMO_VIEWING, FIELD_MEMO_VIEWING);
			fld_addr->field_attr.field_insert_pt_visible = TRUE;
			fld_addr->field_attr.field_enable = TRUE;
			fld_addr->field_attr.field_active = TRUE;
			fld_addr->field_back_line = GREY_LINE;
			
			MenuDeleteItem(MEMO_MENU, 4);
			FieldGetFont(FIELD_MEMO_VIEWING, &original_font);
			if (original_font == SMALL_FONT)
				MenuInsertItem(MEMO_MENU, 4, MEMOLFONT);
			else
				MenuInsertItem(MEMO_MENU, 4, MEMOSFONT);
		}
		/* Highlight the selection text */
		if (goto_highlight == FALSE)
		{
			fld_addr->field_attr.field_highlight = FALSE;
			fld_addr->field_highlight_length = 0;
		}
		
		// mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm
		// modified at 26052000
		if (show_line == FALSE)				
		{
			FormGetObjectPointer(POPUP_TRIGGER_CATEGORY, &object_type, (void **)&ctl_addr);
			ctl_addr->control_attr.control_enable = FALSE;
			ctl_addr->control_attr.control_visible = FALSE;
			
			FormGetObjectPointer(STRING_MEMO_TITLE, &object_type, (void **)&string_addr);
			string_addr->string_attr.string_visible = TRUE;
			StringSetText(STRING_MEMO_TITLE, current_cate);
		}
		else
		{
			FormGetObjectPointer(POPUP_TRIGGER_CATEGORY, &object_type, (void **)&ctl_addr);
			// M =======================================================================================
			// modified at 29052000
			ControlGetLabel(POPUP_TRIGGER_CATEGORY, &label);
			if (ControlPopupFindItemNum(POPUP_TRIGGER_CATEGORY, label, &item_num) == FALSE)
				ControlPopupSetSelectedItem(POPUP_TRIGGER_CATEGORY, 0);
			// M ========================================================================================
			
			ctl_addr->control_attr.control_enable = TRUE;
			ctl_addr->control_attr.control_visible = TRUE;
			
			FormGetObjectPointer(STRING_MEMO_TITLE, &object_type, (void **)&string_addr);
			string_addr->string_attr.string_visible = FALSE;
			//StringSetText(STRING_MEMO_TITLE, current_cate);
		}
		// mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm
		// new at 30062000
		//				FieldGetTopLineNum(FIELD_MEMO_VIEWING, &memo_top_line);
		
		FieldSetTopLineNum(FIELD_MEMO_VIEWING, memo_top_line);
		FieldSetInsertPointPositionByCharPos(FIELD_MEMO_VIEWING, memo_insert_pt_pos);
		MemoSetUpFieldScreen(FORM_MEMO_VIEWING);
		MemoFieldSetScrollbar(FIELD_MEMO_VIEWING, SCROLLBAR_MEMO_VIEWING);
		FormDrawForm(FORM_MEMO_VIEWING);
		return TRUE;
		
	case	EVT_KEYBOARD_STATUS:
#ifdef DEBUG
		printf("\n EVT_KEYBOARD_STATUS");
#endif
		MemoSetUpFieldScreen(FORM_MEMO_VIEWING);
		MemoEditSetField(FORM_MEMO_VIEWING, FIELD_MEMO_VIEWING);
		MemoFieldSetScrollbar(FIELD_MEMO_VIEWING, SCROLLBAR_MEMO_VIEWING);
		FieldGetTopLineNum(FIELD_MEMO_VIEWING, &memo_top_line);
		FieldEraseField(FIELD_MEMO_VIEWING);
		FieldDrawField(FIELD_MEMO_VIEWING);
		return TRUE;
		
	case	EVT_SCROLLBAR_REPEAT:
		
		if (show_line == TRUE)
		{
			FormSetFormActiveObject(FORM_MEMO_VIEWING, FIELD_MEMO_VIEWING);
			FormGetObjectPointer(FIELD_MEMO_VIEWING, &object_type, (void **)&fld_addr);
			
			if ((fld_addr->field_insert_pt_x >= fld_addr->bounds.xcoord && fld_addr->field_insert_pt_x < fld_addr->bounds.xcoord + fld_addr->bounds.width) &&
				(fld_addr->field_insert_pt_y >= fld_addr->bounds.ycoord && fld_addr->field_insert_pt_y < fld_addr->bounds.ycoord + fld_addr->bounds.height))
				FieldGetInsertPointPosition(FIELD_MEMO_VIEWING, &memo_insert_pt_pos);
#ifdef	DEBUG
			printf("\n----> Scrollbar Repeat insert_pt_pos %d <----", memo_insert_pt_pos);
#endif				
		}
		MemoScrollbarSetField(FIELD_MEMO_VIEWING, SCROLLBAR_MEMO_VIEWING, Event);
		
		if (show_line == TRUE)
		{
			if (!fld_addr->field_attr.field_highlight)
				FieldSetInsertPointPositionByCharPos(FIELD_MEMO_VIEWING, memo_insert_pt_pos);
			
			if ((fld_addr->field_insert_pt_x >= fld_addr->bounds.xcoord && fld_addr->field_insert_pt_x < fld_addr->bounds.xcoord + fld_addr->bounds.width) &&
				(fld_addr->field_insert_pt_y >= fld_addr->bounds.ycoord && fld_addr->field_insert_pt_y < fld_addr->bounds.ycoord + fld_addr->bounds.height))
			{
				if (!fld_addr->field_attr.field_highlight)
					FieldSetInsertPointOn(FIELD_MEMO_VIEWING);
			}
			else
				FieldSetInsertPointOff(FIELD_MEMO_VIEWING);
		}
		return TRUE;
		
	case	EVT_SCROLLBAR_SELECT:
		
		ScrollbarDrawScrollbar(SCROLLBAR_MEMO_VIEWING);
		return TRUE;
		
	case	EVT_KEY:
		if (Event->eventID == SOFT_KEY)
		{
			FormGetObjectPointer(FIELD_MEMO_VIEWING, &object_type, (void **)&fld_addr);
			MemoEditSetField(FORM_MEMO_VIEWING, FIELD_MEMO_VIEWING);
			MemoFieldSetScrollbar(FIELD_MEMO_VIEWING, SCROLLBAR_MEMO_VIEWING);
			if (fld_addr->field_attr.field_enable == TRUE && (fld_addr->field_attr.field_insert_pt_visible == TRUE ||
				fld_addr->field_attr.field_highlight == TRUE))
			{
#ifdef	PR31700
				if (MemoryCheckMemLow() || (entry_low_memory && entry_old_edit))
				{
					low_memory_form_id = FORM_MEMO_VIEWING;
					FormPopupForm(FORM_SYSTEM_LOW_MEM);	
					return TRUE;
				}											
#endif
				FieldGetInsertPointPosition(FIELD_MEMO_VIEWING, &memo_insert_pt_pos);
#ifdef	DEBUG
				printf("\n----> Key Add insert_pt_pos %d <----", memo_insert_pt_pos);
#endif				
				FieldAddKeyInChar(FIELD_MEMO_VIEWING,(BYTE)(Event->para1));
			}
			return TRUE;
		}
		return TRUE;
		
	case	EVT_FIELD_CHANGED:
		
		MemoFieldSetScrollbar(FIELD_MEMO_VIEWING, SCROLLBAR_MEMO_VIEWING);
		return TRUE;
		
#ifdef PR31700
	case	EVT_FIELD_MODIFIED:
		app_status.field_change = TRUE;
		FieldGetTopLineNum(FIELD_MEMO_VIEWING, &memo_top_line);
		FieldGetInsertPointPosition(FIELD_MEMO_VIEWING, &memo_insert_pt_pos);
		return TRUE;
#endif
		
	case	PEN_EVENT:
		if (Event->eventID == PEN_DOWN)
		{
			FormGetObjectPointer(FIELD_MEMO_VIEWING, &object_type, (void **)&fld_addr);
			
			if ((Event->para1 >= fld_addr->bounds.xcoord && Event->para1 < fld_addr->bounds.xcoord + fld_addr->bounds.width &&
				Event->para2 >= fld_addr->bounds.ycoord && Event->para2 < fld_addr->bounds.ycoord + fld_addr->bounds.height) &&
				fld_addr->field_attr.field_enable == FALSE)
			{
				MenuDeleteItem(MEMO_MENU, 0);
				MenuInsertItem(MEMO_MENU, 0, MEMOCOPY);
				MenuInsertItem(MEMO_MENU, 1, MEMOCUT);
				MenuInsertItem(MEMO_MENU, 2, MEMOPASTE);
				MenuInsertItem(MEMO_MENU, 3, MEMOUNDO);
				
				FieldGetFont(FIELD_MEMO_VIEWING, &original_font);
				if (original_font == SMALL_FONT)
					MenuInsertItem(MEMO_MENU, 4, MEMOLFONT);
				else
					MenuInsertItem(MEMO_MENU, 4, MEMOSFONT);
				
				FormGetObjectPointer(POPUP_TRIGGER_CATEGORY, &object_type, (void **)&ctl_addr);
				ctl_addr->control_attr.control_enable = TRUE;
				ctl_addr->control_attr.control_visible = TRUE;
				
				FormGetObjectPointer(STRING_MEMO_TITLE, &object_type, (void **)&string_addr);
				string_addr->string_attr.string_visible = FALSE;
				
				fld_addr->field_attr.field_insert_pt_visible = TRUE;
				fld_addr->field_attr.field_enable = TRUE;
				fld_addr->field_attr.field_active = TRUE;
				fld_addr->field_attr.field_highlight = FALSE;
				fld_addr->field_highlight_length = 0;
				fld_addr->field_back_line = GREY_LINE;
				
				show_line = TRUE;
				/* Set the  Insert Point Positino by pen's X &Y */
				FieldSetInsertPointPositionByXY(FIELD_MEMO_VIEWING, (SHORT)Event->para1, (SHORT)Event->para2);
				FormSetFormActiveObject(FORM_MEMO_VIEWING, FIELD_MEMO_VIEWING);
				FormDrawForm(FORM_MEMO_VIEWING);
				
				FieldGetTopLineNum(FIELD_MEMO_VIEWING, &memo_top_line);
				FieldGetInsertPointPosition(FIELD_MEMO_VIEWING, &memo_insert_pt_pos);
			}
		}
		return TRUE;				
		
	case	EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{
		case	BUTTON_MEMO_DEL:
			FormPopupForm(FORM_ITEM_ERASE);
			return TRUE;
			
		case	BUTTON_MEMO_SKETCH:
#ifdef	PR31700
			if ((MemoryCheckMemLow() || (entry_low_memory && entry_old_edit)) && 
				app_status.sketch_status == MEMO_NO_SKETCH)
			{
				low_memory_form_id = FORM_MEMO_VIEWING;
				FormPopupForm(FORM_SYSTEM_LOW_MEM);
				return TRUE;
			}											
#endif
			MemoLaunchApplication();
			return TRUE;
			
		default:
			return FALSE;
		}
		return	TRUE;
		
		case	EVT_CONTROL_POPUP_SELECT:
			if (MemoPopupCateActions((SHORT)(Event->para1)) == TRUE) 
				return TRUE;
			break;
			
		case	EVT_BITMAP_SELECT:
			MemoLaunchApplication();
			return TRUE;
			
		case	EVT_MENU_SELECT_ITEM:
			MenuGetNumOfItems(MEMO_MENU, &num_items);
			
			if (num_items == 1)
				MemoViewingSelectedLargeFontOnly();
			else
				MemoMenuSelectedAction((USHORT)(Event->para1));
			return TRUE;
			
			
#ifdef PR31700
		case 	EVT_IO_KEY_CTRL:
			if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
			{
				if (Event->para2 == IO_UP_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_MEMO_VIEWING, SCROLLBAR_UP_ARROW);
				else if (Event->para2 == IO_DOWN_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_MEMO_VIEWING, SCROLLBAR_DOWN_ARROW);
				return TRUE;
			}
			return FALSE;
#endif
			
		case	EVT_INLAY_SELECT:
			switch (Event->para1)
			{
			case	INLAY_OK:
				MemoFieldToFieldBuffer();
				MemoFieldUpdateRecord();
				MemoChangeUpdateRecord();
				MemoSetTableFont();
				if (!show_line || (show_line && MemoCompareTwoStrings(current_cate, old_cate) == SAME && app_status.field_change == FALSE))
					strcpy(current_cate, temp_cate);															
				MemoRecordToTable(memo_dbid, app_status.new_sort_mode, current_cate);
				show_line = FALSE;
				FieldSetInsertPointOff(FIELD_MEMO_VIEWING);
				FormPopupForm(FORM_MEMO_LIST);
				return TRUE;
				
			case	INLAY_EXIT:
				MemoFieldToFieldBuffer();
				FieldSetInsertPointOff(FIELD_MEMO_VIEWING);
				pressed_object1 = FORM_MEMO_LIST;			
				pressed_object2 = FORM_MEMO_VIEWING;
				
				if (show_line && (MemoCompareTwoStrings(current_cate, old_cate) != SAME || app_status.field_change != FALSE))
					FormPopupForm(FORM_SAVE_CHANGES);
				else
				{
					/* Disable the field for next use */
					MemoCateNameToPopupTrigger(memo_dbid);
					MemoSetTableFont();
					strcpy(current_cate, temp_cate);
					MemoRecordToTable(memo_dbid, app_status.new_sort_mode, current_cate);
					show_line = FALSE;
					FieldSetInsertPointOff(FIELD_MEMO_VIEWING);
					FormPopupForm(FORM_MEMO_LIST);
				}
				return TRUE;
				
			default:
				return FALSE;
			}
			return	TRUE;
			
			default:
				return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerAnnNew
* Purpose: 	This function is the event handler for the 
*			TO DO NEW edit screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN MemoNew(EvtType* Event)
{	
	BYTE	object_type, original_font;
	Field	*fld_addr;
	Control	*ctl_addr;
	USHORT	num_items, item_num;
	BYTE	*label;
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_SKETCH || Event->para1 == SLETTER_SKETCH)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_MEMO_SKETCH;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_CATE || Event->para1 == SLETTER_CATE)
			{
				ControlPopupPopupTrigger(POPUP_TRIGGER_CATEGORY);
				return	FALSE;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		/* Set up the edit mode */
		app_status.edit_mode = MEMO_NEW;
		restart_form = RESTART_MEMO_NEW;
		show_line = TRUE;
		MenuGetNumOfItems(MEMO_MENU, &num_items);
		if (num_items == 1)
		{
			MenuDeleteItem(MEMO_MENU, 0);
			MenuInsertItem(MEMO_MENU, 0, MEMOCOPY);
			MenuInsertItem(MEMO_MENU, 1, MEMOCUT);
			MenuInsertItem(MEMO_MENU, 2, MEMOPASTE);
			MenuInsertItem(MEMO_MENU, 3, MEMOUNDO);
		}
		FieldGetFont(FIELD_MEMO_NEW, &original_font);
		MenuDeleteItem(MEMO_MENU, 4);
		if (original_font == SMALL_FONT)
			MenuInsertItem(MEMO_MENU, 4, MEMOLFONT);
		else
			MenuInsertItem(MEMO_MENU, 4, MEMOSFONT);
		
		FormSetFormActiveObject(FORM_MEMO_NEW, FIELD_MEMO_NEW);
		FieldSetTopLineNum(FIELD_MEMO_NEW, memo_top_line);
		FieldSetInsertPointOn(FIELD_MEMO_NEW);
		FieldSetInsertPointPositionByCharPos(FIELD_MEMO_NEW, memo_insert_pt_pos);
		MemoSetUpFieldScreen(FORM_MEMO_NEW);
		MemoFieldSetScrollbar(FIELD_MEMO_NEW, SCROLLBAR_MEMO_VIEWING);
		
		// M =============================================================================================
		// modified at 29052000
		FormGetObjectPointer(POPUP_TRIGGER_CATEGORY, &object_type, (void**)&ctl_addr);
		ControlGetLabel(POPUP_TRIGGER_CATEGORY, &label);
		if (ControlPopupFindItemNum(POPUP_TRIGGER_CATEGORY, label, &item_num) == FALSE)
			ControlPopupSetSelectedItem(POPUP_TRIGGER_CATEGORY, 0);
		// M =============================================================================================
		
		FormDrawForm(FORM_MEMO_NEW);
		return TRUE;
		
	case	EVT_KEYBOARD_STATUS:
#ifdef DEBUG
		printf("\n\n Evt_keyboard_status");
#endif
		MemoSetUpFieldScreen(FORM_MEMO_NEW);
		MemoEditSetField(FORM_MEMO_NEW, FIELD_MEMO_NEW);
		MemoFieldSetScrollbar(FIELD_MEMO_NEW, SCROLLBAR_MEMO_VIEWING);
		FieldGetTopLineNum(FIELD_MEMO_NEW, &memo_top_line);
		FieldEraseField(FIELD_MEMO_NEW);
		FieldDrawField(FIELD_MEMO_NEW);
		return TRUE;
		
	case	EVT_SCROLLBAR_REPEAT:
		if (show_line == TRUE)
		{
			FormSetFormActiveObject(FORM_MEMO_NEW, FIELD_MEMO_NEW);
			FormGetObjectPointer(FIELD_MEMO_NEW, &object_type, (void **)&fld_addr);
			
			if ((fld_addr->field_insert_pt_x >= fld_addr->bounds.xcoord && fld_addr->field_insert_pt_x < fld_addr->bounds.xcoord + fld_addr->bounds.width) &&
				(fld_addr->field_insert_pt_y >= fld_addr->bounds.ycoord && fld_addr->field_insert_pt_y < fld_addr->bounds.ycoord + fld_addr->bounds.height))
				FieldGetInsertPointPosition(FIELD_MEMO_NEW, &memo_insert_pt_pos);
		}
		MemoScrollbarSetField(FIELD_MEMO_NEW, SCROLLBAR_MEMO_VIEWING, Event);
		
		if (show_line == TRUE)
		{
			FieldSetInsertPointPositionByCharPos(FIELD_MEMO_NEW, memo_insert_pt_pos);
			
			if ((fld_addr->field_insert_pt_x >= fld_addr->bounds.xcoord && fld_addr->field_insert_pt_x < fld_addr->bounds.xcoord + fld_addr->bounds.width) &&
				(fld_addr->field_insert_pt_y >= fld_addr->bounds.ycoord && fld_addr->field_insert_pt_y < fld_addr->bounds.ycoord + fld_addr->bounds.height))
				FieldSetInsertPointOn(FIELD_MEMO_NEW);
			else
				FieldSetInsertPointOff(FIELD_MEMO_NEW);
		}
		return TRUE;
		
	case	EVT_SCROLLBAR_SELECT:
		ScrollbarDrawScrollbar(SCROLLBAR_MEMO_VIEWING);
		return TRUE;
		
	case	EVT_KEY:
		if (Event->eventID == SOFT_KEY)
		{
			MemoSetUpFieldScreen(FORM_MEMO_NEW);
			MemoEditSetField(FORM_MEMO_NEW, FIELD_MEMO_NEW);
			MemoFieldSetScrollbar(FIELD_MEMO_NEW, SCROLLBAR_MEMO_VIEWING);
			FieldAddKeyInChar(FIELD_MEMO_NEW,(BYTE)(Event->para1));
		}
		return TRUE;
		
	case	EVT_FIELD_CHANGED:
		MemoFieldSetScrollbar(FIELD_MEMO_NEW, SCROLLBAR_MEMO_VIEWING);
		return TRUE;
		
#ifdef PR31700
	case	EVT_FIELD_MODIFIED:
		app_status.field_change = TRUE;
		FieldGetTopLineNum(FIELD_MEMO_NEW, &memo_top_line);
		FieldGetInsertPointPosition(FIELD_MEMO_NEW, &memo_insert_pt_pos);
		return TRUE;
#endif
		
	case	PEN_EVENT:
		if (Event->eventID == PEN_DOWN)
		{
			FieldGetTopLineNum(FIELD_MEMO_NEW, &memo_top_line);
			FieldGetInsertPointPosition(FIELD_MEMO_NEW, &memo_insert_pt_pos);
		}
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
#ifdef	PR31700
		if ((MemoryCheckMemLow() || (entry_low_memory && entry_old_edit)) && 
			app_status.sketch_status == MEMO_NO_SKETCH)
		{
			
			low_memory_form_id = FORM_MEMO_NEW;
			FormPopupForm(FORM_SYSTEM_LOW_MEM);	
			return TRUE;
		}											
#endif
		MemoLaunchApplication();
		return	TRUE;
		
	case	EVT_CONTROL_POPUP_SELECT:
		if (MemoPopupCateActions((SHORT)(Event->para1)) == TRUE) 
			return TRUE;
		break;
		
	case	EVT_BITMAP_SELECT:
		MemoLaunchApplication();
		return TRUE;
		
	case	EVT_MENU_SELECT_ITEM:
		MemoMenuSelectedAction((USHORT)(Event->para1));
		return TRUE;
		
	case	EVT_INLAY_SELECT:
		switch (Event->para1)
		{
		case	INLAY_OK:
			/* Save the content from FIELD object to field buffer */
			
#ifdef PR31700
			if (app_status.field_change == TRUE || app_status.sketch_status == TRUE)
#else
				if (app_status.sketch_status == TRUE)
#endif
				{
					MemoFieldToFieldBuffer();
					MemoFieldUpdateRecord();
					MemoChangeUpdateRecord();
					MemoSetTableFont();
					MemoRecordToTable(memo_dbid, app_status.new_sort_mode, current_cate);
				}
				else
				{
					if (memo_field_buffer[0] !=NULL)
					{
						strcpy(memo_field_buffer[0],(BYTE*)(""));
						MemoFieldBufferToField();
						MemoClearFieldBuffer();
					}
					MemoCateNameToPopupTrigger(memo_dbid);
					DataCloseRecord(memo_dbid, app_status.rec_id);
					DataDeleteRecord(memo_dbid, app_status.rec_id, FALSE);
					MemoSetTableFont();
					MemoRecordToTable(memo_dbid, app_status.new_sort_mode, temp_cate);
					ControlSetLabel(POPUP_TRIGGER_CATEGORY, temp_cate);                                                             
					current_cate = temp_cate;
				}
				FieldSetInsertPointOff(FIELD_MEMO_NEW);
				FormPopupForm(FORM_MEMO_LIST);
				return TRUE;
				
		case	INLAY_EXIT:
			MemoFieldToFieldBuffer();
			pressed_object1 = FORM_MEMO_LIST;
			pressed_object2 = FORM_MEMO_NEW;
			FieldSetInsertPointOff(FIELD_MEMO_NEW);
#ifdef PR31700
			if (app_status.field_change == TRUE || app_status.sketch_status == TRUE)
#else
				if (app_status.sketch_status == TRUE)
#endif
					FormPopupForm(FORM_SAVE_CHANGES);
				else
				{
					if (memo_field_buffer[0] !=NULL)
					{
						strcpy(memo_field_buffer[0],(BYTE*)(""));
						MemoFieldBufferToField();
						MemoClearFieldBuffer();
					}
					MemoCateNameToPopupTrigger(memo_dbid);
					DataCloseRecord(memo_dbid, app_status.rec_id);
					DataDeleteRecord(memo_dbid, app_status.rec_id, FALSE);
					MemoSetTableFont();
					MemoRecordToTable(memo_dbid, app_status.new_sort_mode, temp_cate);
					ControlSetLabel(POPUP_TRIGGER_CATEGORY, temp_cate);
					current_cate = temp_cate;
					FormPopupForm(FORM_MEMO_LIST);
				}
				return TRUE;
				
		default:
			return FALSE;
		}
		return TRUE;
		
#ifdef PR31700
		case 	EVT_IO_KEY_CTRL:
			if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
			{
				if (Event->para2 == IO_UP_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_MEMO_VIEWING, SCROLLBAR_UP_ARROW);
				else if (Event->para2 == IO_DOWN_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_MEMO_VIEWING, SCROLLBAR_DOWN_ARROW);
				return TRUE;
			}
			return FALSE;
#endif
			
		default:
			return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerItemErase
* Purpose: 	This function is the event handler for the 
*			CONFIRM ITEM ERASE screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN MemoItemErase(EvtType* Event)
{
	BOOLEAN control_value;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_ITEM_ERASE_YES;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_ITEM_ERASE_NO;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_ITEM_ERASE);
#ifdef	DEBUG
		FormGetControlValue(CHECKBOX_ITEM_ERASE, &control_value);
		printf("\n----> Check Box Value %d <----", control_value);
#endif
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_ITEM_ERASE_YES)
		{
			/* Check the check box's setting and delete the record */ 
			FormGetControlValue(CHECKBOX_ITEM_ERASE, &control_value);
			DataCloseRecord(memo_dbid, app_status.rec_id);
			DataDeleteRecord(memo_dbid, app_status.rec_id, control_value);
			MemoRecordToTable(memo_dbid, app_status.new_sort_mode, current_cate);
			MemoCateNameToPopupTrigger(memo_dbid);
			ControlSetLabel(POPUP_TRIGGER_CATEGORY, current_cate);
			FormPopupForm(FORM_MEMO_LIST);
			return TRUE;
		}
		else if (Event->eventID == BUTTON_ITEM_ERASE_NO)
		{
			FormPopupForm(FORM_MEMO_VIEWING);
			return TRUE;
		}
		return TRUE;
		
	default:
		return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerSaveChanges
* Purpose: 	This function is the event handler for the 
*			Save Changes screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN MemoSaveChanges(EvtType* Event)
{
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_SAVE_CHANGES_YES;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_SAVE_CHANGES_NO;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_SAVE_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_SAVE_CHANGES);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		FormPopupForm(pressed_object2);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{
		case	BUTTON_SAVE_CHANGES_YES:
			MemoFieldUpdateRecord();
			MemoChangeUpdateRecord();
			///							if (app_status.edit_mode == MEMO_NEW)
			///								FieldGetFont(FIELD_MEMO_NEW, &table_font);
			///							else if (app_status.edit_mode == MEMO_VIEWING)
			///								FieldGetFont(FIELD_MEMO_VIEWING, &table_font);
			MemoSetTableFont();
			MemoRecordToTable(memo_dbid, app_status.new_sort_mode, current_cate);
			FormPopupForm(pressed_object1);
			return TRUE;
			
		case	BUTTON_SAVE_CHANGES_NO:
			if (app_status.edit_mode == MEMO_NEW)
			{
				if (memo_field_buffer[0] !=NULL)
				{
					strcpy(memo_field_buffer[0],(BYTE*)(""));
					MemoFieldBufferToField();
					MemoClearFieldBuffer();
				}
				MemoCateNameToPopupTrigger(memo_dbid);
				DataCloseRecord(memo_dbid, app_status.rec_id);
				DataDeleteRecord(memo_dbid, app_status.rec_id, FALSE);
				
				///								FieldGetFont(FIELD_MEMO_NEW, &table_font);
				MemoSetTableFont();
				
				MemoRecordToTable(memo_dbid, app_status.new_sort_mode, temp_cate);
				ControlSetLabel(POPUP_TRIGGER_CATEGORY, temp_cate);
				current_cate = temp_cate;
			}
			else if (app_status.edit_mode == MEMO_VIEWING)
			{
				MemoCateNameToPopupTrigger(memo_dbid);
				
				///								FieldGetFont(FIELD_MEMO_VIEWING, &table_font);
				MemoSetTableFont();
				
				MemoRecordToTable(memo_dbid, app_status.new_sort_mode, temp_cate);
				ControlSetLabel(POPUP_TRIGGER_CATEGORY, temp_cate);
				current_cate = temp_cate;
			}
			else
			{
				MemoSetTableFont();
				MemoTableDisplayDraw(&memo_list);
			}
			
			FormPopupForm(pressed_object1);
			return TRUE;
			
		default:
			return FALSE;
		}
		return TRUE;
		
		default:
			return FALSE;
	}
	return FALSE;
}

/******************************************************************
* Function:	SchedulerMemoSort
* Purpose: 	This function is the event handler for the 
*			TO DO PREF screen of the scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*******************************************************************/
BOOLEAN MemoSort(EvtType* Event)
{
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_SORT_1 || Event->para1 == SLETTER_SORT_1)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = PUSHBUTTON_SORT_N1;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_SORT_2 || Event->para1 == SLETTER_SORT_2)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = PUSHBUTTON_SORT_N2;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_MEMO_SORT_EXIT;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		/* Set up the default key of the PRIORITY */
		if (app_status.new_sort_mode == ALP_ORDER)
			FormSetControlGroupSelection(FORM_SORT_BY, PUSHBUTTON_SORT_N1);
		else
			FormSetControlGroupSelection(FORM_SORT_BY, PUSHBUTTON_SORT_N2);
		
		FormDrawForm(FORM_SORT_BY);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		FormPopupForm(FORM_MEMO_LIST);
		return TRUE;
		
	case	EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			FormPopupForm(FORM_MEMO_LIST);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{
		case	PUSHBUTTON_SORT_N1:
			app_status.new_sort_mode = ALP_ORDER;
			MemoRecordToTable(memo_dbid, app_status.new_sort_mode, current_cate);
			FormPopupForm(FORM_MEMO_LIST);
			return TRUE;
			
		case	PUSHBUTTON_SORT_N2:
			app_status.new_sort_mode = CHR_ORDER;
			MemoRecordToTable(memo_dbid, app_status.new_sort_mode, current_cate);
			FormPopupForm(FORM_MEMO_LIST);
			return TRUE;
			
		default:
			return FALSE;
		}
		
		default:
			return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	MemoSelectCate
* Purpose: 	This function is the event handler for the 
*			NO CATEGORY SELECTED page of the Memo application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN MemoSelectCate(EvtType* Event)
{
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_SELECT_CATE_X;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_SELECT_CATE);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		FormPopupForm(FORM_EDIT_CATE);
		return TRUE;
		
	case	EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_EXIT || Event->para1 == INLAY_OK)
			FormPopupForm(FORM_EDIT_CATE);
		return TRUE;
		
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	MemoEraseCate
* Purpose: 	This function is the event handler for the 
*			ERASE CATEGORY page of the Memo application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN MemoEraseCate(EvtType *Event)
{
	SHORT selected_item;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_ERASE_CATE_YES;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_ERASE_CATE_NO;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_ERASE_CATE);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_ERASE_CATE_YES)
		{	
			ListGetSelectedItem(LIST_CATE, &selected_item);
			
			if (DeleteCate(selected_item) == TRUE)
			{
				FormPopupForm(FORM_EDIT_CATE);
				return TRUE;
			}
			else 
				break;
		}
		else
			FormPopupForm(FORM_EDIT_CATE);
		return TRUE;
		
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	MemoRemoveCate
* Purpose: 	This function is the event handler for the 
*			REMOVE CATEGORY	page of the Memo application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN MemoRemoveCate(EvtType *Event)
{
	SHORT selected_item;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_REMOVE_CATE_YES;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_REMOVE_CATE_NO;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_REMOVE_CATE);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_REMOVE_CATE_YES)
		{	
			ListGetSelectedItem(LIST_CATE, &selected_item);
			if (DeleteCate(selected_item) == TRUE)
			{
				strcpy(current_cate, MEMOUNFILED);
				FormPopupForm(FORM_EDIT_CATE);
				return TRUE;
			}
			else 
				break;
		}
		else
			FormPopupForm(FORM_EDIT_CATE);
		return TRUE;
		
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	MemoCateFull
* Purpose: 	This function is the event handler for the 
*			CATEGORY FULL page of the Memo application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN MemoFullCate(EvtType *Event)
{
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_CATE_FULL_X;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_FULL_CATE);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		FormPopupForm(FORM_EDIT_CATE);
		return TRUE;
		
	case	EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_EXIT || Event->para1 == INLAY_OK)
			FormPopupForm(FORM_EDIT_CATE);
		return TRUE;
		
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	MemoExistsCate
* Purpose: 	This function is the event handler for the 
*			CATEGORY ALREADY EXISTS	page of the Memo application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN MemoExistsCate(EvtType *Event)
{
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_CATE_NAME_EXISTS_X;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_EXISTS_CATE);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		FormPopupForm(FORM_EDIT_CATE);
		FormPopupForm(FORM_NEW_CATE);
		TextboxSetInsertPointOn(TEXTBOX_NEW_CATE);
		TextboxDrawTextbox(TEXTBOX_NEW_CATE);
		FormSetFormActiveObject(FORM_NEW_CATE, TEXTBOX_NEW_CATE);
		return TRUE;
		
	case	EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_EXIT || Event->para1 == INLAY_OK)
		{
			FormPopupForm(FORM_EDIT_CATE);
			FormPopupForm(FORM_NEW_CATE);
			TextboxSetInsertPointOn(TEXTBOX_NEW_CATE);
			TextboxDrawTextbox(TEXTBOX_NEW_CATE);
			FormSetFormActiveObject(FORM_NEW_CATE, TEXTBOX_NEW_CATE);
			return TRUE;
		}	
		break;
		
	default:
		return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	MemoEditCate
* Purpose: 	This function is the event handler for the EDIT CATEGORIES
page of the Memo application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN MemoEditCate(EvtType* Event)
{
	SHORT	selected_cate;
	USHORT	num_items, item_num;
	BYTE	*list_string, object_type;
	Textbox *textbox_ptr;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_NEW || Event->para1 == SLETTER_NEW)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_MEMO_NEW;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_DEL || Event->para1 == SLETTER_DEL)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_DEL_CATE;
				Event->evtPBP = NULL;
			}
			else if(Event->para1 == LLETTER_RENAME || Event->para1 == SLETTER_RENAME)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_RENAME_CATE;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{
	case	EVT_FORM_OPEN:
		if (FormCheckObjectExists(SCROLLBAR_MEMO_LIST) == FALSE)
			ScrollbarInitScrollbar(SCROLLBAR_MEMO_LIST);
		
		MemoEditCateSetScrollbar();
		FormDrawForm(FORM_EDIT_CATE);
		return TRUE;
		
	case	EVT_SCROLLBAR_SELECT:
		ScrollbarDrawScrollbar(SCROLLBAR_MEMO_LIST);
		return TRUE;
		
	case	EVT_SCROLLBAR_REPEAT:
		MemoScrollbarSetEditCate(Event);
		return TRUE;
		
	case	EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{	
		case	BUTTON_MEMO_NEW:				
#ifdef	PR31700
			
			if (MemoryCheckMemLow() || (entry_low_memory && entry_old_edit))
			{
				low_memory_form_id = FORM_EDIT_CATE;
				FormPopupForm(FORM_SYSTEM_LOW_MEM);	
				return TRUE;
			}											
#endif												
			ListGetNumOfItems(LIST_CATE, &num_items);
			
			if (num_items >= MAX_NUM_OF_CATE)
				FormPopupForm(FORM_FULL_CATE);
			else
			{				
				TextboxSetText(TEXTBOX_NEW_CATE, (BYTE*)(""));
				TextboxSetLeftCharPos(TEXTBOX_NEW_CATE, 0);
				TextboxSetRightCharPos(TEXTBOX_NEW_CATE, -1);
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_NEW_CATE, 0);
				TextboxSetInsertPointOn(TEXTBOX_NEW_CATE);
				FormSetFormActiveObject(FORM_NEW_CATE, TEXTBOX_NEW_CATE);
				
				pressed_key = BUTTON_MEMO_NEW;
				FormPopupForm(FORM_NEW_CATE);
			}
			break;
			
		case	BUTTON_DEL_CATE:
			ListGetNumOfItems(LIST_CATE, &num_items);
			
			if (num_items == 0) return TRUE;
			
			ListGetSelectedItem(LIST_CATE, &selected_cate);
			
			if (selected_cate != -1)
			{
				if (DeleteCateCheck(selected_cate) == TRUE) 
					return TRUE;
			}
			else
			{
				FormPopupForm(FORM_SELECT_CATE);
				return TRUE;
			}
			break;
			
		case	BUTTON_RENAME_CATE:
#ifdef	PR31700
			if (MemoryCheckMemLow() || (entry_low_memory && entry_old_edit))
			{
				low_memory_form_id = FORM_EDIT_CATE;
				FormPopupForm(FORM_SYSTEM_LOW_MEM);	
				return TRUE;
			}											
#endif												
			ListGetSelectedItem(LIST_CATE, &selected_cate);
			
			if (selected_cate != -1)
			{
				ListGetListItem(LIST_CATE,(USHORT)selected_cate, &list_string);
				
				TextboxInitTextbox(TEXTBOX_NEW_CATE);
				TextboxSetText(TEXTBOX_NEW_CATE, list_string);
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_NEW_CATE, strlen(list_string));
				TextboxSetInsertPointOn(TEXTBOX_NEW_CATE);
				
				FormGetObjectPointer(TEXTBOX_NEW_CATE, &object_type, (void **)&textbox_ptr);
				textbox_ptr->textbox_highlight_start_char = 0;
				textbox_ptr->textbox_highlight_length = strlen(list_string);
				textbox_ptr->textbox_attr.textbox_highlight = TRUE;
				
				FormSetFormActiveObject(FORM_NEW_CATE, TEXTBOX_NEW_CATE);
				pressed_key = BUTTON_RENAME_CATE;
				FormPopupForm(FORM_NEW_CATE);
				return TRUE;
			}
			else
			{
				FormPopupForm(FORM_SELECT_CATE);
				return TRUE;
			}
			break;
			
		default: return FALSE;
		}
		break;
		
		case	EVT_LIST_SELECT:
			ListSetHighlightedItem(LIST_CATE, (SHORT)(Event->para1));
			ListDrawList(LIST_CATE);
			return TRUE;
			
		case	EVT_INLAY_SELECT:
			if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			{
				if (app_status.edit_mode == MEMO_LIST)
				{	
					ControlInitControl(POPUP_TRIGGER_CATEGORY);
					MemoCateNameToPopupTrigger(memo_dbid);
					MemoSetTableFont();
					
					if (ControlPopupFindItemNum(POPUP_TRIGGER_CATEGORY, current_cate, &item_num) == TRUE) 
					{
						ControlPopupSetSelectedItem(POPUP_TRIGGER_CATEGORY, (SHORT)item_num);
						MemoRecordToTable(memo_dbid, app_status.new_sort_mode, current_cate);
					}
					else
					{
						ControlPopupSetSelectedItem(POPUP_TRIGGER_CATEGORY, 0);
						MemoRecordToTable(memo_dbid, app_status.new_sort_mode, MEMOALL);
					}
					FormPopupForm(FORM_MEMO_LIST);
					return TRUE;
				}
				else
				{
					ControlInitControl(POPUP_TRIGGER_CATEGORY);
					MemoCateNameToPopupTrigger(memo_dbid);
					ControlPopupDeleteItem(POPUP_TRIGGER_CATEGORY, 0);
					
					if (ControlPopupFindItemNum(POPUP_TRIGGER_CATEGORY, current_cate, &item_num) == TRUE)
						ControlPopupSetSelectedItem(POPUP_TRIGGER_CATEGORY, (SHORT)item_num);
					else
						ControlPopupSetSelectedItem(POPUP_TRIGGER_CATEGORY, 0);
					
					ControlSetLabel(POPUP_TRIGGER_CATEGORY, current_cate);
					
					if (app_status.edit_mode == MEMO_NEW)
					{
						FieldSetFont(FIELD_MEMO_NEW, table_font);
						MenuDeleteItem(MEMO_MENU, 4);
						
						if (table_font == SMALL_FONT)
							MenuInsertItem(MEMO_MENU, 4, MEMOLFONT);
						else
							MenuInsertItem(MEMO_MENU, 4, MEMOSFONT);
						
						FormPopupForm(FORM_MEMO_NEW);
					}
					else
					{
						FieldSetFont(FIELD_MEMO_VIEWING, table_font);
						MenuDeleteItem(MEMO_MENU, 4);
						
						if (table_font == SMALL_FONT)
							MenuInsertItem(MEMO_MENU, 4, MEMOLFONT);
						else
							MenuInsertItem(MEMO_MENU, 4, MEMOSFONT);
						
						FormPopupForm(FORM_MEMO_VIEWING);
					}
					return TRUE;
				}
			}
			return FALSE;		
			
		case	EVT_MENU_SELECT_ITEM:
			MemoChangeCateListFontSize();
			return TRUE;
			
#ifdef PR31700
		case	EVT_IO_KEY_CTRL:
			if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
			{
				if (Event->para2 == IO_UP_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_MEMO_LIST, SCROLLBAR_UP_ARROW);
				else if (Event->para2 == IO_DOWN_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_MEMO_LIST, SCROLLBAR_DOWN_ARROW);
				return TRUE;
			}
			return FALSE;
#endif
			
		default:
			return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	MemoNewCate
* Purpose: 	This function is the event handler for the 
*			NEW CATEGORIES page of the Phonebook application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN MemoNewCate(EvtType *Event)
{
	ObjectID	tempID;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_NEW_CATE_X;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch (Event->eventType)
	{		
	case	EVT_FORM_OPEN:
		FormDrawForm(FORM_NEW_CATE);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		MemoEditCateSetScrollbar();
		FormPopupForm(FORM_EDIT_CATE);
		return TRUE;
		
	case	EVT_KEY:
		if (Event->eventID == SOFT_KEY)
		{
			FormGetActiveObject(FORM_NEW_CATE, &tempID);
			
			if (tempID == TEXTBOX_NEW_CATE) 
			{
				if ((BYTE)(Event->para1) == 13 && (MemoInputCatCheckCharIn() == TRUE))
					return TRUE;
				else
				{
					TextboxAddKeyInChar(TEXTBOX_NEW_CATE, (BYTE)(Event->para1));
					return TRUE;
				}
			}
		}
		break;
		
	case	EVT_MENU_SELECT_ITEM:
		MemoMenuSelectedAction((USHORT)(Event->para1));
		return TRUE;
		
	case	EVT_INLAY_SELECT:
		switch (Event->para1)
		{
		case	INLAY_OK:
			if (MemoInputCatCheckCharIn() == TRUE)
				return TRUE;
			return FALSE;
			
		case	INLAY_EXIT:
			FormPopupForm(FORM_EDIT_CATE);
			return TRUE;
			
		default: 
			return FALSE;
		}
		break;
		
		default:
			return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	SchedulerSysLowMem
* Purpose: 	This function is called to handle the event for the form
*			NO MEMORY
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
*			FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN MemoSysLowMem(EvtType *Event)
{
	BYTE	object_type;
	Form	*form_addr;
	
	
	/* Keyboard Function Key Event Mapping */
	if(Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if((Event->para2 & 0x00000200))
		{
			if(Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_SYS_LOW_MEMORY_X;
				Event->evtPBP = NULL;
			}
		}	
	}
	
	switch	(Event->eventType)
	{
	case	EVT_FORM_OPEN:
		if (FormGetObjectPointer(FORM_SYSTEM_LOW_MEM, &object_type, (void **)&form_addr)
			== ERR_UI_RES_NOT_FOUND)
			FormInitAllFormObjects(FORM_SYSTEM_LOW_MEM);
		
		FormDrawForm(FORM_SYSTEM_LOW_MEM);
		return TRUE;
		
	case	EVT_BITMAP_SELECT:
		FormPopupForm(low_memory_form_id);
		return TRUE;
		
	case	EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			FormPopupForm(low_memory_form_id);
		return TRUE;
		
	default:
		return FALSE;
	}
	return FALSE;
}
