/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   memosk.c
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



/********************************************************
* Function:	ToDoGotoItem
* Purpose: 	This function is called to init all related variables
*			and goto the specific form to display the required record
* Scope:	application/internal
* Input:	dbid
*			rec_id
*			field_num
*			search_string
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void MemoGotoItem(DatabaseID dbid, RecordID rec_id, USHORT field_num, BYTE *search_string)
{
	WORD	total_num_lines;
	WORD	highlight_char_pos =0, line_num;
	UWORD	rec_num;
	BOOLEAN	found =FALSE;
	Bitmap	*bmp_addr;
	Field	*fld_addr;
	UWORD	byte_read;
	BYTE	sorted_by, *buffer, object_type;
	BYTE	application_status;
	
	
	/* Set up app_status variables */
	app_status.rec_id = rec_id;
	/* Allocate global variable */
	if(memo_field_buffer != NULL)
		qfree(memo_field_buffer);
	memo_field_buffer = (BYTE**)qmalloc(1*sizeof(BYTE*));
	memo_field_buffer[0] = NULL;
	
	if(current_cate != NULL)
		qfree(current_cate);
	current_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
	current_cate[0] = 0;
	
	if(temp_cate != NULL)
		qfree(temp_cate);
	temp_cate = (BYTE*)qmalloc(30*sizeof(BYTE));
	temp_cate[0] = 0;
	
	/* Allocate global variable */
	pressed_object1 = 0;
	pressed_object2 = 0;
	sorted_by = ALP_ORDER;
	font_size = SMALL_FONT;
	pen_down = FALSE;
	
	MemoDatabaseChecking();
	
	/* Initialisation all the Forms */
	FormInitAllFormObjects(FORM_MEMO_NEW);
	FormInitAllFormObjects(FORM_MEMO_LIST);
	FormInitAllFormObjects(FORM_MEMO_VIEWING);
	FormInitAllFormObjects(FORM_SAVE_CHANGES);
	FormInitAllFormObjects(FORM_ITEM_ERASE);
	FormInitAllFormObjects(FORM_SORT_BY);
	FormInitAllFormObjects(FORM_SELECT_CATE);
	FormInitAllFormObjects(FORM_NEW_CATE);
	FormInitAllFormObjects(FORM_ERASE_CATE);
	FormInitAllFormObjects(FORM_REMOVE_CATE);
	FormInitAllFormObjects(FORM_EXISTS_CATE);
	FormInitAllFormObjects(FORM_FULL_CATE);
	FormInitAllFormObjects(FORM_EDIT_CATE);
	
	DataGetField(memo_dbid, MEMO_STATUS, 0, &buffer, &byte_read);
	application_status = *buffer;
	qfree(buffer);
	
	if (application_status == RESTART_MEMO_VIEWING)
	{		
		printf("\n*** MemoGotoItem 1 ***");
		/* Set up app_status variables */
		MemoRecordToVariable();
		MemoViewingSetUpScreen();
		strcpy(temp_cate, current_cate);
		FormGetObjectPointer(FIELD_MEMO_VIEWING, &object_type, (void **)&fld_addr);
		
		/* Goto to select text */
		if (search_string != NULL)
		{
			printf("\n*** MemoGotoItem 2 ***");
			
			DataRecIDtoNum(memo_dbid, rec_id, &rec_num);
			DataOpenRecord(memo_dbid, rec_num, &rec_id, NULL);
			DataGetField(memo_dbid, rec_id, 1, &buffer, &byte_read);
			strcpy(memo_field_buffer[0], buffer);
			qfree(buffer);
			
			highlight_char_pos = GlobalFindSearchText(search_string, memo_field_buffer[0]);
			total_num_lines = fld_addr->field_total_num_lines;
			
			for (line_num =0; line_num <total_num_lines; line_num++)
			{
				if ((highlight_char_pos >= fld_addr->field_lineinfo[line_num].start) &&
					(highlight_char_pos <= (fld_addr->field_lineinfo[line_num].start +
					fld_addr->field_lineinfo[line_num].length -1)))
				{
					found = TRUE;
					
					if (line_num > (total_num_lines - fld_addr->field_num_lines_displayed))
						line_num = (total_num_lines - fld_addr->field_num_lines_displayed);
					fld_addr->field_top_line_num = line_num;
					break;
				}
			}
			
			if (!found)
				fld_addr->field_top_line_num = 0;
			
			MemoSetUpFieldScreen(FORM_MEMO_VIEWING);
			MemoFieldSetScrollbar(FIELD_MEMO_VIEWING, SCROLLBAR_MEMO_VIEWING);
			
			fld_addr->field_highlight_start_char = highlight_char_pos;
			fld_addr->field_highlight_end_char = highlight_char_pos + strlen(search_string) - 1;
			fld_addr->field_highlight_length = strlen(search_string);
			fld_addr->field_attr.field_highlight = TRUE;
			FormSetFormActiveObject(FORM_MEMO_VIEWING, fld_addr->identification.ui_object_id);
		}
		/* Disable the field object */
		fld_addr->field_attr.field_insert_pt_visible = FALSE;
		fld_addr->field_attr.field_enable = FALSE;
		FormPopupForm(FORM_MEMO_VIEWING);
	}
	else
	{	
		DataGetField(memo_dbid, MEMO_EDIT_INFO, 2, &buffer, &byte_read);
		strcpy(app_status.create_time, buffer);
		qfree(buffer);	
		
		DataGetField(memo_dbid, MEMO_EDIT_INFO, 3, &buffer, &byte_read);
		app_status.new_sort_mode = (BYTE)(*buffer);
		qfree(buffer);
		
		DataGetField(memo_dbid, MEMO_EDIT_INFO, 4, &buffer, &byte_read);
		app_status.edit_mode = (BYTE)(*buffer);
		qfree(buffer);
		
		DataGetField(memo_dbid, MEMO_EDIT_INFO, 5, &buffer, &byte_read);
		pressed_object1 = (BYTE)(*buffer);
		qfree(buffer);
		
		DataGetField(memo_dbid, MEMO_EDIT_INFO, 6, &buffer, &byte_read);
		pressed_object2 = (BYTE)(*buffer);
		qfree(buffer);
		
		/* Restore field_buffers */
		DataGetField(memo_dbid, MEMO_EDIT_INFO, 7, &buffer, &byte_read);
		memo_field_buffer[0] = (BYTE*)qmalloc((strlen(buffer) + 1)*sizeof(BYTE));
		strcpy(memo_field_buffer[0], buffer);
		qfree(buffer);	
		
		DataGetField(memo_dbid, MEMO_EDIT_INFO, 8, &buffer, &byte_read);
		strcpy(current_cate, buffer);
		qfree(buffer);
		
		/* Restore the org cate on the list screen */
		DataGetField(memo_dbid, MEMO_EDIT_INFO, 9, &buffer, &byte_read);
		strcpy(temp_cate, buffer);
		qfree(buffer);
		
		/*  Restore New Sketch status */
		FormGetObjectPointer(BITMAP_MEMO_SKETCH, &object_type, (void **)&bmp_addr);
		
		DataRecIDtoNum(memo_dbid, rec_id, &rec_num);
		DataOpenRecord(memo_dbid, rec_num, &rec_id, NULL);
		DataGetField(memo_dbid, rec_id, 0, &buffer, &byte_read);
		if (*buffer == MEMO_SKETCH)
		{
			app_status.sketch_status = MEMO_SKETCH; 
			bmp_addr->bitmap_attr.bitmap_visible = TRUE;
		}
		else
		{
			app_status.sketch_status = MEMO_NO_SKETCH; 
			bmp_addr->bitmap_attr.bitmap_visible = FALSE;
		}
		bmp_addr->bitmap_attr.bitmap_enable = FALSE;
		qfree(buffer);
		/* Set up Category */
		MemoCateNameToPopupTrigger(memo_dbid);
		ControlPopupDeleteItem(POPUP_TRIGGER_CATEGORY, 0);
		ControlSetLabel(POPUP_TRIGGER_CATEGORY, current_cate);
		FieldSetText(FIELD_MEMO_NEW, memo_field_buffer[0]);
		FormPopupForm(FORM_MEMO_NEW);
	}
}

